/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.jpa;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.drools.persistence.ByteArraySnapshotter;
import org.drools.persistence.Persister;
import org.drools.persistence.Transaction;
import org.drools.persistence.jpa.ByteArrayObject;
import org.drools.persistence.jpa.JPAXaResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPAPersister<T>
implements Persister<T> {
    private String id;
    private ByteArrayObject object;
    private ByteArraySnapshotter<T> snapshotter;
    private EntityManagerFactory emf;
    private EntityManager em;

    public JPAPersister(EntityManagerFactory emf, ByteArraySnapshotter<T> snapshotter) {
        this.emf = emf;
        this.em = emf.createEntityManager();
        this.snapshotter = snapshotter;
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.emf;
    }

    public EntityManager getEntityManager() {
        return this.em;
    }

    public void save() {
        this.em.getTransaction().begin();
        this.updateObject();
        this.em.getTransaction().commit();
    }

    public void updateObject() {
        if (this.object == null) {
            this.object = new ByteArrayObject();
        }
        this.object.setByteArray(this.snapshotter.getSnapshot());
        this.em.persist((Object)this.object);
        if (this.id == null) {
            this.id = this.object.getId() + "";
        }
    }

    public void load() {
        this.object = (ByteArrayObject)this.em.find(ByteArrayObject.class, (Object)new Long(this.id));
        this.snapshotter.loadSnapshot(this.object.getByteArray());
    }

    public T getObject() {
        return (T)this.snapshotter.getObject();
    }

    public Transaction getTransaction() {
        return new Transaction(this.getUniqueXID(), this.getXAResource());
    }

    public String getUniqueId() {
        return this.object == null ? null : this.object.getId() + "";
    }

    public XAResource getXAResource() {
        return new JPAXaResource(this, this.em.getTransaction());
    }

    public void setUniqueId(String id) {
        this.id = id;
    }

    private Xid getUniqueXID() {
        return null;
    }
}

