/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.processinstance;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import org.drools.WorkingMemory;
import org.drools.persistence.processinstance.WorkItemInfo;
import org.drools.process.instance.ProcessInstance;
import org.drools.process.instance.WorkItem;
import org.drools.process.instance.impl.WorkItemImpl;
import org.drools.runtime.process.WorkItemHandler;
import org.drools.runtime.process.WorkItemManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPAWorkItemManager
implements org.drools.process.instance.WorkItemManager {
    private EntityManager manager;
    private WorkingMemory workingMemory;
    private Map<String, WorkItemHandler> workItemHandlers = new HashMap<String, WorkItemHandler>();

    public JPAWorkItemManager(WorkingMemory workingMemory) {
        this.workingMemory = workingMemory;
    }

    public void setEntityManager(EntityManager manager) {
        this.manager = manager;
    }

    public void internalExecuteWorkItem(WorkItem workItem) {
        WorkItemInfo workItemInfo = new WorkItemInfo(workItem);
        this.manager.persist((Object)workItemInfo);
        ((WorkItemImpl)workItem).setId(workItemInfo.getId());
        workItemInfo.update();
        WorkItemHandler handler = this.workItemHandlers.get(workItem.getName());
        if (handler != null) {
            handler.executeWorkItem((org.drools.runtime.process.WorkItem)workItem, (WorkItemManager)this);
        } else {
            System.err.println("Could not find work item handler for " + workItem.getName());
        }
    }

    public void internalAbortWorkItem(long id) {
        WorkItemInfo workItemInfo = (WorkItemInfo)this.manager.find(WorkItemInfo.class, (Object)id);
        if (workItemInfo != null) {
            WorkItemImpl workItem = (WorkItemImpl)workItemInfo.getWorkItem();
            WorkItemHandler handler = this.workItemHandlers.get(workItem.getName());
            if (handler != null) {
                handler.abortWorkItem((org.drools.runtime.process.WorkItem)workItem, (WorkItemManager)this);
            } else {
                System.err.println("Could not find work item handler for " + workItem.getName());
            }
            this.manager.remove((Object)workItemInfo);
        }
    }

    public void internalAddWorkItem(WorkItem workItem) {
    }

    public void completeWorkItem(long id, Map<String, Object> results) {
        WorkItemInfo workItemInfo = (WorkItemInfo)this.manager.find(WorkItemInfo.class, (Object)id);
        if (workItemInfo != null) {
            WorkItemImpl workItem = (WorkItemImpl)workItemInfo.getWorkItem();
            workItem.setResults(results);
            ProcessInstance processInstance = this.workingMemory.getProcessInstance(workItem.getProcessInstanceId());
            workItem.setState(2);
            if (processInstance != null) {
                processInstance.signalEvent("workItemCompleted", (Object)workItem);
            }
            this.manager.remove((Object)workItemInfo);
            this.workingMemory.fireAllRules();
        }
    }

    public void abortWorkItem(long id) {
        WorkItemInfo workItemInfo = (WorkItemInfo)this.manager.find(WorkItemInfo.class, (Object)id);
        if (workItemInfo != null) {
            WorkItemImpl workItem = (WorkItemImpl)workItemInfo.getWorkItem();
            ProcessInstance processInstance = this.workingMemory.getProcessInstance(workItem.getProcessInstanceId());
            workItem.setState(3);
            if (processInstance != null) {
                processInstance.signalEvent("workItemAborted", (Object)workItem);
            }
            this.manager.remove((Object)workItemInfo);
            this.workingMemory.fireAllRules();
        }
    }

    public WorkItem getWorkItem(long id) {
        WorkItemInfo workItemInfo = (WorkItemInfo)this.manager.find(WorkItemInfo.class, (Object)id);
        if (workItemInfo == null) {
            return null;
        }
        return workItemInfo.getWorkItem();
    }

    public Set<WorkItem> getWorkItems() {
        return new HashSet<WorkItem>();
    }

    public void registerWorkItemHandler(String workItemName, WorkItemHandler handler) {
        this.workItemHandlers.put(workItemName, handler);
    }
}

