/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.session;

import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.drools.RuleBase;
import org.drools.SessionConfiguration;
import org.drools.StatefulSession;
import org.drools.marshalling.PlaceholderResolverStrategyFactory;
import org.drools.persistence.ByteArraySnapshotter;
import org.drools.persistence.Persister;
import org.drools.persistence.jpa.JPAPersister;
import org.drools.persistence.session.StatefulSessionSnapshotter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPAPersisterManager {
    private EntityManagerFactory emf;
    private PlaceholderResolverStrategyFactory factory;

    public JPAPersisterManager(PlaceholderResolverStrategyFactory factory, EntityManagerFactory emf) {
        this.emf = emf == null ? Persistence.createEntityManagerFactory((String)"org.drools.persistence.jpa") : emf;
        this.factory = factory;
    }

    public JPAPersisterManager(PlaceholderResolverStrategyFactory factory) {
        this(factory, null);
    }

    public void dispose() {
        this.emf.close();
    }

    public Persister<StatefulSession> getSessionPersister(StatefulSession session) {
        return new JPAPersister<StatefulSession>(this.emf, (ByteArraySnapshotter<StatefulSession>)new StatefulSessionSnapshotter(session, this.factory));
    }

    public Persister<StatefulSession> getSessionPersister(RuleBase ruleBase) {
        return new JPAPersister<StatefulSession>(this.emf, (ByteArraySnapshotter<StatefulSession>)new StatefulSessionSnapshotter(ruleBase.newStatefulSession(), this.factory));
    }

    public Persister<StatefulSession> getSessionPersister(RuleBase ruleBase, SessionConfiguration conf) {
        return new JPAPersister<StatefulSession>(this.emf, (ByteArraySnapshotter<StatefulSession>)new StatefulSessionSnapshotter(ruleBase.newStatefulSession(conf), this.factory));
    }

    public Persister<StatefulSession> getSessionPersister(String uniqueId, RuleBase ruleBase) {
        return this.getSessionPersister(uniqueId, ruleBase, null);
    }

    public Persister<StatefulSession> getSessionPersister(String uniqueId, RuleBase ruleBase, SessionConfiguration conf) {
        JPAPersister<StatefulSession> persister = new JPAPersister<StatefulSession>(this.emf, (ByteArraySnapshotter<StatefulSession>)new StatefulSessionSnapshotter(ruleBase, conf, this.factory));
        persister.setUniqueId(uniqueId);
        persister.load();
        return persister;
    }
}

