/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.session;

import javax.transaction.xa.XAException;
import org.drools.KnowledgeBase;
import org.drools.RuleBase;
import org.drools.SessionConfiguration;
import org.drools.StatefulSession;
import org.drools.common.InternalWorkingMemory;
import org.drools.impl.EnvironmentFactory;
import org.drools.impl.KnowledgeBaseImpl;
import org.drools.persistence.Persister;
import org.drools.persistence.Transaction;
import org.drools.persistence.jpa.JPAPersister;
import org.drools.persistence.processinstance.JPAProcessInstanceManager;
import org.drools.persistence.processinstance.JPASignalManager;
import org.drools.persistence.processinstance.JPAWorkItemManager;
import org.drools.persistence.session.JPAPersisterManager;
import org.drools.persistence.session.PersistenceConfig;
import org.drools.process.command.Command;
import org.drools.process.command.CommandService;
import org.drools.runtime.Environment;
import org.drools.runtime.KnowledgeSessionConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleSessionCommandService
implements CommandService {
    private Persister<StatefulSession> persister;
    private PersistenceConfig pconfig;

    public SingleSessionCommandService(RuleBase ruleBase) {
        this(ruleBase, null);
    }

    public SingleSessionCommandService(RuleBase ruleBase, SessionConfiguration conf) {
        PersistenceConfig pconfig;
        if (conf == null) {
            conf = new SessionConfiguration();
        }
        this.persister = (pconfig = this.getPersistenceConfig()).getSessionId() != null ? new JPAPersisterManager(pconfig.getPlaceholderResolverStrategyFactory(), pconfig.getEntityManagerFactory()).getSessionPersister(pconfig.getSessionId(), ruleBase, conf) : new JPAPersisterManager(pconfig.getPlaceholderResolverStrategyFactory(), pconfig.getEntityManagerFactory()).getSessionPersister(ruleBase, conf);
        this.init();
    }

    public SingleSessionCommandService(KnowledgeBase kbase) {
        this(((KnowledgeBaseImpl)kbase).getRuleBase());
    }

    public SingleSessionCommandService(KnowledgeBase kbase, KnowledgeSessionConfiguration conf) {
        this(((KnowledgeBaseImpl)kbase).getRuleBase(), (SessionConfiguration)conf);
    }

    private void init() {
        StatefulSession session = (StatefulSession)this.persister.getObject();
        ((JPAProcessInstanceManager)((InternalWorkingMemory)session).getProcessInstanceManager()).setEntityManager(((JPAPersister)this.persister).getEntityManager());
        ((JPAWorkItemManager)((InternalWorkingMemory)session).getWorkItemManager()).setEntityManager(((JPAPersister)this.persister).getEntityManager());
        ((JPASignalManager)((InternalWorkingMemory)session).getSignalManager()).setEntityManager(((JPAPersister)this.persister).getEntityManager());
        ((JPASignalManager)((InternalWorkingMemory)session).getSignalManager()).setPersister(this.persister);
    }

    public StatefulSession getSession() {
        return (StatefulSession)this.persister.getObject();
    }

    public <T> T execute(Command<T> command) {
        StatefulSession session = (StatefulSession)this.persister.getObject();
        Transaction transaction = this.persister.getTransaction();
        try {
            transaction.start();
            Object result = command.execute(session);
            transaction.commit();
            if (this.pconfig.getSessionId() == null) {
                this.pconfig.setSessionId(this.getSessionId());
            }
            return (T)result;
        }
        catch (Throwable t) {
            t.printStackTrace();
            try {
                transaction.rollback();
                throw new RuntimeException("Could not execute command", t);
            }
            catch (XAException e) {
                throw new RuntimeException("Could not rollback transaction", e);
            }
        }
    }

    public void dispose() {
        StatefulSession session = (StatefulSession)this.persister.getObject();
        if (session != null) {
            session.dispose();
        }
    }

    public String getSessionId() {
        return this.persister.getUniqueId();
    }

    public PersistenceConfig getPersistenceConfig() {
        Environment environment = EnvironmentFactory.newEnvironment();
        this.pconfig = (PersistenceConfig)environment.get(PersistenceConfig.class.getName());
        if (this.pconfig == null) {
            this.pconfig = new PersistenceConfig();
            environment.set(PersistenceConfig.class.getName(), (Object)this.pconfig);
        }
        return this.pconfig;
    }
}

