/*
 * Decompiled with CFR 0.152.
 */
package org.drools.process.workitem.wsht;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.mina.transport.socket.SocketConnector;
import org.apache.mina.transport.socket.nio.NioSocketConnector;
import org.drools.process.instance.impl.WorkItemImpl;
import org.drools.process.workitem.wsht.WSHumanTaskHandler;
import org.drools.runtime.process.WorkItem;
import org.drools.runtime.process.WorkItemHandler;
import org.drools.runtime.process.WorkItemManager;
import org.drools.task.AccessType;
import org.drools.task.BaseTest;
import org.drools.task.Status;
import org.drools.task.Task;
import org.drools.task.query.TaskSummary;
import org.drools.task.service.ContentData;
import org.drools.task.service.MinaTaskClient;
import org.drools.task.service.MinaTaskServer;
import org.drools.task.service.TaskClientHandler;
import org.drools.task.service.responsehandlers.BlockingGetContentResponseHandler;
import org.drools.task.service.responsehandlers.BlockingGetTaskResponseHandler;
import org.drools.task.service.responsehandlers.BlockingTaskOperationResponseHandler;
import org.drools.task.service.responsehandlers.BlockingTaskSummaryResponseHandler;

public class WSHumanTaskHandlerTest
extends BaseTest {
    MinaTaskServer server;
    MinaTaskClient client;
    WSHumanTaskHandler handler;

    protected void setUp() throws Exception {
        super.setUp();
        this.server = new MinaTaskServer(this.taskService);
        Thread thread = new Thread((Runnable)this.server);
        thread.start();
        Thread.sleep(500L);
        this.client = new MinaTaskClient("client 1", new TaskClientHandler());
        NioSocketConnector connector = new NioSocketConnector();
        InetSocketAddress address = new InetSocketAddress("127.0.0.1", 9123);
        this.client.connect((SocketConnector)connector, (SocketAddress)address);
        this.handler = new WSHumanTaskHandler();
    }

    protected void tearDown() throws Exception {
        this.handler.dispose();
        this.client.disconnect();
        this.server.stop();
        super.tearDown();
    }

    public void testTask() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("TaskName", (Object)"TaskName");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        this.handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Thread.sleep(500L);
        BlockingTaskSummaryResponseHandler responseHandler = new BlockingTaskSummaryResponseHandler();
        this.client.getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        List tasks = responseHandler.getResults();
        WSHumanTaskHandlerTest.assertEquals((int)1, (int)tasks.size());
        TaskSummary task = (TaskSummary)tasks.get(0);
        WSHumanTaskHandlerTest.assertEquals((String)"TaskName", (String)task.getName());
        WSHumanTaskHandlerTest.assertEquals((int)10, (int)task.getPriority());
        WSHumanTaskHandlerTest.assertEquals((String)"Comment", (String)task.getDescription());
        WSHumanTaskHandlerTest.assertEquals((Object)Status.Reserved, (Object)task.getStatus());
        WSHumanTaskHandlerTest.assertEquals((String)"Darth Vader", (String)task.getActualOwner().getId());
        System.out.println("Starting task " + task.getId());
        BlockingTaskOperationResponseHandler operationResponseHandler = new BlockingTaskOperationResponseHandler();
        this.client.start(task.getId(), "Darth Vader", (TaskClientHandler.TaskOperationResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        System.out.println("Started task " + task.getId());
        System.out.println("Completing task " + task.getId());
        operationResponseHandler = new BlockingTaskOperationResponseHandler();
        this.client.complete(task.getId(), "Darth Vader", null, (TaskClientHandler.TaskOperationResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(15000L);
        System.out.println("Completed task " + task.getId());
        WSHumanTaskHandlerTest.assertTrue((boolean)manager.isCompleted());
    }

    public void testTaskMultipleActors() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("TaskName", (Object)"TaskName");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader, Dalai Lama");
        this.handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Thread.sleep(500L);
        BlockingTaskSummaryResponseHandler responseHandler = new BlockingTaskSummaryResponseHandler();
        this.client.getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        List tasks = responseHandler.getResults();
        WSHumanTaskHandlerTest.assertEquals((int)1, (int)tasks.size());
        TaskSummary task = (TaskSummary)tasks.get(0);
        WSHumanTaskHandlerTest.assertEquals((String)"TaskName", (String)task.getName());
        WSHumanTaskHandlerTest.assertEquals((int)10, (int)task.getPriority());
        WSHumanTaskHandlerTest.assertEquals((String)"Comment", (String)task.getDescription());
        WSHumanTaskHandlerTest.assertEquals((Object)Status.Ready, (Object)task.getStatus());
        System.out.println("Claiming task " + task.getId());
        BlockingTaskOperationResponseHandler operationResponseHandler = new BlockingTaskOperationResponseHandler();
        this.client.claim(task.getId(), "Darth Vader", (TaskClientHandler.TaskOperationResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        System.out.println("Claimed task " + task.getId());
        System.out.println("Starting task " + task.getId());
        operationResponseHandler = new BlockingTaskOperationResponseHandler();
        this.client.start(task.getId(), "Darth Vader", (TaskClientHandler.TaskOperationResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        System.out.println("Started task " + task.getId());
        System.out.println("Completing task " + task.getId());
        operationResponseHandler = new BlockingTaskOperationResponseHandler();
        this.client.complete(task.getId(), "Darth Vader", null, (TaskClientHandler.TaskOperationResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        System.out.println("Completed task " + task.getId());
        WSHumanTaskHandlerTest.assertTrue((boolean)manager.isCompleted());
    }

    public void testTaskGroupActors() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("TaskName", (Object)"TaskName");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("GroupId", (Object)"Crusaders");
        this.handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Thread.sleep(500L);
        BlockingTaskSummaryResponseHandler responseHandler = new BlockingTaskSummaryResponseHandler();
        this.client.getTasksAssignedAsPotentialOwner(null, "Crusaders", "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        List tasks = responseHandler.getResults();
        WSHumanTaskHandlerTest.assertEquals((int)1, (int)tasks.size());
        TaskSummary taskSummary = (TaskSummary)tasks.get(0);
        WSHumanTaskHandlerTest.assertEquals((String)"TaskName", (String)taskSummary.getName());
        WSHumanTaskHandlerTest.assertEquals((int)10, (int)taskSummary.getPriority());
        WSHumanTaskHandlerTest.assertEquals((String)"Comment", (String)taskSummary.getDescription());
        WSHumanTaskHandlerTest.assertEquals((Object)Status.Ready, (Object)taskSummary.getStatus());
        System.out.println("Claiming task " + taskSummary.getId());
        BlockingTaskOperationResponseHandler operationResponseHandler = new BlockingTaskOperationResponseHandler();
        this.client.claim(taskSummary.getId(), "Darth Vader", (TaskClientHandler.TaskOperationResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        System.out.println("Claimed task " + taskSummary.getId());
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskSummary.getId(), (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task = getTaskResponseHandler.getTask();
        WSHumanTaskHandlerTest.assertEquals((Object)Status.Ready, (Object)task.getTaskData().getStatus());
    }

    public void testTaskSingleAndGroupActors() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task One");
        workItem.setParameter("TaskName", (Object)"TaskNameOne");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("GroupId", (Object)"Crusaders");
        this.handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Thread.sleep(500L);
        workItem = new WorkItemImpl();
        workItem.setName("Human Task Two");
        workItem.setParameter("TaskName", (Object)"TaskNameTwo");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        this.handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Thread.sleep(500L);
        BlockingTaskSummaryResponseHandler responseHandler = new BlockingTaskSummaryResponseHandler();
        this.client.getTasksAssignedAsPotentialOwner("Darth Vader", "Crusaders", "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        List tasks = responseHandler.getResults();
        WSHumanTaskHandlerTest.assertEquals((int)2, (int)tasks.size());
    }

    public void testTaskFail() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("TaskName", (Object)"TaskName");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        this.handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Thread.sleep(500L);
        BlockingTaskSummaryResponseHandler responseHandler = new BlockingTaskSummaryResponseHandler();
        this.client.getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        List tasks = responseHandler.getResults();
        WSHumanTaskHandlerTest.assertEquals((int)1, (int)tasks.size());
        TaskSummary task = (TaskSummary)tasks.get(0);
        WSHumanTaskHandlerTest.assertEquals((String)"TaskName", (String)task.getName());
        WSHumanTaskHandlerTest.assertEquals((int)10, (int)task.getPriority());
        WSHumanTaskHandlerTest.assertEquals((String)"Comment", (String)task.getDescription());
        WSHumanTaskHandlerTest.assertEquals((Object)Status.Reserved, (Object)task.getStatus());
        WSHumanTaskHandlerTest.assertEquals((String)"Darth Vader", (String)task.getActualOwner().getId());
        System.out.println("Starting task " + task.getId());
        BlockingTaskOperationResponseHandler operationResponseHandler = new BlockingTaskOperationResponseHandler();
        this.client.start(task.getId(), "Darth Vader", (TaskClientHandler.TaskOperationResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        System.out.println("Started task " + task.getId());
        System.out.println("Failing task " + task.getId());
        operationResponseHandler = new BlockingTaskOperationResponseHandler();
        this.client.fail(task.getId(), "Darth Vader", null, (TaskClientHandler.TaskOperationResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        System.out.println("Failed task " + task.getId());
        WSHumanTaskHandlerTest.assertTrue((boolean)manager.isAborted());
    }

    public void testTaskSkip() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("TaskName", (Object)"TaskName");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        this.handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Thread.sleep(500L);
        BlockingTaskSummaryResponseHandler responseHandler = new BlockingTaskSummaryResponseHandler();
        this.client.getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        List tasks = responseHandler.getResults();
        WSHumanTaskHandlerTest.assertEquals((int)1, (int)tasks.size());
        TaskSummary task = (TaskSummary)tasks.get(0);
        WSHumanTaskHandlerTest.assertEquals((String)"TaskName", (String)task.getName());
        WSHumanTaskHandlerTest.assertEquals((int)10, (int)task.getPriority());
        WSHumanTaskHandlerTest.assertEquals((String)"Comment", (String)task.getDescription());
        WSHumanTaskHandlerTest.assertEquals((Object)Status.Reserved, (Object)task.getStatus());
        WSHumanTaskHandlerTest.assertEquals((String)"Darth Vader", (String)task.getActualOwner().getId());
        System.out.println("Skipping task " + task.getId());
        BlockingTaskOperationResponseHandler operationResponseHandler = new BlockingTaskOperationResponseHandler();
        this.client.skip(task.getId(), "Darth Vader", (TaskClientHandler.TaskOperationResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        System.out.println("Skipped task " + task.getId());
        WSHumanTaskHandlerTest.assertTrue((boolean)manager.isAborted());
    }

    public void testTaskAbortSkippable() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("TaskName", (Object)"TaskName");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        this.handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Thread.sleep(500L);
        this.handler.abortWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Thread.sleep(500L);
        BlockingTaskSummaryResponseHandler responseHandler = new BlockingTaskSummaryResponseHandler();
        this.client.getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        List tasks = responseHandler.getResults();
        WSHumanTaskHandlerTest.assertEquals((int)0, (int)tasks.size());
    }

    public void testTaskAbortNotSkippable() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("TaskName", (Object)"TaskName");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        workItem.setParameter("Skippable", (Object)"false");
        this.handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Thread.sleep(500L);
        BlockingTaskSummaryResponseHandler responseHandler = new BlockingTaskSummaryResponseHandler();
        this.client.getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        List tasks = responseHandler.getResults();
        WSHumanTaskHandlerTest.assertEquals((int)1, (int)tasks.size());
        this.handler.abortWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Thread.sleep(500L);
        responseHandler = new BlockingTaskSummaryResponseHandler();
        this.client.getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        tasks = responseHandler.getResults();
        WSHumanTaskHandlerTest.assertEquals((int)1, (int)tasks.size());
    }

    public void testTaskData() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("TaskName", (Object)"TaskName");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        workItem.setParameter("Content", (Object)"This is the content");
        this.handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Thread.sleep(500L);
        BlockingTaskSummaryResponseHandler responseHandler = new BlockingTaskSummaryResponseHandler();
        this.client.getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        List tasks = responseHandler.getResults();
        WSHumanTaskHandlerTest.assertEquals((int)1, (int)tasks.size());
        TaskSummary taskSummary = (TaskSummary)tasks.get(0);
        WSHumanTaskHandlerTest.assertEquals((String)"TaskName", (String)taskSummary.getName());
        WSHumanTaskHandlerTest.assertEquals((int)10, (int)taskSummary.getPriority());
        WSHumanTaskHandlerTest.assertEquals((String)"Comment", (String)taskSummary.getDescription());
        WSHumanTaskHandlerTest.assertEquals((Object)Status.Reserved, (Object)taskSummary.getStatus());
        WSHumanTaskHandlerTest.assertEquals((String)"Darth Vader", (String)taskSummary.getActualOwner().getId());
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskSummary.getId(), (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task = getTaskResponseHandler.getTask();
        WSHumanTaskHandlerTest.assertEquals((Object)AccessType.Inline, (Object)task.getTaskData().getDocumentAccessType());
        long contentId = task.getTaskData().getDocumentContentId();
        WSHumanTaskHandlerTest.assertTrue((contentId != -1L ? 1 : 0) != 0);
        BlockingGetContentResponseHandler getContentResponseHandler = new BlockingGetContentResponseHandler();
        this.client.getContent(contentId, (TaskClientHandler.GetContentResponseHandler)getContentResponseHandler);
        ByteArrayInputStream bis = new ByteArrayInputStream(getContentResponseHandler.getContent().getContent());
        ObjectInputStream in = new ObjectInputStream(bis);
        Object data = in.readObject();
        in.close();
        WSHumanTaskHandlerTest.assertEquals((Object)"This is the content", (Object)data);
        System.out.println("Starting task " + task.getId());
        BlockingTaskOperationResponseHandler operationResponseHandler = new BlockingTaskOperationResponseHandler();
        this.client.start(task.getId().longValue(), "Darth Vader", (TaskClientHandler.TaskOperationResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        System.out.println("Started task " + task.getId());
        System.out.println("Completing task " + task.getId());
        operationResponseHandler = new BlockingTaskOperationResponseHandler();
        ContentData result = new ContentData();
        result.setAccessType(AccessType.Inline);
        result.setType("java.lang.String");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bos);
        out.writeObject("This is the result");
        out.close();
        result.setContent(bos.toByteArray());
        this.client.complete(task.getId().longValue(), "Darth Vader", result, (TaskClientHandler.TaskOperationResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        System.out.println("Completed task " + task.getId());
        WSHumanTaskHandlerTest.assertTrue((boolean)manager.isCompleted());
        Map<String, Object> results = manager.getResults();
        WSHumanTaskHandlerTest.assertNotNull(results);
        WSHumanTaskHandlerTest.assertEquals((Object)"Darth Vader", (Object)results.get("ActorId"));
        WSHumanTaskHandlerTest.assertEquals((Object)"This is the result", (Object)results.get("Result"));
    }

    public void testOnAllSubTasksEndParentEndStrategy() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("TaskName", (Object)"TaskNameParent");
        workItem.setParameter("Comment", (Object)"CommentParent");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        workItem.setParameter("SubTaskStrategies", (Object)"OnAllSubTasksEndParentEnd");
        this.handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Thread.sleep(500L);
        BlockingTaskSummaryResponseHandler responseHandler = new BlockingTaskSummaryResponseHandler();
        this.client.getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        List tasks = responseHandler.getResults();
        WSHumanTaskHandlerTest.assertEquals((int)1, (int)tasks.size());
        TaskSummary task = (TaskSummary)tasks.get(0);
        WSHumanTaskHandlerTest.assertEquals((String)"TaskNameParent", (String)task.getName());
        WSHumanTaskHandlerTest.assertEquals((int)10, (int)task.getPriority());
        WSHumanTaskHandlerTest.assertEquals((String)"CommentParent", (String)task.getDescription());
        WSHumanTaskHandlerTest.assertEquals((Object)Status.Reserved, (Object)task.getStatus());
        WSHumanTaskHandlerTest.assertEquals((String)"Darth Vader", (String)task.getActualOwner().getId());
        workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("TaskName", (Object)"TaskNameChild1");
        workItem.setParameter("Comment", (Object)"CommentChild1");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        workItem.setParameter("ParentId", (Object)task.getId());
        this.handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Thread.sleep(500L);
        workItem = new WorkItemImpl();
        workItem.setName("Human Task2");
        workItem.setParameter("TaskName", (Object)"TaskNameChild2");
        workItem.setParameter("Comment", (Object)"CommentChild2");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        workItem.setParameter("ParentId", (Object)task.getId());
        this.handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Thread.sleep(500L);
        System.out.println("Starting task " + task.getId());
        BlockingTaskOperationResponseHandler operationResponseHandler = new BlockingTaskOperationResponseHandler();
        this.client.start(task.getId(), "Darth Vader", (TaskClientHandler.TaskOperationResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        System.out.println("Started task " + task.getId());
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(task.getId(), (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task parentTask = getTaskResponseHandler.getTask();
        WSHumanTaskHandlerTest.assertEquals((Object)Status.InProgress, (Object)parentTask.getTaskData().getStatus());
        WSHumanTaskHandlerTest.assertEquals(this.users.get("darth"), (Object)parentTask.getTaskData().getActualOwner());
        responseHandler = new BlockingTaskSummaryResponseHandler();
        this.client.getSubTasksAssignedAsPotentialOwner(parentTask.getId().longValue(), "Darth Vader", "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        List subTasks = responseHandler.getResults();
        WSHumanTaskHandlerTest.assertEquals((int)2, (int)subTasks.size());
        TaskSummary subTaskSummary1 = (TaskSummary)subTasks.get(0);
        TaskSummary subTaskSummary2 = (TaskSummary)subTasks.get(1);
        WSHumanTaskHandlerTest.assertNotNull((Object)subTaskSummary1);
        WSHumanTaskHandlerTest.assertNotNull((Object)subTaskSummary2);
        System.out.println("Starting sub task " + subTaskSummary1.getId());
        operationResponseHandler = new BlockingTaskOperationResponseHandler();
        this.client.start(subTaskSummary1.getId(), "Darth Vader", (TaskClientHandler.TaskOperationResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        System.out.println("Started sub task " + subTaskSummary1.getId());
        System.out.println("Starting sub task " + subTaskSummary2.getId());
        operationResponseHandler = new BlockingTaskOperationResponseHandler();
        this.client.start(subTaskSummary2.getId(), "Darth Vader", (TaskClientHandler.TaskOperationResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        System.out.println("Started sub task " + subTaskSummary2.getId());
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(subTaskSummary1.getId(), (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task subTask1 = getTaskResponseHandler.getTask();
        WSHumanTaskHandlerTest.assertEquals((Object)Status.InProgress, (Object)subTask1.getTaskData().getStatus());
        WSHumanTaskHandlerTest.assertEquals(this.users.get("darth"), (Object)subTask1.getTaskData().getActualOwner());
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(subTaskSummary2.getId(), (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task subTask2 = getTaskResponseHandler.getTask();
        WSHumanTaskHandlerTest.assertEquals((Object)Status.InProgress, (Object)subTask2.getTaskData().getStatus());
        WSHumanTaskHandlerTest.assertEquals(this.users.get("darth"), (Object)subTask2.getTaskData().getActualOwner());
        System.out.println("Completing sub task " + subTask1.getId());
        operationResponseHandler = new BlockingTaskOperationResponseHandler();
        this.client.complete(subTask1.getId().longValue(), "Darth Vader", null, (TaskClientHandler.TaskOperationResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        System.out.println("Completed sub task " + subTask1.getId());
        System.out.println("Completing sub task " + subTask2.getId());
        operationResponseHandler = new BlockingTaskOperationResponseHandler();
        this.client.complete(subTask2.getId().longValue(), "Darth Vader", null, (TaskClientHandler.TaskOperationResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        System.out.println("Completed sub task " + subTask2.getId());
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(subTask1.getId().longValue(), (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        subTask1 = getTaskResponseHandler.getTask();
        WSHumanTaskHandlerTest.assertEquals((Object)Status.Completed, (Object)subTask1.getTaskData().getStatus());
        WSHumanTaskHandlerTest.assertEquals(this.users.get("darth"), (Object)subTask1.getTaskData().getActualOwner());
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(subTask2.getId().longValue(), (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        subTask2 = getTaskResponseHandler.getTask();
        WSHumanTaskHandlerTest.assertEquals((Object)Status.Completed, (Object)subTask2.getTaskData().getStatus());
        WSHumanTaskHandlerTest.assertEquals(this.users.get("darth"), (Object)subTask2.getTaskData().getActualOwner());
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(parentTask.getId().longValue(), (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        parentTask = getTaskResponseHandler.getTask();
        WSHumanTaskHandlerTest.assertEquals((Object)Status.Completed, (Object)parentTask.getTaskData().getStatus());
        WSHumanTaskHandlerTest.assertEquals(this.users.get("darth"), (Object)parentTask.getTaskData().getActualOwner());
        WSHumanTaskHandlerTest.assertTrue((boolean)manager.isCompleted());
    }

    public void testOnParentAbortAllSubTasksEndStrategy() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("TaskName", (Object)"TaskNameParent");
        workItem.setParameter("Comment", (Object)"CommentParent");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        workItem.setParameter("SubTaskStrategies", (Object)"OnParentAbortAllSubTasksEnd");
        this.handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Thread.sleep(500L);
        BlockingTaskSummaryResponseHandler responseHandler = new BlockingTaskSummaryResponseHandler();
        this.client.getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        List tasks = responseHandler.getResults();
        WSHumanTaskHandlerTest.assertEquals((int)1, (int)tasks.size());
        TaskSummary task = (TaskSummary)tasks.get(0);
        WSHumanTaskHandlerTest.assertEquals((String)"TaskNameParent", (String)task.getName());
        WSHumanTaskHandlerTest.assertEquals((int)10, (int)task.getPriority());
        WSHumanTaskHandlerTest.assertEquals((String)"CommentParent", (String)task.getDescription());
        WSHumanTaskHandlerTest.assertEquals((Object)Status.Reserved, (Object)task.getStatus());
        WSHumanTaskHandlerTest.assertEquals((String)"Darth Vader", (String)task.getActualOwner().getId());
        workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("TaskName", (Object)"TaskNameChild1");
        workItem.setParameter("Comment", (Object)"CommentChild1");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        workItem.setParameter("ParentId", (Object)task.getId());
        this.handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Thread.sleep(500L);
        workItem = new WorkItemImpl();
        workItem.setName("Human Task2");
        workItem.setParameter("TaskName", (Object)"TaskNameChild2");
        workItem.setParameter("Comment", (Object)"CommentChild2");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        workItem.setParameter("ParentId", (Object)task.getId());
        this.handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Thread.sleep(500L);
        System.out.println("Starting task " + task.getId());
        BlockingTaskOperationResponseHandler operationResponseHandler = new BlockingTaskOperationResponseHandler();
        this.client.start(task.getId(), "Darth Vader", (TaskClientHandler.TaskOperationResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        System.out.println("Started task " + task.getId());
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(task.getId(), (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task parentTask = getTaskResponseHandler.getTask();
        WSHumanTaskHandlerTest.assertEquals((Object)Status.InProgress, (Object)parentTask.getTaskData().getStatus());
        WSHumanTaskHandlerTest.assertEquals(this.users.get("darth"), (Object)parentTask.getTaskData().getActualOwner());
        responseHandler = new BlockingTaskSummaryResponseHandler();
        this.client.getSubTasksAssignedAsPotentialOwner(parentTask.getId().longValue(), "Darth Vader", "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        List subTasks = responseHandler.getResults();
        WSHumanTaskHandlerTest.assertEquals((int)2, (int)subTasks.size());
        TaskSummary subTaskSummary1 = (TaskSummary)subTasks.get(0);
        TaskSummary subTaskSummary2 = (TaskSummary)subTasks.get(1);
        WSHumanTaskHandlerTest.assertNotNull((Object)subTaskSummary1);
        WSHumanTaskHandlerTest.assertNotNull((Object)subTaskSummary2);
        System.out.println("Starting sub task " + subTaskSummary1.getId());
        operationResponseHandler = new BlockingTaskOperationResponseHandler();
        this.client.start(subTaskSummary1.getId(), "Darth Vader", (TaskClientHandler.TaskOperationResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        System.out.println("Started sub task " + subTaskSummary1.getId());
        System.out.println("Starting sub task " + subTaskSummary2.getId());
        operationResponseHandler = new BlockingTaskOperationResponseHandler();
        this.client.start(subTaskSummary2.getId(), "Darth Vader", (TaskClientHandler.TaskOperationResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        System.out.println("Started sub task " + subTaskSummary2.getId());
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(subTaskSummary1.getId(), (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task subTask1 = getTaskResponseHandler.getTask();
        WSHumanTaskHandlerTest.assertEquals((Object)Status.InProgress, (Object)subTask1.getTaskData().getStatus());
        WSHumanTaskHandlerTest.assertEquals(this.users.get("darth"), (Object)subTask1.getTaskData().getActualOwner());
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(subTaskSummary2.getId(), (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task subTask2 = getTaskResponseHandler.getTask();
        WSHumanTaskHandlerTest.assertEquals((Object)Status.InProgress, (Object)subTask2.getTaskData().getStatus());
        WSHumanTaskHandlerTest.assertEquals(this.users.get("darth"), (Object)subTask2.getTaskData().getActualOwner());
        System.out.println("Completing parent task " + parentTask.getId());
        operationResponseHandler = new BlockingTaskOperationResponseHandler();
        this.client.skip(parentTask.getId().longValue(), "Darth Vader", (TaskClientHandler.TaskOperationResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        System.out.println("Completed parent task " + parentTask.getId());
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(subTaskSummary1.getId(), (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        subTask1 = getTaskResponseHandler.getTask();
        WSHumanTaskHandlerTest.assertEquals((Object)Status.Completed, (Object)subTask1.getTaskData().getStatus());
        WSHumanTaskHandlerTest.assertEquals(this.users.get("darth"), (Object)subTask1.getTaskData().getActualOwner());
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(subTaskSummary2.getId(), (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        subTask2 = getTaskResponseHandler.getTask();
        WSHumanTaskHandlerTest.assertEquals((Object)Status.Completed, (Object)subTask2.getTaskData().getStatus());
        WSHumanTaskHandlerTest.assertEquals(this.users.get("darth"), (Object)subTask2.getTaskData().getActualOwner());
        WSHumanTaskHandlerTest.assertTrue((boolean)manager.isCompleted());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TestWorkItemManager
    implements WorkItemManager {
        private boolean completed;
        private boolean aborted;
        private Map<String, Object> results;

        private TestWorkItemManager() {
        }

        public void abortWorkItem(long id) {
            this.aborted = true;
        }

        public boolean isAborted() {
            return this.aborted;
        }

        public void completeWorkItem(long id, Map<String, Object> results) {
            this.completed = true;
            this.results = results;
        }

        public boolean isCompleted() {
            return this.completed;
        }

        public WorkItem getWorkItem(long id) {
            return null;
        }

        public Set<WorkItem> getWorkItems() {
            return null;
        }

        public Map<String, Object> getResults() {
            return this.results;
        }

        public void internalAbortWorkItem(long id) {
        }

        public void internalAddWorkItem(WorkItem workItem) {
        }

        public void internalExecuteWorkItem(WorkItem workItem) {
        }

        public void registerWorkItemHandler(String workItemName, WorkItemHandler handler) {
        }
    }
}

