/*
 * Decompiled with CFR 0.152.
 */
package org.drools.task;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.apache.commons.collections.map.HashedMap;
import org.drools.task.Group;
import org.drools.task.MockUserInfo;
import org.drools.task.User;
import org.drools.task.UserInfo;
import org.drools.task.service.MinaTaskServer;
import org.drools.task.service.SendIcal;
import org.drools.task.service.TaskService;
import org.drools.task.service.TaskServiceSession;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;
import org.mvel2.compiler.ExpressionCompiler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunTaskService {
    private EntityManagerFactory emf;
    private TaskService taskService;
    private TaskServiceSession taskSession;
    private MinaTaskServer server;

    public static void main(String[] args) throws Exception {
        new RunTaskService().start();
    }

    private void start() throws Exception {
        Properties conf = new Properties();
        conf.setProperty("mail.smtp.host", "localhost");
        conf.setProperty("mail.smtp.port", "2345");
        conf.setProperty("from", "from@domain.com");
        conf.setProperty("replyTo", "replyTo@domain.com");
        conf.setProperty("defaultLanguage", "en-UK");
        SendIcal.initInstance((Properties)conf);
        this.emf = Persistence.createEntityManagerFactory((String)"org.drools.task");
        this.taskService = new TaskService(this.emf);
        this.taskSession = this.taskService.createSession();
        MockUserInfo userInfo = new MockUserInfo();
        this.taskService.setUserinfo((UserInfo)userInfo);
        HashedMap vars = new HashedMap();
        InputStreamReader reader = new InputStreamReader(RunTaskService.class.getResourceAsStream("LoadUsers.mvel"));
        Map users = (Map)this.eval(reader, (Map<String, Object>)vars);
        for (User user : users.values()) {
            this.taskSession.addUser(user);
        }
        reader = new InputStreamReader(RunTaskService.class.getResourceAsStream("LoadGroups.mvel"));
        Map groups = (Map)this.eval(reader, (Map<String, Object>)vars);
        for (Group group : groups.values()) {
            this.taskSession.addGroup(group);
        }
        this.server = new MinaTaskServer(this.taskService);
        Thread thread = new Thread((Runnable)this.server);
        thread.start();
        Thread.sleep(500L);
        System.out.println("Server started ...");
    }

    protected void stop() throws Exception {
        this.server.stop();
        this.taskSession.dispose();
        this.emf.close();
    }

    public Object eval(Reader reader, Map<String, Object> vars) {
        try {
            return this.eval(this.toString(reader), vars);
        }
        catch (IOException e) {
            throw new RuntimeException("Exception Thrown", e);
        }
    }

    public String toString(Reader reader) throws IOException {
        int charValue = 0;
        StringBuffer sb = new StringBuffer(1024);
        while ((charValue = reader.read()) != -1) {
            sb.append((char)charValue);
        }
        return sb.toString();
    }

    public Object eval(String str, Map<String, Object> vars) {
        ExpressionCompiler compiler = new ExpressionCompiler(str.trim());
        ParserContext context = new ParserContext();
        context.addPackageImport("org.drools.task");
        context.addPackageImport("org.drools.task.service");
        context.addPackageImport("org.drools.task.query");
        context.addPackageImport("java.util");
        vars.put("now", new Date());
        return MVEL.executeExpression((Object)compiler.compile(context), vars);
    }
}

