/*
 * Decompiled with CFR 0.152.
 */
package org.drools.task.service;

import java.io.StringReader;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.HashedMap;
import org.apache.mina.transport.socket.SocketConnector;
import org.apache.mina.transport.socket.nio.NioSocketConnector;
import org.drools.eventmessaging.EventKey;
import org.drools.eventmessaging.EventResponseHandler;
import org.drools.eventmessaging.Payload;
import org.drools.task.BaseTest;
import org.drools.task.Status;
import org.drools.task.Task;
import org.drools.task.User;
import org.drools.task.event.TaskCompletedEvent;
import org.drools.task.event.TaskEventKey;
import org.drools.task.query.TaskSummary;
import org.drools.task.service.MinaTaskClient;
import org.drools.task.service.MinaTaskServer;
import org.drools.task.service.TaskClientHandler;
import org.drools.task.service.responsehandlers.BlockingAddTaskResponseHandler;
import org.drools.task.service.responsehandlers.BlockingEventResponseHandler;
import org.drools.task.service.responsehandlers.BlockingGetTaskResponseHandler;
import org.drools.task.service.responsehandlers.BlockingTaskOperationResponseHandler;
import org.drools.task.service.responsehandlers.BlockingTaskSummaryResponseHandler;

public class TaskLifeCycleTest
extends BaseTest {
    MinaTaskServer server;
    MinaTaskClient client;

    protected void setUp() throws Exception {
        super.setUp();
        this.server = new MinaTaskServer(this.taskService);
        Thread thread = new Thread((Runnable)this.server);
        thread.start();
        Thread.sleep(500L);
        this.client = new MinaTaskClient("client 1", new TaskClientHandler());
        NioSocketConnector connector = new NioSocketConnector();
        InetSocketAddress address = new InetSocketAddress("127.0.0.1", 9123);
        this.client.connect((SocketConnector)connector, (SocketAddress)address);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.client.disconnect();
        this.server.stop();
    }

    public void testLifeCycle() throws Exception {
        HashedMap vars = new HashedMap();
        vars.put("users", this.users);
        vars.put("groups", this.groups);
        vars.put("now", new Date());
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { workItemId = 1 } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba']], }),";
        str = str + "descriptions = [ new I18NText( 'en-UK', 'This is my description')], ";
        str = str + "subjects = [ new I18NText( 'en-UK', 'This is my subject')], ";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)this.eval(new StringReader(str), (Map)vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        TaskEventKey key = new TaskEventKey(TaskCompletedEvent.class, taskId);
        BlockingEventResponseHandler handler = new BlockingEventResponseHandler();
        this.client.registerForEvent((EventKey)key, true, (EventResponseHandler)handler);
        BlockingTaskSummaryResponseHandler taskSummaryResponseHandler = new BlockingTaskSummaryResponseHandler();
        this.client.getTasksAssignedAsPotentialOwner(((User)this.users.get("bobba")).getId(), "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)taskSummaryResponseHandler);
        List tasks = taskSummaryResponseHandler.getResults();
        TaskLifeCycleTest.assertEquals((int)1, (int)tasks.size());
        TaskLifeCycleTest.assertEquals((Object)Status.Reserved, (Object)((TaskSummary)tasks.get(0)).getStatus());
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.start(taskId, ((User)this.users.get("bobba")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        taskSummaryResponseHandler = new BlockingTaskSummaryResponseHandler();
        this.client.getTasksAssignedAsPotentialOwner(((User)this.users.get("bobba")).getId(), "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)taskSummaryResponseHandler);
        tasks = taskSummaryResponseHandler.getResults();
        TaskLifeCycleTest.assertEquals((int)1, (int)tasks.size());
        TaskLifeCycleTest.assertEquals((Object)Status.InProgress, (Object)((TaskSummary)tasks.get(0)).getStatus());
        responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.complete(taskId, ((User)this.users.get("bobba")).getId(), null, (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        taskSummaryResponseHandler = new BlockingTaskSummaryResponseHandler();
        this.client.getTasksAssignedAsPotentialOwner(((User)this.users.get("bobba")).getId(), "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)taskSummaryResponseHandler);
        tasks = taskSummaryResponseHandler.getResults();
        TaskLifeCycleTest.assertEquals((int)0, (int)tasks.size());
        Payload payload = handler.getPayload();
        TaskCompletedEvent event = (TaskCompletedEvent)payload.get();
        TaskLifeCycleTest.assertNotNull((Object)event);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskLifeCycleTest.assertEquals((Object)Status.Completed, (Object)task1.getTaskData().getStatus());
    }

    public void testLifeCycleMultipleTasks() throws Exception {
        HashedMap vars = new HashedMap();
        vars.put("users", this.users);
        vars.put("groups", this.groups);
        vars.put("now", new Date());
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { workItemId = 1 } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba']], }),";
        str = str + "descriptions = [ new I18NText( 'en-UK', 'This is my description')], ";
        str = str + "subjects = [ new I18NText( 'en-UK', 'This is my subject')], ";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)this.eval(new StringReader(str), (Map)vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        TaskEventKey key = new TaskEventKey(TaskCompletedEvent.class, taskId);
        BlockingEventResponseHandler handler = new BlockingEventResponseHandler();
        this.client.registerForEvent((EventKey)key, true, (EventResponseHandler)handler);
        BlockingTaskSummaryResponseHandler taskSummaryResponseHandler = new BlockingTaskSummaryResponseHandler();
        this.client.getTasksAssignedAsPotentialOwner(((User)this.users.get("bobba")).getId(), "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)taskSummaryResponseHandler);
        List tasks = taskSummaryResponseHandler.getResults();
        TaskLifeCycleTest.assertEquals((int)1, (int)tasks.size());
        TaskLifeCycleTest.assertEquals((Object)Status.Reserved, (Object)((TaskSummary)tasks.get(0)).getStatus());
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.start(taskId, ((User)this.users.get("bobba")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        taskSummaryResponseHandler = new BlockingTaskSummaryResponseHandler();
        this.client.getTasksAssignedAsPotentialOwner(((User)this.users.get("bobba")).getId(), "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)taskSummaryResponseHandler);
        tasks = taskSummaryResponseHandler.getResults();
        TaskLifeCycleTest.assertEquals((int)1, (int)tasks.size());
        TaskLifeCycleTest.assertEquals((Object)Status.InProgress, (Object)((TaskSummary)tasks.get(0)).getStatus());
        BlockingAddTaskResponseHandler addTaskResponseHandler2 = new BlockingAddTaskResponseHandler();
        Task task2 = (Task)this.eval(new StringReader(str), (Map)vars);
        this.client.addTask(task2, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler2);
        long taskId2 = addTaskResponseHandler.getTaskId();
        TaskEventKey key2 = new TaskEventKey(TaskCompletedEvent.class, taskId2);
        BlockingEventResponseHandler handler2 = new BlockingEventResponseHandler();
        this.client.registerForEvent((EventKey)key2, true, (EventResponseHandler)handler2);
        taskSummaryResponseHandler = new BlockingTaskSummaryResponseHandler();
        this.client.getTasksAssignedAsPotentialOwner(((User)this.users.get("bobba")).getId(), "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)taskSummaryResponseHandler);
        tasks = taskSummaryResponseHandler.getResults();
        TaskLifeCycleTest.assertEquals((int)2, (int)tasks.size());
        responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.complete(taskId, ((User)this.users.get("bobba")).getId(), null, (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.start(taskId2, ((User)this.users.get("bobba")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        taskSummaryResponseHandler = new BlockingTaskSummaryResponseHandler();
        this.client.getTasksAssignedAsPotentialOwner(((User)this.users.get("bobba")).getId(), "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)taskSummaryResponseHandler);
        tasks = taskSummaryResponseHandler.getResults();
        TaskLifeCycleTest.assertEquals((int)1, (int)tasks.size());
        Payload payload = handler.getPayload();
        TaskCompletedEvent event = (TaskCompletedEvent)payload.get();
        TaskLifeCycleTest.assertNotNull((Object)event);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        task = getTaskResponseHandler.getTask();
        TaskLifeCycleTest.assertEquals((Object)Status.Completed, (Object)task.getTaskData().getStatus());
        responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.complete(taskId2, ((User)this.users.get("bobba")).getId(), null, (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        payload = handler.getPayload();
        event = (TaskCompletedEvent)payload.get();
        TaskLifeCycleTest.assertNotNull((Object)event);
        BlockingGetTaskResponseHandler getTaskResponseHandler2 = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId2, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler2);
        task2 = getTaskResponseHandler2.getTask();
        TaskLifeCycleTest.assertEquals((Object)Status.Completed, (Object)task2.getTaskData().getStatus());
    }
}

