/*
 * Decompiled with CFR 0.152.
 */
package org.drools.task.service;

import java.io.StringReader;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.HashedMap;
import org.apache.mina.transport.socket.SocketConnector;
import org.apache.mina.transport.socket.nio.NioSocketConnector;
import org.drools.task.AccessType;
import org.drools.task.Attachment;
import org.drools.task.BaseTest;
import org.drools.task.Comment;
import org.drools.task.Content;
import org.drools.task.Status;
import org.drools.task.Task;
import org.drools.task.User;
import org.drools.task.service.MinaTaskClient;
import org.drools.task.service.MinaTaskServer;
import org.drools.task.service.TaskClientHandler;
import org.drools.task.service.responsehandlers.BlockingAddAttachmentResponseHandler;
import org.drools.task.service.responsehandlers.BlockingAddCommentResponseHandler;
import org.drools.task.service.responsehandlers.BlockingAddTaskResponseHandler;
import org.drools.task.service.responsehandlers.BlockingDeleteAttachmentResponseHandler;
import org.drools.task.service.responsehandlers.BlockingDeleteCommentResponseHandler;
import org.drools.task.service.responsehandlers.BlockingGetContentResponseHandler;
import org.drools.task.service.responsehandlers.BlockingGetTaskResponseHandler;
import org.drools.task.utils.CollectionUtils;

public class TaskServiceCommentsAndAttachmentsTest
extends BaseTest {
    MinaTaskServer server;
    MinaTaskClient client;

    protected void setUp() throws Exception {
        super.setUp();
        this.server = new MinaTaskServer(this.taskService);
        Thread thread = new Thread((Runnable)this.server);
        thread.start();
        Thread.sleep(500L);
        this.client = new MinaTaskClient("client 1", new TaskClientHandler());
        NioSocketConnector connector = new NioSocketConnector();
        InetSocketAddress address = new InetSocketAddress("127.0.0.1", 9123);
        this.client.connect((SocketConnector)connector, (SocketAddress)address);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.client.disconnect();
        this.server.stop();
    }

    public void testAddRemoveComment() {
        HashedMap vars = new HashedMap();
        vars.put("users", this.users);
        vars.put("groups", this.groups);
        vars.put("now", new Date());
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { createdOn = now, activationTime = now}), ";
        str = str + "deadlines = new Deadlines(),";
        str = str + "delegation = new Delegation(),";
        str = str + "peopleAssignments = new PeopleAssignments(),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)this.eval(new StringReader(str), (Map)vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        Comment comment = new Comment();
        Date addedAt = new Date(System.currentTimeMillis());
        comment.setAddedAt(addedAt);
        comment.setAddedBy((User)this.users.get("luke"));
        comment.setText("This is my comment1!!!!!");
        BlockingAddCommentResponseHandler addCommentResponseHandler = new BlockingAddCommentResponseHandler();
        this.client.addComment(taskId, comment, (TaskClientHandler.AddCommentResponseHandler)addCommentResponseHandler);
        TaskServiceCommentsAndAttachmentsTest.assertTrue((addCommentResponseHandler.getCommentId() != comment.getId().longValue() ? 1 : 0) != 0);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceCommentsAndAttachmentsTest.assertNotSame((Object)task, (Object)task1);
        TaskServiceCommentsAndAttachmentsTest.assertFalse((boolean)task.equals((Object)task1));
        List comments1 = task1.getTaskData().getComments();
        TaskServiceCommentsAndAttachmentsTest.assertEquals((int)1, (int)comments1.size());
        Comment returnedComment = (Comment)comments1.get(0);
        TaskServiceCommentsAndAttachmentsTest.assertEquals((String)"This is my comment1!!!!!", (String)returnedComment.getText());
        TaskServiceCommentsAndAttachmentsTest.assertEquals((Object)addedAt, (Object)returnedComment.getAddedAt());
        TaskServiceCommentsAndAttachmentsTest.assertEquals(this.users.get("luke"), (Object)returnedComment.getAddedBy());
        TaskServiceCommentsAndAttachmentsTest.assertEquals((long)addCommentResponseHandler.getCommentId(), (long)returnedComment.getId());
        task.getTaskData().setComments(comments1);
        task.getTaskData().setStatus(Status.Created);
        TaskServiceCommentsAndAttachmentsTest.assertEquals((Object)task, (Object)task1);
        comment = new Comment();
        addedAt = new Date(System.currentTimeMillis());
        comment.setAddedAt(addedAt);
        comment.setAddedBy((User)this.users.get("tony"));
        comment.setText("This is my comment2!!!!!");
        addCommentResponseHandler = new BlockingAddCommentResponseHandler();
        this.client.addComment(taskId, comment, (TaskClientHandler.AddCommentResponseHandler)addCommentResponseHandler);
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        task1 = getTaskResponseHandler.getTask();
        List comments2 = task1.getTaskData().getComments();
        TaskServiceCommentsAndAttachmentsTest.assertEquals((int)2, (int)comments2.size());
        comments1.add(comment);
        TaskServiceCommentsAndAttachmentsTest.assertTrue((boolean)CollectionUtils.equals((List)comments1, (List)comments2));
        BlockingDeleteCommentResponseHandler deleteCommentResponseHandler = new BlockingDeleteCommentResponseHandler();
        this.client.deleteComment(taskId, addCommentResponseHandler.getCommentId(), (TaskClientHandler.DeleteCommentResponseHandler)deleteCommentResponseHandler);
        deleteCommentResponseHandler.waitTillDone(3000L);
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        task1 = getTaskResponseHandler.getTask();
        comments2 = task1.getTaskData().getComments();
        TaskServiceCommentsAndAttachmentsTest.assertEquals((int)1, (int)comments2.size());
        TaskServiceCommentsAndAttachmentsTest.assertEquals((String)"This is my comment1!!!!!", (String)((Comment)comments2.get(0)).getText());
    }

    public void testAddRemoveAttachment() throws Exception {
        HashedMap vars = new HashedMap();
        vars.put("users", this.users);
        vars.put("groups", this.groups);
        vars.put("now", new Date());
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { createdOn = now, activationTime = now}), ";
        str = str + "deadlines = new Deadlines(),";
        str = str + "delegation = new Delegation(),";
        str = str + "peopleAssignments = new PeopleAssignments(),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)this.eval(new StringReader(str), (Map)vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        Attachment attachment = new Attachment();
        Date attachedAt = new Date(System.currentTimeMillis());
        attachment.setAttachedAt(attachedAt);
        attachment.setAttachedBy((User)this.users.get("luke"));
        attachment.setName("file1.txt");
        attachment.setAccessType(AccessType.Inline);
        attachment.setContentType("txt");
        byte[] bytes = "Ths is my attachment text1".getBytes();
        Content content = new Content();
        content.setContent(bytes);
        BlockingAddAttachmentResponseHandler addAttachmentResponseHandler = new BlockingAddAttachmentResponseHandler();
        this.client.addAttachment(taskId, attachment, content, (TaskClientHandler.AddAttachmentResponseHandler)addAttachmentResponseHandler);
        TaskServiceCommentsAndAttachmentsTest.assertTrue((addAttachmentResponseHandler.getAttachmentId() != attachment.getId().longValue() ? 1 : 0) != 0);
        TaskServiceCommentsAndAttachmentsTest.assertTrue((addAttachmentResponseHandler.getContentId() != attachment.getAttachmentContentId() ? 1 : 0) != 0);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceCommentsAndAttachmentsTest.assertNotSame((Object)task, (Object)task1);
        TaskServiceCommentsAndAttachmentsTest.assertFalse((boolean)task.equals((Object)task1));
        List attachments1 = task1.getTaskData().getAttachments();
        TaskServiceCommentsAndAttachmentsTest.assertEquals((int)1, (int)attachments1.size());
        Attachment returnedAttachment = (Attachment)attachments1.get(0);
        TaskServiceCommentsAndAttachmentsTest.assertEquals((Object)attachedAt, (Object)returnedAttachment.getAttachedAt());
        TaskServiceCommentsAndAttachmentsTest.assertEquals(this.users.get("luke"), (Object)returnedAttachment.getAttachedBy());
        TaskServiceCommentsAndAttachmentsTest.assertEquals((Object)AccessType.Inline, (Object)returnedAttachment.getAccessType());
        TaskServiceCommentsAndAttachmentsTest.assertEquals((String)"txt", (String)returnedAttachment.getContentType());
        TaskServiceCommentsAndAttachmentsTest.assertEquals((String)"file1.txt", (String)returnedAttachment.getName());
        TaskServiceCommentsAndAttachmentsTest.assertEquals((int)bytes.length, (int)returnedAttachment.getSize());
        TaskServiceCommentsAndAttachmentsTest.assertEquals((long)addAttachmentResponseHandler.getAttachmentId(), (long)returnedAttachment.getId());
        TaskServiceCommentsAndAttachmentsTest.assertEquals((long)addAttachmentResponseHandler.getContentId(), (long)returnedAttachment.getAttachmentContentId());
        task.getTaskData().setAttachments(attachments1);
        task.getTaskData().setStatus(Status.Created);
        TaskServiceCommentsAndAttachmentsTest.assertEquals((Object)task, (Object)task1);
        BlockingGetContentResponseHandler getResponseHandler = new BlockingGetContentResponseHandler();
        this.client.getContent(returnedAttachment.getAttachmentContentId(), (TaskClientHandler.GetContentResponseHandler)getResponseHandler);
        content = getResponseHandler.getContent();
        TaskServiceCommentsAndAttachmentsTest.assertEquals((String)"Ths is my attachment text1", (String)new String(content.getContent()));
        attachment = new Attachment();
        attachedAt = new Date(System.currentTimeMillis());
        attachment.setAttachedAt(attachedAt);
        attachment.setAttachedBy((User)this.users.get("tony"));
        attachment.setName("file2.txt");
        attachment.setAccessType(AccessType.Inline);
        attachment.setContentType("txt");
        bytes = "Ths is my attachment text2".getBytes();
        content = new Content();
        content.setContent(bytes);
        addAttachmentResponseHandler = new BlockingAddAttachmentResponseHandler();
        this.client.addAttachment(taskId, attachment, content, (TaskClientHandler.AddAttachmentResponseHandler)addAttachmentResponseHandler);
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        task1 = getTaskResponseHandler.getTask();
        TaskServiceCommentsAndAttachmentsTest.assertNotSame((Object)task, (Object)task1);
        TaskServiceCommentsAndAttachmentsTest.assertFalse((boolean)task.equals((Object)task1));
        List attachments2 = task1.getTaskData().getAttachments();
        TaskServiceCommentsAndAttachmentsTest.assertEquals((int)2, (int)attachments2.size());
        getResponseHandler = new BlockingGetContentResponseHandler();
        this.client.getContent(addAttachmentResponseHandler.getContentId(), (TaskClientHandler.GetContentResponseHandler)getResponseHandler);
        content = getResponseHandler.getContent();
        TaskServiceCommentsAndAttachmentsTest.assertEquals((String)"Ths is my attachment text2", (String)new String(content.getContent()));
        attachment.setSize(26);
        attachment.setAttachmentContentId(addAttachmentResponseHandler.getContentId());
        attachments1.add(attachment);
        TaskServiceCommentsAndAttachmentsTest.assertTrue((boolean)CollectionUtils.equals((List)attachments2, (List)attachments1));
        BlockingDeleteAttachmentResponseHandler deleteCommentResponseHandler = new BlockingDeleteAttachmentResponseHandler();
        this.client.deleteAttachment(taskId, addAttachmentResponseHandler.getAttachmentId(), addAttachmentResponseHandler.getContentId(), (TaskClientHandler.DeleteAttachmentResponseHandler)deleteCommentResponseHandler);
        deleteCommentResponseHandler.waitTillDone(3000L);
        Thread.sleep(3000L);
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        task1 = getTaskResponseHandler.getTask();
        attachments2 = task1.getTaskData().getAttachments();
        TaskServiceCommentsAndAttachmentsTest.assertEquals((int)1, (int)attachments2.size());
        TaskServiceCommentsAndAttachmentsTest.assertEquals((String)"file1.txt", (String)((Attachment)attachments2.get(0)).getName());
    }
}

