/*
 * Decompiled with CFR 0.152.
 */
package org.drools.task.service;

import java.io.StringReader;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Date;
import java.util.Map;
import org.apache.commons.collections.map.HashedMap;
import org.apache.mina.transport.socket.SocketConnector;
import org.apache.mina.transport.socket.nio.NioSocketConnector;
import org.drools.eventmessaging.EventKey;
import org.drools.eventmessaging.EventResponseHandler;
import org.drools.eventmessaging.Payload;
import org.drools.task.BaseTest;
import org.drools.task.MockUserInfo;
import org.drools.task.OrganizationalEntity;
import org.drools.task.Status;
import org.drools.task.Task;
import org.drools.task.User;
import org.drools.task.UserInfo;
import org.drools.task.event.TaskClaimedEvent;
import org.drools.task.event.TaskEventKey;
import org.drools.task.event.TaskUserEvent;
import org.drools.task.service.MinaTaskClient;
import org.drools.task.service.MinaTaskServer;
import org.drools.task.service.Operation;
import org.drools.task.service.TaskClientHandler;
import org.drools.task.service.responsehandlers.BlockingAddTaskResponseHandler;
import org.drools.task.service.responsehandlers.BlockingEventResponseHandler;
import org.drools.task.service.responsehandlers.BlockingGetTaskResponseHandler;

public class TaskServiceEventMessagingTest
extends BaseTest {
    MinaTaskServer server;
    MinaTaskClient client;

    protected void setUp() throws Exception {
        super.setUp();
        this.server = new MinaTaskServer(this.taskService);
        Thread thread = new Thread((Runnable)this.server);
        thread.start();
        Thread.sleep(500L);
        this.client = new MinaTaskClient("client 1", new TaskClientHandler());
        NioSocketConnector connector = new NioSocketConnector();
        InetSocketAddress address = new InetSocketAddress("127.0.0.1", 9123);
        this.client.connect((SocketConnector)connector, (SocketAddress)address);
        MockUserInfo userInfo = new MockUserInfo();
        userInfo.getEmails().put((OrganizationalEntity)this.users.get("tony"), "tony@domain.com");
        userInfo.getEmails().put((OrganizationalEntity)this.users.get("steve"), "steve@domain.com");
        userInfo.getLanguages().put((OrganizationalEntity)this.users.get("tony"), "en-UK");
        userInfo.getLanguages().put((OrganizationalEntity)this.users.get("steve"), "en-UK");
        this.taskService.setUserinfo((UserInfo)userInfo);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.client.disconnect();
        this.server.stop();
    }

    public void testClaimEvent() throws Exception {
        HashedMap vars = new HashedMap();
        vars.put("users", this.users);
        vars.put("groups", this.groups);
        vars.put("now", new Date());
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)this.eval(new StringReader(str), (Map)vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceEventMessagingTest.assertEquals((Object)Status.Ready, (Object)task1.getTaskData().getStatus());
        TaskEventKey key = new TaskEventKey(TaskClaimedEvent.class, taskId);
        BlockingEventResponseHandler handler = new BlockingEventResponseHandler();
        this.client.registerForEvent((EventKey)key, true, (EventResponseHandler)handler);
        Thread.sleep(3000L);
        this.taskSession.taskOperation(Operation.Claim, taskId, ((User)this.users.get("darth")).getId(), null, null);
        handler.waitTillDone(5000L);
        Payload payload = handler.getPayload();
        TaskUserEvent event = (TaskUserEvent)payload.get();
        TaskServiceEventMessagingTest.assertNotNull((Object)event);
    }
}

