/*
 * Decompiled with CFR 0.152.
 */
package org.drools.task.service;

import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.HashedMap;
import org.apache.mina.transport.socket.SocketConnector;
import org.apache.mina.transport.socket.nio.NioSocketConnector;
import org.drools.task.BaseTest;
import org.drools.task.Task;
import org.drools.task.User;
import org.drools.task.query.TaskSummary;
import org.drools.task.service.MinaTaskClient;
import org.drools.task.service.MinaTaskServer;
import org.drools.task.service.TaskClientHandler;
import org.drools.task.service.responsehandlers.BlockingAddTaskResponseHandler;
import org.drools.task.utils.CollectionUtils;

public class TaskServiceTest
extends BaseTest {
    MinaTaskServer server;
    MinaTaskClient client;

    protected void setUp() throws Exception {
        super.setUp();
        this.server = new MinaTaskServer(this.taskService);
        Thread thread = new Thread((Runnable)this.server);
        thread.start();
        Thread.sleep(500L);
        this.client = new MinaTaskClient("client 1", new TaskClientHandler());
        NioSocketConnector connector = new NioSocketConnector();
        InetSocketAddress address = new InetSocketAddress("127.0.0.1", 9123);
        this.client.connect((SocketConnector)connector, (SocketAddress)address);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.client.disconnect();
        this.server.stop();
    }

    public void testTasksOwnedQueryWithI18N() throws Exception {
        HashedMap vars = new HashedMap();
        vars.put("users", this.users);
        vars.put("groups", this.groups);
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("QueryData_TasksOwned.mvel"));
        List tasks = (List)this.eval(reader, (Map)vars);
        for (Task task : tasks) {
            BlockingAddTaskResponseHandler responseHandler = new BlockingAddTaskResponseHandler();
            this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)responseHandler);
        }
        reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("QueryResults_TasksOwnedInEnglish.mvel"));
        Map expected = (Map)this.eval(reader, (Map)vars);
        BlockingAllOpenTasksForUseResponseHandler responseHandler = new BlockingAllOpenTasksForUseResponseHandler();
        this.client.getTasksOwned(((User)this.users.get("peter")).getId(), "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        List<TaskSummary> actual = responseHandler.getResults();
        TaskServiceTest.assertEquals((int)3, (int)actual.size());
        TaskServiceTest.assertTrue((boolean)CollectionUtils.equals((List)((List)expected.get("peter")), actual));
        responseHandler = new BlockingAllOpenTasksForUseResponseHandler();
        this.client.getTasksOwned(((User)this.users.get("steve")).getId(), "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        actual = responseHandler.getResults();
        TaskServiceTest.assertEquals((int)2, (int)actual.size());
        TaskServiceTest.assertTrue((boolean)CollectionUtils.equals((List)((List)expected.get("steve")), actual));
        responseHandler = new BlockingAllOpenTasksForUseResponseHandler();
        this.client.getTasksOwned(((User)this.users.get("darth")).getId(), "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        actual = responseHandler.getResults();
        TaskServiceTest.assertEquals((int)1, (int)actual.size());
        TaskServiceTest.assertTrue((boolean)CollectionUtils.equals((List)((List)expected.get("darth")), actual));
        reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("QueryResults_TasksOwnedInGerman.mvel"));
        expected = (Map)this.eval(reader, (Map)vars);
        responseHandler = new BlockingAllOpenTasksForUseResponseHandler();
        this.client.getTasksOwned(((User)this.users.get("peter")).getId(), "en-DK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        actual = responseHandler.getResults();
        TaskServiceTest.assertEquals((int)3, (int)actual.size());
        TaskServiceTest.assertTrue((boolean)CollectionUtils.equals((List)((List)expected.get("peter")), actual));
        responseHandler = new BlockingAllOpenTasksForUseResponseHandler();
        this.client.getTasksOwned(((User)this.users.get("steve")).getId(), "en-DK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        actual = responseHandler.getResults();
        TaskServiceTest.assertEquals((int)2, (int)actual.size());
        TaskServiceTest.assertTrue((boolean)CollectionUtils.equals((List)((List)expected.get("steve")), actual));
        responseHandler = new BlockingAllOpenTasksForUseResponseHandler();
        this.client.getTasksOwned(((User)this.users.get("darth")).getId(), "en-DK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        actual = responseHandler.getResults();
        TaskServiceTest.assertEquals((int)1, (int)actual.size());
        TaskServiceTest.assertTrue((boolean)CollectionUtils.equals((List)((List)expected.get("darth")), actual));
    }

    public void testPeopleAssignmentQueries() {
        HashedMap vars = new HashedMap();
        vars.put("users", this.users);
        vars.put("groups", this.groups);
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("QueryData_TasksOwned.mvel"));
        List tasks = (List)this.eval(reader, (Map)vars);
        for (Task task : tasks) {
            this.taskSession.addTask(task, null);
        }
        reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("QueryResults_PeopleAssignmentQuerries.mvel"));
        Map expected = (Map)this.eval(reader, (Map)vars);
        BlockingAllOpenTasksForUseResponseHandler responseHandler = new BlockingAllOpenTasksForUseResponseHandler();
        this.client.getTasksAssignedAsTaskInitiator(((User)this.users.get("darth")).getId(), "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        List<TaskSummary> actual = responseHandler.getResults();
        TaskServiceTest.assertEquals((int)1, (int)actual.size());
        TaskServiceTest.assertTrue((boolean)CollectionUtils.equals((List)((List)expected.get("darth")), actual));
        responseHandler = new BlockingAllOpenTasksForUseResponseHandler();
        this.client.getTasksAssignedAsBusinessAdministrator(((User)this.users.get("steve")).getId(), "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        actual = responseHandler.getResults();
        TaskServiceTest.assertTrue((boolean)CollectionUtils.equals((List)((List)expected.get("steve")), actual));
        responseHandler = new BlockingAllOpenTasksForUseResponseHandler();
        this.client.getTasksAssignedAsExcludedOwner(((User)this.users.get("liz")).getId(), "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        actual = responseHandler.getResults();
        TaskServiceTest.assertEquals((int)2, (int)actual.size());
        TaskServiceTest.assertTrue((boolean)CollectionUtils.equals((List)((List)expected.get("liz")), actual));
        responseHandler = new BlockingAllOpenTasksForUseResponseHandler();
        this.client.getTasksAssignedAsPotentialOwner(((User)this.users.get("bobba")).getId(), "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        actual = responseHandler.getResults();
        TaskServiceTest.assertEquals((int)3, (int)actual.size());
        TaskServiceTest.assertTrue((boolean)CollectionUtils.equals((List)((List)expected.get("bobba")), actual));
        responseHandler = new BlockingAllOpenTasksForUseResponseHandler();
        this.client.getTasksAssignedAsRecipient(((User)this.users.get("sly")).getId(), "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        actual = responseHandler.getResults();
        TaskServiceTest.assertEquals((int)1, (int)actual.size());
        TaskServiceTest.assertTrue((boolean)CollectionUtils.equals((List)((List)expected.get("sly")), actual));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BlockingAllOpenTasksForUseResponseHandler
    implements TaskClientHandler.TaskSummaryResponseHandler {
        private volatile List<TaskSummary> results;
        private volatile String error;

        public synchronized void execute(List<TaskSummary> results) {
            this.results = results;
            this.notifyAll();
        }

        public synchronized List<TaskSummary> getResults() {
            if (this.results == null) {
                try {
                    this.wait(3000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (this.results == null) {
                throw new RuntimeException("Timeout : unable to retrieve results");
            }
            return this.results;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isDone() {
            List<TaskSummary> list = this.results;
            synchronized (list) {
                return this.results != null;
            }
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getError() {
            return this.error;
        }
    }
}

