/*
 * Decompiled with CFR 0.152.
 */
package org.drools.task;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.List;
import javax.persistence.Embeddable;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import org.drools.task.AllowedToDelegate;
import org.drools.task.OrganizationalEntity;
import org.drools.task.utils.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Embeddable
public class Delegation
implements Externalizable {
    @Enumerated(value=EnumType.STRING)
    private AllowedToDelegate allowedToDelegate;
    @ManyToMany
    @JoinTable(name="Delegation_delegates", joinColumns={@JoinColumn(name="task_id")}, inverseJoinColumns={@JoinColumn(name="entity_id")})
    private List<OrganizationalEntity> delegates = Collections.emptyList();

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.allowedToDelegate != null) {
            out.writeBoolean(true);
            out.writeUTF(this.allowedToDelegate.toString());
        } else {
            out.writeBoolean(false);
        }
        CollectionUtils.writeOrganizationalEntityList(this.delegates, out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        if (in.readBoolean()) {
            this.allowedToDelegate = AllowedToDelegate.valueOf(in.readUTF());
        }
        this.delegates = CollectionUtils.readOrganizationalEntityList(in);
    }

    public AllowedToDelegate getAllowed() {
        return this.allowedToDelegate;
    }

    public void setAllowed(AllowedToDelegate allowedToDelegate) {
        this.allowedToDelegate = allowedToDelegate;
    }

    public List<OrganizationalEntity> getDelegates() {
        return this.delegates;
    }

    public void setDelegates(List<OrganizationalEntity> delegates) {
        this.delegates = delegates;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.allowedToDelegate == null ? 0 : this.allowedToDelegate.hashCode());
        result = 31 * result + CollectionUtils.hashCode(this.delegates);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Delegation)) {
            return false;
        }
        Delegation other = (Delegation)obj;
        if (this.allowedToDelegate == null ? other.allowedToDelegate != null : !this.allowedToDelegate.equals((Object)other.allowedToDelegate)) {
            return false;
        }
        return CollectionUtils.equals(this.delegates, other.delegates);
    }
}

