/*
 * Decompiled with CFR 0.152.
 */
package org.drools.task;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
public class I18NText
implements Externalizable {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private long id;
    private String language;
    @Lob
    private String text;

    public I18NText() {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.id);
        out.writeUTF(this.language);
        out.writeUTF(this.text);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = in.readLong();
        this.language = in.readUTF();
        this.text = in.readUTF();
    }

    public I18NText(String language, String text) {
        this.language = language;
        this.text = text;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.language == null ? 0 : this.language.hashCode());
        result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof I18NText)) {
            return false;
        }
        I18NText other = (I18NText)obj;
        if (this.language == null ? other.language != null : !this.language.equals(other.language)) {
            return false;
        }
        return !(this.text == null ? other.text != null : !this.text.equals(other.text));
    }

    public static String getLocalText(List<I18NText> list, String prefferedLanguage, String defaultLanguage) {
        for (I18NText text : list) {
            if (!text.getLanguage().equals(prefferedLanguage)) continue;
            return text.getText();
        }
        if (defaultLanguage == null) {
            for (I18NText text : list) {
                if (!text.getLanguage().equals(defaultLanguage)) continue;
                return text.getText();
            }
        }
        return "";
    }
}

