/*
 * Decompiled with CFR 0.152.
 */
package org.drools.task.event;

import java.util.Iterator;
import java.util.List;
import org.drools.eventmessaging.EventKeys;
import org.drools.eventmessaging.EventTriggerTransport;
import org.drools.task.event.EventPayload;
import org.drools.task.event.TaskClaimedEvent;
import org.drools.task.event.TaskCompletedEvent;
import org.drools.task.event.TaskEventKey;
import org.drools.task.event.TaskEventListener;
import org.drools.task.event.TaskFailedEvent;
import org.drools.task.event.TaskSkippedEvent;

public class MessagingTaskEventListener
implements TaskEventListener {
    private EventKeys keys;

    public MessagingTaskEventListener(EventKeys keys) {
        this.keys = keys;
    }

    public void taskClaimed(TaskClaimedEvent event) {
        TaskEventKey key = new TaskEventKey(TaskClaimedEvent.class, event.getTaskId());
        List<EventTriggerTransport> targets = this.keys.getTargets(key);
        if (targets == null) {
            return;
        }
        EventPayload payload = new EventPayload(event);
        Iterator<EventTriggerTransport> it = targets.iterator();
        while (it.hasNext()) {
            EventTriggerTransport target = it.next();
            target.trigger(payload);
            if (!target.isRemove()) continue;
            it.remove();
        }
        if (targets.isEmpty()) {
            this.keys.removeKey(key);
        }
    }

    public void taskCompleted(TaskCompletedEvent event) {
        TaskEventKey key = new TaskEventKey(TaskCompletedEvent.class, event.getTaskId());
        List<EventTriggerTransport> targets = this.keys.getTargets(key);
        if (targets == null) {
            return;
        }
        EventPayload payload = new EventPayload(event);
        Iterator<EventTriggerTransport> it = targets.iterator();
        while (it.hasNext()) {
            EventTriggerTransport target = it.next();
            target.trigger(payload);
            if (!target.isRemove()) continue;
            it.remove();
        }
        if (targets.isEmpty()) {
            this.keys.removeKey(key);
        }
    }

    public void taskFailed(TaskFailedEvent event) {
        TaskEventKey key = new TaskEventKey(TaskFailedEvent.class, event.getTaskId());
        List<EventTriggerTransport> targets = this.keys.getTargets(key);
        if (targets == null) {
            return;
        }
        EventPayload payload = new EventPayload(event);
        Iterator<EventTriggerTransport> it = targets.iterator();
        while (it.hasNext()) {
            EventTriggerTransport target = it.next();
            target.trigger(payload);
            if (!target.isRemove()) continue;
            it.remove();
        }
        if (targets.isEmpty()) {
            this.keys.removeKey(key);
        }
    }

    public void taskSkipped(TaskSkippedEvent event) {
        TaskEventKey key = new TaskEventKey(TaskSkippedEvent.class, event.getTaskId());
        List<EventTriggerTransport> targets = this.keys.getTargets(key);
        if (targets == null) {
            return;
        }
        EventPayload payload = new EventPayload(event);
        Iterator<EventTriggerTransport> it = targets.iterator();
        while (it.hasNext()) {
            EventTriggerTransport target = it.next();
            target.trigger(payload);
            if (!target.isRemove()) continue;
            it.remove();
        }
        if (targets.isEmpty()) {
            this.keys.removeKey(key);
        }
    }
}

