/*
 * Decompiled with CFR 0.152.
 */
package org.drools.task.event;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.drools.task.event.TaskClaimedEvent;
import org.drools.task.event.TaskCompletedEvent;
import org.drools.task.event.TaskEventListener;
import org.drools.task.event.TaskFailedEvent;
import org.drools.task.event.TaskSkippedEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskEventSupport
implements Externalizable {
    private static final long serialVersionUID = 400L;
    private List<TaskEventListener> listeners = new CopyOnWriteArrayList<TaskEventListener>();

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.listeners = (List)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.listeners);
    }

    public void addEventListener(TaskEventListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeEventListener(TaskEventListener listener) {
        this.listeners.remove(listener);
    }

    public List<TaskEventListener> getEventListeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    public int size() {
        return this.listeners.size();
    }

    public boolean isEmpty() {
        return this.listeners.isEmpty();
    }

    public void fireTaskClaimed(long taskId, String userId) {
        if (this.listeners.isEmpty()) {
            return;
        }
        TaskClaimedEvent event = new TaskClaimedEvent(taskId, userId);
        for (TaskEventListener listener : this.listeners) {
            listener.taskClaimed(event);
        }
    }

    public void fireTaskCompleted(long taskId, String userId) {
        if (this.listeners.isEmpty()) {
            return;
        }
        TaskCompletedEvent event = new TaskCompletedEvent(taskId, userId);
        for (TaskEventListener listener : this.listeners) {
            listener.taskCompleted(event);
        }
    }

    public void fireTaskFailed(long taskId, String userId) {
        if (this.listeners.isEmpty()) {
            return;
        }
        TaskFailedEvent event = new TaskFailedEvent(taskId, userId);
        for (TaskEventListener listener : this.listeners) {
            listener.taskFailed(event);
        }
    }

    public void fireTaskSkipped(long taskId, String userId) {
        if (this.listeners.isEmpty()) {
            return;
        }
        TaskSkippedEvent event = new TaskSkippedEvent(taskId, userId);
        for (TaskEventListener listener : this.listeners) {
            listener.taskSkipped(event);
        }
    }

    public void reset() {
        this.listeners.clear();
    }
}

