/*
 * Decompiled with CFR 0.152.
 */
package org.drools.task.service;

import java.net.SocketAddress;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.serialization.ObjectSerializationCodecFactory;
import org.apache.mina.transport.socket.SocketConnector;
import org.drools.task.service.BaseMinaHandler;

public class BaseMinaClient {
    protected IoSession session;
    protected final BaseMinaHandler handler;
    protected final String name;
    protected AtomicInteger counter;
    protected SocketConnector connector;
    protected SocketAddress address;

    public BaseMinaClient(String name, BaseMinaHandler handler) {
        if (name == null) {
            throw new IllegalArgumentException("Name can not be null");
        }
        this.name = name;
        this.handler = handler;
        this.counter = new AtomicInteger();
    }

    public boolean connect(SocketConnector connector, SocketAddress address) {
        this.connector = connector;
        this.address = address;
        connector.setHandler((IoHandler)this.handler);
        return this.connect();
    }

    public boolean connect() {
        if (this.session != null && this.session.isConnected()) {
            throw new IllegalStateException("Already connected. Disconnect first.");
        }
        try {
            this.connector.getFilterChain().addLast("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new ObjectSerializationCodecFactory()));
            ConnectFuture future1 = this.connector.connect(this.address);
            future1.join();
            if (!future1.isConnected()) {
                return false;
            }
            this.session = future1.getSession();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void disconnect() {
        if (this.session != null && this.session.isConnected()) {
            this.session.close();
            this.session.getCloseFuture().join();
        }
    }
}

