/*
 * Decompiled with CFR 0.152.
 */
package org.drools.task.service;

import java.util.ArrayList;
import org.drools.eventmessaging.EventKey;
import org.drools.eventmessaging.EventResponseHandler;
import org.drools.task.Attachment;
import org.drools.task.Comment;
import org.drools.task.Content;
import org.drools.task.Task;
import org.drools.task.service.BaseMinaClient;
import org.drools.task.service.Command;
import org.drools.task.service.CommandName;
import org.drools.task.service.ContentData;
import org.drools.task.service.FaultData;
import org.drools.task.service.Operation;
import org.drools.task.service.TaskClientHandler;

public class MinaTaskClient
extends BaseMinaClient {
    public MinaTaskClient(String name, TaskClientHandler handler) {
        super(name, handler);
    }

    public void addTask(Task task, ContentData content, TaskClientHandler.AddTaskResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(2);
        args.add(task);
        args.add(content);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.AddTaskRequest, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.session.write((Object)cmd);
    }

    public void getTask(long taskId, TaskClientHandler.GetTaskResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(1);
        args.add(taskId);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.GetTaskRequest, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.session.write((Object)cmd);
    }

    public void addComment(long taskId, Comment comment, TaskClientHandler.AddCommentResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(2);
        args.add(taskId);
        args.add(comment);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.AddCommentRequest, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.session.write((Object)cmd);
    }

    public void deleteComment(long taskId, long commentId, TaskClientHandler.DeleteCommentResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(2);
        args.add(taskId);
        args.add(commentId);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.DeleteCommentRequest, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.session.write((Object)cmd);
    }

    public void addAttachment(long taskId, Attachment attachment, Content content, TaskClientHandler.AddAttachmentResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(3);
        args.add(taskId);
        args.add(attachment);
        args.add(content);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.AddAttachmentRequest, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.session.write((Object)cmd);
    }

    public void deleteAttachment(long taskId, long attachmentId, long contentId, TaskClientHandler.DeleteAttachmentResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(3);
        args.add(taskId);
        args.add(attachmentId);
        args.add(contentId);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.DeleteAttachmentRequest, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.session.write((Object)cmd);
    }

    public void setDocumentContent(long taskId, Content content, TaskClientHandler.SetDocumentResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(2);
        args.add(taskId);
        args.add(content);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.SetDocumentContentRequest, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.session.write((Object)cmd);
    }

    public void getContent(long contentId, TaskClientHandler.GetContentResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(1);
        args.add(contentId);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.GetContentRequest, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.session.write((Object)cmd);
    }

    public void claim(long taskId, String userId, TaskClientHandler.TaskOperationResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(3);
        args.add((Object)Operation.Claim);
        args.add(taskId);
        args.add(userId);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.OperationRequest, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.session.write((Object)cmd);
    }

    public void start(long taskId, String userId, TaskClientHandler.TaskOperationResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(3);
        args.add((Object)Operation.Start);
        args.add(taskId);
        args.add(userId);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.OperationRequest, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.session.write((Object)cmd);
    }

    public void stop(long taskId, String userId, TaskClientHandler.TaskOperationResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(3);
        args.add((Object)Operation.Stop);
        args.add(taskId);
        args.add(userId);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.OperationRequest, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.session.write((Object)cmd);
    }

    public void release(long taskId, String userId, TaskClientHandler.TaskOperationResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(3);
        args.add((Object)Operation.Release);
        args.add(taskId);
        args.add(userId);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.OperationRequest, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.session.write((Object)cmd);
    }

    public void suspend(long taskId, String userId, TaskClientHandler.TaskOperationResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(3);
        args.add((Object)Operation.Suspend);
        args.add(taskId);
        args.add(userId);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.OperationRequest, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.session.write((Object)cmd);
    }

    public void resume(long taskId, String userId, TaskClientHandler.TaskOperationResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(3);
        args.add((Object)Operation.Resume);
        args.add(taskId);
        args.add(userId);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.OperationRequest, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.session.write((Object)cmd);
    }

    public void skip(long taskId, String userId, TaskClientHandler.TaskOperationResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(3);
        args.add((Object)Operation.Skip);
        args.add(taskId);
        args.add(userId);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.OperationRequest, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.session.write((Object)cmd);
    }

    public void delegate(long taskId, String userId, String targetUserId, TaskClientHandler.TaskOperationResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(4);
        args.add((Object)Operation.Delegate);
        args.add(taskId);
        args.add(userId);
        args.add(targetUserId);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.OperationRequest, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.session.write((Object)cmd);
    }

    public void forward(long taskId, String userId, String targetEntityId, TaskClientHandler.TaskOperationResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(4);
        args.add((Object)Operation.Forward);
        args.add(taskId);
        args.add(userId);
        args.add(targetEntityId);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.OperationRequest, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.session.write((Object)cmd);
    }

    public void complete(long taskId, String userId, ContentData outputData, TaskClientHandler.TaskOperationResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(5);
        args.add((Object)Operation.Complete);
        args.add(taskId);
        args.add(userId);
        args.add(null);
        args.add(outputData);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.OperationRequest, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.session.write((Object)cmd);
    }

    public void fail(long taskId, String userId, FaultData faultData, TaskClientHandler.TaskOperationResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(5);
        args.add((Object)Operation.Fail);
        args.add(taskId);
        args.add(userId);
        args.add(null);
        args.add(faultData);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.OperationRequest, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.session.write((Object)cmd);
    }

    public void getTasksOwned(String userId, String language, TaskClientHandler.TaskSummaryResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(2);
        args.add(userId);
        args.add(language);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.QueryTasksOwned, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.session.write((Object)cmd);
    }

    public void getTasksAssignedAsBusinessAdministrator(String userId, String language, TaskClientHandler.TaskSummaryResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(2);
        args.add(userId);
        args.add(language);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.QueryTasksAssignedAsBusinessAdministrator, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.session.write((Object)cmd);
    }

    public void getTasksAssignedAsExcludedOwner(String userId, String language, TaskClientHandler.TaskSummaryResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(2);
        args.add(userId);
        args.add(language);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.QueryTasksAssignedAsExcludedOwner, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.session.write((Object)cmd);
    }

    public void getTasksAssignedAsPotentialOwner(String userId, String language, TaskClientHandler.TaskSummaryResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(2);
        args.add(userId);
        args.add(language);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.QueryTasksAssignedAsPotentialOwner, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.session.write((Object)cmd);
    }

    public void getTasksAssignedAsPotentialOwner(String userId, String groupId, String language, TaskClientHandler.TaskSummaryResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(2);
        args.add(userId);
        args.add(groupId);
        args.add(language);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.QueryTasksAssignedAsPotentialOwnerWithGroup, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.session.write((Object)cmd);
    }

    public void getSubTasksAssignedAsPotentialOwner(long parentId, String userId, String language, TaskClientHandler.TaskSummaryResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(2);
        args.add(parentId);
        args.add(userId);
        args.add(language);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.QuerySubTasksAssignedAsPotentialOwner, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.session.write((Object)cmd);
    }

    public void getSubTasksByParent(long parentId, TaskClientHandler.TaskSummaryResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(2);
        args.add(parentId);
        args.add("en-UK");
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.QueryGetSubTasksByParentTaskId, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.session.write((Object)cmd);
    }

    public void getTasksAssignedAsRecipient(String userId, String language, TaskClientHandler.TaskSummaryResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(2);
        args.add(userId);
        args.add(language);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.QueryTasksAssignedAsRecipient, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.session.write((Object)cmd);
    }

    public void getTasksAssignedAsTaskInitiator(String userId, String language, TaskClientHandler.TaskSummaryResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(2);
        args.add(userId);
        args.add(language);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.QueryTasksAssignedAsTaskInitiator, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.session.write((Object)cmd);
    }

    public void getTasksAssignedAsTaskStakeholder(String userId, String language, TaskClientHandler.TaskSummaryResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(2);
        args.add(userId);
        args.add(language);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.QueryTasksAssignedAsTaskStakeholder, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.session.write((Object)cmd);
    }

    public void registerForEvent(EventKey key, boolean remove, EventResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(3);
        args.add(key);
        args.add(remove);
        args.add(this.name);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.RegisterForEventRequest, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.session.write((Object)cmd);
    }
}

