/*
 * Decompiled with CFR 0.152.
 */
package org.drools.task.service;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.drools.RuleBase;
import org.drools.StatefulSession;
import org.drools.eventmessaging.EventKeys;
import org.drools.task.Attachment;
import org.drools.task.Comment;
import org.drools.task.Content;
import org.drools.task.Deadline;
import org.drools.task.Group;
import org.drools.task.OrganizationalEntity;
import org.drools.task.PeopleAssignments;
import org.drools.task.Status;
import org.drools.task.SubTasksStrategy;
import org.drools.task.Task;
import org.drools.task.TaskData;
import org.drools.task.User;
import org.drools.task.query.DeadlineSummary;
import org.drools.task.query.TaskSummary;
import org.drools.task.service.Allowed;
import org.drools.task.service.ContentData;
import org.drools.task.service.FaultData;
import org.drools.task.service.Operation;
import org.drools.task.service.OperationCommand;
import org.drools.task.service.SendIcal;
import org.drools.task.service.TaskError;
import org.drools.task.service.TaskService;
import org.drools.task.service.TaskServiceRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskServiceSession {
    private TaskService service;
    private EntityManager em;
    private Map<String, RuleBase> ruleBases;
    private Map<String, Map<String, Object>> globals;
    private EventKeys eventKeys;

    public TaskServiceSession(TaskService service, EntityManager em) {
        this.service = service;
        this.em = em;
    }

    public void dispose() {
        this.em.close();
    }

    public EntityManager getEntityManager() {
        return this.em;
    }

    public void setRuleBase(String type, RuleBase ruleBase) {
        if (this.ruleBases == null) {
            this.ruleBases = new HashMap<String, RuleBase>();
        }
        this.ruleBases.put(type, ruleBase);
    }

    public void setGlobals(String type, Map<String, Object> globals) {
        if (this.globals == null) {
            this.globals = new HashMap<String, Map<String, Object>>();
        }
        this.globals.put(type, globals);
    }

    public void addUser(User user) {
        this.em.getTransaction().begin();
        this.em.persist((Object)user);
        this.em.getTransaction().commit();
    }

    public void addGroup(Group group) {
        this.em.getTransaction().begin();
        this.em.persist((Object)group);
        this.em.getTransaction().commit();
    }

    public void addTask(Task task, ContentData contentData) {
        RuleBase ruleBase;
        TaskData taskData = task.getTaskData();
        taskData.setStatus(Status.Created);
        if (this.ruleBases != null && (ruleBase = this.ruleBases.get("addTask")) != null) {
            StatefulSession session = ruleBase.newStatefulSession();
            Map<String, Object> globals = this.globals.get("addTask");
            if (globals != null) {
                for (Map.Entry<String, Object> entry : globals.entrySet()) {
                    session.setGlobal(entry.getKey(), entry.getValue());
                }
            }
            TaskServiceRequest request = new TaskServiceRequest("addTask", null, null);
            session.setGlobal("request", (Object)request);
            session.insert((Object)task);
            session.insert((Object)contentData);
            session.fireAllRules();
            if (!request.isAllowed()) {
                String error = "Cannot add Task:\n";
                if (request.getReasons() != null) {
                    for (String reason : request.getReasons()) {
                        error = error + reason + "\n";
                    }
                }
                throw new RuntimeException(error);
            }
        }
        if (task.getPeopleAssignments() != null) {
            List<OrganizationalEntity> potentialOwners = task.getPeopleAssignments().getPotentialOwners();
            if (potentialOwners.size() == 1) {
                OrganizationalEntity potentialOwner = potentialOwners.get(0);
                if (potentialOwner instanceof User) {
                    taskData.setActualOwner((User)potentialOwners.get(0));
                    taskData.setStatus(Status.Reserved);
                }
                if (potentialOwner instanceof Group) {
                    taskData.setStatus(Status.Ready);
                }
            } else if (potentialOwners.size() > 1) {
                taskData.setStatus(Status.Ready);
            }
        }
        if (taskData.getCreatedOn() == null) {
            taskData.setCreatedOn(new Date());
        }
        if (taskData.getActivationTime() == null) {
            taskData.setActivationTime(taskData.getCreatedOn());
        }
        this.em.getTransaction().begin();
        this.em.persist((Object)task);
        if (contentData != null) {
            Content content = new Content();
            content.setContent(contentData.getContent());
            this.em.persist((Object)content);
            taskData.setDocumentAccessType(contentData.getAccessType());
            taskData.setDocumentType(contentData.getType());
            taskData.setDocumentContentId(content.getId());
        }
        this.em.getTransaction().commit();
        long now = System.currentTimeMillis();
        if (task.getDeadlines() != null) {
            Date date;
            if (task.getDeadlines().getStartDeadlines() != null) {
                for (Deadline deadline : task.getDeadlines().getStartDeadlines()) {
                    if (deadline.isEscalated()) continue;
                    date = deadline.getDate();
                    this.service.schedule(new TaskService.ScheduledTaskDeadline(task.getId(), deadline.getId(), this.service), date.getTime() - now);
                }
            }
            if (task.getDeadlines().getEndDeadlines() != null) {
                for (Deadline deadline : task.getDeadlines().getEndDeadlines()) {
                    if (deadline.isEscalated()) continue;
                    date = deadline.getDate();
                    this.service.schedule(new TaskService.ScheduledTaskDeadline(task.getId(), deadline.getId(), this.service), date.getTime() - now);
                }
            }
        }
        if (task.getTaskData().getStatus() == Status.Reserved) {
            SendIcal.getInstance().sendIcalForTask(task, this.service.getUserinfo());
            this.service.getEventSupport().fireTaskClaimed(task.getId(), task.getTaskData().getActualOwner().getId());
        }
    }

    public TaskError evalCommand(Operation operation, List<OperationCommand> commands, Task task, User user, OrganizationalEntity targetEntity) {
        TaskData taskData = task.getTaskData();
        boolean statusMatched = false;
        for (OperationCommand command : commands) {
            if (command.getStatus() != null) {
                for (Status status : command.getStatus()) {
                    if (taskData.getStatus() != status) continue;
                    statusMatched = true;
                    if (!this.isAllowed(command, task, user, targetEntity)) {
                        return new TaskError("User '" + user + "' does not have permissions to execution operation '" + (Object)((Object)operation) + "' on task id " + task.getId());
                    }
                    this.commands(command, task, user, targetEntity);
                    return null;
                }
            }
            if (command.getPreviousStatus() == null) continue;
            for (Status status : command.getPreviousStatus()) {
                if (taskData.getPreviousStatus() != status) continue;
                statusMatched = true;
                if (!this.isAllowed(command, task, user, targetEntity)) {
                    return new TaskError("User '" + user + "' does not have permissions to execution operation '" + (Object)((Object)operation) + "' on task id " + task.getId());
                }
                this.commands(command, task, user, targetEntity);
                return null;
            }
        }
        if (!statusMatched) {
            return new TaskError("User '" + user + "' was unable to execution operation '" + (Object)((Object)operation) + "' on task id " + task.getId() + " due to no 'current status' matchines");
        }
        return null;
    }

    private boolean isAllowed(OperationCommand command, Task task, User user, OrganizationalEntity targetEntity) {
        PeopleAssignments people = task.getPeopleAssignments();
        TaskData taskData = task.getTaskData();
        boolean operationAllowed = false;
        for (Allowed allowed : command.getAllowed()) {
            if (operationAllowed) break;
            switch (allowed) {
                case Owner: {
                    operationAllowed = taskData.getActualOwner() != null && taskData.getActualOwner().getId() == user.getId();
                    break;
                }
                case Initiator: {
                    operationAllowed = taskData.getCreatedBy() != null && taskData.getCreatedBy().getId() == user.getId();
                    break;
                }
                case PotentialOwner: {
                    operationAllowed = this.isAllowed(user, people.getPotentialOwners());
                    break;
                }
                case BusinessAdministrator: {
                    operationAllowed = this.isAllowed(user, people.getBusinessAdministrators());
                }
            }
        }
        if (operationAllowed && command.isUserIsExplicitPotentialOwner()) {
            operationAllowed = people.getPotentialOwners().contains(user);
        }
        if (operationAllowed && command.isSkippable()) {
            operationAllowed = taskData.isSkipable();
        }
        return operationAllowed;
    }

    private void commands(OperationCommand command, Task task, User user, OrganizationalEntity targetEntity) {
        PeopleAssignments people = task.getPeopleAssignments();
        TaskData taskData = task.getTaskData();
        if (command.getNewStatus() != null) {
            taskData.setStatus(command.getNewStatus());
        } else if (command.isSetToPreviousStatus()) {
            taskData.setStatus(taskData.getPreviousStatus());
        }
        if (command.isAddTargetEntityToPotentialOwners() && !people.getPotentialOwners().contains(targetEntity)) {
            people.getPotentialOwners().add(targetEntity);
        }
        if (command.isRemoveUserFromPotentialOwners()) {
            people.getPotentialOwners().remove(user);
        }
        if (command.isSetNewOwnerToUser()) {
            taskData.setActualOwner(user);
        }
        if (command.isSetNewOwnerToNull()) {
            taskData.setActualOwner(null);
        }
        if (command.getExec() != null) {
            switch (command.getExec()) {
                case Claim: {
                    taskData.setActualOwner((User)targetEntity);
                    SendIcal.getInstance().sendIcalForTask(task, this.service.getUserinfo());
                    this.service.getEventSupport().fireTaskClaimed(task.getId(), task.getTaskData().getActualOwner().getId());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TaskError taskOperation(Operation operation, long taskId, String userId, String targetEntityId, ContentData data) {
        Task task = (Task)this.em.find(Task.class, (Object)taskId);
        User user = (User)this.em.find(User.class, (Object)userId);
        OrganizationalEntity targetEntity = null;
        if (targetEntityId != null) {
            targetEntity = (OrganizationalEntity)this.em.find(OrganizationalEntity.class, (Object)targetEntityId);
        }
        if (!this.em.getTransaction().isActive()) {
            this.em.getTransaction().begin();
        }
        TaskError error = null;
        try {
            Map<Operation, List<OperationCommand>> dsl = this.service.getOperations();
            List<OperationCommand> commands = dsl.get((Object)operation);
            error = this.evalCommand(operation, commands, task, user, targetEntity);
            if (error != null) {
                throw new RuntimeException("TaskOperationException");
            }
            switch (operation) {
                case Claim: {
                    SendIcal.getInstance().sendIcalForTask(task, this.service.getUserinfo());
                    this.service.getEventSupport().fireTaskClaimed(task.getId(), task.getTaskData().getActualOwner().getId());
                    return error;
                }
                case Complete: {
                    if (data != null) {
                        TaskData taskData = task.getTaskData();
                        Content content = new Content();
                        content.setContent(data.getContent());
                        this.em.persist((Object)content);
                        taskData.setOutputContentId(content.getId());
                        taskData.setOutputAccessType(data.getAccessType());
                        taskData.setOutputType(data.getType());
                    }
                    this.service.getEventSupport().fireTaskCompleted(task.getId(), task.getTaskData().getActualOwner().getId());
                    this.checkSubTaskStrategy(task);
                    return error;
                }
                case Fail: {
                    if (data != null) {
                        TaskData taskData = task.getTaskData();
                        Content content = new Content();
                        content.setContent(data.getContent());
                        this.em.persist((Object)content);
                        taskData.setFaultContentId(content.getId());
                        taskData.setFaultAccessType(data.getAccessType());
                        taskData.setFaultType(data.getType());
                        taskData.setFaultName(((FaultData)data).getFaultName());
                    }
                    this.service.getEventSupport().fireTaskFailed(task.getId(), task.getTaskData().getActualOwner().getId());
                    return error;
                }
                case Skip: {
                    this.service.getEventSupport().fireTaskSkipped(task.getId(), userId);
                    this.checkSubTaskStrategy(task);
                    return error;
                }
            }
            return error;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.em.getTransaction().rollback();
            this.em.getTransaction().begin();
            task.getTaskData().setStatus(Status.Error);
            this.em.getTransaction().commit();
            error = new TaskError("User '" + user + "' was unable to execution operation '" + (Object)((Object)operation) + "' on task id " + task.getId() + " due to exception:\n" + e.getMessage());
            return error;
        }
        finally {
            if (this.em.getTransaction().isActive()) {
                this.em.getTransaction().commit();
            }
        }
    }

    public void addComment(long taskId, Comment comment) {
        Task task = (Task)this.em.find(Task.class, (Object)taskId);
        if (task == null) {
            // empty if block
        }
        this.em.getTransaction().begin();
        List<Comment> list = task.getTaskData().getComments();
        if (list == null || list == Collections.emptyList()) {
            list = new ArrayList<Comment>(1);
            task.getTaskData().setComments(list);
        }
        list.add(comment);
        this.em.getTransaction().commit();
    }

    public void addAttachment(long taskId, Attachment attachment, Content content) {
        Task task = (Task)this.em.find(Task.class, (Object)taskId);
        if (task == null) {
            // empty if block
        }
        this.em.getTransaction().begin();
        this.em.persist((Object)content);
        attachment.setSize(content.getContent().length);
        attachment.setAttachmentContentId(content.getId());
        List<Attachment> list = task.getTaskData().getAttachments();
        if (list == null || list == Collections.emptyList()) {
            list = new ArrayList<Attachment>(1);
            task.getTaskData().setAttachments(list);
        }
        list.add(attachment);
        this.em.getTransaction().commit();
    }

    public void setDocumentContent(long taskId, Content content) {
        Task task = (Task)this.em.find(Task.class, (Object)taskId);
        if (task == null) {
            // empty if block
        }
        this.em.getTransaction().begin();
        this.em.persist((Object)content);
        task.getTaskData().setDocumentContentId(content.getId());
        this.em.getTransaction().commit();
    }

    public Content getContent(long contentId) {
        Content content = (Content)this.em.find(Content.class, (Object)contentId);
        return content;
    }

    public void deleteAttachment(long taskId, long attachmentId, long contentId) {
        Task task = (Task)this.em.find(Task.class, (Object)taskId);
        this.em.getTransaction().begin();
        Iterator<Attachment> it = task.getTaskData().getAttachments().iterator();
        while (it.hasNext()) {
            Attachment attachment = it.next();
            if (attachment.getId() != attachmentId) continue;
            it.remove();
            this.em.remove((Object)attachment);
            break;
        }
        String deleteContent = "delete from Content where id = :id";
        this.em.createQuery(deleteContent).setParameter("id", (Object)contentId).executeUpdate();
        this.em.getTransaction().commit();
    }

    public void deleteComment(long taskId, long commentId) {
        Task task = (Task)this.em.find(Task.class, (Object)taskId);
        this.em.getTransaction().begin();
        Iterator<Comment> it = task.getTaskData().getComments().iterator();
        while (it.hasNext()) {
            Comment comment = it.next();
            if (comment.getId() != commentId) continue;
            it.remove();
            this.em.remove((Object)comment);
            break;
        }
        this.em.getTransaction().commit();
    }

    public Task getTask(long taskId) {
        Task task = (Task)this.em.find(Task.class, (Object)taskId);
        return task;
    }

    public List<DeadlineSummary> getUnescalatedDeadlines() {
        return this.em.createNamedQuery("UnescalatedDeadlines").getResultList();
    }

    public List<TaskSummary> getTasksOwned(String userId, String language) {
        Query tasksOwned = this.em.createNamedQuery("TasksOwned");
        tasksOwned.setParameter("userId", (Object)userId);
        tasksOwned.setParameter("language", (Object)language);
        List list = tasksOwned.getResultList();
        return list;
    }

    public List<TaskSummary> getTasksAssignedAsBusinessAdministrator(String userId, String language) {
        Query tasksAssignedAsBusinessAdministrator = this.em.createNamedQuery("TasksAssignedAsBusinessAdministrator");
        tasksAssignedAsBusinessAdministrator.setParameter("userId", (Object)userId);
        tasksAssignedAsBusinessAdministrator.setParameter("language", (Object)language);
        List list = tasksAssignedAsBusinessAdministrator.getResultList();
        return list;
    }

    public List<TaskSummary> getTasksAssignedAsExcludedOwner(String userId, String language) {
        Query tasksAssignedAsExcludedOwner = this.em.createNamedQuery("TasksAssignedAsExcludedOwner");
        tasksAssignedAsExcludedOwner.setParameter("userId", (Object)userId);
        tasksAssignedAsExcludedOwner.setParameter("language", (Object)language);
        List list = tasksAssignedAsExcludedOwner.getResultList();
        return list;
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwner(String userId, String language) {
        Query tasksAssignedAsPotentialOwner = this.em.createNamedQuery("TasksAssignedAsPotentialOwner");
        tasksAssignedAsPotentialOwner.setParameter("userId", (Object)userId);
        tasksAssignedAsPotentialOwner.setParameter("language", (Object)language);
        List list = tasksAssignedAsPotentialOwner.getResultList();
        return list;
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwner(String userId, String groupId, String language) {
        Query tasksAssignedAsPotentialOwner = this.em.createNamedQuery("TasksAssignedAsPotentialOwnerWithGroup");
        tasksAssignedAsPotentialOwner.setParameter("userId", (Object)userId);
        tasksAssignedAsPotentialOwner.setParameter("groupId", (Object)groupId);
        tasksAssignedAsPotentialOwner.setParameter("language", (Object)language);
        List list = tasksAssignedAsPotentialOwner.getResultList();
        return list;
    }

    public List<TaskSummary> getSubTasksAssignedAsPotentialOwner(long parentId, String userId, String language) {
        Query tasksAssignedAsPotentialOwner = this.em.createNamedQuery("SubTasksAssignedAsPotentialOwner");
        tasksAssignedAsPotentialOwner.setParameter("parentId", (Object)parentId);
        tasksAssignedAsPotentialOwner.setParameter("userId", (Object)userId);
        tasksAssignedAsPotentialOwner.setParameter("language", (Object)language);
        List list = tasksAssignedAsPotentialOwner.getResultList();
        return list;
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwnerByGroup(String groupId, String language) {
        Query tasksAssignedAsPotentialOwnerByGroup = this.em.createNamedQuery("TasksAssignedAsPotentialOwnerByGroup");
        tasksAssignedAsPotentialOwnerByGroup.setParameter("groupId", (Object)groupId);
        tasksAssignedAsPotentialOwnerByGroup.setParameter("language", (Object)language);
        List list = tasksAssignedAsPotentialOwnerByGroup.getResultList();
        return list;
    }

    public List<TaskSummary> getSubTasksByParent(long parentId, String language) {
        Query subTaskByParent = this.em.createNamedQuery("GetSubTasksByParentTaskId");
        subTaskByParent.setParameter("parentId", (Object)parentId);
        subTaskByParent.setParameter("language", (Object)language);
        List list = subTaskByParent.getResultList();
        return list;
    }

    public List<TaskSummary> getTasksAssignedAsRecipient(String userId, String language) {
        Query tasksAssignedAsRecipient = this.em.createNamedQuery("TasksAssignedAsRecipient");
        tasksAssignedAsRecipient.setParameter("userId", (Object)userId);
        tasksAssignedAsRecipient.setParameter("language", (Object)language);
        List list = tasksAssignedAsRecipient.getResultList();
        return list;
    }

    public List<TaskSummary> getTasksAssignedAsTaskInitiator(String userId, String language) {
        Query tasksAssignedAsTaskInitiator = this.em.createNamedQuery("TasksAssignedAsTaskInitiator");
        tasksAssignedAsTaskInitiator.setParameter("userId", (Object)userId);
        tasksAssignedAsTaskInitiator.setParameter("language", (Object)language);
        List list = tasksAssignedAsTaskInitiator.getResultList();
        return list;
    }

    public List<TaskSummary> getTasksAssignedAsTaskStakeholder(String userId, String language) {
        Query tasksAssignedAsTaskStakeholder = this.em.createNamedQuery("TasksAssignedAsTaskStakeholder");
        tasksAssignedAsTaskStakeholder.setParameter("userId", (Object)userId);
        tasksAssignedAsTaskStakeholder.setParameter("language", (Object)language);
        List list = tasksAssignedAsTaskStakeholder.getResultList();
        return list;
    }

    public boolean isAllowed(User user, List<OrganizationalEntity>[] people) {
        for (List<OrganizationalEntity> list : people) {
            if (!this.isAllowed(user, list)) continue;
            return true;
        }
        return false;
    }

    public boolean isAllowed(User user, List<OrganizationalEntity> entities) {
        for (OrganizationalEntity entity : entities) {
            if (!entity.getId().equals(user.getId())) continue;
            return true;
        }
        return false;
    }

    public static String toString(Reader reader) throws IOException {
        int charValue = 0;
        StringBuffer sb = new StringBuffer(1024);
        while ((charValue = reader.read()) != -1) {
            sb.append((char)charValue);
        }
        return sb.toString();
    }

    private void checkSubTaskStrategy(Task task) {
        if (task != null) {
            for (SubTasksStrategy strategy : task.getSubTaskStrategies()) {
                strategy.execute(this, this.service, task);
            }
        }
        Task parentTask = null;
        if (task.getTaskData().getParentId() != -1L) {
            parentTask = this.getTask(task.getTaskData().getParentId());
            for (SubTasksStrategy strategy : parentTask.getSubTaskStrategies()) {
                strategy.execute(this, this.service, parentTask);
            }
        }
    }
}

