/*
 * Decompiled with CFR 0.152.
 */
package org.drools.task;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import junit.framework.TestCase;
import org.apache.commons.collections.map.HashedMap;
import org.drools.SystemEventListenerFactory;
import org.drools.task.Group;
import org.drools.task.MockUserInfo;
import org.drools.task.User;
import org.drools.task.UserInfo;
import org.drools.task.service.SendIcal;
import org.drools.task.service.TaskService;
import org.drools.task.service.TaskServiceSession;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;
import org.mvel2.compiler.ExpressionCompiler;

public abstract class BaseTest
extends TestCase {
    protected EntityManagerFactory emf;
    protected Map<String, User> users;
    protected Map<String, Group> groups;
    protected TaskService taskService;
    protected TaskServiceSession taskSession;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setUp() throws Exception {
        Properties conf = new Properties();
        conf.setProperty("mail.smtp.host", "localhost");
        conf.setProperty("mail.smtp.port", "2345");
        conf.setProperty("from", "from@domain.com");
        conf.setProperty("replyTo", "replyTo@domain.com");
        conf.setProperty("defaultLanguage", "en-UK");
        SendIcal.initInstance((Properties)conf);
        this.emf = Persistence.createEntityManagerFactory((String)"org.drools.task");
        this.taskService = new TaskService(this.emf, SystemEventListenerFactory.getSystemEventListener());
        this.taskSession = this.taskService.createSession();
        MockUserInfo userInfo = new MockUserInfo();
        this.taskService.setUserinfo((UserInfo)userInfo);
        HashedMap vars = new HashedMap();
        Reader reader = null;
        try {
            reader = new InputStreamReader(BaseTest.class.getResourceAsStream("LoadUsers.mvel"));
            this.users = (Map)this.eval(reader, (Map)vars);
            for (User user : this.users.values()) {
                this.taskSession.addUser(user);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            reader = null;
        }
        try {
            reader = new InputStreamReader(BaseTest.class.getResourceAsStream("LoadGroups.mvel"));
            this.groups = (Map)this.eval(reader, (Map)vars);
            for (Group group : this.groups.values()) {
                this.taskSession.addGroup(group);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    protected void tearDown() throws Exception {
        this.taskSession.dispose();
        this.emf.close();
    }

    public Object eval(Reader reader, Map vars) {
        try {
            return this.eval(this.toString(reader), vars);
        }
        catch (IOException e) {
            throw new RuntimeException("Exception Thrown", e);
        }
    }

    public String toString(Reader reader) throws IOException {
        int charValue;
        StringBuilder sb = new StringBuilder(1024);
        while ((charValue = reader.read()) != -1) {
            sb.append((char)charValue);
        }
        return sb.toString();
    }

    public Object eval(String str, Map vars) {
        ExpressionCompiler compiler = new ExpressionCompiler(str.trim());
        ParserContext context = new ParserContext();
        context.addPackageImport("org.drools.task");
        context.addPackageImport("org.drools.task.service");
        context.addPackageImport("org.drools.task.query");
        context.addPackageImport("java.util");
        vars.put("now", new Date());
        return MVEL.executeExpression((Object)compiler.compile(context), (Map)vars);
    }
}

