/*
 * Decompiled with CFR 0.152.
 */
package org.drools.task.service;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Date;
import java.util.Map;
import javax.mail.BodyPart;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.collections.map.HashedMap;
import org.apache.mina.transport.socket.SocketConnector;
import org.apache.mina.transport.socket.nio.NioSocketConnector;
import org.drools.SystemEventListenerFactory;
import org.drools.task.BaseTest;
import org.drools.task.MockUserInfo;
import org.drools.task.OrganizationalEntity;
import org.drools.task.Task;
import org.drools.task.User;
import org.drools.task.UserInfo;
import org.drools.task.service.MinaTaskClient;
import org.drools.task.service.MinaTaskServer;
import org.drools.task.service.TaskClientHandler;
import org.drools.task.service.responsehandlers.BlockingAddTaskResponseHandler;
import org.drools.task.service.responsehandlers.BlockingTaskOperationResponseHandler;
import org.drools.util.ChainedProperties;
import org.subethamail.wiser.Wiser;
import org.subethamail.wiser.WiserMessage;

public class IcalTest
extends BaseTest {
    MinaTaskServer server;
    MinaTaskClient client;
    Wiser wiser;
    String emailHost;
    String emailPort;

    protected void setUp() throws Exception {
        super.setUp();
        ChainedProperties props = new ChainedProperties("process.email.conf");
        this.emailHost = props.getProperty("host", "locahost");
        this.emailPort = props.getProperty("port", "2345");
        this.server = new MinaTaskServer(this.taskService);
        Thread thread = new Thread((Runnable)this.server);
        thread.start();
        Thread.sleep(500L);
        this.client = new MinaTaskClient("client 1", new TaskClientHandler(SystemEventListenerFactory.getSystemEventListener()));
        NioSocketConnector connector = new NioSocketConnector();
        InetSocketAddress address = new InetSocketAddress("127.0.0.1", 9123);
        this.client.connect((SocketConnector)connector, (SocketAddress)address);
        this.wiser = new Wiser();
        this.wiser.setHostname(this.emailHost);
        this.wiser.setPort(Integer.parseInt(this.emailPort));
        this.wiser.start();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.client.disconnect();
        this.server.stop();
        this.wiser.stop();
    }

    public void testSendWithStartandEndDeadline() throws Exception {
        HashedMap vars = new HashedMap();
        vars.put("users", this.users);
        vars.put("groups", this.groups);
        vars.put("now", new Date());
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { createdOn = now, createdBy = users['tony'], activationTime = now}), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) {potentialOwners = [users['steve' ], users['tony' ]]}), ";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')],";
        str = str + "subjects = [ new I18NText( 'en-UK', 'This is my task subject')],";
        str = str + "descriptions = [ new I18NText( 'en-UK', 'This is my task description')],";
        str = str + "deadlines = (with (new Deadlines() ) {";
        str = str + "    startDeadlines = [ ";
        str = str + "       (with (new Deadline()) {";
        str = str + "           date = now";
        str = str + "       } ) ],";
        str = str + "    endDeadlines = [";
        str = str + "        (with (new Deadline()) {";
        str = str + "             date = new Date( now.time + ( 1000 * 60 * * 60 * 24 ) )";
        str = str + "        } ) ]";
        str = str + "} ) })";
        MockUserInfo userInfo = new MockUserInfo();
        userInfo.getEmails().put((OrganizationalEntity)this.users.get("tony"), "tony@domain.com");
        userInfo.getEmails().put((OrganizationalEntity)this.users.get("steve"), "steve@domain.com");
        userInfo.getLanguages().put((OrganizationalEntity)this.users.get("tony"), "en-UK");
        userInfo.getLanguages().put((OrganizationalEntity)this.users.get("steve"), "en-UK");
        this.taskService.setUserinfo((UserInfo)userInfo);
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)this.eval(new StringReader(str), (Map)vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.claim(taskId, ((User)this.users.get("steve")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        IcalTest.assertEquals((int)2, (int)this.wiser.getMessages().size());
        IcalTest.assertEquals((String)"steve@domain.com", (String)((WiserMessage)this.wiser.getMessages().get(0)).getEnvelopeReceiver());
        IcalTest.assertEquals((String)"steve@domain.com", (String)((WiserMessage)this.wiser.getMessages().get(1)).getEnvelopeReceiver());
        String subject = "Summary\n-------\n\nThis is my task subject\n\n";
        String description = "Description\n-----------\n\nThis is my task description";
        MimeMessage msg = ((WiserMessage)this.wiser.getMessages().get(0)).getMimeMessage();
        IcalTest.assertEqualsIgnoreWhitespace("multipart/alternative;boundary=\"----=_Part_", msg.getContentType(), 0, 47);
        IcalTest.assertEquals((String)"tony@domain.com", (String)((InternetAddress)msg.getFrom()[0]).getAddress());
        IcalTest.assertEquals((String)"tony@domain.com", (String)((InternetAddress)msg.getReplyTo()[0]).getAddress());
        IcalTest.assertEquals((String)"steve@domain.com", (String)((InternetAddress)msg.getRecipients(MimeMessage.RecipientType.TO)[0]).getAddress());
        IcalTest.assertEquals((String)"Task Assignment Start Event: This is my task name", (String)msg.getSubject());
        MimeMultipart multiPart = (MimeMultipart)msg.getContent();
        BodyPart messageBodyPart = multiPart.getBodyPart(0);
        IcalTest.assertEquals((String)"text/plain; charset=UTF8;", (String)messageBodyPart.getDataHandler().getContentType());
        String content = new String(IcalTest.getBytes(messageBodyPart.getDataHandler().getInputStream()));
        IcalTest.assertEqualsIgnoreWhitespace(subject + description, content);
        messageBodyPart = multiPart.getBodyPart(1);
        IcalTest.assertEquals((String)"text/calendar; charset=UTF8; name=ical-Start-1.ics", (String)messageBodyPart.getDataHandler().getContentType());
        content = new String(IcalTest.getBytes(messageBodyPart.getDataHandler().getInputStream()));
        IcalTest.assertEqualsIgnoreWhitespace("BEGIN:VCALENDARPRODID:-//iCal4j 1.0//ENCALSCALE:GREGORIANVERSION:2.0METHOD:REQUESTBEGIN:VEVENTDTSTART;TZID=UTC:", content.substring(0, 123));
        IcalTest.assertEqualsIgnoreWhitespace("SUMMARY:\"Task Start : This is my task subject\"DESCRIPTION:\"This is my task description\"PRIORITY:55END:VEVENTEND:VCALENDAR", content.substring(content.length() - 131, content.length()));
        msg = ((WiserMessage)this.wiser.getMessages().get(1)).getMimeMessage();
        IcalTest.assertEqualsIgnoreWhitespace("multipart/alternative;boundary=\"----=_Part_", msg.getContentType(), 0, 47);
        IcalTest.assertEquals((String)"tony@domain.com", (String)((InternetAddress)msg.getFrom()[0]).getAddress());
        IcalTest.assertEquals((String)"tony@domain.com", (String)((InternetAddress)msg.getReplyTo()[0]).getAddress());
        IcalTest.assertEquals((String)"steve@domain.com", (String)((InternetAddress)msg.getRecipients(MimeMessage.RecipientType.TO)[0]).getAddress());
        IcalTest.assertEquals((String)"Task Assignment End Event: This is my task name", (String)msg.getSubject());
        multiPart = (MimeMultipart)msg.getContent();
        messageBodyPart = multiPart.getBodyPart(0);
        IcalTest.assertEquals((String)"text/plain; charset=UTF8;", (String)messageBodyPart.getDataHandler().getContentType());
        content = new String(IcalTest.getBytes(messageBodyPart.getDataHandler().getInputStream()));
        IcalTest.assertEqualsIgnoreWhitespace(subject + description, content);
        messageBodyPart = multiPart.getBodyPart(1);
        IcalTest.assertEquals((String)"text/calendar; charset=UTF8; name=ical-End-1.ics", (String)messageBodyPart.getDataHandler().getContentType());
        content = new String(IcalTest.getBytes(messageBodyPart.getDataHandler().getInputStream()));
        IcalTest.assertEqualsIgnoreWhitespace("BEGIN:VCALENDARPRODID:-//iCal4j 1.0//ENCALSCALE:GREGORIANVERSION:2.0METHOD:REQUESTBEGIN:VEVENTDTSTART;TZID=UTC:", content.substring(0, 123));
        IcalTest.assertEqualsIgnoreWhitespace("SUMMARY:\"Task End : This is my task subject\"DESCRIPTION:\"This is my task description\"PRIORITY:55END:VEVENTEND:VCALENDAR", content.substring(content.length() - 131, content.length()));
    }

    public void testSendWithStartDeadline() throws Exception {
        HashedMap vars = new HashedMap();
        vars.put("users", this.users);
        vars.put("groups", this.groups);
        vars.put("now", new Date());
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { createdOn = now, createdBy = users['tony'], activationTime = now}), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) {potentialOwners = [users['steve' ], users['tony' ]]}), ";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')],";
        str = str + "subjects = [ new I18NText( 'en-UK', 'This is my task subject')],";
        str = str + "descriptions = [ new I18NText( 'en-UK', 'This is my task description')],";
        str = str + "deadlines = (with (new Deadlines() ) {";
        str = str + "    startDeadlines = [ ";
        str = str + "       (with (new Deadline()) {";
        str = str + "           date = now";
        str = str + "       } ) ]";
        str = str + "} ) })";
        MockUserInfo userInfo = new MockUserInfo();
        userInfo.getEmails().put((OrganizationalEntity)this.users.get("tony"), "tony@domain.com");
        userInfo.getEmails().put((OrganizationalEntity)this.users.get("steve"), "steve@domain.com");
        userInfo.getLanguages().put((OrganizationalEntity)this.users.get("tony"), "en-UK");
        userInfo.getLanguages().put((OrganizationalEntity)this.users.get("steve"), "en-UK");
        this.taskService.setUserinfo((UserInfo)userInfo);
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)this.eval(new StringReader(str), (Map)vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.claim(taskId, ((User)this.users.get("steve")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        IcalTest.assertEquals((int)1, (int)this.wiser.getMessages().size());
        IcalTest.assertEquals((String)"steve@domain.com", (String)((WiserMessage)this.wiser.getMessages().get(0)).getEnvelopeReceiver());
        String subject = "Summary\n-------\n\nThis is my task subject\n\n";
        String description = "Description\n-----------\n\nThis is my task description";
        MimeMessage msg = ((WiserMessage)this.wiser.getMessages().get(0)).getMimeMessage();
        IcalTest.assertEqualsIgnoreWhitespace("multipart/alternative;boundary=\"----=_Part_", msg.getContentType(), 0, 47);
        IcalTest.assertEquals((String)"tony@domain.com", (String)((InternetAddress)msg.getFrom()[0]).getAddress());
        IcalTest.assertEquals((String)"tony@domain.com", (String)((InternetAddress)msg.getReplyTo()[0]).getAddress());
        IcalTest.assertEquals((String)"steve@domain.com", (String)((InternetAddress)msg.getRecipients(MimeMessage.RecipientType.TO)[0]).getAddress());
        IcalTest.assertEquals((String)"Task Assignment Start Event: This is my task name", (String)msg.getSubject());
        MimeMultipart multiPart = (MimeMultipart)msg.getContent();
        BodyPart messageBodyPart = multiPart.getBodyPart(0);
        IcalTest.assertEquals((String)"text/plain; charset=UTF8;", (String)messageBodyPart.getDataHandler().getContentType());
        String content = new String(IcalTest.getBytes(messageBodyPart.getDataHandler().getInputStream()));
        IcalTest.assertEqualsIgnoreWhitespace(subject + description, content);
        messageBodyPart = multiPart.getBodyPart(1);
        IcalTest.assertEquals((String)"text/calendar; charset=UTF8; name=ical-Start-1.ics", (String)messageBodyPart.getDataHandler().getContentType());
        content = new String(IcalTest.getBytes(messageBodyPart.getDataHandler().getInputStream()));
        IcalTest.assertEqualsIgnoreWhitespace("BEGIN:VCALENDARPRODID:-//iCal4j 1.0//ENCALSCALE:GREGORIANVERSION:2.0METHOD:REQUESTBEGIN:VEVENTDTSTART;TZID=UTC:", content.substring(0, 123));
        IcalTest.assertEqualsIgnoreWhitespace("SUMMARY:\"Task Start : This is my task subject\"DESCRIPTION:\"This is my task description\"PRIORITY:55END:VEVENTEND:VCALENDAR", content.substring(content.length() - 131, content.length()));
    }

    public void testSendWithEndDeadline() throws Exception {
        HashedMap vars = new HashedMap();
        vars.put("users", this.users);
        vars.put("groups", this.groups);
        vars.put("now", new Date());
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { createdOn = now, createdBy = users['tony'], activationTime = now}), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) {potentialOwners = [users['steve' ], users['tony' ]]}), ";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')],";
        str = str + "subjects = [ new I18NText( 'en-UK', 'This is my task subject')],";
        str = str + "descriptions = [ new I18NText( 'en-UK', 'This is my task description')],";
        str = str + "deadlines = (with (new Deadlines() ) {";
        str = str + "    endDeadlines = [";
        str = str + "        (with (new Deadline()) {";
        str = str + "             date = new Date( now.time + ( 1000 * 60 * * 60 * 24 ) )";
        str = str + "        } ) ]";
        str = str + "} ) })";
        MockUserInfo userInfo = new MockUserInfo();
        userInfo.getEmails().put((OrganizationalEntity)this.users.get("tony"), "tony@domain.com");
        userInfo.getEmails().put((OrganizationalEntity)this.users.get("steve"), "steve@domain.com");
        userInfo.getLanguages().put((OrganizationalEntity)this.users.get("tony"), "en-UK");
        userInfo.getLanguages().put((OrganizationalEntity)this.users.get("steve"), "en-UK");
        this.taskService.setUserinfo((UserInfo)userInfo);
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)this.eval(new StringReader(str), (Map)vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.claim(taskId, ((User)this.users.get("steve")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        IcalTest.assertEquals((int)1, (int)this.wiser.getMessages().size());
        IcalTest.assertEquals((String)"steve@domain.com", (String)((WiserMessage)this.wiser.getMessages().get(0)).getEnvelopeReceiver());
        String subject = "Summary\n-------\n\nThis is my task subject\n\n";
        String description = "Description\n-----------\n\nThis is my task description";
        MimeMessage msg = ((WiserMessage)this.wiser.getMessages().get(0)).getMimeMessage();
        IcalTest.assertEqualsIgnoreWhitespace("multipart/alternative;boundary=\"----=_Part_", msg.getContentType(), 0, 47);
        IcalTest.assertEquals((String)"tony@domain.com", (String)((InternetAddress)msg.getFrom()[0]).getAddress());
        IcalTest.assertEquals((String)"tony@domain.com", (String)((InternetAddress)msg.getReplyTo()[0]).getAddress());
        IcalTest.assertEquals((String)"steve@domain.com", (String)((InternetAddress)msg.getRecipients(MimeMessage.RecipientType.TO)[0]).getAddress());
        IcalTest.assertEquals((String)"Task Assignment End Event: This is my task name", (String)msg.getSubject());
        MimeMultipart multiPart = (MimeMultipart)msg.getContent();
        BodyPart messageBodyPart = multiPart.getBodyPart(0);
        IcalTest.assertEquals((String)"text/plain; charset=UTF8;", (String)messageBodyPart.getDataHandler().getContentType());
        String content = new String(IcalTest.getBytes(messageBodyPart.getDataHandler().getInputStream()));
        IcalTest.assertEqualsIgnoreWhitespace(subject + description, content);
        messageBodyPart = multiPart.getBodyPart(1);
        IcalTest.assertEquals((String)"text/calendar; charset=UTF8; name=ical-End-1.ics", (String)messageBodyPart.getDataHandler().getContentType());
        content = new String(IcalTest.getBytes(messageBodyPart.getDataHandler().getInputStream()));
        IcalTest.assertEqualsIgnoreWhitespace("BEGIN:VCALENDARPRODID:-//iCal4j 1.0//ENCALSCALE:GREGORIANVERSION:2.0METHOD:REQUESTBEGIN:VEVENTDTSTART;TZID=UTC:", content.substring(0, 123));
        IcalTest.assertEqualsIgnoreWhitespace("SUMMARY:\"Task End : This is my task subject\"DESCRIPTION:\"This is my task description\"PRIORITY:55END:VEVENTEND:VCALENDAR", content.substring(content.length() - 131, content.length()));
    }

    public void testSendWithNoDeadline() throws Exception {
        HashedMap vars = new HashedMap();
        vars.put("users", this.users);
        vars.put("groups", this.groups);
        vars.put("now", new Date());
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { createdOn = now, createdBy = users['tony'], activationTime = now}), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) {potentialOwners = [users['steve' ], users['tony' ]]}), ";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')],";
        str = str + "subjects = [ new I18NText( 'en-UK', 'This is my task subject')],";
        str = str + "descriptions = [ new I18NText( 'en-UK', 'This is my task description')]";
        str = str + "})";
        MockUserInfo userInfo = new MockUserInfo();
        userInfo.getEmails().put((OrganizationalEntity)this.users.get("tony"), "tony@domain.com");
        userInfo.getEmails().put((OrganizationalEntity)this.users.get("steve"), "steve@domain.com");
        userInfo.getLanguages().put((OrganizationalEntity)this.users.get("tony"), "en-UK");
        userInfo.getLanguages().put((OrganizationalEntity)this.users.get("steve"), "en-UK");
        this.taskService.setUserinfo((UserInfo)userInfo);
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)this.eval(new StringReader(str), (Map)vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.claim(taskId, ((User)this.users.get("steve")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        IcalTest.assertEquals((int)0, (int)this.wiser.getMessages().size());
    }

    private static void assertEqualsIgnoreWhitespace(String expected, String actual) {
        IcalTest.assertEqualsIgnoreWhitespace(expected, actual, 0, actual.length());
    }

    private static void assertEqualsIgnoreWhitespace(String expected, String actual, int beginIndex, int endIndex) {
        String cleanExpected = expected.replaceAll("\\s+", "").replaceAll("\\n", "").replaceAll("\\r", "");
        String cleanActual = actual.substring(beginIndex, endIndex).replaceAll("\\s+", "").replaceAll("\\n", "").replaceAll("\\r", "");
        IcalTest.assertEquals((String)cleanExpected, (String)cleanActual);
    }

    private static byte[] getBytes(InputStream inputStream) throws Exception {
        int readBytes;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(1024);
        byte[] bytes = new byte[512];
        while ((readBytes = inputStream.read(bytes)) > 0) {
            outputStream.write(bytes, 0, readBytes);
        }
        byte[] byteData = outputStream.toByteArray();
        inputStream.close();
        outputStream.close();
        return byteData;
    }
}

