/*
 * Decompiled with CFR 0.152.
 */
package org.drools.task.service;

import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.collections.map.HashedMap;
import org.apache.mina.transport.socket.SocketConnector;
import org.apache.mina.transport.socket.nio.NioSocketConnector;
import org.drools.SystemEventListenerFactory;
import org.drools.process.instance.impl.DefaultWorkItemManager;
import org.drools.runtime.process.WorkItemManager;
import org.drools.task.BaseTest;
import org.drools.task.Content;
import org.drools.task.MockUserInfo;
import org.drools.task.OrganizationalEntity;
import org.drools.task.Status;
import org.drools.task.Task;
import org.drools.task.User;
import org.drools.task.UserInfo;
import org.drools.task.service.DefaultEscalatedDeadlineHandler;
import org.drools.task.service.EscalatedDeadlineHandler;
import org.drools.task.service.MinaTaskClient;
import org.drools.task.service.MinaTaskServer;
import org.drools.task.service.TaskClientHandler;
import org.drools.task.service.responsehandlers.BlockingAddTaskResponseHandler;
import org.drools.task.service.responsehandlers.BlockingGetContentResponseHandler;
import org.drools.task.service.responsehandlers.BlockingGetTaskResponseHandler;
import org.drools.task.service.responsehandlers.BlockingSetContentResponseHandler;
import org.subethamail.wiser.Wiser;
import org.subethamail.wiser.WiserMessage;

public class TaskServiceDeadlinesTest
extends BaseTest {
    MinaTaskServer server;
    MinaTaskClient client;
    Properties conf;
    Wiser wiser;

    protected void setUp() throws Exception {
        super.setUp();
        this.conf = new Properties();
        this.conf.setProperty("mail.smtp.host", "localhost");
        this.conf.setProperty("mail.smtp.port", "2345");
        this.conf.setProperty("from", "from@domain.com");
        this.conf.setProperty("replyTo", "replyTo@domain.com");
        this.conf.setProperty("defaultLanguage", "en-UK");
        this.server = new MinaTaskServer(this.taskService);
        Thread thread = new Thread((Runnable)this.server);
        thread.start();
        Thread.sleep(500L);
        this.client = new MinaTaskClient("client 1", new TaskClientHandler(SystemEventListenerFactory.getSystemEventListener()));
        NioSocketConnector connector = new NioSocketConnector();
        InetSocketAddress address = new InetSocketAddress("127.0.0.1", 9123);
        this.client.connect((SocketConnector)connector, (SocketAddress)address);
        this.wiser = new Wiser();
        this.wiser.setHostname(this.conf.getProperty("mail.smtp.host"));
        this.wiser.setPort(Integer.parseInt(this.conf.getProperty("mail.smtp.port")));
        this.wiser.start();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.client.disconnect();
        this.server.stop();
        this.wiser.stop();
    }

    public void testDelayedEmailNotificationOnDeadline() throws Exception {
        HashedMap vars = new HashedMap();
        vars.put("users", this.users);
        vars.put("groups", this.groups);
        vars.put("now", new Date());
        DefaultEscalatedDeadlineHandler notificationHandler = new DefaultEscalatedDeadlineHandler(this.conf);
        DefaultWorkItemManager manager = new DefaultWorkItemManager(null);
        notificationHandler.setManager((WorkItemManager)manager);
        MockUserInfo userInfo = new MockUserInfo();
        userInfo.getEmails().put((OrganizationalEntity)this.users.get("tony"), "tony@domain.com");
        userInfo.getEmails().put((OrganizationalEntity)this.users.get("darth"), "darth@domain.com");
        userInfo.getLanguages().put((OrganizationalEntity)this.users.get("tony"), "en-UK");
        userInfo.getLanguages().put((OrganizationalEntity)this.users.get("darth"), "en-UK");
        notificationHandler.setUserInfo((UserInfo)userInfo);
        this.taskService.setEscalatedDeadlineHandler((EscalatedDeadlineHandler)notificationHandler);
        String string = this.toString(new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("DeadlineWithNotification.mvel")));
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)this.eval(new StringReader(string), (Map)vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        Content content = new Content();
        content.setContent("['subject' : 'My Subject', 'body' : 'My Body']".getBytes());
        BlockingSetContentResponseHandler setContentResponseHandler = new BlockingSetContentResponseHandler();
        this.client.setDocumentContent(taskId, content, (TaskClientHandler.SetDocumentResponseHandler)setContentResponseHandler);
        long contentId = setContentResponseHandler.getContentId();
        BlockingGetContentResponseHandler getResponseHandler = new BlockingGetContentResponseHandler();
        this.client.getContent(contentId, (TaskClientHandler.GetContentResponseHandler)getResponseHandler);
        content = getResponseHandler.getContent();
        TaskServiceDeadlinesTest.assertEquals((String)"['subject' : 'My Subject', 'body' : 'My Body']", (String)new String(content.getContent()));
        TaskServiceDeadlinesTest.assertEquals((int)0, (int)this.wiser.getMessages().size());
        Thread.sleep(100L);
        TaskServiceDeadlinesTest.assertEquals((int)0, (int)this.wiser.getMessages().size());
        for (long time = 0L; this.wiser.getMessages().size() != 2 && time < 15000L; time += 500L) {
            Thread.sleep(500L);
        }
        TaskServiceDeadlinesTest.assertEquals((int)2, (int)this.wiser.getMessages().size());
        ArrayList<String> list = new ArrayList<String>(2);
        list.add(((WiserMessage)this.wiser.getMessages().get(0)).getEnvelopeReceiver());
        list.add(((WiserMessage)this.wiser.getMessages().get(1)).getEnvelopeReceiver());
        TaskServiceDeadlinesTest.assertTrue((boolean)list.contains("tony@domain.com"));
        TaskServiceDeadlinesTest.assertTrue((boolean)list.contains("darth@domain.com"));
        MimeMessage msg = ((WiserMessage)this.wiser.getMessages().get(0)).getMimeMessage();
        TaskServiceDeadlinesTest.assertEquals((Object)"My Body", (Object)msg.getContent());
        TaskServiceDeadlinesTest.assertEquals((String)"My Subject", (String)msg.getSubject());
        TaskServiceDeadlinesTest.assertEquals((String)"from@domain.com", (String)((InternetAddress)msg.getFrom()[0]).getAddress());
        TaskServiceDeadlinesTest.assertEquals((String)"replyTo@domain.com", (String)((InternetAddress)msg.getReplyTo()[0]).getAddress());
        TaskServiceDeadlinesTest.assertEquals((String)"tony@domain.com", (String)((InternetAddress)msg.getRecipients(MimeMessage.RecipientType.TO)[0]).getAddress());
        TaskServiceDeadlinesTest.assertEquals((String)"darth@domain.com", (String)((InternetAddress)msg.getRecipients(MimeMessage.RecipientType.TO)[1]).getAddress());
    }

    public void testDelayedReassignmentOnDeadline() throws Exception {
        HashedMap vars = new HashedMap();
        vars.put("users", this.users);
        vars.put("groups", this.groups);
        vars.put("now", new Date());
        DefaultEscalatedDeadlineHandler notificationHandler = new DefaultEscalatedDeadlineHandler(this.conf);
        DefaultWorkItemManager manager = new DefaultWorkItemManager(null);
        notificationHandler.setManager((WorkItemManager)manager);
        MockUserInfo userInfo = new MockUserInfo();
        userInfo.getEmails().put((OrganizationalEntity)this.users.get("tony"), "tony@domain.com");
        userInfo.getEmails().put((OrganizationalEntity)this.users.get("luke"), "luke@domain.com");
        userInfo.getEmails().put((OrganizationalEntity)this.users.get("bobba"), "luke@domain.com");
        userInfo.getEmails().put((OrganizationalEntity)this.users.get("jabba"), "luke@domain.com");
        userInfo.getLanguages().put((OrganizationalEntity)this.users.get("tony"), "en-UK");
        userInfo.getLanguages().put((OrganizationalEntity)this.users.get("luke"), "en-UK");
        userInfo.getLanguages().put((OrganizationalEntity)this.users.get("bobba"), "en-UK");
        userInfo.getLanguages().put((OrganizationalEntity)this.users.get("jabba"), "en-UK");
        notificationHandler.setUserInfo((UserInfo)userInfo);
        this.taskService.setEscalatedDeadlineHandler((EscalatedDeadlineHandler)notificationHandler);
        String string = this.toString(new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("DeadlineWithReassignment.mvel")));
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)this.eval(new StringReader(string), (Map)vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        Thread.sleep(1000L);
        BlockingGetTaskResponseHandler getTaskHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskHandler);
        task = getTaskHandler.getTask();
        List potentialOwners = task.getPeopleAssignments().getPotentialOwners();
        ArrayList<String> ids = new ArrayList<String>(potentialOwners.size());
        for (OrganizationalEntity entity : potentialOwners) {
            ids.add(entity.getId());
        }
        TaskServiceDeadlinesTest.assertTrue((boolean)ids.contains(((User)this.users.get("tony")).getId()));
        TaskServiceDeadlinesTest.assertTrue((boolean)ids.contains(((User)this.users.get("luke")).getId()));
        for (long time = 0L; this.wiser.getMessages().size() != 2 && time < 15000L; time += 500L) {
            Thread.sleep(500L);
        }
        getTaskHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskHandler);
        task = getTaskHandler.getTask();
        TaskServiceDeadlinesTest.assertEquals((Object)Status.Ready, (Object)task.getTaskData().getStatus());
        potentialOwners = task.getPeopleAssignments().getPotentialOwners();
        System.out.println(potentialOwners);
        ids = new ArrayList(potentialOwners.size());
        for (OrganizationalEntity entity : potentialOwners) {
            ids.add(entity.getId());
        }
        TaskServiceDeadlinesTest.assertTrue((boolean)ids.contains(((User)this.users.get("bobba")).getId()));
        TaskServiceDeadlinesTest.assertTrue((boolean)ids.contains(((User)this.users.get("jabba")).getId()));
    }
}

