/*
 * Decompiled with CFR 0.152.
 */
package org.drools.task.service;

import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import org.apache.commons.collections.map.HashedMap;
import org.apache.mina.transport.socket.SocketConnector;
import org.apache.mina.transport.socket.nio.NioSocketConnector;
import org.drools.SystemEventListenerFactory;
import org.drools.task.BaseTest;
import org.drools.task.Deadline;
import org.drools.task.Task;
import org.drools.task.service.EscalatedDeadlineHandler;
import org.drools.task.service.MinaTaskClient;
import org.drools.task.service.MinaTaskServer;
import org.drools.task.service.TaskClientHandler;
import org.drools.task.service.TaskService;
import org.drools.task.service.responsehandlers.BlockingAddTaskResponseHandler;

public class TaskServiceEscalationTest
extends BaseTest {
    MinaTaskServer server;
    MinaTaskClient client;

    protected void setUp() throws Exception {
        super.setUp();
        this.server = new MinaTaskServer(this.taskService);
        Thread thread = new Thread((Runnable)this.server);
        thread.start();
        Thread.sleep(500L);
        this.client = new MinaTaskClient("client 1", new TaskClientHandler(SystemEventListenerFactory.getSystemEventListener()));
        NioSocketConnector connector = new NioSocketConnector();
        InetSocketAddress address = new InetSocketAddress("127.0.0.1", 9123);
        this.client.connect((SocketConnector)connector, (SocketAddress)address);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.client.disconnect();
        this.server.stop();
    }

    public void testDummy() {
        TaskServiceEscalationTest.assertTrue((boolean)true);
    }

    public void FIXME_testUnescalatedDeadlines() throws Exception {
        HashedMap vars = new HashedMap();
        vars.put("users", this.users);
        vars.put("groups", this.groups);
        MockEscalatedDeadlineHandler handler = new MockEscalatedDeadlineHandler();
        this.taskService.setEscalatedDeadlineHandler((EscalatedDeadlineHandler)handler);
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("../QueryData_UnescalatedDeadlines.mvel"));
        List tasks = (List)this.eval(reader, (Map)vars);
        long now = ((Date)vars.get("now")).getTime();
        for (Task task : tasks) {
            BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
            this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
            addTaskResponseHandler.waitTillDone(3000L);
        }
        handler.wait(3, 30000);
        TaskServiceEscalationTest.assertEquals((int)3, (int)handler.list.size());
        MockEscalatedDeadlineHandler.Item item0 = handler.list.get(0);
        TaskServiceEscalationTest.assertEquals((long)(now + 20000L), (long)item0.getDeadline().getDate().getTime());
        MockEscalatedDeadlineHandler.Item item1 = handler.list.get(1);
        TaskServiceEscalationTest.assertEquals((long)(now + 22000L), (long)item1.getDeadline().getDate().getTime());
        MockEscalatedDeadlineHandler.Item item2 = handler.list.get(2);
        TaskServiceEscalationTest.assertEquals((long)(now + 24000L), (long)item2.getDeadline().getDate().getTime());
    }

    public void FIXME_testUnescalatedDeadlinesOnStartup() throws Exception {
        HashedMap vars = new HashedMap();
        vars.put("users", this.users);
        vars.put("groups", this.groups);
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("../QueryData_UnescalatedDeadlines.mvel"));
        List tasks = (List)this.eval(reader, (Map)vars);
        long now = ((Date)vars.get("now")).getTime();
        EntityManager em = this.emf.createEntityManager();
        em.getTransaction().begin();
        for (Task task : tasks) {
            em.persist((Object)task);
        }
        em.getTransaction().commit();
        MockEscalatedDeadlineHandler handler = new MockEscalatedDeadlineHandler();
        TaskService local = new TaskService(this.emf, SystemEventListenerFactory.getSystemEventListener(), (EscalatedDeadlineHandler)handler);
        handler.wait(3, 30000);
        TaskServiceEscalationTest.assertEquals((int)3, (int)handler.list.size());
        MockEscalatedDeadlineHandler.Item item0 = handler.list.get(0);
        TaskServiceEscalationTest.assertEquals((long)item0.getDeadline().getDate().getTime(), (long)(now + 20000L));
        MockEscalatedDeadlineHandler.Item item1 = handler.list.get(1);
        TaskServiceEscalationTest.assertEquals((long)item1.getDeadline().getDate().getTime(), (long)(now + 22000L));
        MockEscalatedDeadlineHandler.Item item2 = handler.list.get(2);
        TaskServiceEscalationTest.assertEquals((long)item2.getDeadline().getDate().getTime(), (long)(now + 24000L));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MockEscalatedDeadlineHandler
    implements EscalatedDeadlineHandler {
        List<Item> list = new ArrayList<Item>();
        TaskService taskService;

        public void executeEscalatedDeadline(Task task, Deadline deadline, EntityManager em, TaskService taskService) {
            this.list.add(new Item(task, deadline, em, taskService));
        }

        public List<Item> getList() {
            return this.list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void wait(int totalSize, int totalWait) {
            int wait = 0;
            int size = 0;
            while (true) {
                List<Item> list = this.list;
                synchronized (list) {
                    size = this.list.size();
                }
                if (size >= totalSize || wait >= totalWait) break;
                try {
                    Thread.sleep(250L);
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to sleep", e);
                }
                wait += 250;
            }
        }

        public static class Item {
            Task task;
            Deadline deadline;
            EntityManager em;

            public Item(Task task, Deadline deadline, EntityManager em, TaskService taskService) {
                this.deadline = deadline;
                this.em = em;
                this.task = task;
            }

            public Task getTask() {
                return this.task;
            }

            public void setTask(Task task) {
                this.task = task;
            }

            public Deadline getDeadline() {
                return this.deadline;
            }

            public void setDeadline(Deadline deadline) {
                this.deadline = deadline;
            }

            public EntityManager getEntityManager() {
                return this.em;
            }

            public void setEntityManager(EntityManager em) {
                this.em = em;
            }

            public EntityManager getEm() {
                return this.em;
            }

            public void setEm(EntityManager em) {
                this.em = em;
            }
        }
    }
}

