/*
 * Decompiled with CFR 0.152.
 */
package org.drools.task.service;

import java.io.StringReader;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Date;
import java.util.Map;
import org.apache.commons.collections.map.HashedMap;
import org.apache.mina.transport.socket.SocketConnector;
import org.apache.mina.transport.socket.nio.NioSocketConnector;
import org.drools.SystemEventListenerFactory;
import org.drools.task.AccessType;
import org.drools.task.BaseTest;
import org.drools.task.Content;
import org.drools.task.Status;
import org.drools.task.Task;
import org.drools.task.User;
import org.drools.task.service.ContentData;
import org.drools.task.service.FaultData;
import org.drools.task.service.MinaTaskClient;
import org.drools.task.service.MinaTaskServer;
import org.drools.task.service.PermissionDeniedException;
import org.drools.task.service.TaskClientHandler;
import org.drools.task.service.responsehandlers.BlockingAddTaskResponseHandler;
import org.drools.task.service.responsehandlers.BlockingGetContentResponseHandler;
import org.drools.task.service.responsehandlers.BlockingGetTaskResponseHandler;
import org.drools.task.service.responsehandlers.BlockingTaskOperationResponseHandler;

public class TaskServiceLifeCycleTest
extends BaseTest {
    MinaTaskServer server;
    MinaTaskClient client;
    private static final int DEFAULT_WAIT_TIME = 5000;

    protected void setUp() throws Exception {
        super.setUp();
        this.server = new MinaTaskServer(this.taskService);
        Thread thread = new Thread((Runnable)this.server);
        thread.start();
        Thread.sleep(500L);
        this.client = new MinaTaskClient("client 1", new TaskClientHandler(SystemEventListenerFactory.getSystemEventListener()));
        NioSocketConnector connector = new NioSocketConnector();
        InetSocketAddress address = new InetSocketAddress("127.0.0.1", 9123);
        this.client.connect((SocketConnector)connector, (SocketAddress)address);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.client.disconnect();
        this.server.stop();
    }

    public void testNewTaskWithNoPotentialOwners() {
        HashedMap vars = new HashedMap();
        vars.put("users", this.users);
        vars.put("groups", this.groups);
        vars.put("now", new Date());
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)this.eval(new StringReader(str), (Map)vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleTest.assertEquals((Object)task1.getTaskData().getStatus(), (Object)Status.Created);
        TaskServiceLifeCycleTest.assertNull((Object)task1.getTaskData().getActualOwner());
    }

    public void testNewTaskWithSinglePotentialOwner() {
        HashedMap vars = new HashedMap();
        vars.put("users", this.users);
        vars.put("groups", this.groups);
        vars.put("now", new Date());
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)this.eval(new StringReader(str), (Map)vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleTest.assertEquals((Object)Status.Reserved, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleTest.assertEquals(this.users.get("bobba"), (Object)task1.getTaskData().getActualOwner());
    }

    public void testNewTaskWithContent() {
        HashedMap vars = new HashedMap();
        vars.put("users", this.users);
        vars.put("groups", this.groups);
        vars.put("now", new Date());
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        ContentData data = new ContentData();
        data.setAccessType(AccessType.Inline);
        data.setType("type");
        data.setContent("content".getBytes());
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)this.eval(new StringReader(str), (Map)vars);
        this.client.addTask(task, data, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleTest.assertEquals((Object)AccessType.Inline, (Object)task1.getTaskData().getDocumentAccessType());
        TaskServiceLifeCycleTest.assertEquals((String)"type", (String)task1.getTaskData().getDocumentType());
        long contentId = task1.getTaskData().getDocumentContentId();
        TaskServiceLifeCycleTest.assertTrue((contentId != -1L ? 1 : 0) != 0);
        BlockingGetContentResponseHandler getContentResponseHandler = new BlockingGetContentResponseHandler();
        this.client.getContent(contentId, (TaskClientHandler.GetContentResponseHandler)getContentResponseHandler);
        Content content = getContentResponseHandler.getContent();
        TaskServiceLifeCycleTest.assertEquals((String)"content", (String)new String(content.getContent()));
    }

    public void testClaimWithMultiplePotentialOwners() throws Exception {
        HashedMap vars = new HashedMap();
        vars.put("users", this.users);
        vars.put("groups", this.groups);
        vars.put("now", new Date());
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)this.eval(new StringReader(str), (Map)vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleTest.assertEquals((Object)Status.Ready, (Object)task1.getTaskData().getStatus());
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.claim(taskId, ((User)this.users.get("darth")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleTest.assertEquals((Object)Status.Reserved, (Object)task2.getTaskData().getStatus());
        TaskServiceLifeCycleTest.assertEquals(this.users.get("darth"), (Object)task2.getTaskData().getActualOwner());
    }

    public void testStartFromReadyStateWithPotentialOwner() throws Exception {
        HashedMap vars = new HashedMap();
        vars.put("users", this.users);
        vars.put("groups", this.groups);
        vars.put("now", new Date());
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)this.eval(new StringReader(str), (Map)vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleTest.assertEquals((Object)Status.Ready, (Object)task1.getTaskData().getStatus());
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.start(taskId, ((User)this.users.get("darth")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleTest.assertEquals((Object)Status.InProgress, (Object)task2.getTaskData().getStatus());
        TaskServiceLifeCycleTest.assertEquals(this.users.get("darth"), (Object)task2.getTaskData().getActualOwner());
    }

    public void testStartFromReadyStateWithIncorrectPotentialOwner() {
        HashedMap vars = new HashedMap();
        vars.put("users", this.users);
        vars.put("groups", this.groups);
        vars.put("now", new Date());
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)this.eval(new StringReader(str), (Map)vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleTest.assertEquals((Object)Status.Ready, (Object)task1.getTaskData().getStatus());
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.start(taskId, ((User)this.users.get("tony")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        PermissionDeniedException denied = null;
        try {
            responseHandler.waitTillDone(5000L);
        }
        catch (PermissionDeniedException e) {
            denied = e;
        }
        TaskServiceLifeCycleTest.assertNotNull((String)"Should get permissed denied exception", (Object)((Object)denied));
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleTest.assertEquals((Object)Status.Ready, (Object)task2.getTaskData().getStatus());
        TaskServiceLifeCycleTest.assertNull((Object)task2.getTaskData().getActualOwner());
    }

    public void testStartFromReserved() throws Exception {
        HashedMap vars = new HashedMap();
        vars.put("users", this.users);
        vars.put("groups", this.groups);
        vars.put("now", new Date());
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)this.eval(new StringReader(str), (Map)vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleTest.assertEquals((Object)Status.Reserved, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleTest.assertEquals(this.users.get("bobba"), (Object)task1.getTaskData().getActualOwner());
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.start(taskId, ((User)this.users.get("bobba")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleTest.assertEquals((Object)Status.InProgress, (Object)task2.getTaskData().getStatus());
        TaskServiceLifeCycleTest.assertEquals(this.users.get("bobba"), (Object)task1.getTaskData().getActualOwner());
    }

    public void testStartFromReservedWithIncorrectUser() {
        HashedMap vars = new HashedMap();
        vars.put("users", this.users);
        vars.put("groups", this.groups);
        vars.put("now", new Date());
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)this.eval(new StringReader(str), (Map)vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleTest.assertEquals((Object)Status.Reserved, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleTest.assertEquals(this.users.get("bobba"), (Object)task1.getTaskData().getActualOwner());
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.start(taskId, ((User)this.users.get("tony")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        PermissionDeniedException denied = null;
        try {
            responseHandler.waitTillDone(5000L);
        }
        catch (PermissionDeniedException e) {
            denied = e;
        }
        TaskServiceLifeCycleTest.assertNotNull((String)"Should get permissed denied exception", (Object)((Object)denied));
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleTest.assertEquals((Object)Status.Reserved, (Object)task2.getTaskData().getStatus());
        TaskServiceLifeCycleTest.assertEquals(this.users.get("bobba"), (Object)task1.getTaskData().getActualOwner());
    }

    public void testStop() {
        HashedMap vars = new HashedMap();
        vars.put("users", this.users);
        vars.put("groups", this.groups);
        vars.put("now", new Date());
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)this.eval(new StringReader(str), (Map)vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.start(taskId, ((User)this.users.get("darth")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleTest.assertEquals((Object)Status.InProgress, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleTest.assertEquals(this.users.get("darth"), (Object)task1.getTaskData().getActualOwner());
        responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.stop(taskId, ((User)this.users.get("darth")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleTest.assertEquals((Object)Status.Reserved, (Object)task2.getTaskData().getStatus());
        TaskServiceLifeCycleTest.assertEquals(this.users.get("darth"), (Object)task2.getTaskData().getActualOwner());
    }

    public void testStopWithIncorrectUser() {
        HashedMap vars = new HashedMap();
        vars.put("users", this.users);
        vars.put("groups", this.groups);
        vars.put("now", new Date());
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)this.eval(new StringReader(str), (Map)vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.start(taskId, ((User)this.users.get("darth")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleTest.assertEquals((Object)Status.InProgress, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleTest.assertEquals(this.users.get("darth"), (Object)task1.getTaskData().getActualOwner());
        responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.stop(taskId, ((User)this.users.get("bobba")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        PermissionDeniedException denied = null;
        try {
            responseHandler.waitTillDone(5000L);
        }
        catch (PermissionDeniedException e) {
            denied = e;
        }
        TaskServiceLifeCycleTest.assertNotNull((String)"Should get permissed denied exception", (Object)((Object)denied));
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleTest.assertEquals((Object)Status.InProgress, (Object)task2.getTaskData().getStatus());
        TaskServiceLifeCycleTest.assertEquals(this.users.get("darth"), (Object)task2.getTaskData().getActualOwner());
    }

    public void testReleaseFromInprogress() throws Exception {
        HashedMap vars = new HashedMap();
        vars.put("users", this.users);
        vars.put("groups", this.groups);
        vars.put("now", new Date());
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)this.eval(new StringReader(str), (Map)vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.start(taskId, ((User)this.users.get("darth")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleTest.assertEquals((Object)Status.InProgress, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleTest.assertEquals(this.users.get("darth"), (Object)task1.getTaskData().getActualOwner());
        responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.release(taskId, ((User)this.users.get("darth")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleTest.assertEquals((Object)Status.Ready, (Object)task2.getTaskData().getStatus());
        TaskServiceLifeCycleTest.assertNull((Object)task2.getTaskData().getActualOwner());
    }

    public void testReleaseFromReserved() {
        HashedMap vars = new HashedMap();
        vars.put("users", this.users);
        vars.put("groups", this.groups);
        vars.put("now", new Date());
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)this.eval(new StringReader(str), (Map)vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.claim(taskId, ((User)this.users.get("darth")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleTest.assertEquals((Object)Status.Reserved, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleTest.assertEquals(this.users.get("darth"), (Object)task1.getTaskData().getActualOwner());
        responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.release(taskId, ((User)this.users.get("darth")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleTest.assertEquals((Object)Status.Ready, (Object)task2.getTaskData().getStatus());
        TaskServiceLifeCycleTest.assertNull((Object)task2.getTaskData().getActualOwner());
    }

    public void testReleaseWithIncorrectUser() {
        HashedMap vars = new HashedMap();
        vars.put("users", this.users);
        vars.put("groups", this.groups);
        vars.put("now", new Date());
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)this.eval(new StringReader(str), (Map)vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.claim(taskId, ((User)this.users.get("darth")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleTest.assertEquals((Object)Status.Reserved, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleTest.assertEquals(this.users.get("darth"), (Object)task1.getTaskData().getActualOwner());
        responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.release(taskId, ((User)this.users.get("bobba")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        PermissionDeniedException denied = null;
        try {
            responseHandler.waitTillDone(5000L);
        }
        catch (PermissionDeniedException e) {
            denied = e;
        }
        TaskServiceLifeCycleTest.assertNotNull((String)"Should get permissed denied exception", (Object)((Object)denied));
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleTest.assertEquals((Object)Status.Reserved, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleTest.assertEquals(this.users.get("darth"), (Object)task1.getTaskData().getActualOwner());
    }

    public void testSuspendFromReady() {
        HashedMap vars = new HashedMap();
        vars.put("users", this.users);
        vars.put("groups", this.groups);
        vars.put("now", new Date());
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)this.eval(new StringReader(str), (Map)vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleTest.assertEquals((Object)Status.Ready, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleTest.assertNull((Object)task1.getTaskData().getActualOwner());
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.suspend(taskId, ((User)this.users.get("darth")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleTest.assertEquals((Object)Status.Suspended, (Object)task2.getTaskData().getStatus());
        TaskServiceLifeCycleTest.assertEquals((Object)Status.Ready, (Object)task2.getTaskData().getPreviousStatus());
        TaskServiceLifeCycleTest.assertNull((Object)task1.getTaskData().getActualOwner());
    }

    public void testSuspendFromReserved() {
        HashedMap vars = new HashedMap();
        vars.put("users", this.users);
        vars.put("groups", this.groups);
        vars.put("now", new Date());
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)this.eval(new StringReader(str), (Map)vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.claim(taskId, ((User)this.users.get("darth")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleTest.assertEquals((Object)Status.Reserved, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleTest.assertEquals(this.users.get("darth"), (Object)task1.getTaskData().getActualOwner());
        responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.suspend(taskId, ((User)this.users.get("darth")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleTest.assertEquals((Object)Status.Reserved, (Object)task2.getTaskData().getPreviousStatus());
        TaskServiceLifeCycleTest.assertEquals((Object)Status.Suspended, (Object)task2.getTaskData().getStatus());
        TaskServiceLifeCycleTest.assertEquals(this.users.get("darth"), (Object)task2.getTaskData().getActualOwner());
    }

    public void testSuspendFromReservedWithIncorrectUser() {
        HashedMap vars = new HashedMap();
        vars.put("users", this.users);
        vars.put("groups", this.groups);
        vars.put("now", new Date());
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)this.eval(new StringReader(str), (Map)vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.claim(taskId, ((User)this.users.get("darth")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleTest.assertEquals((Object)Status.Reserved, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleTest.assertEquals(this.users.get("darth"), (Object)task1.getTaskData().getActualOwner());
        responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.suspend(taskId, ((User)this.users.get("bobba")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        PermissionDeniedException denied = null;
        try {
            responseHandler.waitTillDone(5000L);
        }
        catch (PermissionDeniedException e) {
            denied = e;
        }
        TaskServiceLifeCycleTest.assertNotNull((String)"Should get permissed denied exception", (Object)((Object)denied));
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleTest.assertEquals((Object)Status.Reserved, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleTest.assertEquals(this.users.get("darth"), (Object)task1.getTaskData().getActualOwner());
    }

    public void testResumeFromReady() {
        HashedMap vars = new HashedMap();
        vars.put("users", this.users);
        vars.put("groups", this.groups);
        vars.put("now", new Date());
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)this.eval(new StringReader(str), (Map)vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleTest.assertEquals((Object)Status.Ready, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleTest.assertNull((Object)task1.getTaskData().getActualOwner());
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.suspend(taskId, ((User)this.users.get("darth")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleTest.assertEquals((Object)Status.Suspended, (Object)task2.getTaskData().getStatus());
        TaskServiceLifeCycleTest.assertEquals((Object)Status.Ready, (Object)task2.getTaskData().getPreviousStatus());
        TaskServiceLifeCycleTest.assertNull((Object)task1.getTaskData().getActualOwner());
        responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.resume(taskId, ((User)this.users.get("darth")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task3 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleTest.assertEquals((Object)Status.Ready, (Object)task3.getTaskData().getStatus());
        TaskServiceLifeCycleTest.assertEquals((Object)Status.Suspended, (Object)task3.getTaskData().getPreviousStatus());
        TaskServiceLifeCycleTest.assertNull((Object)task3.getTaskData().getActualOwner());
    }

    public void testResumeFromReserved() {
        HashedMap vars = new HashedMap();
        vars.put("users", this.users);
        vars.put("groups", this.groups);
        vars.put("now", new Date());
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)this.eval(new StringReader(str), (Map)vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.claim(taskId, ((User)this.users.get("darth")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleTest.assertEquals((Object)Status.Reserved, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleTest.assertEquals(this.users.get("darth"), (Object)task1.getTaskData().getActualOwner());
        responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.suspend(taskId, ((User)this.users.get("darth")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleTest.assertEquals((Object)Status.Reserved, (Object)task2.getTaskData().getPreviousStatus());
        TaskServiceLifeCycleTest.assertEquals((Object)Status.Suspended, (Object)task2.getTaskData().getStatus());
        TaskServiceLifeCycleTest.assertEquals(this.users.get("darth"), (Object)task2.getTaskData().getActualOwner());
        responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.resume(taskId, ((User)this.users.get("darth")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task3 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleTest.assertEquals((Object)Status.Reserved, (Object)task3.getTaskData().getStatus());
        TaskServiceLifeCycleTest.assertEquals((Object)Status.Suspended, (Object)task3.getTaskData().getPreviousStatus());
        TaskServiceLifeCycleTest.assertEquals(this.users.get("darth"), (Object)task3.getTaskData().getActualOwner());
    }

    public void testResumeFromReservedWithIncorrectUser() {
        HashedMap vars = new HashedMap();
        vars.put("users", this.users);
        vars.put("groups", this.groups);
        vars.put("now", new Date());
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)this.eval(new StringReader(str), (Map)vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.claim(taskId, ((User)this.users.get("darth")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleTest.assertEquals((Object)Status.Reserved, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleTest.assertEquals(this.users.get("darth"), (Object)task1.getTaskData().getActualOwner());
        responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.suspend(taskId, ((User)this.users.get("bobba")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        PermissionDeniedException denied = null;
        try {
            responseHandler.waitTillDone(5000L);
        }
        catch (PermissionDeniedException e) {
            denied = e;
        }
        TaskServiceLifeCycleTest.assertNotNull((String)"Should get permissed denied exception", (Object)((Object)denied));
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleTest.assertEquals((Object)Status.Reserved, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleTest.assertEquals(this.users.get("darth"), (Object)task1.getTaskData().getActualOwner());
    }

    public void testSkipFromReady() {
        HashedMap vars = new HashedMap();
        vars.put("users", this.users);
        vars.put("groups", this.groups);
        vars.put("now", new Date());
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { skipable = true} ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ] }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)this.eval(new StringReader(str), (Map)vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.skip(taskId, ((User)this.users.get("darth")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleTest.assertEquals((Object)Status.Obsolete, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleTest.assertNull((Object)task1.getTaskData().getActualOwner());
    }

    public void testSkipFromReserved() {
        HashedMap vars = new HashedMap();
        vars.put("users", this.users);
        vars.put("groups", this.groups);
        vars.put("now", new Date());
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { skipable = true} ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ] }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)this.eval(new StringReader(str), (Map)vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.claim(taskId, ((User)this.users.get("darth")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.skip(taskId, ((User)this.users.get("darth")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleTest.assertEquals((Object)Status.Obsolete, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleTest.assertEquals(this.users.get("darth"), (Object)task1.getTaskData().getActualOwner());
    }

    public void testDelegateFromReady() throws Exception {
        HashedMap vars = new HashedMap();
        vars.put("users", this.users);
        vars.put("groups", this.groups);
        vars.put("now", new Date());
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)this.eval(new StringReader(str), (Map)vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.delegate(taskId, ((User)this.users.get("darth")).getId(), ((User)this.users.get("tony")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleTest.assertTrue((boolean)task2.getPeopleAssignments().getPotentialOwners().contains(this.users.get("darth")));
        TaskServiceLifeCycleTest.assertTrue((boolean)task2.getPeopleAssignments().getPotentialOwners().contains(this.users.get("tony")));
        TaskServiceLifeCycleTest.assertEquals(this.users.get("tony"), (Object)task2.getTaskData().getActualOwner());
        TaskServiceLifeCycleTest.assertEquals((Object)Status.Ready, (Object)task2.getTaskData().getStatus());
    }

    public void testDelegateFromReserved() throws Exception {
        HashedMap vars = new HashedMap();
        vars.put("users", this.users);
        vars.put("groups", this.groups);
        vars.put("now", new Date());
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)this.eval(new StringReader(str), (Map)vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.claim(taskId, ((User)this.users.get("darth")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleTest.assertEquals((Object)Status.Reserved, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleTest.assertEquals(this.users.get("darth"), (Object)task1.getTaskData().getActualOwner());
        responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.delegate(taskId, ((User)this.users.get("darth")).getId(), ((User)this.users.get("tony")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleTest.assertTrue((boolean)task2.getPeopleAssignments().getPotentialOwners().contains(this.users.get("darth")));
        TaskServiceLifeCycleTest.assertTrue((boolean)task2.getPeopleAssignments().getPotentialOwners().contains(this.users.get("tony")));
        TaskServiceLifeCycleTest.assertEquals(this.users.get("tony"), (Object)task2.getTaskData().getActualOwner());
        TaskServiceLifeCycleTest.assertEquals((Object)Status.Ready, (Object)task2.getTaskData().getStatus());
    }

    public void testDelegateFromReservedWithIncorrectUser() throws Exception {
        HashedMap vars = new HashedMap();
        vars.put("users", this.users);
        vars.put("groups", this.groups);
        vars.put("now", new Date());
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)this.eval(new StringReader(str), (Map)vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.claim(taskId, ((User)this.users.get("darth")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleTest.assertEquals((Object)Status.Reserved, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleTest.assertEquals(this.users.get("darth"), (Object)task1.getTaskData().getActualOwner());
        responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.delegate(taskId, ((User)this.users.get("bobba")).getId(), ((User)this.users.get("tony")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        PermissionDeniedException denied = null;
        try {
            responseHandler.waitTillDone(5000L);
        }
        catch (PermissionDeniedException e) {
            denied = e;
        }
        TaskServiceLifeCycleTest.assertNotNull((String)"Should get permissed denied exception", (Object)((Object)denied));
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleTest.assertTrue((boolean)task2.getPeopleAssignments().getPotentialOwners().contains(this.users.get("darth")));
        TaskServiceLifeCycleTest.assertFalse((boolean)task2.getPeopleAssignments().getPotentialOwners().contains(this.users.get("tony")));
        TaskServiceLifeCycleTest.assertEquals(this.users.get("darth"), (Object)task2.getTaskData().getActualOwner());
        TaskServiceLifeCycleTest.assertEquals((Object)Status.Reserved, (Object)task2.getTaskData().getStatus());
    }

    public void testForwardFromReady() throws Exception {
        HashedMap vars = new HashedMap();
        vars.put("users", this.users);
        vars.put("groups", this.groups);
        vars.put("now", new Date());
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)this.eval(new StringReader(str), (Map)vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.forward(taskId, ((User)this.users.get("darth")).getId(), ((User)this.users.get("tony")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleTest.assertFalse((boolean)task2.getPeopleAssignments().getPotentialOwners().contains(this.users.get("darth")));
        TaskServiceLifeCycleTest.assertTrue((boolean)task2.getPeopleAssignments().getPotentialOwners().contains(this.users.get("tony")));
        TaskServiceLifeCycleTest.assertNull((Object)task2.getTaskData().getActualOwner());
        TaskServiceLifeCycleTest.assertEquals((Object)Status.Ready, (Object)task2.getTaskData().getStatus());
    }

    public void testForwardFromReserved() throws Exception {
        HashedMap vars = new HashedMap();
        vars.put("users", this.users);
        vars.put("groups", this.groups);
        vars.put("now", new Date());
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)this.eval(new StringReader(str), (Map)vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.claim(taskId, ((User)this.users.get("darth")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleTest.assertEquals((Object)Status.Reserved, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleTest.assertEquals(this.users.get("darth"), (Object)task1.getTaskData().getActualOwner());
        responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.forward(taskId, ((User)this.users.get("darth")).getId(), ((User)this.users.get("tony")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleTest.assertFalse((boolean)task2.getPeopleAssignments().getPotentialOwners().contains(this.users.get("darth")));
        TaskServiceLifeCycleTest.assertTrue((boolean)task2.getPeopleAssignments().getPotentialOwners().contains(this.users.get("tony")));
        TaskServiceLifeCycleTest.assertNull((Object)task2.getTaskData().getActualOwner());
        TaskServiceLifeCycleTest.assertEquals((Object)Status.Ready, (Object)task2.getTaskData().getStatus());
    }

    public void testForwardFromReservedWithIncorrectUser() throws Exception {
        HashedMap vars = new HashedMap();
        vars.put("users", this.users);
        vars.put("groups", this.groups);
        vars.put("now", new Date());
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)this.eval(new StringReader(str), (Map)vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.claim(taskId, ((User)this.users.get("darth")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleTest.assertEquals((Object)Status.Reserved, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleTest.assertEquals(this.users.get("darth"), (Object)task1.getTaskData().getActualOwner());
        responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.forward(taskId, ((User)this.users.get("bobba")).getId(), ((User)this.users.get("tony")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        PermissionDeniedException denied = null;
        try {
            responseHandler.waitTillDone(5000L);
        }
        catch (PermissionDeniedException e) {
            denied = e;
        }
        TaskServiceLifeCycleTest.assertNotNull((String)"Should get permissed denied exception", (Object)((Object)denied));
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleTest.assertTrue((boolean)task2.getPeopleAssignments().getPotentialOwners().contains(this.users.get("darth")));
        TaskServiceLifeCycleTest.assertFalse((boolean)task2.getPeopleAssignments().getPotentialOwners().contains(this.users.get("tony")));
        TaskServiceLifeCycleTest.assertEquals(this.users.get("darth"), (Object)task2.getTaskData().getActualOwner());
        TaskServiceLifeCycleTest.assertEquals((Object)Status.Reserved, (Object)task2.getTaskData().getStatus());
    }

    public void testComplete() {
        HashedMap vars = new HashedMap();
        vars.put("users", this.users);
        vars.put("groups", this.groups);
        vars.put("now", new Date());
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)this.eval(new StringReader(str), (Map)vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.start(taskId, ((User)this.users.get("darth")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleTest.assertEquals((Object)Status.InProgress, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleTest.assertEquals(this.users.get("darth"), (Object)task1.getTaskData().getActualOwner());
        responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.complete(taskId, ((User)this.users.get("darth")).getId(), null, (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleTest.assertEquals((Object)Status.Completed, (Object)task2.getTaskData().getStatus());
        TaskServiceLifeCycleTest.assertEquals(this.users.get("darth"), (Object)task2.getTaskData().getActualOwner());
    }

    public void testCompleteWithIncorrectUser() {
        HashedMap vars = new HashedMap();
        vars.put("users", this.users);
        vars.put("groups", this.groups);
        vars.put("now", new Date());
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)this.eval(new StringReader(str), (Map)vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.start(taskId, ((User)this.users.get("darth")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleTest.assertEquals((Object)Status.InProgress, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleTest.assertEquals(this.users.get("darth"), (Object)task1.getTaskData().getActualOwner());
        responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.complete(taskId, ((User)this.users.get("bobba")).getId(), null, (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        PermissionDeniedException denied = null;
        try {
            responseHandler.waitTillDone(5000L);
        }
        catch (PermissionDeniedException e) {
            denied = e;
        }
        TaskServiceLifeCycleTest.assertNotNull((String)"Should get permissed denied exception", (Object)((Object)denied));
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleTest.assertEquals((Object)Status.InProgress, (Object)task2.getTaskData().getStatus());
        TaskServiceLifeCycleTest.assertEquals(this.users.get("darth"), (Object)task2.getTaskData().getActualOwner());
    }

    public void testCompleteWithContent() {
        HashedMap vars = new HashedMap();
        vars.put("users", this.users);
        vars.put("groups", this.groups);
        vars.put("now", new Date());
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)this.eval(new StringReader(str), (Map)vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.start(taskId, ((User)this.users.get("darth")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleTest.assertEquals((Object)Status.InProgress, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleTest.assertEquals(this.users.get("darth"), (Object)task1.getTaskData().getActualOwner());
        ContentData data = new ContentData();
        data.setAccessType(AccessType.Inline);
        data.setType("type");
        data.setContent("content".getBytes());
        responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.complete(taskId, ((User)this.users.get("darth")).getId(), data, (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleTest.assertEquals((Object)AccessType.Inline, (Object)task2.getTaskData().getOutputAccessType());
        TaskServiceLifeCycleTest.assertEquals((String)"type", (String)task2.getTaskData().getOutputType());
        long contentId = task2.getTaskData().getOutputContentId();
        TaskServiceLifeCycleTest.assertTrue((contentId != -1L ? 1 : 0) != 0);
        BlockingGetContentResponseHandler getContentResponseHandler = new BlockingGetContentResponseHandler();
        this.client.getContent(contentId, (TaskClientHandler.GetContentResponseHandler)getContentResponseHandler);
        Content content = getContentResponseHandler.getContent();
        TaskServiceLifeCycleTest.assertEquals((String)"content", (String)new String(content.getContent()));
    }

    public void testFail() {
        HashedMap vars = new HashedMap();
        vars.put("users", this.users);
        vars.put("groups", this.groups);
        vars.put("now", new Date());
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)this.eval(new StringReader(str), (Map)vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.start(taskId, ((User)this.users.get("darth")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleTest.assertEquals((Object)Status.InProgress, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleTest.assertEquals(this.users.get("darth"), (Object)task1.getTaskData().getActualOwner());
        responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.fail(taskId, ((User)this.users.get("darth")).getId(), null, (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleTest.assertEquals((Object)Status.Failed, (Object)task2.getTaskData().getStatus());
        TaskServiceLifeCycleTest.assertEquals(this.users.get("darth"), (Object)task2.getTaskData().getActualOwner());
    }

    public void testFailWithIncorrectUser() {
        HashedMap vars = new HashedMap();
        vars.put("users", this.users);
        vars.put("groups", this.groups);
        vars.put("now", new Date());
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)this.eval(new StringReader(str), (Map)vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.start(taskId, ((User)this.users.get("darth")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleTest.assertEquals((Object)Status.InProgress, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleTest.assertEquals(this.users.get("darth"), (Object)task1.getTaskData().getActualOwner());
        responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.fail(taskId, ((User)this.users.get("bobba")).getId(), null, (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        PermissionDeniedException denied = null;
        try {
            responseHandler.waitTillDone(5000L);
        }
        catch (PermissionDeniedException e) {
            denied = e;
        }
        TaskServiceLifeCycleTest.assertNotNull((String)"Should get permissed denied exception", (Object)((Object)denied));
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleTest.assertEquals((Object)Status.InProgress, (Object)task2.getTaskData().getStatus());
        TaskServiceLifeCycleTest.assertEquals(this.users.get("darth"), (Object)task2.getTaskData().getActualOwner());
    }

    public void testFailWithContent() {
        HashedMap vars = new HashedMap();
        vars.put("users", this.users);
        vars.put("groups", this.groups);
        vars.put("now", new Date());
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)this.eval(new StringReader(str), (Map)vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.start(taskId, ((User)this.users.get("darth")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleTest.assertEquals((Object)Status.InProgress, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleTest.assertEquals(this.users.get("darth"), (Object)task1.getTaskData().getActualOwner());
        FaultData data = new FaultData();
        data.setAccessType(AccessType.Inline);
        data.setType("type");
        data.setFaultName("faultName");
        data.setContent("content".getBytes());
        responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.fail(taskId, ((User)this.users.get("darth")).getId(), data, (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleTest.assertEquals((Object)Status.Failed, (Object)task2.getTaskData().getStatus());
        TaskServiceLifeCycleTest.assertEquals((Object)AccessType.Inline, (Object)task2.getTaskData().getFaultAccessType());
        TaskServiceLifeCycleTest.assertEquals((String)"type", (String)task2.getTaskData().getFaultType());
        TaskServiceLifeCycleTest.assertEquals((String)"faultName", (String)task2.getTaskData().getFaultName());
        long contentId = task2.getTaskData().getFaultContentId();
        TaskServiceLifeCycleTest.assertTrue((contentId != -1L ? 1 : 0) != 0);
        BlockingGetContentResponseHandler getContentResponseHandler = new BlockingGetContentResponseHandler();
        this.client.getContent(contentId, (TaskClientHandler.GetContentResponseHandler)getContentResponseHandler);
        Content content = getContentResponseHandler.getContent();
        TaskServiceLifeCycleTest.assertEquals((String)"content", (String)new String(content.getContent()));
    }
}

