/*
 * Decompiled with CFR 0.152.
 */
package org.drools.process.workitem.wsht;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.mina.transport.socket.SocketConnector;
import org.apache.mina.transport.socket.nio.NioSocketConnector;
import org.drools.SystemEventListenerFactory;
import org.drools.eventmessaging.EventResponseHandler;
import org.drools.eventmessaging.Payload;
import org.drools.runtime.process.WorkItem;
import org.drools.runtime.process.WorkItemHandler;
import org.drools.runtime.process.WorkItemManager;
import org.drools.task.AccessType;
import org.drools.task.Content;
import org.drools.task.Group;
import org.drools.task.I18NText;
import org.drools.task.OrganizationalEntity;
import org.drools.task.PeopleAssignments;
import org.drools.task.SubTasksStrategy;
import org.drools.task.SubTasksStrategyFactory;
import org.drools.task.Task;
import org.drools.task.TaskData;
import org.drools.task.User;
import org.drools.task.event.TaskCompletedEvent;
import org.drools.task.event.TaskEvent;
import org.drools.task.event.TaskEventKey;
import org.drools.task.event.TaskFailedEvent;
import org.drools.task.event.TaskSkippedEvent;
import org.drools.task.service.ContentData;
import org.drools.task.service.MinaTaskClient;
import org.drools.task.service.TaskClientHandler;
import org.drools.task.service.responsehandlers.AbstractBaseResponseHandler;

public class WSHumanTaskHandler
implements WorkItemHandler {
    private String ipAddress = "127.0.0.1";
    private int port = 9123;
    private MinaTaskClient client;
    private Map<Long, WorkItemManager> managers = new HashMap<Long, WorkItemManager>();
    private Map<Long, Long> idMapping = new HashMap<Long, Long>();

    public void setConnection(String ipAddress, int port) {
        this.ipAddress = ipAddress;
        this.port = port;
    }

    public void connect() {
        if (this.client == null) {
            this.client = new MinaTaskClient("org.drools.process.workitem.wsht.WSHumanTaskHandler", new TaskClientHandler(SystemEventListenerFactory.getSystemEventListener()));
            NioSocketConnector connector = new NioSocketConnector();
            InetSocketAddress address = new InetSocketAddress(this.ipAddress, this.port);
            boolean connected = this.client.connect((SocketConnector)connector, address);
            if (!connected) {
                throw new IllegalArgumentException("Could not connect task client");
            }
        }
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
        String groupId;
        String subTaskStrategiesCommaSeparated;
        String comment;
        this.connect();
        Task task = new Task();
        String taskName = (String)workItem.getParameter("TaskName");
        if (taskName != null) {
            ArrayList<I18NText> names = new ArrayList<I18NText>();
            names.add(new I18NText("en-UK", taskName));
            task.setNames(names);
        }
        if ((comment = (String)workItem.getParameter("Comment")) != null) {
            ArrayList<I18NText> descriptions = new ArrayList<I18NText>();
            descriptions.add(new I18NText("en-UK", comment));
            task.setDescriptions(descriptions);
            ArrayList<I18NText> subjects = new ArrayList<I18NText>();
            subjects.add(new I18NText("en-UK", comment));
            task.setSubjects(subjects);
        }
        String priorityString = (String)workItem.getParameter("Priority");
        int priority = 0;
        if (priorityString != null) {
            try {
                priority = new Integer(priorityString);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        task.setPriority(priority);
        TaskData taskData = new TaskData();
        taskData.setWorkItemId(workItem.getId());
        taskData.setSkipable(!"false".equals(workItem.getParameter("Skippable")));
        Long parentId = (Long)workItem.getParameter("ParentId");
        if (parentId != null) {
            taskData.setParentId(parentId);
        }
        if ((subTaskStrategiesCommaSeparated = (String)workItem.getParameter("SubTaskStrategies")) != null && !subTaskStrategiesCommaSeparated.equals("")) {
            String[] subTaskStrategies = subTaskStrategiesCommaSeparated.split(",");
            ArrayList<SubTasksStrategy> strategies = new ArrayList<SubTasksStrategy>();
            for (String subTaskStrategyString : subTaskStrategies) {
                SubTasksStrategy subTaskStrategy = SubTasksStrategyFactory.newStrategy(subTaskStrategyString);
                strategies.add(subTaskStrategy);
            }
            task.setSubTaskStrategies(strategies);
        }
        PeopleAssignments assignments = new PeopleAssignments();
        ArrayList<OrganizationalEntity> potentialOwners = new ArrayList<OrganizationalEntity>();
        String actorId = (String)workItem.getParameter("ActorId");
        if (actorId != null) {
            String[] actorIds;
            for (String id : actorIds = actorId.split(",")) {
                User user = new User();
                user.setId(id.trim());
                potentialOwners.add(user);
            }
            if (potentialOwners.size() > 0) {
                taskData.setCreatedBy((User)potentialOwners.get(0));
            }
        }
        if ((groupId = (String)workItem.getParameter("GroupId")) != null) {
            String[] groupIds;
            for (String id : groupIds = groupId.split(",")) {
                potentialOwners.add(new Group(id));
            }
        }
        assignments.setPotentialOwners(potentialOwners);
        ArrayList<OrganizationalEntity> businessAdministrators = new ArrayList<OrganizationalEntity>();
        businessAdministrators.add(new User("Administrator"));
        assignments.setBusinessAdministrators(businessAdministrators);
        task.setPeopleAssignments(assignments);
        task.setTaskData(taskData);
        ContentData content = null;
        Object contentObject = workItem.getParameter("Content");
        if (contentObject != null) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                ObjectOutputStream out = new ObjectOutputStream(bos);
                out.writeObject(contentObject);
                out.close();
                content = new ContentData();
                content.setContent(bos.toByteArray());
                content.setAccessType(AccessType.Inline);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        TaskWorkItemAddTaskResponseHandler taskResponseHandler = new TaskWorkItemAddTaskResponseHandler(this.client, this.managers, this.idMapping, manager, workItem.getId());
        this.client.addTask(task, content, taskResponseHandler);
    }

    public void dispose() {
        if (this.client != null) {
            this.client.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
        Long taskId = this.idMapping.get(workItem.getId());
        if (taskId != null) {
            Map<Long, Long> map = this.idMapping;
            synchronized (map) {
                this.idMapping.remove(taskId);
            }
            map = this.managers;
            synchronized (map) {
                this.managers.remove(taskId);
            }
            this.client.skip(taskId, "Administrator", null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GetResultContentResponseHandler
    extends AbstractBaseResponseHandler
    implements TaskClientHandler.GetContentResponseHandler {
        private WorkItemManager manager;
        private Task task;
        private Map<String, Object> results;

        public GetResultContentResponseHandler(WorkItemManager manager, Task task, Map<String, Object> results) {
            this.manager = manager;
            this.task = task;
            this.results = results;
        }

        @Override
        public void execute(Content content) {
            ByteArrayInputStream bis = new ByteArrayInputStream(content.getContent());
            try {
                ObjectInputStream in = new ObjectInputStream(bis);
                Object result = in.readObject();
                in.close();
                this.results.put("Result", result);
                this.manager.completeWorkItem(this.task.getTaskData().getWorkItemId(), this.results);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    private static class GetCompletedTaskResponseHandler
    extends AbstractBaseResponseHandler
    implements TaskClientHandler.GetTaskResponseHandler {
        private WorkItemManager manager;
        private MinaTaskClient client;

        public GetCompletedTaskResponseHandler(WorkItemManager manager, MinaTaskClient client) {
            this.manager = manager;
            this.client = client;
        }

        public void execute(Task task) {
            long workItemId = task.getTaskData().getWorkItemId();
            String userId = task.getTaskData().getActualOwner().getId();
            HashMap<String, Object> results = new HashMap<String, Object>();
            results.put("ActorId", userId);
            long contentId = task.getTaskData().getOutputContentId();
            if (contentId != -1L) {
                GetResultContentResponseHandler getContentResponseHandler = new GetResultContentResponseHandler(this.manager, task, results);
                this.client.getContent(contentId, getContentResponseHandler);
            } else {
                this.manager.completeWorkItem(workItemId, results);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TaskCompletedHandler
    extends AbstractBaseResponseHandler
    implements EventResponseHandler {
        private long workItemId;
        private long taskId;
        private Map<Long, WorkItemManager> managers;
        private MinaTaskClient client;

        public TaskCompletedHandler(long workItemId, long taskId, Map<Long, WorkItemManager> managers, MinaTaskClient client) {
            this.workItemId = workItemId;
            this.taskId = taskId;
            this.managers = managers;
            this.client = client;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(Payload payload) {
            TaskEvent event = (TaskEvent)payload.get();
            if (event.getTaskId() != this.taskId) {
                this.setError(new IllegalStateException("Expected task id and arrived task id do not march"));
                return;
            }
            if (event instanceof TaskCompletedEvent) {
                Map<Long, WorkItemManager> map = this.managers;
                synchronized (map) {
                    WorkItemManager manager = this.managers.get(this.taskId);
                    if (manager != null) {
                        GetCompletedTaskResponseHandler getTaskResponseHandler = new GetCompletedTaskResponseHandler(manager, this.client);
                        this.client.getTask(this.taskId, getTaskResponseHandler);
                    }
                }
            }
            Map<Long, WorkItemManager> map = this.managers;
            synchronized (map) {
                WorkItemManager manager = this.managers.get(this.taskId);
                if (manager != null) {
                    manager.abortWorkItem(this.workItemId);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TaskWorkItemAddTaskResponseHandler
    extends AbstractBaseResponseHandler
    implements TaskClientHandler.AddTaskResponseHandler {
        private Map<Long, WorkItemManager> managers;
        private Map<Long, Long> idMapping;
        private WorkItemManager manager;
        private long workItemId;
        private MinaTaskClient client;

        public TaskWorkItemAddTaskResponseHandler(MinaTaskClient client, Map<Long, WorkItemManager> managers, Map<Long, Long> idMapping, WorkItemManager manager, long workItemId) {
            this.client = client;
            this.managers = managers;
            this.idMapping = idMapping;
            this.manager = manager;
            this.workItemId = workItemId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(long taskId) {
            Map<Long, Object> map = this.managers;
            synchronized (map) {
                this.managers.put(taskId, this.manager);
            }
            map = this.idMapping;
            synchronized (map) {
                this.idMapping.put(this.workItemId, taskId);
            }
            TaskEventKey key = new TaskEventKey(TaskCompletedEvent.class, taskId);
            TaskCompletedHandler eventResponseHandler = new TaskCompletedHandler(this.workItemId, taskId, this.managers, this.client);
            this.client.registerForEvent(key, true, eventResponseHandler);
            key = new TaskEventKey(TaskFailedEvent.class, taskId);
            this.client.registerForEvent(key, true, eventResponseHandler);
            key = new TaskEventKey(TaskSkippedEvent.class, taskId);
            this.client.registerForEvent(key, true, eventResponseHandler);
        }
    }
}

