/*
 * Decompiled with CFR 0.152.
 */
package org.drools.task.service;

import java.util.Arrays;
import java.util.List;
import org.apache.mina.core.session.IoSession;
import org.drools.SystemEventListener;
import org.drools.eventmessaging.EventResponseHandler;
import org.drools.eventmessaging.Payload;
import org.drools.task.Content;
import org.drools.task.Task;
import org.drools.task.query.TaskSummary;
import org.drools.task.service.BaseMinaHandler;
import org.drools.task.service.Command;
import org.drools.task.service.MinaTaskClient;

public class TaskClientHandler
extends BaseMinaHandler {
    private MinaTaskClient client;
    private SystemEventListener systemEventListener;

    public TaskClientHandler(SystemEventListener systemEventListener) {
        this.systemEventListener = systemEventListener;
    }

    public MinaTaskClient getClient() {
        return this.client;
    }

    public void setClient(MinaTaskClient client) {
        this.client = client;
    }

    public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
        this.systemEventListener.exception("Uncaught exception on client", cause);
    }

    public void messageReceived(IoSession session, Object message) throws Exception {
        Command cmd = (Command)message;
        this.systemEventListener.debug("Message receieved on client : " + (Object)((Object)cmd.getName()));
        this.systemEventListener.debug("Arguments : " + Arrays.toString(cmd.getArguments().toArray()));
        switch (cmd.getName()) {
            case OperationResponse: {
                TaskOperationResponseHandler responseHandler = (TaskOperationResponseHandler)this.responseHandlers.remove(cmd.getId());
                if (responseHandler == null) break;
                if (!cmd.getArguments().isEmpty() && cmd.getArguments().get(0) instanceof RuntimeException) {
                    responseHandler.setError((RuntimeException)cmd.getArguments().get(0));
                    break;
                }
                responseHandler.setIsDone(true);
                break;
            }
            case GetTaskResponse: {
                Task task = (Task)cmd.getArguments().get(0);
                GetTaskResponseHandler responseHandler = (GetTaskResponseHandler)this.responseHandlers.remove(cmd.getId());
                if (responseHandler == null) break;
                if (!cmd.getArguments().isEmpty() && cmd.getArguments().get(0) instanceof RuntimeException) {
                    responseHandler.setError((RuntimeException)cmd.getArguments().get(0));
                    break;
                }
                responseHandler.execute(task);
                break;
            }
            case AddTaskResponse: {
                long taskId = (Long)cmd.getArguments().get(0);
                AddTaskResponseHandler responseHandler = (AddTaskResponseHandler)this.responseHandlers.remove(cmd.getId());
                if (responseHandler == null) break;
                if (!cmd.getArguments().isEmpty() && cmd.getArguments().get(0) instanceof RuntimeException) {
                    responseHandler.setError((RuntimeException)cmd.getArguments().get(0));
                    break;
                }
                responseHandler.execute(taskId);
                break;
            }
            case AddCommentResponse: {
                long commentId = (Long)cmd.getArguments().get(0);
                AddCommentResponseHandler responseHandler = (AddCommentResponseHandler)this.responseHandlers.remove(cmd.getId());
                if (responseHandler == null) break;
                if (!cmd.getArguments().isEmpty() && cmd.getArguments().get(0) instanceof RuntimeException) {
                    responseHandler.setError((RuntimeException)cmd.getArguments().get(0));
                    break;
                }
                responseHandler.execute(commentId);
                break;
            }
            case DeleteCommentResponse: {
                DeleteCommentResponseHandler responseHandler = (DeleteCommentResponseHandler)this.responseHandlers.remove(cmd.getId());
                if (responseHandler == null) break;
                if (!cmd.getArguments().isEmpty() && cmd.getArguments().get(0) instanceof RuntimeException) {
                    responseHandler.setError((RuntimeException)cmd.getArguments().get(0));
                    break;
                }
                responseHandler.setIsDone(true);
                break;
            }
            case AddAttachmentResponse: {
                long attachmentId = (Long)cmd.getArguments().get(0);
                long contentId = (Long)cmd.getArguments().get(1);
                AddAttachmentResponseHandler responseHandler = (AddAttachmentResponseHandler)this.responseHandlers.remove(cmd.getId());
                if (responseHandler == null) break;
                if (!cmd.getArguments().isEmpty() && cmd.getArguments().get(0) instanceof RuntimeException) {
                    responseHandler.setError((RuntimeException)cmd.getArguments().get(0));
                    break;
                }
                responseHandler.execute(attachmentId, contentId);
                break;
            }
            case DeleteAttachmentResponse: {
                DeleteAttachmentResponseHandler responseHandler = (DeleteAttachmentResponseHandler)this.responseHandlers.remove(cmd.getId());
                if (responseHandler == null) break;
                if (!cmd.getArguments().isEmpty() && cmd.getArguments().get(0) instanceof RuntimeException) {
                    responseHandler.setError((RuntimeException)cmd.getArguments().get(0));
                    break;
                }
                responseHandler.setIsDone(true);
                break;
            }
            case GetContentResponse: {
                Content content = (Content)cmd.getArguments().get(0);
                GetContentResponseHandler responseHandler = (GetContentResponseHandler)this.responseHandlers.remove(cmd.getId());
                if (responseHandler == null) break;
                if (!cmd.getArguments().isEmpty() && cmd.getArguments().get(0) instanceof RuntimeException) {
                    responseHandler.setError((RuntimeException)cmd.getArguments().get(0));
                    break;
                }
                responseHandler.execute(content);
                break;
            }
            case SetDocumentContentResponse: {
                long contentId = (Long)cmd.getArguments().get(0);
                SetDocumentResponseHandler responseHandler = (SetDocumentResponseHandler)this.responseHandlers.remove(cmd.getId());
                if (responseHandler == null) break;
                if (!cmd.getArguments().isEmpty() && cmd.getArguments().get(0) instanceof RuntimeException) {
                    responseHandler.setError((RuntimeException)cmd.getArguments().get(0));
                    break;
                }
                responseHandler.execute(contentId);
                break;
            }
            case QueryTaskSummaryResponse: {
                List results = (List)cmd.getArguments().get(0);
                TaskSummaryResponseHandler responseHandler = (TaskSummaryResponseHandler)this.responseHandlers.remove(cmd.getId());
                if (responseHandler == null) break;
                if (!cmd.getArguments().isEmpty() && cmd.getArguments().get(0) instanceof RuntimeException) {
                    responseHandler.setError((RuntimeException)cmd.getArguments().get(0));
                    break;
                }
                responseHandler.execute(results);
                break;
            }
            case EventTriggerResponse: {
                Payload payload = (Payload)cmd.getArguments().get(0);
                EventResponseHandler responseHandler = (EventResponseHandler)this.responseHandlers.remove(cmd.getId());
                if (responseHandler == null) break;
                if (!cmd.getArguments().isEmpty() && cmd.getArguments().get(0) instanceof RuntimeException) {
                    responseHandler.setError((RuntimeException)cmd.getArguments().get(0));
                    break;
                }
                responseHandler.execute(payload);
                break;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface TaskSummaryResponseHandler
    extends BaseMinaHandler.ResponseHandler {
        public void execute(List<TaskSummary> var1);
    }

    public static interface GetContentResponseHandler
    extends BaseMinaHandler.ResponseHandler {
        public void execute(Content var1);
    }

    public static interface SetDocumentResponseHandler
    extends BaseMinaHandler.ResponseHandler {
        public void execute(long var1);
    }

    public static interface DeleteAttachmentResponseHandler
    extends BaseMinaHandler.ResponseHandler {
        public void setIsDone(boolean var1);
    }

    public static interface AddAttachmentResponseHandler
    extends BaseMinaHandler.ResponseHandler {
        public void execute(long var1, long var3);
    }

    public static interface DeleteCommentResponseHandler
    extends BaseMinaHandler.ResponseHandler {
        public void setIsDone(boolean var1);
    }

    public static interface AddCommentResponseHandler
    extends BaseMinaHandler.ResponseHandler {
        public void execute(long var1);
    }

    public static interface TaskOperationResponseHandler
    extends BaseMinaHandler.ResponseHandler {
        public void setIsDone(boolean var1);
    }

    public static interface AddTaskResponseHandler
    extends BaseMinaHandler.ResponseHandler {
        public void execute(long var1);
    }

    public static interface GetTaskResponseHandler
    extends BaseMinaHandler.ResponseHandler {
        public void execute(Task var1);
    }
}

