/*
 * Decompiled with CFR 0.152.
 */
package org.drools.task.service;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityNotFoundException;
import javax.persistence.EntityTransaction;
import javax.persistence.Query;
import org.drools.RuleBase;
import org.drools.StatefulSession;
import org.drools.eventmessaging.EventKeys;
import org.drools.task.Attachment;
import org.drools.task.Comment;
import org.drools.task.Content;
import org.drools.task.Deadline;
import org.drools.task.Group;
import org.drools.task.OrganizationalEntity;
import org.drools.task.PeopleAssignments;
import org.drools.task.Status;
import org.drools.task.SubTasksStrategy;
import org.drools.task.Task;
import org.drools.task.TaskData;
import org.drools.task.User;
import org.drools.task.query.DeadlineSummary;
import org.drools.task.query.TaskSummary;
import org.drools.task.service.Allowed;
import org.drools.task.service.CannotAddTaskException;
import org.drools.task.service.ContentData;
import org.drools.task.service.FaultData;
import org.drools.task.service.Operation;
import org.drools.task.service.OperationCommand;
import org.drools.task.service.PermissionDeniedException;
import org.drools.task.service.SendIcal;
import org.drools.task.service.TaskException;
import org.drools.task.service.TaskService;
import org.drools.task.service.TaskServiceRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskServiceSession {
    private final TaskService service;
    private final EntityManager em;
    private Map<String, RuleBase> ruleBases;
    private Map<String, Map<String, Object>> globals;
    private EventKeys eventKeys;

    public TaskServiceSession(TaskService service, EntityManager em) {
        this.service = service;
        this.em = em;
    }

    public void dispose() {
        this.em.close();
    }

    public EntityManager getEntityManager() {
        return this.em;
    }

    public void setRuleBase(String type, RuleBase ruleBase) {
        if (this.ruleBases == null) {
            this.ruleBases = new HashMap<String, RuleBase>();
        }
        this.ruleBases.put(type, ruleBase);
    }

    public void setGlobals(String type, Map<String, Object> globals) {
        if (this.globals == null) {
            this.globals = new HashMap<String, Map<String, Object>>();
        }
        this.globals.put(type, globals);
    }

    public void addUser(User user) {
        this.persistInTransaction(user);
    }

    public void addGroup(Group group) {
        this.persistInTransaction(group);
    }

    private void executeTaskAddRules(Task task, ContentData contentData) throws CannotAddTaskException {
        RuleBase ruleBase = this.ruleBases.get("addTask");
        if (ruleBase != null) {
            StatefulSession session = ruleBase.newStatefulSession();
            Map<String, Object> globals = this.globals.get("addTask");
            if (globals != null) {
                for (Map.Entry<String, Object> entry : globals.entrySet()) {
                    session.setGlobal(entry.getKey(), entry.getValue());
                }
            }
            TaskServiceRequest request = new TaskServiceRequest("addTask", null, null);
            session.setGlobal("request", (Object)request);
            session.insert((Object)task);
            session.insert((Object)contentData);
            session.fireAllRules();
            if (!request.isAllowed()) {
                StringBuilder error = new StringBuilder("Cannot add Task:\n");
                if (request.getReasons() != null) {
                    for (String reason : request.getReasons()) {
                        error.append(reason).append('\n');
                    }
                }
                throw new CannotAddTaskException(error.toString());
            }
        }
    }

    public void addTask(final Task task, final ContentData contentData) throws CannotAddTaskException {
        PeopleAssignments assignments;
        final TaskData taskData = task.getTaskData();
        Status currentStatus = taskData.initialize();
        if (this.ruleBases != null) {
            this.executeTaskAddRules(task, contentData);
        }
        if ((assignments = task.getPeopleAssignments()) != null) {
            List<OrganizationalEntity> potentialOwners = assignments.getPotentialOwners();
            currentStatus = taskData.assignOwnerAndStatus(potentialOwners);
        }
        this.doOperationInTransaction(new TransactedOperation(){

            public void doOperation() {
                TaskServiceSession.this.em.persist((Object)task);
                if (contentData != null) {
                    Content content = new Content(contentData.getContent());
                    TaskServiceSession.this.em.persist((Object)content);
                    taskData.setDocument(content.getId(), contentData);
                }
            }
        });
        if (task.getDeadlines() != null) {
            this.scheduleTask(task);
        }
        if (currentStatus == Status.Reserved) {
            SendIcal.getInstance().sendIcalForTask(task, this.service.getUserinfo());
            this.service.getEventSupport().fireTaskClaimed(task.getId(), task.getTaskData().getActualOwner().getId());
        }
    }

    private void scheduleTask(Task task) {
        List<Deadline> endDeadlines;
        long now = System.currentTimeMillis();
        List<Deadline> startDeadlines = task.getDeadlines().getStartDeadlines();
        if (startDeadlines != null) {
            this.scheduleDeadlines(startDeadlines, now, task.getId());
        }
        if ((endDeadlines = task.getDeadlines().getEndDeadlines()) != null) {
            this.scheduleDeadlines(endDeadlines, now, task.getId());
        }
    }

    private void scheduleDeadlines(List<Deadline> deadlines, long now, long taskId) {
        for (Deadline deadline : deadlines) {
            if (deadline.isEscalated()) continue;
            Date date = deadline.getDate();
            this.service.schedule(new TaskService.ScheduledTaskDeadline(taskId, deadline.getId(), this.service), date.getTime() - now);
        }
    }

    void evalCommand(Operation operation, List<OperationCommand> commands, Task task, User user, OrganizationalEntity targetEntity) throws PermissionDeniedException {
        TaskData taskData = task.getTaskData();
        boolean statusMatched = false;
        for (OperationCommand command : commands) {
            if (command.getStatus() != null) {
                for (Status status : command.getStatus()) {
                    if (taskData.getStatus() != status) continue;
                    statusMatched = true;
                    if (!TaskServiceSession.isAllowed(command, task, user)) {
                        String errorMessage = "User '" + user + "' does not have permissions to execution operation '" + (Object)((Object)operation) + "' on task id " + task.getId();
                        throw new PermissionDeniedException(errorMessage);
                    }
                    this.commands(command, task, user, targetEntity);
                }
            }
            if (command.getPreviousStatus() == null) continue;
            for (Status status : command.getPreviousStatus()) {
                if (taskData.getPreviousStatus() != status) continue;
                statusMatched = true;
                if (!TaskServiceSession.isAllowed(command, task, user)) {
                    String errorMessage = "User '" + user + "' does not have permissions to execution operation '" + (Object)((Object)operation) + "' on task id " + task.getId();
                    throw new PermissionDeniedException(errorMessage);
                }
                this.commands(command, task, user, targetEntity);
            }
        }
        if (!statusMatched) {
            String errorMessage = "User '" + user + "' was unable to execution operation '" + (Object)((Object)operation) + "' on task id " + task.getId() + " due to no 'current status' matchines";
            throw new PermissionDeniedException(errorMessage);
        }
    }

    private static boolean isAllowed(OperationCommand command, Task task, User user) {
        PeopleAssignments people = task.getPeopleAssignments();
        TaskData taskData = task.getTaskData();
        boolean operationAllowed = false;
        for (Allowed allowed : command.getAllowed()) {
            if (operationAllowed) break;
            switch (allowed) {
                case Owner: {
                    operationAllowed = taskData.getActualOwner() != null && taskData.getActualOwner().equals(user);
                    break;
                }
                case Initiator: {
                    operationAllowed = taskData.getCreatedBy() != null && taskData.getCreatedBy().equals(user);
                    break;
                }
                case PotentialOwner: {
                    operationAllowed = TaskServiceSession.isAllowed(user, people.getPotentialOwners());
                    break;
                }
                case BusinessAdministrator: {
                    operationAllowed = TaskServiceSession.isAllowed(user, people.getBusinessAdministrators());
                }
            }
        }
        if (operationAllowed && command.isUserIsExplicitPotentialOwner()) {
            operationAllowed = people.getPotentialOwners().contains(user);
        }
        if (operationAllowed && command.isSkippable()) {
            operationAllowed = taskData.isSkipable();
        }
        return operationAllowed;
    }

    private void commands(OperationCommand command, Task task, User user, OrganizationalEntity targetEntity) {
        PeopleAssignments people = task.getPeopleAssignments();
        TaskData taskData = task.getTaskData();
        if (command.getNewStatus() != null) {
            taskData.setStatus(command.getNewStatus());
        } else if (command.isSetToPreviousStatus()) {
            taskData.setStatus(taskData.getPreviousStatus());
        }
        if (command.isAddTargetEntityToPotentialOwners() && !people.getPotentialOwners().contains(targetEntity)) {
            people.getPotentialOwners().add(targetEntity);
        }
        if (command.isRemoveUserFromPotentialOwners()) {
            people.getPotentialOwners().remove(user);
        }
        if (command.isSetNewOwnerToUser()) {
            taskData.setActualOwner(user);
        }
        if (command.isSetNewOwnerToNull()) {
            taskData.setActualOwner(null);
        }
        if (command.getExec() != null) {
            switch (command.getExec()) {
                case Claim: {
                    taskData.setActualOwner((User)targetEntity);
                    SendIcal.getInstance().sendIcalForTask(task, this.service.getUserinfo());
                    this.service.getEventSupport().fireTaskClaimed(task.getId(), task.getTaskData().getActualOwner().getId());
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void taskOperation(Operation operation, long taskId, String userId, String targetEntityId, ContentData data) throws TaskException {
        OrganizationalEntity targetEntity = null;
        if (targetEntityId != null) {
            targetEntity = this.getEntity(OrganizationalEntity.class, targetEntityId);
        }
        final Task task = this.getTask(taskId);
        User user = this.getEntity(User.class, userId);
        try {
            List<OperationCommand> commands = this.service.getCommandsForOperation(operation);
            this.beginOrUseExistingTransaction();
            this.evalCommand(operation, commands, task, user, targetEntity);
            switch (operation) {
                case Claim: {
                    this.taskClaimOperation(task);
                    return;
                }
                case Complete: {
                    this.taskCompleteOperation(task, data);
                    return;
                }
                case Fail: {
                    this.taskFailOperation(task, data);
                    return;
                }
                case Skip: {
                    this.taskSkipOperation(task, userId);
                    return;
                }
            }
            return;
        }
        catch (RuntimeException e) {
            this.em.getTransaction().rollback();
            this.doOperationInTransaction(new TransactedOperation(){

                public void doOperation() {
                    task.getTaskData().setStatus(Status.Error);
                }
            });
            throw e;
        }
        finally {
            if (this.em.getTransaction().isActive()) {
                this.em.getTransaction().commit();
            }
        }
    }

    private void taskClaimOperation(Task task) {
        SendIcal.getInstance().sendIcalForTask(task, this.service.getUserinfo());
        this.service.getEventSupport().fireTaskClaimed(task.getId(), task.getTaskData().getActualOwner().getId());
    }

    private void taskCompleteOperation(final Task task, final ContentData data) {
        if (data != null) {
            this.doOperationInTransaction(new TransactedOperation(){

                public void doOperation() {
                    Content content = new Content();
                    content.setContent(data.getContent());
                    TaskServiceSession.this.em.persist((Object)content);
                    TaskData taskData = task.getTaskData();
                    taskData.setOutput(content.getId(), data);
                }
            });
        }
        this.service.getEventSupport().fireTaskCompleted(task.getId(), task.getTaskData().getActualOwner().getId());
        this.checkSubTaskStrategy(task);
    }

    private void taskFailOperation(final Task task, final ContentData data) {
        if (data != null) {
            this.doOperationInTransaction(new TransactedOperation(){

                public void doOperation() {
                    Content content = new Content(data.getContent());
                    TaskServiceSession.this.em.persist((Object)content);
                    TaskData taskData = task.getTaskData();
                    taskData.setFault(content.getId(), (FaultData)data);
                }
            });
        }
        this.service.getEventSupport().fireTaskFailed(task.getId(), task.getTaskData().getActualOwner().getId());
    }

    private void taskSkipOperation(Task task, String userId) {
        this.service.getEventSupport().fireTaskSkipped(task.getId(), userId);
        this.checkSubTaskStrategy(task);
    }

    public Task getTask(long taskId) {
        return this.getEntity(Task.class, taskId);
    }

    public void addComment(long taskId, final Comment comment) {
        final Task task = this.getTask(taskId);
        this.doOperationInTransaction(new TransactedOperation(){

            public void doOperation() {
                task.getTaskData().addComment(comment);
            }
        });
    }

    public void addAttachment(long taskId, final Attachment attachment, final Content content) {
        final Task task = this.getTask(taskId);
        this.doOperationInTransaction(new TransactedOperation(){

            public void doOperation() {
                TaskServiceSession.this.em.persist((Object)content);
                attachment.setContent(content);
                task.getTaskData().addAttachment(attachment);
            }
        });
    }

    public void setDocumentContent(long taskId, final Content content) {
        final Task task = this.getTask(taskId);
        this.doOperationInTransaction(new TransactedOperation(){

            public void doOperation() {
                TaskServiceSession.this.em.persist((Object)content);
                task.getTaskData().setDocumentContentId(content.getId());
            }
        });
    }

    public Content getContent(long contentId) {
        return this.getEntity(Content.class, contentId);
    }

    public void deleteAttachment(long taskId, final long attachmentId, final long contentId) {
        final Task task = this.getTask(taskId);
        this.doOperationInTransaction(new TransactedOperation(){

            public void doOperation() {
                Attachment removedAttachment = task.getTaskData().removeAttachment(attachmentId);
                if (removedAttachment != null) {
                    TaskServiceSession.this.em.remove((Object)removedAttachment);
                }
                String deleteContent = "delete from Content c where c.id = :id";
                TaskServiceSession.this.em.createQuery("delete from Content c where c.id = :id").setParameter("id", (Object)contentId).executeUpdate();
            }
        });
    }

    public void deleteComment(long taskId, final long commentId) {
        final Task task = this.getTask(taskId);
        this.doOperationInTransaction(new TransactedOperation(){

            public void doOperation() {
                Comment removedComment = task.getTaskData().removeComment(commentId);
                if (removedComment != null) {
                    TaskServiceSession.this.em.remove((Object)removedComment);
                }
            }
        });
    }

    public List<DeadlineSummary> getUnescalatedDeadlines() {
        return this.em.createNamedQuery("UnescalatedDeadlines").getResultList();
    }

    public List<TaskSummary> getTasksOwned(String userId, String language) {
        Query tasksOwned = this.em.createNamedQuery("TasksOwned");
        tasksOwned.setParameter("userId", (Object)userId);
        tasksOwned.setParameter("language", (Object)language);
        return tasksOwned.getResultList();
    }

    public List<TaskSummary> getTasksAssignedAsBusinessAdministrator(String userId, String language) {
        Query tasksAssignedAsBusinessAdministrator = this.em.createNamedQuery("TasksAssignedAsBusinessAdministrator");
        tasksAssignedAsBusinessAdministrator.setParameter("userId", (Object)userId);
        tasksAssignedAsBusinessAdministrator.setParameter("language", (Object)language);
        return tasksAssignedAsBusinessAdministrator.getResultList();
    }

    public List<TaskSummary> getTasksAssignedAsExcludedOwner(String userId, String language) {
        Query tasksAssignedAsExcludedOwner = this.em.createNamedQuery("TasksAssignedAsExcludedOwner");
        tasksAssignedAsExcludedOwner.setParameter("userId", (Object)userId);
        tasksAssignedAsExcludedOwner.setParameter("language", (Object)language);
        return tasksAssignedAsExcludedOwner.getResultList();
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwner(String userId, String language) {
        Query tasksAssignedAsPotentialOwner = this.em.createNamedQuery("TasksAssignedAsPotentialOwner");
        tasksAssignedAsPotentialOwner.setParameter("userId", (Object)userId);
        tasksAssignedAsPotentialOwner.setParameter("language", (Object)language);
        return tasksAssignedAsPotentialOwner.getResultList();
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwner(String userId, String groupId, String language) {
        Query tasksAssignedAsPotentialOwner = this.em.createNamedQuery("TasksAssignedAsPotentialOwnerWithGroup");
        tasksAssignedAsPotentialOwner.setParameter("userId", (Object)userId);
        tasksAssignedAsPotentialOwner.setParameter("groupId", (Object)groupId);
        tasksAssignedAsPotentialOwner.setParameter("language", (Object)language);
        return tasksAssignedAsPotentialOwner.getResultList();
    }

    public List<TaskSummary> getSubTasksAssignedAsPotentialOwner(long parentId, String userId, String language) {
        Query tasksAssignedAsPotentialOwner = this.em.createNamedQuery("SubTasksAssignedAsPotentialOwner");
        tasksAssignedAsPotentialOwner.setParameter("parentId", (Object)parentId);
        tasksAssignedAsPotentialOwner.setParameter("userId", (Object)userId);
        tasksAssignedAsPotentialOwner.setParameter("language", (Object)language);
        return tasksAssignedAsPotentialOwner.getResultList();
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwnerByGroup(String groupId, String language) {
        Query tasksAssignedAsPotentialOwnerByGroup = this.em.createNamedQuery("TasksAssignedAsPotentialOwnerByGroup");
        tasksAssignedAsPotentialOwnerByGroup.setParameter("groupId", (Object)groupId);
        tasksAssignedAsPotentialOwnerByGroup.setParameter("language", (Object)language);
        return tasksAssignedAsPotentialOwnerByGroup.getResultList();
    }

    public List<TaskSummary> getSubTasksByParent(long parentId, String language) {
        Query subTaskByParent = this.em.createNamedQuery("GetSubTasksByParentTaskId");
        subTaskByParent.setParameter("parentId", (Object)parentId);
        subTaskByParent.setParameter("language", (Object)language);
        return subTaskByParent.getResultList();
    }

    public List<TaskSummary> getTasksAssignedAsRecipient(String userId, String language) {
        Query tasksAssignedAsRecipient = this.em.createNamedQuery("TasksAssignedAsRecipient");
        tasksAssignedAsRecipient.setParameter("userId", (Object)userId);
        tasksAssignedAsRecipient.setParameter("language", (Object)language);
        return tasksAssignedAsRecipient.getResultList();
    }

    public List<TaskSummary> getTasksAssignedAsTaskInitiator(String userId, String language) {
        Query tasksAssignedAsTaskInitiator = this.em.createNamedQuery("TasksAssignedAsTaskInitiator");
        tasksAssignedAsTaskInitiator.setParameter("userId", (Object)userId);
        tasksAssignedAsTaskInitiator.setParameter("language", (Object)language);
        return tasksAssignedAsTaskInitiator.getResultList();
    }

    public List<TaskSummary> getTasksAssignedAsTaskStakeholder(String userId, String language) {
        Query tasksAssignedAsTaskStakeholder = this.em.createNamedQuery("TasksAssignedAsTaskStakeholder");
        tasksAssignedAsTaskStakeholder.setParameter("userId", (Object)userId);
        tasksAssignedAsTaskStakeholder.setParameter("language", (Object)language);
        return tasksAssignedAsTaskStakeholder.getResultList();
    }

    public static boolean isAllowed(User user, List<OrganizationalEntity>[] people) {
        for (List<OrganizationalEntity> list : people) {
            if (!TaskServiceSession.isAllowed(user, list)) continue;
            return true;
        }
        return false;
    }

    static boolean isAllowed(User user, List<OrganizationalEntity> entities) {
        for (OrganizationalEntity entity : entities) {
            if (!entity.equals(user)) continue;
            return true;
        }
        return false;
    }

    private void checkSubTaskStrategy(Task task) {
        for (SubTasksStrategy strategy : task.getSubTaskStrategies()) {
            strategy.execute(this, this.service, task);
        }
        if (task.getTaskData().getParentId() != -1L) {
            Task parentTask = this.getTask(task.getTaskData().getParentId());
            for (SubTasksStrategy strategy : parentTask.getSubTaskStrategies()) {
                strategy.execute(this, this.service, parentTask);
            }
        }
    }

    private <T> T getEntity(Class<T> entityClass, Object primaryKey) {
        Object entity = this.em.find(entityClass, primaryKey);
        if (entity == null) {
            throw new EntityNotFoundException("No " + entityClass.getSimpleName() + " with ID " + primaryKey + " was found!");
        }
        return (T)entity;
    }

    private void persistInTransaction(final Object object) {
        this.doOperationInTransaction(new TransactedOperation(){

            public void doOperation() {
                TaskServiceSession.this.em.persist(object);
            }
        });
    }

    private void beginOrUseExistingTransaction() {
        EntityTransaction tx = this.em.getTransaction();
        if (!tx.isActive()) {
            tx.begin();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doOperationInTransaction(TransactedOperation operation) {
        EntityTransaction tx = this.em.getTransaction();
        try {
            if (!tx.isActive()) {
                tx.begin();
            }
            operation.doOperation();
            tx.commit();
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
        }
    }

    private static interface TransactedOperation {
        public void doOperation();
    }
}

