/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reliability.infinispan;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Set;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.common.Storage;
import org.drools.reliability.core.StorageManager;
import org.drools.reliability.infinispan.InfinispanStorage;
import org.drools.reliability.infinispan.InfinispanStorageManager;
import org.drools.util.Config;
import org.drools.util.FileUtils;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.commons.marshall.JavaSerializationMarshaller;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.globalstate.ConfigurationStorage;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.persistence.sifs.configuration.SoftIndexFileStoreConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedStorageManager
implements InfinispanStorageManager {
    private static final Logger LOG = LoggerFactory.getLogger(EmbeddedStorageManager.class);
    public static final String GLOBAL_STATE_DIR = Config.getConfig((String)"drools.reliability.storage.infinispan.dir", (String)"global/state");
    static final EmbeddedStorageManager INSTANCE = new EmbeddedStorageManager();
    private DefaultCacheManager embeddedCacheManager;
    private Configuration cacheConfiguration;
    public static final String CACHE_DIR = "cache";

    private EmbeddedStorageManager() {
    }

    public void initStorageManager() {
        LOG.info("Using Embedded Cache Manager");
        GlobalConfigurationBuilder global = new GlobalConfigurationBuilder();
        global.serialization().marshaller((Marshaller)new JavaSerializationMarshaller()).allowList().addRegexps(InfinispanStorageManager.getAllowedPackages());
        global.globalState().enable().persistentLocation(GLOBAL_STATE_DIR).configurationStorage(ConfigurationStorage.OVERLAY);
        global.metrics().gauges(false);
        this.embeddedCacheManager = new DefaultCacheManager(global.build());
        org.infinispan.configuration.cache.ConfigurationBuilder builder = new org.infinispan.configuration.cache.ConfigurationBuilder();
        ((SoftIndexFileStoreConfigurationBuilder)builder.persistence().passivation(false).addSoftIndexFileStore().shared(false)).dataLocation("cache/data").indexLocation("cache/index");
        builder.unsafe().unreliableReturnValues(true);
        builder.clustering().cacheMode(CacheMode.LOCAL);
        this.cacheConfiguration = builder.build();
    }

    public <K, V> Storage<K, V> internalGetOrCreateStorageForSession(ReteEvaluator reteEvaluator, String cacheName) {
        Cache cache = this.embeddedCacheManager.administration().getOrCreateCache(StorageManager.createStorageId((ReteEvaluator)reteEvaluator, (String)cacheName), this.cacheConfiguration);
        return InfinispanStorage.fromCache(cache);
    }

    public <K, V> Storage<K, V> getOrCreateSharedStorage(String cacheName) {
        Cache cache = this.embeddedCacheManager.administration().getOrCreateCache("shared_" + cacheName, this.cacheConfiguration);
        return InfinispanStorage.fromCache(cache);
    }

    public void close() {
        this.embeddedCacheManager.stop();
    }

    public void removeStorage(String storageName) {
        if (this.embeddedCacheManager.cacheExists(storageName)) {
            this.embeddedCacheManager.administration().removeCache(storageName);
        }
    }

    public void removeStoragesBySessionId(String sessionId) {
        this.embeddedCacheManager.getCacheNames().stream().filter(cacheName -> cacheName.startsWith("session_" + sessionId + "_")).forEach(this::removeStorage);
    }

    public void removeAllSessionStorages() {
        this.embeddedCacheManager.getCacheNames().stream().filter(cacheName -> cacheName.startsWith("session_")).forEach(this::removeStorage);
    }

    public Set<String> getStorageNames() {
        return this.embeddedCacheManager.getCacheNames();
    }

    @Override
    public void setRemoteCacheManager(RemoteCacheManager remoteCacheManager) {
        throw new UnsupportedOperationException("setRemoteCacheManager is not supported in " + this.getClass());
    }

    public void restart() {
        this.embeddedCacheManager.stop();
        this.embeddedCacheManager = null;
        this.cacheConfiguration = null;
        this.initStorageManager();
    }

    public void restartWithCleanUp() {
        this.embeddedCacheManager.stop();
        this.embeddedCacheManager = null;
        this.cacheConfiguration = null;
        EmbeddedStorageManager.cleanUpGlobalStateAndFileStore();
        this.initStorageManager();
    }

    @Override
    public void setEmbeddedCacheManager(DefaultCacheManager embeddedCacheManager) {
        if (this.embeddedCacheManager != null) {
            this.embeddedCacheManager.stop();
        }
        this.embeddedCacheManager = embeddedCacheManager;
    }

    public DefaultCacheManager getEmbeddedCacheManager() {
        return this.embeddedCacheManager;
    }

    public Configuration getCacheConfiguration() {
        return this.cacheConfiguration;
    }

    private static void cleanUpGlobalStateAndFileStore() {
        FileUtils.deleteDirectory((Path)Paths.get(GLOBAL_STATE_DIR, new String[0]));
    }

    @Override
    public ConfigurationBuilder provideAdditionalRemoteConfigurationBuilder() {
        throw new UnsupportedOperationException("provideRemoteConfigurationBuilder is not supported in " + this.getClass());
    }

    public boolean isRemote() {
        return false;
    }
}

