/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reliability;

import java.util.Set;
import org.drools.core.common.ReteEvaluator;
import org.drools.reliability.ReliabilityConfigurationException;
import org.infinispan.Cache;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.commons.marshall.JavaSerializationMarshaller;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManagerAdmin;
import org.infinispan.persistence.sifs.configuration.SoftIndexFileStoreConfigurationBuilder;
import org.kie.api.runtime.conf.PersistedSessionOption;

public enum CacheManager implements AutoCloseable
{
    INSTANCE;

    public static final String SESSION_CACHE_PREFIX = "session_";
    public static final String DELIMITER = "_";
    private DefaultCacheManager cacheManager;
    private Configuration cacheConfiguration;
    public static final String CACHE_DIR = "tmp/cache";

    private CacheManager() {
        this.initCacheManager();
    }

    private void initCacheManager() {
        GlobalConfigurationBuilder global = new GlobalConfigurationBuilder();
        global.serialization().marshaller((Marshaller)new JavaSerializationMarshaller()).allowList().addRegexps(new String[]{"org.kie.*"}).addRegexps(new String[]{"org.drools.*"}).addRegexps(new String[]{"java.*"});
        this.cacheManager = new DefaultCacheManager(global.build());
        ConfigurationBuilder builder = new ConfigurationBuilder();
        ((SoftIndexFileStoreConfigurationBuilder)builder.persistence().passivation(false).addSoftIndexFileStore().shared(false)).dataLocation("tmp/cache/data").indexLocation("tmp/cache/index");
        builder.clustering().cacheMode(CacheMode.LOCAL).hash().numOwners(1);
        this.cacheConfiguration = builder.build();
    }

    public <k, V> Cache<k, V> getOrCreateCacheForSession(ReteEvaluator reteEvaluator, String cacheName) {
        String cacheId = SESSION_CACHE_PREFIX + this.getSessionIdentifier(reteEvaluator) + DELIMITER + cacheName;
        return ((EmbeddedCacheManagerAdmin)this.cacheManager.administration().withFlags(new CacheContainerAdmin.AdminFlag[]{CacheContainerAdmin.AdminFlag.VOLATILE})).getOrCreateCache(cacheId, this.cacheConfiguration);
    }

    private long getSessionIdentifier(ReteEvaluator reteEvaluator) {
        PersistedSessionOption persistedSessionOption = reteEvaluator.getSessionConfiguration().getPersistedSessionOption();
        if (persistedSessionOption != null) {
            return persistedSessionOption.isNewSession() ? reteEvaluator.getIdentifier() : persistedSessionOption.getSessionId();
        }
        throw new ReliabilityConfigurationException("PersistedSessionOption has to be configured when drools-reliability is used");
    }

    @Override
    public void close() {
        this.cacheManager.stop();
    }

    void restart() {
        this.cacheManager.stop();
        this.cacheManager = null;
        this.cacheConfiguration = null;
        this.initCacheManager();
    }

    void setCacheManager(DefaultCacheManager cacheManager) {
        if (this.cacheManager != null) {
            this.cacheManager.stop();
        }
        this.cacheManager = cacheManager;
    }

    public void removeCache(String cacheName) {
        if (this.cacheManager.cacheExists(cacheName)) {
            this.cacheManager.removeCache(cacheName);
        }
    }

    public void removeAllSessionCaches() {
        this.cacheManager.getCacheNames().stream().filter(cacheName -> cacheName.startsWith(SESSION_CACHE_PREFIX)).forEach(this::removeCache);
    }

    public Set<String> getCacheNames() {
        return this.cacheManager.getCacheNames();
    }
}

