/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reliability;

import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.core.SessionConfiguration;
import org.drools.core.WorkingMemoryEntryPoint;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.phreak.PropagationEntry;
import org.drools.reliability.SimpleReliableObjectStore;
import org.kie.api.event.rule.ObjectDeletedEvent;
import org.kie.api.event.rule.ObjectInsertedEvent;
import org.kie.api.event.rule.ObjectUpdatedEvent;
import org.kie.api.event.rule.RuleRuntimeEventListener;
import org.kie.api.runtime.conf.PersistedSessionOption;
import org.kie.api.runtime.rule.EntryPoint;

public class ReliableSessionInitializer {
    private static final Map<PersistedSessionOption.Strategy, SessionInitializer> initializersMap = Map.of(PersistedSessionOption.Strategy.STORES_ONLY, new StoresOnlySessionInitializer(), PersistedSessionOption.Strategy.FULL, new FullReliableSessionInitializer());

    static InternalWorkingMemory initReliableSession(SessionConfiguration sessionConfig, InternalWorkingMemory session) {
        PersistedSessionOption persistedSessionOption = sessionConfig.getPersistedSessionOption();
        return initializersMap.get(persistedSessionOption.getStrategy()).init(session, persistedSessionOption);
    }

    private static class FullReliableSessionInitializer
    implements SessionInitializer {
        private FullReliableSessionInitializer() {
        }

        @Override
        public InternalWorkingMemory init(InternalWorkingMemory session, PersistedSessionOption persistedSessionOption) {
            return session;
        }
    }

    private static class StoresOnlySessionInitializer
    implements SessionInitializer {
        private StoresOnlySessionInitializer() {
        }

        @Override
        public InternalWorkingMemory init(InternalWorkingMemory session, PersistedSessionOption persistedSessionOption) {
            if (!persistedSessionOption.isNewSession()) {
                this.populateSessionFromCache(session);
            }
            session.setWorkingMemoryActionListener(entry -> this.onWorkingMemoryAction(session, (PropagationEntry)entry));
            session.getRuleRuntimeEventSupport().addEventListener((EventListener)((Object)new SimpleStoreRuntimeEventListener(session)));
            return session;
        }

        private void onWorkingMemoryAction(InternalWorkingMemory session, PropagationEntry entry) {
            if (entry instanceof PropagationEntry.Insert) {
                InternalFactHandle fh = ((PropagationEntry.Insert)entry).getHandle();
                WorkingMemoryEntryPoint ep = fh.getEntryPoint((ReteEvaluator)session);
                ((SimpleReliableObjectStore)ep.getObjectStore()).putIntoPersistedCache(fh.getObject(), true);
            }
        }

        private void populateSessionFromCache(InternalWorkingMemory session) {
            HashMap<EntryPoint, List> notPropagatedByEntryPoint = new HashMap<EntryPoint, List>();
            for (EntryPoint ep2 : session.getEntryPoints()) {
                SimpleReliableObjectStore store = (SimpleReliableObjectStore)((WorkingMemoryEntryPoint)ep2).getObjectStore();
                notPropagatedByEntryPoint.put(ep2, store.reInit(session, ep2));
            }
            notPropagatedByEntryPoint.forEach((ep, objects) -> objects.forEach(arg_0 -> ((EntryPoint)ep).insert(arg_0)));
        }

        static class SimpleStoreRuntimeEventListener
        implements RuleRuntimeEventListener {
            private final InternalWorkingMemory session;

            SimpleStoreRuntimeEventListener(InternalWorkingMemory session) {
                this.session = session;
            }

            public void objectInserted(ObjectInsertedEvent ev) {
            }

            public void objectDeleted(ObjectDeletedEvent ev) {
            }

            public void objectUpdated(ObjectUpdatedEvent ev) {
                SimpleReliableObjectStore store = (SimpleReliableObjectStore)((InternalFactHandle)ev.getFactHandle()).getEntryPoint((ReteEvaluator)this.session).getObjectStore();
                store.putIntoPersistedCache(ev.getObject(), false);
            }
        }
    }

    static interface SessionInitializer {
        public InternalWorkingMemory init(InternalWorkingMemory var1, PersistedSessionOption var2);
    }
}

