/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reliability;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.drools.core.ClassObjectFilter;
import org.drools.reliability.BeforeAllMethodExtension;
import org.drools.reliability.CacheManagerFactory;
import org.drools.reliability.ReliableRuntimeComponentFactoryImpl;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.server.test.core.InfinispanContainer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.conf.Option;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.runtime.conf.KieSessionOption;
import org.kie.api.runtime.conf.PersistedSessionOption;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.utils.KieHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.test.domain.Person;

@ExtendWith(value={BeforeAllMethodExtension.class})
public abstract class ReliabilityTestBasics {
    private static final Logger LOG = LoggerFactory.getLogger(ReliabilityTestBasics.class);
    private InfinispanContainer container;
    protected long savedSessionId;
    protected KieSession session;

    static Stream<PersistedSessionOption.Strategy> strategyProvider() {
        return Stream.of(PersistedSessionOption.Strategy.STORES_ONLY, PersistedSessionOption.Strategy.FULL);
    }

    static Stream<PersistedSessionOption.Strategy> strategyProviderStoresOnly() {
        return Stream.of(PersistedSessionOption.Strategy.STORES_ONLY);
    }

    @BeforeEach
    public void setUp() {
        if (CacheManagerFactory.INSTANCE.getCacheManager().isRemote()) {
            LOG.info("Starting InfinispanContainer");
            this.container = new InfinispanContainer();
            this.container.start();
            LOG.info("InfinispanContainer started");
            RemoteCacheManager remoteCacheManager = this.container.getRemoteCacheManager(CacheManagerFactory.INSTANCE.getCacheManager().provideAdditionalRemoteConfigurationBuilder());
            CacheManagerFactory.INSTANCE.getCacheManager().setRemoteCacheManager(remoteCacheManager);
        }
    }

    @AfterEach
    public void tearDown() {
        if (CacheManagerFactory.INSTANCE.getCacheManager().isRemote()) {
            CacheManagerFactory.INSTANCE.getCacheManager().close();
            this.container.stop();
        } else {
            CacheManagerFactory.INSTANCE.getCacheManager().restartWithCleanUp();
        }
        ReliableRuntimeComponentFactoryImpl.resetCounter();
    }

    public void failover() {
        if (CacheManagerFactory.INSTANCE.getCacheManager().isRemote()) {
            CacheManagerFactory.INSTANCE.getCacheManager().close();
            RemoteCacheManager remoteCacheManager = this.container.getRemoteCacheManager(CacheManagerFactory.INSTANCE.getCacheManager().provideAdditionalRemoteConfigurationBuilder());
            CacheManagerFactory.INSTANCE.getCacheManager().setRemoteCacheManager(remoteCacheManager);
        } else {
            CacheManagerFactory.INSTANCE.getCacheManager().restart();
        }
        ReliableRuntimeComponentFactoryImpl.refreshCounterUsingCache();
    }

    protected FactHandle insertString(String str) {
        return this.session.insert((Object)str);
    }

    protected FactHandle insertInteger(Integer number) {
        return this.session.insert((Object)number);
    }

    protected FactHandle insertMatchingPerson(String name, Integer age) {
        return this.session.insert((Object)new Person(name, age));
    }

    protected void updateWithMatchingPerson(FactHandle nonMatching, Object matching) {
        this.session.update(nonMatching, matching);
    }

    protected void updateWithNonMatchingPerson(FactHandle matching, Object nonMatching) {
        this.session.update(matching, nonMatching);
    }

    protected FactHandle insertNonMatchingPerson(String name, Integer age) {
        return this.session.insert((Object)new Person(name, age));
    }

    protected List<Object> getResults() {
        return (List)this.session.getGlobal("results");
    }

    protected void clearResults() {
        ((List)this.session.getGlobal("results")).clear();
    }

    protected KieSession createSession(String drl, PersistedSessionOption.Strategy strategy, Option ... options) {
        this.getKieSession(drl, strategy != null ? PersistedSessionOption.newSession((PersistedSessionOption.Strategy)strategy) : null, options);
        this.savedSessionId = this.session.getIdentifier();
        return this.session;
    }

    protected KieSession restoreSession(String drl, PersistedSessionOption.Strategy strategy, Option ... options) {
        return this.getKieSession(drl, PersistedSessionOption.fromSession((long)this.savedSessionId, (PersistedSessionOption.Strategy)strategy), options);
    }

    protected void disposeSession() {
        this.session.dispose();
    }

    protected KieSession getKieSession(String drl, PersistedSessionOption persistedSessionOption, Option ... options) {
        OptionsFilter optionsFilter = new OptionsFilter(options);
        KieBase kbase = new KieHelper().addContent(drl, ResourceType.DRL).build(optionsFilter.getKieBaseOptions());
        KieSessionConfiguration conf = KieServices.get().newKieSessionConfiguration();
        if (persistedSessionOption != null) {
            conf.setOption((Option)persistedSessionOption);
        }
        Stream.of(optionsFilter.getKieSessionOption()).forEach(arg_0 -> ((KieSessionConfiguration)conf).setOption(arg_0));
        this.session = kbase.newKieSession(conf, null);
        if (persistedSessionOption == null || persistedSessionOption.isNewSession()) {
            ArrayList results = new ArrayList();
            this.session.setGlobal("results", results);
        }
        return this.session;
    }

    protected Optional<Person> getPersonByName(KieSession kieSession, String name) {
        return kieSession.getObjects((ObjectFilter)new ClassObjectFilter(Person.class)).stream().map(Person.class::cast).filter(p -> p.getName().equals(name)).findFirst();
    }

    private static class OptionsFilter {
        private final Option[] options;

        OptionsFilter(Option[] options) {
            this.options = options;
        }

        KieBaseOption[] getKieBaseOptions() {
            return this.options == null ? new KieBaseOption[]{} : (KieBaseOption[])Stream.of(this.options).filter(KieBaseOption.class::isInstance).toArray(KieBaseOption[]::new);
        }

        KieSessionOption[] getKieSessionOption() {
            return this.options == null ? new KieSessionOption[]{} : (KieSessionOption[])Stream.of(this.options).filter(KieSessionOption.class::isInstance).toArray(KieSessionOption[]::new);
        }
    }
}

