/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reliability;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import org.drools.core.common.ReteEvaluator;
import org.drools.reliability.CacheManager;
import org.drools.util.Config;
import org.drools.util.FileUtils;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.commons.marshall.JavaSerializationMarshaller;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.globalstate.ConfigurationStorage;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.persistence.sifs.configuration.SoftIndexFileStoreConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EmbeddedCacheManager
implements CacheManager {
    private static final Logger LOG = LoggerFactory.getLogger(EmbeddedCacheManager.class);
    private static final String[] ALLOWED_PACKAGES;
    public static final String GLOBAL_STATE_DIR;
    static final EmbeddedCacheManager INSTANCE;
    private DefaultCacheManager embeddedCacheManager;
    private Configuration cacheConfiguration;
    public static final String CACHE_DIR = "cache";

    private EmbeddedCacheManager() {
    }

    @Override
    public void initCacheManager() {
        LOG.info("Using Embedded Cache Manager");
        GlobalConfigurationBuilder global = new GlobalConfigurationBuilder();
        global.serialization().marshaller((Marshaller)new JavaSerializationMarshaller()).allowList().addRegexps(ALLOWED_PACKAGES);
        global.globalState().enable().persistentLocation(GLOBAL_STATE_DIR).configurationStorage(ConfigurationStorage.OVERLAY);
        this.embeddedCacheManager = new DefaultCacheManager(global.build());
        org.infinispan.configuration.cache.ConfigurationBuilder builder = new org.infinispan.configuration.cache.ConfigurationBuilder();
        ((SoftIndexFileStoreConfigurationBuilder)builder.persistence().passivation(false).addSoftIndexFileStore().shared(false)).dataLocation("cache/data").indexLocation("cache/index");
        builder.clustering().cacheMode(CacheMode.LOCAL);
        this.cacheConfiguration = builder.build();
    }

    public <k, V> Cache<k, V> getOrCreateCacheForSession(ReteEvaluator reteEvaluator, String cacheName) {
        return this.embeddedCacheManager.administration().getOrCreateCache(CacheManager.createCacheId(reteEvaluator, cacheName), this.cacheConfiguration);
    }

    @Override
    public <k, V> BasicCache<k, V> getOrCreateSharedCache(String cacheName) {
        return this.embeddedCacheManager.administration().getOrCreateCache("shared_" + cacheName, this.cacheConfiguration);
    }

    @Override
    public void close() {
        this.embeddedCacheManager.stop();
    }

    @Override
    public void removeCache(String cacheName) {
        if (this.embeddedCacheManager.cacheExists(cacheName)) {
            this.embeddedCacheManager.removeCache(cacheName);
        }
    }

    @Override
    public void removeCachesBySessionId(String sessionId) {
        this.embeddedCacheManager.getCacheNames().stream().filter(cacheName -> cacheName.startsWith("session_" + sessionId + "_")).forEach(this::removeCache);
    }

    @Override
    public void removeAllSessionCaches() {
        this.embeddedCacheManager.getCacheNames().stream().filter(cacheName -> cacheName.startsWith("session_")).forEach(this::removeCache);
    }

    @Override
    public Set<String> getCacheNames() {
        return this.embeddedCacheManager.getCacheNames();
    }

    @Override
    public void setRemoteCacheManager(RemoteCacheManager remoteCacheManager) {
        throw new UnsupportedOperationException("setRemoteCacheManager is not supported in " + this.getClass());
    }

    @Override
    public void restart() {
        this.embeddedCacheManager.stop();
        this.embeddedCacheManager = null;
        this.cacheConfiguration = null;
        this.initCacheManager();
    }

    @Override
    public void restartWithCleanUp() {
        this.embeddedCacheManager.stop();
        this.embeddedCacheManager = null;
        this.cacheConfiguration = null;
        EmbeddedCacheManager.cleanUpGlobalStateAndFileStore();
        this.initCacheManager();
    }

    @Override
    public void setEmbeddedCacheManager(DefaultCacheManager embeddedCacheManager) {
        if (this.embeddedCacheManager != null) {
            this.embeddedCacheManager.stop();
        }
        this.embeddedCacheManager = embeddedCacheManager;
    }

    private static void cleanUpGlobalStateAndFileStore() {
        FileUtils.deleteDirectory((Path)Paths.get(GLOBAL_STATE_DIR, new String[0]));
    }

    @Override
    public ConfigurationBuilder provideAdditionalRemoteConfigurationBuilder() {
        throw new UnsupportedOperationException("provideRemoteConfigurationBuilder is not supported in " + this.getClass());
    }

    @Override
    public boolean isRemote() {
        return false;
    }

    static {
        GLOBAL_STATE_DIR = Config.getConfig((String)"drools.reliability.cache.dir", (String)"global/state");
        ArrayList<String> allowList = new ArrayList<String>();
        allowList.add("org.kie.*");
        allowList.add("org.drools.*");
        allowList.add("java.*");
        Config.getOptionalConfig((String)"drools.reliability.cache.allowedpackages").ifPresent(additionalPkgs -> Arrays.stream(additionalPkgs.split(",")).forEach(p -> allowList.add(p + ".*")));
        ALLOWED_PACKAGES = allowList.toArray(new String[allowList.size()]);
        INSTANCE = new EmbeddedCacheManager();
    }
}

