/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reliability;

import java.util.HashMap;
import java.util.Map;
import org.drools.core.rule.accessor.GlobalResolver;
import org.infinispan.commons.api.BasicCache;

public class ReliableGlobalResolver
implements GlobalResolver {
    private final BasicCache<String, Object> cache;
    private final Map<String, Object> toBeRefreshed = new HashMap<String, Object>();

    public ReliableGlobalResolver(BasicCache<String, Object> cache) {
        this.cache = cache;
    }

    public Object resolveGlobal(String identifier) {
        if (this.toBeRefreshed.containsKey(identifier)) {
            return this.toBeRefreshed.get(identifier);
        }
        Object global = this.cache.get((Object)identifier);
        this.toBeRefreshed.put(identifier, global);
        return global;
    }

    public void setGlobal(String identifier, Object value) {
        this.cache.put((Object)identifier, value);
    }

    public void removeGlobal(String identifier) {
        this.cache.remove((Object)identifier);
    }

    public void clear() {
        this.cache.clear();
    }

    public void updateCache() {
        if (!this.toBeRefreshed.isEmpty()) {
            this.toBeRefreshed.forEach((arg_0, arg_1) -> this.cache.put(arg_0, arg_1));
            this.toBeRefreshed.clear();
        }
    }
}

