/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reliability;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import org.drools.core.common.ReteEvaluator;
import org.drools.reliability.CacheManager;
import org.drools.util.Config;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.commons.marshall.JavaSerializationMarshaller;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.manager.DefaultCacheManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RemoteCacheManager
implements CacheManager {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteCacheManager.class);
    private static final String[] ALLOWED_PACKAGES;
    static final RemoteCacheManager INSTANCE;
    private org.infinispan.client.hotrod.RemoteCacheManager remoteCacheManager;

    private RemoteCacheManager() {
    }

    @Override
    public void initCacheManager() {
        LOG.info("Using Remote Cache Manager");
        String host = Config.getConfig((String)"drools.reliability.cache.remote.host");
        String port = Config.getConfig((String)"drools.reliability.cache.remote.port");
        String user = Config.getConfig((String)"drools.reliability.cache.remote.user");
        String pass = Config.getConfig((String)"drools.reliability.cache.remote.pass");
        if (host == null || port == null) {
            LOG.info("Remote Cache Manager host '{}' and port '{}' not set. So not creating a default RemoteCacheManager. You will need to set a RemoteCacheManager with setRemoteCacheManager() method.", (Object)host, (Object)port);
            return;
        }
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.addServer().host(host).port(Integer.parseInt(port));
        if (user != null && pass != null) {
            builder.security().authentication().username(user).password(pass);
        }
        builder.marshaller((Marshaller)new JavaSerializationMarshaller()).addJavaSerialAllowList(ALLOWED_PACKAGES);
        this.remoteCacheManager = new org.infinispan.client.hotrod.RemoteCacheManager(builder.build());
    }

    @Override
    public <k, V> BasicCache<k, V> getOrCreateCacheForSession(ReteEvaluator reteEvaluator, String cacheName) {
        return this.remoteCacheManager.administration().getOrCreateCache(CacheManager.createCacheId(reteEvaluator, cacheName), (String)null);
    }

    @Override
    public <k, V> BasicCache<k, V> getOrCreateSharedCache(String cacheName) {
        return this.remoteCacheManager.administration().getOrCreateCache("shared_" + cacheName, (String)null);
    }

    @Override
    public void close() {
        this.remoteCacheManager.close();
    }

    @Override
    public void removeCache(String cacheName) {
        if (this.remoteCacheManager.getCache(cacheName) != null) {
            this.remoteCacheManager.administration().removeCache(cacheName);
        }
    }

    @Override
    public void removeCachesBySessionId(String sessionId) {
        this.remoteCacheManager.getCacheNames().stream().filter(cacheName -> cacheName.startsWith("session_" + sessionId + "_")).forEach(this::removeCache);
    }

    @Override
    public void removeAllSessionCaches() {
        this.remoteCacheManager.getCacheNames().stream().filter(cacheName -> cacheName.startsWith("session_")).forEach(this::removeCache);
    }

    @Override
    public Set<String> getCacheNames() {
        return this.remoteCacheManager.getCacheNames();
    }

    @Override
    public void setRemoteCacheManager(org.infinispan.client.hotrod.RemoteCacheManager remoteCacheManager) {
        this.remoteCacheManager = remoteCacheManager;
    }

    @Override
    public void restart() {
        if (this.remoteCacheManager != null) {
            this.remoteCacheManager.stop();
        }
    }

    @Override
    public void restartWithCleanUp() {
        if (this.remoteCacheManager != null) {
            this.removeAllCache();
            this.remoteCacheManager.stop();
        }
    }

    private void removeAllCache() {
        this.remoteCacheManager.getCacheNames().forEach(this::removeCache);
    }

    @Override
    public void setEmbeddedCacheManager(DefaultCacheManager cacheManager) {
        throw new UnsupportedOperationException("setEmbeddedCacheManager is not supported in " + this.getClass());
    }

    @Override
    public ConfigurationBuilder provideAdditionalRemoteConfigurationBuilder() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.marshaller((Marshaller)new JavaSerializationMarshaller()).addJavaSerialAllowList(ALLOWED_PACKAGES);
        return builder;
    }

    @Override
    public boolean isRemote() {
        return true;
    }

    static {
        ArrayList<String> allowList = new ArrayList<String>();
        allowList.add("org.kie.*");
        allowList.add("org.drools.*");
        allowList.add("java.*");
        String additionalPkgs = Config.getConfig((String)"drools.reliability.cache.allowedpackages");
        if (additionalPkgs != null) {
            Arrays.stream(additionalPkgs.split(",")).forEach(p -> allowList.add(p + ".*"));
        }
        ALLOWED_PACKAGES = allowList.toArray(new String[allowList.size()]);
        INSTANCE = new RemoteCacheManager();
    }
}

