/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reliability;

import java.util.ArrayList;
import java.util.List;
import org.drools.core.common.EventFactHandle;
import org.drools.core.common.IdentityObjectStore;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.InternalWorkingMemoryEntryPoint;
import org.drools.reliability.StoredObject;
import org.infinispan.commons.api.BasicCache;

public class SimpleReliableObjectStore
extends IdentityObjectStore {
    private final BasicCache<Long, StoredObject> cache;
    private boolean reInitPropagated = false;

    public SimpleReliableObjectStore(BasicCache<Long, StoredObject> cache) {
        this.cache = cache;
    }

    public void addHandle(InternalFactHandle handle, Object object) {
        super.addHandle(handle, object);
        this.putIntoPersistedCache(handle, handle.hasMatches());
    }

    public void removeHandle(InternalFactHandle handle) {
        this.removeFromPersistedCache(handle.getObject());
        super.removeHandle(handle);
    }

    List<StoredObject> reInit(InternalWorkingMemory session, InternalWorkingMemoryEntryPoint ep) {
        this.reInitPropagated = true;
        ArrayList<StoredObject> propagated = new ArrayList<StoredObject>();
        ArrayList<StoredObject> notPropagated = new ArrayList<StoredObject>();
        for (StoredObject entry : this.cache.values()) {
            if (entry.isPropagated()) {
                propagated.add(entry);
                continue;
            }
            notPropagated.add(entry);
        }
        this.cache.clear();
        propagated.forEach(obj -> obj.repropagate(ep));
        session.fireAllRules(match -> false);
        this.reInitPropagated = false;
        return notPropagated;
    }

    void putIntoPersistedCache(InternalFactHandle handle, boolean propagated) {
        Object object = handle.getObject();
        StoredObject storedObject = handle.isEvent() ? new StoredObject(object, this.reInitPropagated || propagated, ((EventFactHandle)handle).getStartTimestamp(), ((EventFactHandle)handle).getDuration()) : new StoredObject(object, this.reInitPropagated || propagated);
        this.cache.put((Object)((InternalFactHandle)this.fhMap.get(object)).getId(), (Object)storedObject);
    }

    void removeFromPersistedCache(Object object) {
        InternalFactHandle fh = (InternalFactHandle)this.fhMap.get(object);
        if (fh != null) {
            this.cache.remove((Object)fh.getId());
        }
    }
}

