/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reliability;

import java.io.Serializable;
import org.drools.core.WorkingMemoryEntryPoint;
import org.drools.core.common.EventFactHandle;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemoryEntryPoint;
import org.drools.core.rule.accessor.FactHandleFactory;

public class StoredObject
implements Serializable {
    private final Object object;
    private final boolean propagated;
    private final long timestamp;
    private final long duration;

    public StoredObject(Object object, boolean propagated) {
        this(object, propagated, -1L, -1L);
    }

    public StoredObject(Object object, boolean propagated, long timestamp, long duration) {
        this.object = object;
        this.propagated = propagated;
        this.timestamp = timestamp;
        this.duration = duration;
    }

    boolean isEvent() {
        return this.timestamp >= 0L;
    }

    public boolean isPropagated() {
        return this.propagated;
    }

    void repropagate(InternalWorkingMemoryEntryPoint ep) {
        if (this.isEvent()) {
            FactHandleFactory fhFactory = ep.getHandleFactory();
            EventFactHandle eFh = fhFactory.createEventFactHandle(fhFactory.getNextId(), this.object, fhFactory.getNextRecency(), (WorkingMemoryEntryPoint)ep, this.timestamp, this.duration);
            ep.insert((InternalFactHandle)eFh);
        } else {
            ep.insert(this.object);
        }
    }
}

