/*
 * Decompiled with CFR 0.152.
 */
package org.drools.repository.security;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.drools.repository.RepositorySessionUtil;
import org.drools.repository.security.PermissionManager;

public class PermissionManagerTest
extends TestCase {
    public void testLoadSave() throws Exception {
        PermissionManager pm = new PermissionManager(RepositorySessionUtil.getRepository());
        HashMap<String, List<String>> perms = new HashMap<String, List<String>>(){
            {
                this.put("package.admin", new ArrayList<String>(){
                    {
                        this.add("1234567890");
                    }
                });
                this.put("package.developer", new ArrayList<String>(){
                    {
                        this.add("1");
                        this.add("2");
                    }
                });
                this.put("analyst", new ArrayList<String>(){
                    {
                        this.add("HR");
                    }
                });
                this.put("admin", new ArrayList());
            }
        };
        pm.updateUserPermissions("wankle", (Map)perms);
        Map perms_ = pm.retrieveUserPermissions("wankle");
        PermissionManagerTest.assertEquals((int)perms.size(), (int)perms_.size());
        perms_ = pm.retrieveUserPermissions("wankle");
        PermissionManagerTest.assertEquals((int)perms.size(), (int)perms_.size());
        List padmin = (List)perms_.get("package.admin");
        PermissionManagerTest.assertEquals((int)1, (int)padmin.size());
        PermissionManagerTest.assertEquals((String)"1234567890", (String)((String)padmin.get(0)));
        List pdev = (List)perms_.get("package.developer");
        PermissionManagerTest.assertEquals((int)2, (int)pdev.size());
        perms = new HashMap<String, List<String>>(){
            {
                this.put("admin", null);
            }
        };
        pm.updateUserPermissions("wankle2", (Map)perms);
        perms_ = pm.retrieveUserPermissions("wankle2");
        List aperms = (List)perms_.get("admin");
        PermissionManagerTest.assertEquals((int)0, (int)aperms.size());
        perms_.remove("admin");
        PermissionManagerTest.assertEquals((int)0, (int)perms_.size());
        pm.updateUserPermissions("wankle2", perms_);
        perms_ = pm.retrieveUserPermissions("wankle2");
        PermissionManagerTest.assertEquals((int)0, (int)perms_.size());
        perms_ = pm.retrieveUserPermissions("wankle");
        padmin = (List)perms_.get("package.admin");
        PermissionManagerTest.assertEquals((int)1, (int)padmin.size());
        PermissionManagerTest.assertEquals((String)"1234567890", (String)((String)padmin.get(0)));
        PermissionManagerTest.assertTrue((boolean)pm.listUsers().containsKey("wankle"));
        pm.removeUserPermissions("wankle");
        PermissionManagerTest.assertFalse((boolean)pm.listUsers().containsKey("wankle"));
    }

    public void testUpdatePerms() throws Exception {
        PermissionManager pm = new PermissionManager(RepositorySessionUtil.getRepository());
        Map<String, List<String>> perms = new HashMap<String, List<String>>(){
            {
                this.put("package.admin", new ArrayList<String>(){
                    {
                        this.add("1234567890");
                    }
                });
                this.put("package.developer", new ArrayList<String>(){
                    {
                        this.add("1");
                        this.add("2");
                    }
                });
                this.put("analyst", new ArrayList<String>(){
                    {
                        this.add("HR");
                    }
                });
                this.put("admin", new ArrayList());
            }
        };
        pm.updateUserPermissions("testUpdatePermsWankle", (Map)perms);
        perms = pm.retrieveUserPermissions("testUpdatePermsWankle");
        PermissionManagerTest.assertEquals((int)4, (int)perms.size());
        perms.remove("package.developer");
        pm.updateUserPermissions("testUpdatePermsWankle", perms);
        perms = pm.retrieveUserPermissions("testUpdatePermsWankle");
        PermissionManagerTest.assertEquals((int)3, (int)perms.size());
    }

    public void testNilUser() throws Exception {
        PermissionManager pm = new PermissionManager(RepositorySessionUtil.getRepository());
        Map perms_ = pm.retrieveUserPermissions("nobody");
        PermissionManagerTest.assertEquals((int)0, (int)perms_.size());
        perms_ = pm.retrieveUserPermissions("nobody");
        PermissionManagerTest.assertEquals((int)0, (int)perms_.size());
    }

    public void testListingUsers() throws Exception {
        PermissionManager pm = new PermissionManager(RepositorySessionUtil.getRepository());
        pm.deleteAllPermissions();
        HashMap<String, List<String>> perms = new HashMap<String, List<String>>(){
            {
                this.put("package.admin", new ArrayList<String>(){
                    {
                        this.add("1234567890");
                    }
                });
                this.put("package.developer", new ArrayList<String>(){
                    {
                        this.add("1");
                        this.add("2");
                    }
                });
                this.put("analyst", new ArrayList<String>(){
                    {
                        this.add("HR");
                    }
                });
                this.put("admin", new ArrayList());
            }
        };
        pm.updateUserPermissions("listingUser1", (Map)perms);
        perms = new HashMap<String, List<String>>(){
            {
                this.put("admin", new ArrayList());
            }
        };
        pm.updateUserPermissions("listingUser2", (Map)perms);
        pm.updateUserPermissions("listingUser3", (Map)perms);
        perms = new HashMap<String, List<String>>(){
            {
                this.put("package.developer", new ArrayList<String>(){
                    {
                        this.add("1");
                        this.add("2");
                    }
                });
            }
        };
        pm.updateUserPermissions("listingUser4", (Map)perms);
        perms = new HashMap<String, List<String>>(){
            {
                this.put("analyst", new ArrayList<String>(){
                    {
                        this.add("1");
                        this.add("2");
                    }
                });
            }
        };
        pm.updateUserPermissions("listingUser5", (Map)perms);
        Map result = pm.listUsers();
        PermissionManagerTest.assertNotNull((Object)result);
        PermissionManagerTest.assertEquals((int)5, (int)result.size());
        PermissionManagerTest.assertTrue((boolean)result.containsKey("listingUser1"));
        PermissionManagerTest.assertTrue((boolean)result.containsKey("listingUser2"));
        PermissionManagerTest.assertTrue((boolean)result.containsKey("listingUser3"));
        PermissionManagerTest.assertTrue((boolean)result.containsKey("listingUser4"));
        PermissionManagerTest.assertTrue((boolean)result.containsKey("listingUser5"));
        List permTypes = (List)result.get("listingUser1");
        PermissionManagerTest.assertEquals((int)4, (int)permTypes.size());
        PermissionManagerTest.assertTrue((boolean)permTypes.contains("package.developer"));
        permTypes = (List)result.get("listingUser5");
        PermissionManagerTest.assertEquals((int)1, (int)permTypes.size());
        PermissionManagerTest.assertEquals((String)"analyst", (String)((String)permTypes.get(0)));
    }

    public void testEmptyUserName() throws Exception {
        PermissionManager pm = new PermissionManager(RepositorySessionUtil.getRepository());
        Map perms_ = pm.retrieveUserPermissions("");
        PermissionManagerTest.assertEquals((int)0, (int)perms_.size());
        perms_ = pm.retrieveUserPermissions("  ");
        PermissionManagerTest.assertEquals((int)0, (int)perms_.size());
        HashMap<String, List<String>> perms = new HashMap<String, List<String>>(){
            {
                this.put("package.admin", new ArrayList<String>(){
                    {
                        this.add("1234567890");
                    }
                });
                this.put("package.developer", new ArrayList<String>(){
                    {
                        this.add("1");
                        this.add("2");
                    }
                });
                this.put("analyst", new ArrayList<String>(){
                    {
                        this.add("HR");
                    }
                });
                this.put("admin", new ArrayList());
            }
        };
        pm.updateUserPermissions(" ", (Map)perms);
        pm.updateUserPermissions("", (Map)perms);
        pm.removeUserPermissions("");
        pm.removeUserPermissions("  ");
    }
}

