/*
 * Decompiled with CFR 0.152.
 */
package org.drools.resource;

import java.io.File;
import java.net.URL;
import junit.framework.TestCase;
import org.apache.log4j.Logger;
import org.drools.resource.RepositoryBean;
import org.drools.resource.ResourceType;
import org.drools.resource.SvnResourceHandler;
import org.drools.resource.util.SvnUtil;

public class SvnResourceHandlerTest
extends TestCase {
    private static Logger logger = Logger.getLogger(SvnResourceHandlerTest.class);
    private static String svnUrl = "file:///D:/dev/trunk2/rule-resource-handler/target/test-classes/svn_repo";
    private static String testFilePath = "D:/dev/trunk2/rule-resource-handler/target/test-classes/files";

    public void setUp() {
        URL url = ((Object)((Object)this)).getClass().getResource("/svn_repo");
        SvnResourceHandlerTest.assertNotNull((Object)url);
        File file = new File(url.getFile());
        svnUrl = "file:///" + file.getAbsolutePath().replaceAll("\\\\", "/");
        testFilePath = file.getParentFile().getAbsolutePath().replaceAll("\\\\", "/") + "/files";
    }

    public void testAuthentication() {
        SvnResourceHandler rHandler = new SvnResourceHandler();
        rHandler.setCredentials("mrtrout", "drools");
        boolean authRtnPass = rHandler.authenticate(svnUrl);
        boolean authRtnFail = rHandler.authenticate(svnUrl + "2");
        System.out.println(svnUrl);
        SvnResourceHandlerTest.assertEquals((boolean)true, (boolean)authRtnPass);
        SvnResourceHandlerTest.assertEquals((boolean)false, (boolean)authRtnFail);
        logger.debug((Object)"testAuthentication executed");
    }

    public void testGetDrlFile() {
        SvnResourceHandler rHandler = new SvnResourceHandler();
        rHandler.setRepositoryUrl(svnUrl);
        rHandler.setCredentials("mrtrout", "drools");
        RepositoryBean bean = new RepositoryBean();
        bean.setName("test");
        bean.setResourceType(ResourceType.DRL_FILE);
        try {
            File f = new File(testFilePath + "/drls/test.drl");
            System.out.println(rHandler.getResourceStream(bean));
            SvnResourceHandlerTest.assertEquals((String)SvnUtil.getByteArrayOutputFromFile((File)f).toString(), (String)rHandler.getResourceStream(bean).toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public void testGetDrlFileByVersion() {
        SvnResourceHandler rHandler = new SvnResourceHandler();
        rHandler.setRepositoryUrl(svnUrl);
        rHandler.setCredentials("mrtrout", "drools");
        RepositoryBean bean = new RepositoryBean();
        bean.setName("test");
        bean.setResourceType(ResourceType.DRL_FILE);
        bean.setVersion("1");
        try {
            File f = new File(testFilePath + "/drls/test.drl");
            System.out.println(rHandler.getResourceStream(bean));
            SvnResourceHandlerTest.assertEquals((String)SvnUtil.getByteArrayOutputFromFile((File)f).toString(), (String)rHandler.getResourceStream(bean).toString());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void testGetDslFile() {
        SvnResourceHandler rHandler = new SvnResourceHandler();
        rHandler.setRepositoryUrl(svnUrl);
        rHandler.setCredentials("mrtrout", "drools");
        RepositoryBean bean = new RepositoryBean();
        bean.setName("test");
        bean.setResourceType(ResourceType.DSL_FILE);
        try {
            File f = new File(testFilePath + "/dsls/test.dsl");
            System.out.println(rHandler.getResourceStream(bean));
            SvnResourceHandlerTest.assertEquals((String)SvnUtil.getByteArrayOutputFromFile((File)f).toString(), (String)rHandler.getResourceStream(bean).toString());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void testGetDslFileByVersion() {
        SvnResourceHandler rHandler = new SvnResourceHandler();
        rHandler.setRepositoryUrl(svnUrl);
        rHandler.setCredentials("mrtrout", "drools");
        RepositoryBean bean = new RepositoryBean();
        bean.setName("test");
        bean.setResourceType(ResourceType.DSL_FILE);
        bean.setVersion("1");
        try {
            File f = new File(testFilePath + "/dsls/test.dsl");
            System.out.println(rHandler.getResourceStream(bean));
            SvnResourceHandlerTest.assertEquals((String)SvnUtil.getByteArrayOutputFromFile((File)f).toString(), (String)rHandler.getResourceStream(bean).toString());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void testGetRuleFunctionByVersion() {
        SvnResourceHandler rHandler = new SvnResourceHandler();
        rHandler.setRepositoryUrl(svnUrl);
        rHandler.setCredentials("mrtrout", "drools");
        RepositoryBean bean = new RepositoryBean();
        bean.setName("test");
        bean.setResourceType(ResourceType.FUNCTION);
        bean.setVersion("1");
        try {
            File f = new File(testFilePath + "/functions/test.function");
            System.out.println(rHandler.getResourceStream(bean));
            SvnResourceHandlerTest.assertEquals((String)SvnUtil.getByteArrayOutputFromFile((File)f).toString(), (String)rHandler.getResourceStream(bean).toString());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void testGetRuleFunction() {
        SvnResourceHandler rHandler = new SvnResourceHandler();
        rHandler.setRepositoryUrl(svnUrl);
        rHandler.setCredentials("mrtrout", "drools");
        RepositoryBean bean = new RepositoryBean();
        bean.setName("test");
        bean.setResourceType(ResourceType.FUNCTION);
        try {
            File f = new File(testFilePath + "/functions/test.function");
            System.out.println(rHandler.getResourceStream(bean));
            SvnResourceHandlerTest.assertEquals((String)SvnUtil.getByteArrayOutputFromFile((File)f).toString(), (String)rHandler.getResourceStream(bean).toString());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void testGetRule() {
        SvnResourceHandler rHandler = new SvnResourceHandler();
        rHandler.setRepositoryUrl(svnUrl);
        rHandler.setCredentials("mrtrout", "drools");
        RepositoryBean bean = new RepositoryBean();
        bean.setName("test");
        bean.setResourceType(ResourceType.RULE);
        try {
            File f = new File(testFilePath + "/rules/test.rule");
            System.out.println(rHandler.getResourceStream(bean));
            SvnResourceHandlerTest.assertEquals((String)SvnUtil.getByteArrayOutputFromFile((File)f).toString(), (String)rHandler.getResourceStream(bean).toString());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void testGetRuleByVersion() {
        SvnResourceHandler rHandler = new SvnResourceHandler();
        rHandler.setRepositoryUrl(svnUrl);
        rHandler.setCredentials("mrtrout", "drools");
        RepositoryBean bean = new RepositoryBean();
        bean.setName("test");
        bean.setResourceType(ResourceType.RULE);
        bean.setVersion("1");
        try {
            File f = new File(testFilePath + "/rules/test.rule");
            System.out.println(rHandler.getResourceStream(bean));
            SvnResourceHandlerTest.assertEquals((String)SvnUtil.getByteArrayOutputFromFile((File)f).toString(), (String)rHandler.getResourceStream(bean).toString());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void testGetSpreadsheet() {
        SvnResourceHandler rHandler = new SvnResourceHandler();
        rHandler.setRepositoryUrl(svnUrl);
        rHandler.setCredentials("mrtrout", "drools");
        RepositoryBean bean = new RepositoryBean();
        bean.setName("test");
        bean.setResourceType(ResourceType.XLS_FILE);
        try {
            File f = new File(testFilePath + "/spreadsheets/test.xls");
            SvnResourceHandlerTest.assertEquals((String)SvnUtil.getByteArrayOutputFromFile((File)f).toString(), (String)rHandler.getResourceStream(bean).toString());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void testGetSpreadsheetByVersion() {
        SvnResourceHandler rHandler = new SvnResourceHandler();
        rHandler.setRepositoryUrl(svnUrl);
        rHandler.setCredentials("mrtrout", "drools");
        RepositoryBean bean = new RepositoryBean();
        bean.setName("test");
        bean.setResourceType(ResourceType.XLS_FILE);
        bean.setVersion("1");
        try {
            File f = new File(testFilePath + "/spreadsheets/test.xls");
            SvnResourceHandlerTest.assertEquals((String)SvnUtil.getByteArrayOutputFromFile((File)f).toString(), (String)rHandler.getResourceStream(bean).toString());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

