/*
 * Decompiled with CFR 0.152.
 */
package org.drools.repository.migration;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.drools.repository.AssetItem;
import org.drools.repository.PackageItem;
import org.drools.repository.PackageIterator;
import org.drools.repository.RulesRepository;

public class MigrateDroolsPackage {
    public boolean needsMigration(RulesRepository repo) throws RepositoryException {
        Node root = repo.getSession().getRootNode().getNode("drools:repository");
        return !root.hasNode("drools.package.migrated");
    }

    public void migrate(RulesRepository repo) throws RepositoryException {
        System.out.println("AUTO MIGRATION: Performing drools.package migration...");
        PackageIterator pkgs = repo.listPackages();
        boolean performed = false;
        while (pkgs.hasNext()) {
            performed = true;
            PackageItem pkg = (PackageItem)pkgs.next();
            this.migratePackage(pkg);
            String[] snaps = repo.listPackageSnapshots(pkg.getName());
            if (snaps == null) continue;
            for (int i = 0; i < snaps.length; ++i) {
                PackageItem snap = repo.loadPackageSnapshot(pkg.getName(), snaps[i]);
                this.migratePackage(snap);
            }
        }
        if (performed) {
            repo.getSession().getRootNode().getNode("drools:repository").addNode("drools.package.migrated", "nt:folder");
            repo.save();
            System.out.println("AUTO MIGRATION: drools.package migration completed.");
        }
    }

    private void migratePackage(PackageItem pkg) {
        if (!pkg.containsAsset("drools")) {
            AssetItem asset = pkg.addAsset("drools", "");
            asset.updateFormat("package");
            asset.updateContent(pkg.getStringProperty("drools:header"));
            asset.checkin("");
        }
    }
}

