/*
 * Decompiled with CFR 0.152.
 */
package org.drools.repository.security;

import java.util.ArrayList;
import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.core.ItemId;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.uuid.UUID;
import org.apache.log4j.Logger;
import org.drools.repository.security.DroolsACLRegistration;
import org.drools.repository.security.DroolsRepositoryAccessManager;
import org.drools.repository.security.UUIDResource;
import org.jboss.security.acl.ACL;
import org.jboss.security.acl.ACLEntry;
import org.jboss.security.acl.ACLEntryImpl;
import org.jboss.security.acl.ACLPermission;
import org.jboss.security.acl.ACLPersistenceStrategy;
import org.jboss.security.acl.ACLProvider;
import org.jboss.security.acl.ACLProviderImpl;
import org.jboss.security.acl.BasicACLPermission;
import org.jboss.security.acl.BitMaskPermission;
import org.jboss.security.acl.CompositeACLPermission;
import org.jboss.security.acl.JPAPersistenceStrategy;
import org.jboss.security.authorization.AuthorizationException;
import org.jboss.security.authorization.Resource;
import org.jboss.security.identity.Identity;

public class DroolsRepositoryACLManager {
    private Identity identity;
    private ACLPersistenceStrategy strategy = new JPAPersistenceStrategy();
    private DroolsACLRegistration registration = new DroolsACLRegistration(this.strategy);
    private ACLProvider provider = new ACLProviderImpl();
    private static Logger log = Logger.getLogger(DroolsRepositoryAccessManager.class);

    public DroolsRepositoryACLManager(Identity identity) {
        this.provider.setPersistenceStrategy(this.strategy);
        this.identity = identity;
        log.debug((Object)("ACL manager for user:" + identity.getName()));
    }

    public void setPermission(String uuid, int permission) {
        UUIDResource localresource = new UUIDResource(uuid);
        ArrayList<ACLEntry> entries = new ArrayList<ACLEntry>();
        ACLEntryImpl entry = new ACLEntryImpl(this.toSecurityByteMaskPermission(permission), this.identity);
        entries.add(entry);
        this.registration.registerACL(localresource, entries);
    }

    public void removePermission(UUID uuid) {
        ACL acl = this.strategy.getACL((Resource)new UUIDResource(uuid.toString()));
        this.strategy.removeACL(acl);
    }

    public boolean checkPermission(ItemId id, int permissions) throws AuthorizationException, ItemNotFoundException, RepositoryException {
        Session session = DroolsRepositoryAccessManager.adminThreadlocal.get();
        UUID nodeUUID = this.getNodeUUIDFromItemId(id);
        if (session != null && nodeUUID != null) {
            UUIDResource localresource = new UUIDResource(nodeUUID.toString());
            return this.provider.isAccessGranted((Resource)localresource, this.identity, (ACLPermission)this.toSecurityByteMaskPermission(permissions));
        }
        return true;
    }

    private UUID getNodeUUIDFromItemId(ItemId id) {
        if (id.denotesNode()) {
            return ((NodeId)id).getUUID();
        }
        return null;
    }

    private BitMaskPermission toSecurityByteMaskPermission(int permission) {
        switch (permission) {
            case 1: {
                return BasicACLPermission.READ;
            }
            case 2: {
                return new CompositeACLPermission(new BasicACLPermission[]{BasicACLPermission.UPDATE, BasicACLPermission.CREATE});
            }
            case 4: {
                return BasicACLPermission.DELETE;
            }
        }
        return new CompositeACLPermission(permission);
    }
}

