/*
 * Decompiled with CFR 0.152.
 */
package org.drools.repository;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.drools.repository.AssetItem;
import org.drools.repository.AssetItemIterator;
import org.drools.repository.PackageItem;
import org.drools.repository.PackageIterator;
import org.drools.repository.RepositorySessionUtil;
import org.drools.repository.RulesRepository;
import org.drools.repository.RulesRepositoryException;
import org.drools.repository.StateItem;

public class PackageItemTest
extends TestCase {
    public void testListPackages() throws Exception {
        RulesRepository repo = this.getRepo();
        PackageItem item = repo.createPackage("testListPackages1", "lalalala");
        PackageItemTest.assertNotNull((Object)item.getCreator());
        item.updateStringProperty("goo", "whee");
        PackageItemTest.assertEquals((String)"goo", (String)item.getStringProperty("whee"));
        PackageItemTest.assertFalse((boolean)item.getCreator().equals(""));
        List list = this.iteratorToList((Iterator)repo.listPackages());
        int prevSize = list.size();
        repo.createPackage("testListPackages2", "abc");
        list = this.iteratorToList((Iterator)repo.listPackages());
        PackageItemTest.assertEquals((int)(prevSize + 1), (int)list.size());
    }

    public void testPackageRemove() throws Exception {
        RulesRepository repo = this.getRepo();
        PackageItem p = repo.createPackage("removeMe", "");
        AssetItem a = p.addAsset("Whee", "");
        a.updateContent("yeah");
        a.checkin("la");
        p.addAsset("Waa", "");
        repo.save();
        PackageItem pkgNested = p.createPackage("NestedGoodness");
        PackageItemTest.assertNotNull((Object)pkgNested);
        int n = this.iteratorToList((Iterator)repo.listPackages()).size();
        p = repo.loadPackage("removeMe");
        p.remove();
        repo.save();
        int n_ = this.iteratorToList((Iterator)repo.listPackages()).size();
        PackageItemTest.assertEquals((int)(n - 1), (int)n_);
    }

    public void testRulePackageItem() throws Exception {
        RulesRepository repo = this.getRepo();
        PackageItem rulePackageItem1 = repo.createPackage("testRulePackage", "desc");
        PackageItemTest.assertNotNull((Object)rulePackageItem1);
        PackageItemTest.assertEquals((String)"testRulePackage", (String)rulePackageItem1.getName());
        PackageIterator it = this.getRepo().listPackages();
        PackageItemTest.assertTrue((boolean)it.hasNext());
        while (it.hasNext()) {
            PackageItem pack = (PackageItem)it.next();
            if (!pack.getName().equals("testRulePackage")) continue;
            return;
        }
        PackageItemTest.fail((String)"should have picked up the testRulePackage but didnt.");
    }

    public void testPackageCopy() throws Exception {
        RulesRepository repo = this.getRepo();
        PackageItem pkg = repo.createPackage("testPackageCopy", "this is something");
        AssetItem it1 = pkg.addAsset("testPackageCopy1", "la");
        AssetItem it2 = pkg.addAsset("testPackageCopy2", "la");
        it1.updateContent("new content");
        it2.updateContent("more content");
        it1.checkin("c");
        it2.checkin("c");
        it1 = pkg.loadAsset("testPackageCopy1");
        List hist1 = this.iteratorToList((Iterator)it1.getHistory());
        System.out.println(hist1.size());
        repo.getSession().getWorkspace().copy(pkg.getNode().getPath(), pkg.getNode().getPath() + "_");
        PackageItem pkg2 = repo.loadPackage("testPackageCopy_");
        PackageItemTest.assertNotNull((Object)pkg2);
        PackageItemTest.assertEquals((int)2, (int)this.iteratorToList(pkg2.getAssets()).size());
        AssetItem it1_ = pkg2.loadAsset("testPackageCopy1");
        it1.updateContent("new content2");
        it1.checkin("la");
        it1_ = pkg2.loadAsset("testPackageCopy1");
        PackageItemTest.assertEquals((String)"new content", (String)it1_.getContent());
    }

    public void testPackageSnapshot() throws Exception {
        RulesRepository repo = this.getRepo();
        PackageItem pkg = repo.createPackage("testPackageSnapshot", "this is something");
        PackageItemTest.assertFalse((boolean)pkg.isSnapshot());
        AssetItem it1 = pkg.addAsset("testPackageCopy1", "la");
        AssetItem it2 = pkg.addAsset("testPackageCopy2", "la");
        it1.updateContent("new content");
        it1.updateFormat("drl");
        it2.updateContent("more content");
        it2.updateFormat("drl");
        it1.checkin("c");
        it2.checkin("c");
        long ver1 = it1.getVersionNumber();
        long ver2 = it2.getVersionNumber();
        PackageItemTest.assertFalse((ver1 == 0L ? 1 : 0) != 0);
        PackageItemTest.assertEquals((int)2, (int)this.iteratorToList((Iterator)pkg.listAssetsByFormat(new String[]{"drl"})).size());
        repo.createPackageSnapshot("testPackageSnapshot", "PROD 2.0");
        PackageItem pkgLoaded = repo.loadPackageSnapshot("testPackageSnapshot", "PROD 2.0");
        PackageItemTest.assertTrue((boolean)pkgLoaded.isSnapshot());
        PackageItemTest.assertEquals((String)"PROD 2.0", (String)pkgLoaded.getSnapshotName());
        PackageItemTest.assertEquals((String)"testPackageSnapshot", (String)pkgLoaded.getName());
        PackageItem _pkgLoaded = repo.loadPackageByUUID(pkgLoaded.getUUID());
        PackageItemTest.assertNotNull((Object)_pkgLoaded);
        PackageItemTest.assertEquals((Object)pkgLoaded.getCreatedDate(), (Object)_pkgLoaded.getCreatedDate());
        PackageItemTest.assertEquals((String)pkgLoaded.getName(), (String)_pkgLoaded.getName());
        List loadedAssets = this.iteratorToList(pkgLoaded.getAssets());
        List _loadedAssets = this.iteratorToList(_pkgLoaded.getAssets());
        PackageItemTest.assertEquals((int)loadedAssets.size(), (int)_loadedAssets.size());
        it1.updateContent("XXX");
        it1.checkin("X");
        PackageItemTest.assertFalse((it1.getVersionNumber() == ver1 ? 1 : 0) != 0);
        AssetItem it3 = pkg.addAsset("testPackageCopy3", "x");
        it3.updateFormat("drl");
        it3.checkin("a");
        PackageItemTest.assertEquals((int)3, (int)this.iteratorToList((Iterator)pkg.listAssetsByFormat(new String[]{"drl"})).size());
        PackageItem pkg2 = repo.loadPackageSnapshot("testPackageSnapshot", "PROD 2.0");
        PackageItemTest.assertNotNull((Object)pkg2);
        List snapAssets = this.iteratorToList(pkg2.getAssets());
        PackageItemTest.assertEquals((int)2, (int)snapAssets.size());
        PackageItemTest.assertFalse((boolean)pkg2.getUUID().equals(pkg.getUUID()));
        PackageItemTest.assertTrue((boolean)(snapAssets.get(0) instanceof AssetItem));
        PackageItemTest.assertTrue((boolean)(snapAssets.get(1) instanceof AssetItem));
        AssetItem sn1 = (AssetItem)snapAssets.get(0);
        AssetItem sn2 = (AssetItem)snapAssets.get(1);
        PackageItemTest.assertEquals((String)"la", (String)sn1.getDescription());
        PackageItemTest.assertEquals((String)"la", (String)sn2.getDescription());
        PackageItemTest.assertEquals((long)ver1, (long)sn1.getVersionNumber());
        PackageItemTest.assertEquals((long)ver2, (long)sn2.getVersionNumber());
        PackageItemTest.assertEquals((int)2, (int)this.iteratorToList((Iterator)pkg2.listAssetsByFormat(new String[]{"drl"})).size());
        String[] res = repo.listPackageSnapshots("testPackageSnapshot");
        PackageItemTest.assertEquals((int)1, (int)res.length);
        PackageItemTest.assertEquals((String)"PROD 2.0", (String)res[0]);
        res = repo.listPackageSnapshots("does not exist");
        PackageItemTest.assertEquals((int)0, (int)res.length);
        repo.removePackageSnapshot("testPackageSnapshot", "XX");
        try {
            repo.removePackageSnapshot("NOTHING SENSIBLE", "XX");
            PackageItemTest.fail((String)"should not be able to remove this.");
        }
        catch (RulesRepositoryException e) {
            PackageItemTest.assertNotNull((Object)e.getMessage());
        }
        repo.removePackageSnapshot("testPackageSnapshot", "PROD 2.0");
        repo.save();
        res = repo.listPackageSnapshots("testPackageSnapshot");
        PackageItemTest.assertEquals((int)0, (int)res.length);
        repo.createPackageSnapshot("testPackageSnapshot", "BOO");
        res = repo.listPackageSnapshots("testPackageSnapshot");
        PackageItemTest.assertEquals((int)1, (int)res.length);
        repo.copyPackageSnapshot("testPackageSnapshot", "BOO", "BOO2");
        res = repo.listPackageSnapshots("testPackageSnapshot");
        PackageItemTest.assertEquals((int)2, (int)res.length);
        repo.copyPackageSnapshot("testPackageSnapshot", "BOO", "BOO2");
        res = repo.listPackageSnapshots("testPackageSnapshot");
        PackageItemTest.assertEquals((int)2, (int)res.length);
        PackageItemTest.assertEquals((String)"BOO", (String)res[0]);
        PackageItemTest.assertEquals((String)"BOO2", (String)res[1]);
    }

    private RulesRepository getRepo() {
        return RepositorySessionUtil.getRepository();
    }

    public void testLoadRulePackageItem() {
        PackageItem rulePackageItem = this.getRepo().createPackage("testLoadRuleRuleItem", "desc");
        rulePackageItem = this.getRepo().loadPackage("testLoadRuleRuleItem");
        PackageItemTest.assertNotNull((Object)rulePackageItem);
        PackageItemTest.assertEquals((String)"testLoadRuleRuleItem", (String)rulePackageItem.getName());
        PackageItemTest.assertEquals((String)"desc", (String)rulePackageItem.getDescription());
        PackageItemTest.assertEquals((String)"package", (String)rulePackageItem.getFormat());
        try {
            rulePackageItem = this.getRepo().loadPackage("anotherRuleRuleItem");
            PackageItemTest.fail((String)"Exception not thrown loading rule package that was not created.");
        }
        catch (RulesRepositoryException e) {
            PackageItemTest.assertNotNull((Object)e.getMessage());
        }
    }

    public void testPackageRuleVersionExtraction() throws Exception {
        PackageItem pack = this.getRepo().createPackage("package extractor", "foo");
        AssetItem rule1 = pack.addAsset("rule number 1", "yeah man");
        rule1.checkin("version0");
        AssetItem rule2 = pack.addAsset("rule number 2", "no way");
        rule2.checkin("version0");
        AssetItem rule3 = pack.addAsset("rule number 3", "yes way");
        rule3.checkin("version0");
        this.getRepo().save();
        pack = this.getRepo().loadPackage("package extractor");
        List rules = this.iteratorToList(pack.getAssets());
        PackageItemTest.assertEquals((int)3, (int)rules.size());
        this.getRepo().createState("foobar");
        StateItem state = this.getRepo().getState("foobar");
        rule1.updateState("foobar");
        rule1.checkin("yeah");
        pack = this.getRepo().loadPackage("package extractor");
        rules = this.iteratorToList(pack.getAssetsWithStatus(state));
        PackageItemTest.assertEquals((int)1, (int)rules.size());
        this.getRepo().createState("whee");
        rules = this.iteratorToList(pack.getAssetsWithStatus(this.getRepo().getState("whee")));
        PackageItemTest.assertEquals((int)0, (int)rules.size());
        rules = this.iteratorToList(pack.getAssetsWithStatus(this.getRepo().getState("Draft")));
        PackageItemTest.assertEquals((int)3, (int)rules.size());
        rule1.updateContent("new content");
        this.getRepo().createState("extractorState");
        rule1.updateState("extractorState");
        rule1.checkin("latest");
        rules = this.iteratorToList(pack.getAssetsWithStatus(this.getRepo().getState("extractorState")));
        PackageItemTest.assertEquals((int)1, (int)rules.size());
        AssetItem rule = (AssetItem)rules.get(0);
        PackageItemTest.assertEquals((String)"new content", (String)rule.getContent());
        this.getRepo().createState("foobar");
        rules = this.iteratorToList(pack.getAssetsWithStatus(this.getRepo().getState("foobar")));
        PackageItemTest.assertEquals((int)1, (int)rules.size());
        AssetItem prior = (AssetItem)rules.get(0);
        PackageItemTest.assertFalse((boolean)"new content".equals(prior.getContent()));
    }

    public void testIgnoreState() throws Exception {
        PackageItem pack = this.getRepo().createPackage("package testIgnoreState", "foo");
        this.getRepo().createState("x");
        AssetItem rule1 = pack.addAsset("rule number 1", "yeah man");
        rule1.updateState("x");
        rule1.checkin("version0");
        AssetItem rule2 = pack.addAsset("rule number 2", "no way");
        rule2.updateState("x");
        rule2.checkin("version0");
        AssetItem rule3 = pack.addAsset("rule number 3", "yes way");
        this.getRepo().createState("disabled");
        rule3.updateState("disabled");
        rule3.checkin("version0");
        this.getRepo().save();
        Iterator result = pack.getAssetsWithStatus(this.getRepo().getState("x"), this.getRepo().getState("disabled"));
        List l = this.iteratorToList(result);
        PackageItemTest.assertEquals((int)2, (int)l.size());
    }

    public void testDuplicatePackageName() throws Exception {
        PackageItem pack = this.getRepo().createPackage("dupePackageTest", "testing for dupe");
        PackageItemTest.assertNotNull((Object)pack.getName());
        try {
            this.getRepo().createPackage("dupePackageTest", "this should fail");
            PackageItemTest.fail((String)"Should not be able to add a package of the same name.");
        }
        catch (RulesRepositoryException e) {
            PackageItemTest.assertNotNull((Object)e.getMessage());
        }
    }

    public void testPackageInstanceWrongNodeType() throws Exception {
        PackageItem pack = this.getRepo().loadDefaultPackage();
        AssetItem rule = pack.addAsset("packageInstanceWrongNodeType", "");
        try {
            new PackageItem(this.getRepo(), rule.getNode());
            PackageItemTest.fail((String)"Can't create a package from a rule node.");
        }
        catch (RulesRepositoryException e) {
            PackageItemTest.assertNotNull((Object)e.getMessage());
        }
    }

    public void testLoadRulePackageItemByUUID() throws Exception {
        PackageItem rulePackageItem = this.getRepo().createPackage("testLoadRuleRuleItemByUUID", "desc");
        String uuid = null;
        uuid = rulePackageItem.getNode().getUUID();
        rulePackageItem = this.getRepo().loadPackageByUUID(uuid);
        PackageItemTest.assertNotNull((Object)rulePackageItem);
        PackageItemTest.assertEquals((String)"testLoadRuleRuleItemByUUID", (String)rulePackageItem.getName());
        try {
            rulePackageItem = this.getRepo().loadPackageByUUID("01010101-0101-0101-0101-010101010101");
            PackageItemTest.fail((String)"Exception not thrown loading rule package that was not created.");
        }
        catch (RulesRepositoryException e) {
            PackageItemTest.assertNotNull((Object)e.getMessage());
        }
    }

    public void testAddAssetTrailingWhitespace() {
        PackageItem pkg = this.getRepo().createPackage("testAddAssetTrailingWhitespace", "desc");
        pkg.addAsset("wee ", "");
        PackageItemTest.assertNotNull((Object)pkg.loadAsset("wee"));
    }

    public void testAddRuleRuleItem() {
        PackageItem rulePackageItem1 = this.getRepo().createPackage("testAddRuleRuleItem", "desc");
        AssetItem ruleItem1 = rulePackageItem1.addAsset("testAddRuleRuleItem", "test description");
        ruleItem1.updateContent("test content");
        ruleItem1.checkin("updated the rule content");
        Iterator rulesIt = rulePackageItem1.getAssets();
        PackageItemTest.assertNotNull((Object)rulesIt);
        AssetItem first = (AssetItem)rulesIt.next();
        PackageItemTest.assertFalse((boolean)rulesIt.hasNext());
        PackageItemTest.assertEquals((String)"testAddRuleRuleItem", (String)first.getName());
        ruleItem1.updateContent("new lhs");
        ruleItem1.checkin("updated again");
        rulesIt = rulePackageItem1.getAssets();
        PackageItemTest.assertNotNull((Object)rulesIt);
        List rules = this.iteratorToList(rulesIt);
        PackageItemTest.assertEquals((int)1, (int)rules.size());
        PackageItemTest.assertEquals((String)"testAddRuleRuleItem", (String)((AssetItem)rules.get(0)).getName());
        PackageItemTest.assertEquals((String)"new lhs", (String)((AssetItem)rules.get(0)).getContent());
        AssetItem ruleItem2 = rulePackageItem1.addAsset("testAddRuleRuleItem2", "test content");
        rules = this.iteratorToList(rulePackageItem1.getAssets());
        PackageItemTest.assertNotNull((Object)rules);
        PackageItemTest.assertEquals((int)2, (int)rules.size());
    }

    List iteratorToList(Iterator it) {
        ArrayList list = new ArrayList();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    public void testGetRules() {
        PackageItem rulePackageItem1 = this.getRepo().createPackage("testGetRules", "desc");
        PackageItemTest.assertFalse((boolean)rulePackageItem1.containsAsset("goober"));
        AssetItem ruleItem1 = rulePackageItem1.addAsset("testGetRules", "desc");
        ruleItem1.updateContent("test lhs content");
        PackageItemTest.assertTrue((boolean)rulePackageItem1.containsAsset("testGetRules"));
        PackageItemTest.assertFalse((boolean)rulePackageItem1.containsAsset("XXXXYYYYZZZZ"));
        List rules = this.iteratorToList(rulePackageItem1.getAssets());
        PackageItemTest.assertNotNull((Object)rules);
        PackageItemTest.assertEquals((int)1, (int)rules.size());
        PackageItemTest.assertEquals((String)"testGetRules", (String)((AssetItem)rules.get(0)).getName());
        AssetItem ruleItem2 = rulePackageItem1.addAsset("testGetRules2", "desc");
        ruleItem2.updateContent("test lhs content");
        rules = this.iteratorToList(rulePackageItem1.getAssets());
        PackageItemTest.assertNotNull((Object)rules);
        PackageItemTest.assertEquals((int)2, (int)rules.size());
        AssetItem loaded = rulePackageItem1.loadAsset("testGetRules");
        PackageItemTest.assertNotNull((Object)loaded);
        PackageItemTest.assertEquals((String)"testGetRules", (String)loaded.getName());
        PackageItemTest.assertEquals((String)"desc", (String)loaded.getDescription());
    }

    public void testToString() {
        PackageItem rulePackageItem1 = this.getRepo().createPackage("testToStringPackage", "desc");
        AssetItem ruleItem1 = rulePackageItem1.addAsset("testToStringPackage", "test lhs content");
        ruleItem1.updateContent("test lhs content");
        PackageItemTest.assertNotNull((Object)rulePackageItem1.toString());
    }

    public void testRemoveRule() {
        PackageItem rulePackageItem1 = this.getRepo().createPackage("testRemoveRule", "desc");
        AssetItem ruleItem1 = rulePackageItem1.addAsset("testRemoveRule", "test lhs content");
        ruleItem1.updateContent("test lhs content");
        Iterator rulesIt = rulePackageItem1.getAssets();
        AssetItem next = (AssetItem)rulesIt.next();
        PackageItemTest.assertFalse((boolean)rulesIt.hasNext());
        PackageItemTest.assertEquals((String)"testRemoveRule", (String)next.getName());
        ruleItem1.updateContent("new lhs");
        List rules = this.iteratorToList(rulePackageItem1.getAssets());
        PackageItemTest.assertNotNull((Object)rules);
        PackageItemTest.assertEquals((int)1, (int)rules.size());
        PackageItemTest.assertEquals((String)"testRemoveRule", (String)((AssetItem)rules.get(0)).getName());
        PackageItemTest.assertEquals((String)"new lhs", (String)((AssetItem)rules.get(0)).getContent());
        AssetItem ruleItem2 = rulePackageItem1.addAsset("testRemoveRule2", "test lhs content");
        rulePackageItem1.loadAsset(ruleItem1.getName()).remove();
        rulePackageItem1.rulesRepository.save();
        rules = this.iteratorToList(rulePackageItem1.getAssets());
        PackageItemTest.assertEquals((int)1, (int)rules.size());
        PackageItemTest.assertEquals((String)"testRemoveRule2", (String)((AssetItem)rules.get(0)).getName());
        rulePackageItem1.loadAsset(ruleItem2.getName()).remove();
        rules = this.iteratorToList(rulePackageItem1.getAssets());
        PackageItemTest.assertNotNull((Object)rules);
        PackageItemTest.assertEquals((int)0, (int)rules.size());
    }

    public void testSearchByFormat() throws Exception {
        PackageItem pkg = this.getRepo().createPackage("searchByFormat", "");
        this.getRepo().save();
        AssetItem item = pkg.addAsset("searchByFormatAsset1", "");
        item.updateFormat("xyz");
        item.checkin("la");
        item = pkg.addAsset("searchByFormatAsset2", "wee");
        item.updateFormat("xyz");
        item.checkin("la");
        item = pkg.addAsset("searchByFormatAsset3", "wee");
        item.updateFormat("ABC");
        item.checkin("la");
        Thread.sleep(150L);
        AssetItemIterator it = pkg.queryAssets("drools:format='xyz'");
        List list = this.iteratorToList((Iterator)it);
        PackageItemTest.assertEquals((int)2, (int)list.size());
        PackageItemTest.assertTrue((boolean)(list.get(0) instanceof AssetItem));
        PackageItemTest.assertTrue((boolean)(list.get(1) instanceof AssetItem));
        AssetItemIterator it2 = pkg.listAssetsByFormat(new String[]{"xyz"});
        List list2 = this.iteratorToList((Iterator)it2);
        PackageItemTest.assertEquals((int)2, (int)list2.size());
        PackageItemTest.assertTrue((boolean)(list2.get(0) instanceof AssetItem));
        PackageItemTest.assertTrue((boolean)(list2.get(1) instanceof AssetItem));
        it2 = pkg.listAssetsByFormat(new String[]{"xyz", "ABC"});
        list2 = this.iteratorToList((Iterator)it2);
        PackageItemTest.assertEquals((int)3, (int)list2.size());
        PackageItemTest.assertTrue((boolean)(list2.get(0) instanceof AssetItem));
        PackageItemTest.assertTrue((boolean)(list2.get(1) instanceof AssetItem));
        PackageItemTest.assertTrue((boolean)(list2.get(2) instanceof AssetItem));
    }

    public void testListArchivedAssets() throws Exception {
        PackageItem pkg = this.getRepo().createPackage("org.drools.archivedtest", "");
        this.getRepo().save();
        AssetItem item = pkg.addAsset("archivedItem1", "");
        item.archiveItem(true);
        item.checkin("la");
        item = pkg.addAsset("archivedItem2", "wee");
        item.archiveItem(true);
        item.checkin("la");
        item = pkg.addAsset("archivedItem3", "wee");
        item.archiveItem(true);
        item.checkin("la");
        item = pkg.addAsset("NOTarchivedItem", "wee");
        item.checkin("la");
        Thread.sleep(150L);
        AssetItemIterator it = pkg.listArchivedAssets();
        List list = this.iteratorToList((Iterator)it);
        PackageItemTest.assertEquals((int)3, (int)list.size());
        PackageItemTest.assertTrue((boolean)(list.get(0) instanceof AssetItem));
        PackageItemTest.assertTrue((boolean)(list.get(1) instanceof AssetItem));
        PackageItemTest.assertTrue((boolean)(list.get(2) instanceof AssetItem));
        it = pkg.queryAssets("", true);
        list = this.iteratorToList((Iterator)it);
        PackageItemTest.assertEquals((int)4, (int)list.size());
    }

    public void testExcludeAssetTypes() throws Exception {
        PackageItem pkg = this.getRepo().createPackage("testExcludeAssetTypes", "");
        this.getRepo().save();
        AssetItem item = pkg.addAsset("a1", "");
        item.updateFormat("drl");
        item.checkin("la");
        item = pkg.addAsset("a2", "wee");
        item.updateFormat("xls");
        item.checkin("la");
        AssetItemIterator it = pkg.listAssetsNotOfFormat(new String[]{"drl"});
        List ls = this.iteratorToList((Iterator)it);
        PackageItemTest.assertEquals((int)1, (int)ls.size());
        AssetItem as = (AssetItem)ls.get(0);
        PackageItemTest.assertEquals((String)"a2", (String)as.getName());
        it = pkg.listAssetsNotOfFormat(new String[]{"drl", "wang"});
        ls = this.iteratorToList((Iterator)it);
        PackageItemTest.assertEquals((int)1, (int)ls.size());
        as = (AssetItem)ls.get(0);
        PackageItemTest.assertEquals((String)"a2", (String)as.getName());
        it = pkg.listAssetsNotOfFormat(new String[]{"drl", "xls"});
        ls = this.iteratorToList((Iterator)it);
        PackageItemTest.assertEquals((int)0, (int)ls.size());
    }

    public void testSortHistoryByVersionNumber() {
        PackageItem item = new PackageItem();
        ArrayList<MockAssetItem> l = new ArrayList<MockAssetItem>();
        MockAssetItem i1 = new MockAssetItem(42L);
        MockAssetItem i2 = new MockAssetItem(1L);
        l.add(i2);
        l.add(i1);
        PackageItemTest.assertEquals((Object)((Object)i2), l.iterator().next());
        item.sortHistoryByVersionNumber(l);
        PackageItemTest.assertEquals((Object)((Object)i1), l.iterator().next());
    }

    public void testMiscProperties() {
        PackageItem item = this.getRepo().createPackage("testHeader", "ya");
        PackageItemTest.updateHeader("new header", item);
        item.updateExternalURI("boo");
        this.getRepo().save();
        PackageItemTest.assertEquals((String)"new header", (String)PackageItemTest.getHeader(item));
        item = this.getRepo().loadPackage("testHeader");
        PackageItemTest.assertEquals((String)"new header", (String)PackageItemTest.getHeader(item));
        PackageItemTest.assertEquals((String)"boo", (String)item.getExternalURI());
    }

    public void testGetFormatAndUpToDate() {
        PackageItem rulePackageItem1 = this.getRepo().createPackage("testGetFormat", "woot");
        PackageItemTest.assertNotNull((Object)rulePackageItem1);
        PackageItemTest.assertEquals((String)"package", (String)rulePackageItem1.getFormat());
        PackageItemTest.assertFalse((boolean)rulePackageItem1.isBinaryUpToDate());
        rulePackageItem1.updateBinaryUpToDate(true);
        PackageItemTest.assertTrue((boolean)rulePackageItem1.isBinaryUpToDate());
        rulePackageItem1.updateBinaryUpToDate(false);
        PackageItemTest.assertFalse((boolean)rulePackageItem1.isBinaryUpToDate());
    }

    public static void updateHeader(String h, PackageItem pkg) {
        pkg.checkout();
        AssetItem as = null;
        as = pkg.containsAsset("drools") ? pkg.loadAsset("drools") : pkg.addAsset("drools", "");
        as.updateContent(h);
    }

    public static String getHeader(PackageItem pkg) {
        if (pkg.containsAsset("drools")) {
            return pkg.loadAsset("drools").getContent();
        }
        return "";
    }

    public void testPackageCheckinConfig() {
        PackageItem item = this.getRepo().createPackage("testPackageCheckinConfig", "description");
        AssetItem rule = item.addAsset("testPackageCheckinConfig", "w");
        rule.checkin("goo");
        PackageItemTest.assertEquals((int)1, (int)this.iteratorToList(item.getAssets()).size());
        PackageItemTest.updateHeader("la", item);
        item.checkin("woot");
        PackageItemTest.updateHeader("we", item);
        item.checkin("gah");
        AssetItem rule_ = this.getRepo().loadAssetByUUID(rule.getUUID());
        PackageItemTest.assertEquals((long)rule.getVersionNumber(), (long)rule_.getVersionNumber());
        item = this.getRepo().loadPackage("testPackageCheckinConfig");
        long v = item.getVersionNumber();
        item.updateCheckinComment("x");
        this.getRepo().save();
        PackageItemTest.assertEquals((long)v, (long)item.getVersionNumber());
    }

    static class MockAssetItem
    extends AssetItem {
        private long version;

        MockAssetItem(long ver) {
            this.version = ver;
        }

        public long getVersionNumber() {
            return this.version;
        }

        public boolean equals(Object in) {
            return in == this;
        }

        public String toString() {
            return Long.toString(this.version);
        }
    }
}

