/*
 * Decompiled with CFR 0.152.
 */
package org.drools.repository.events;

import junit.framework.TestCase;
import org.drools.repository.AssetItem;
import org.drools.repository.PackageItem;
import org.drools.repository.RepositorySessionUtil;
import org.drools.repository.RulesRepository;
import org.drools.repository.events.LoadEvent;
import org.drools.repository.events.MockLoadEvent;
import org.drools.repository.events.MockSaveEvent;
import org.drools.repository.events.SaveEvent;
import org.drools.repository.events.StorageEventManager;

public class StorageEventManagerTest
extends TestCase {
    protected void tearDown() throws Exception {
        StorageEventManager.le = null;
        StorageEventManager.se = null;
    }

    public void testLoadEvent() {
        System.setProperty("guvnor.loadEventListener", "org.drools.repository.events.MockLoadEvent");
        LoadEvent le = StorageEventManager.loadEvent();
        StorageEventManagerTest.assertNotNull((Object)le);
        StorageEventManagerTest.assertTrue((boolean)(le instanceof MockLoadEvent));
        System.setProperty("guvnor.loadEventListener", "");
        StorageEventManagerTest.assertNull((Object)StorageEventManager.loadEvent());
        StorageEventManager.le = le;
        StorageEventManagerTest.assertNotNull((Object)StorageEventManager.getLoadEvent());
        StorageEventManagerTest.assertTrue((boolean)StorageEventManager.hasLoadEvent());
        StorageEventManager.le = null;
        StorageEventManagerTest.assertFalse((boolean)StorageEventManager.hasLoadEvent());
    }

    public void testSaveEvent() {
        System.setProperty("guvnor.saveEventListener", "org.drools.repository.events.MockSaveEvent");
        SaveEvent le = StorageEventManager.saveEvent();
        StorageEventManagerTest.assertNotNull((Object)le);
        StorageEventManagerTest.assertTrue((boolean)(le instanceof MockSaveEvent));
        System.setProperty("guvnor.saveEventListener", "");
        StorageEventManagerTest.assertNull((Object)StorageEventManager.saveEvent());
        StorageEventManager.se = le;
        StorageEventManagerTest.assertNotNull((Object)StorageEventManager.getSaveEvent());
        StorageEventManagerTest.assertTrue((boolean)StorageEventManager.hasSaveEvent());
        StorageEventManager.se = null;
        StorageEventManagerTest.assertFalse((boolean)StorageEventManager.hasSaveEvent());
    }

    public void testAssetContentCallbacks() {
        StorageEventManager.le = null;
        StorageEventManager.se = null;
        RulesRepository repo = this.getRepo();
        PackageItem pkg = repo.loadDefaultPackage();
        AssetItem asset = pkg.addAsset("testAssetContentCallbacks", "");
        StorageEventManagerTest.assertEquals((long)0L, (long)asset.getContentLength());
        asset.updateContent("boo");
        asset.checkin("");
        asset.updateContent("whee");
        StorageEventManager.le = new MockLoadEvent();
        StorageEventManager.se = new MockSaveEvent();
        asset.checkin("");
        StorageEventManagerTest.assertTrue((boolean)((MockSaveEvent)StorageEventManager.se).checkinCalled);
        asset.getContent();
        StorageEventManagerTest.assertTrue((boolean)((MockLoadEvent)StorageEventManager.le).loadCalled);
    }

    private RulesRepository getRepo() {
        return RepositorySessionUtil.getRepository();
    }
}

