/*
 * Decompiled with CFR 0.152.
 */
package org.drools.repository;

import java.io.File;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.apache.log4j.Logger;
import org.drools.repository.JackrabbitRepositoryConfigurator;
import org.drools.repository.RulesRepository;
import org.drools.repository.RulesRepositoryAdministrator;
import org.drools.repository.RulesRepositoryException;
import org.drools.repository.security.DroolsRepositoryAccessManager;

public class RepositorySessionUtil {
    private static ThreadLocal repo = new ThreadLocal();
    private static final Logger log = Logger.getLogger(RepositorySessionUtil.class);

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = RepositorySessionUtil.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static RulesRepository getRepository() throws RulesRepositoryException {
        Object repoInstance = repo.get();
        if (repoInstance == null) {
            File dir = new File("repository");
            System.out.println("DELETING test repo: " + dir.getAbsolutePath());
            RepositorySessionUtil.deleteDir(dir);
            System.out.println("TEST repo was deleted.");
            JackrabbitRepositoryConfigurator config = new JackrabbitRepositoryConfigurator();
            Repository repository = config.getJCRRepository(null);
            try {
                Session session = repository.login((Credentials)new SimpleCredentials("alan_parsons", "password".toCharArray()));
                RulesRepositoryAdministrator admin = new RulesRepositoryAdministrator(session);
                if (admin.isRepositoryInitialized()) {
                    admin.clearRulesRepository();
                }
                config.setupRulesRepository(session);
                repoInstance = new RulesRepository(session);
                Session adminSession = repository.login((Credentials)new SimpleCredentials("ADMINISTRATOR", "password".toCharArray()));
                DroolsRepositoryAccessManager.adminThreadlocal.set(adminSession);
                repo.set(repoInstance);
            }
            catch (Exception e) {
                throw new RulesRepositoryException(e);
            }
        }
        return (RulesRepository)repoInstance;
    }
}

