/*
 * Decompiled with CFR 0.152.
 */
package org.drools.repository;

import java.util.ArrayList;
import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import org.drools.repository.AssetItem;
import org.drools.repository.Item;
import org.drools.repository.ItemVersionIterator;
import org.drools.repository.RulesRepository;
import org.drools.repository.RulesRepositoryException;
import org.drools.repository.StateItem;
import org.drools.repository.events.StorageEventManager;

public abstract class VersionableItem
extends Item {
    public static final String TITLE_PROPERTY_NAME = "drools:title";
    public static final String DESCRIPTION_PROPERTY_NAME = "drools:description";
    public static final String LAST_MODIFIED_PROPERTY_NAME = "drools:lastModified";
    public static final String FORMAT_PROPERTY_NAME = "drools:format";
    public static final String CHECKIN_COMMENT = "drools:checkinComment";
    public static final String VERSION_NUMBER_PROPERTY_NAME = "drools:versionNumber";
    public static final String CONTENT_PROPERTY_ARCHIVE_FLAG = "drools:archive";
    public static final String LAST_CONTRIBUTOR_PROPERTY_NAME = "drools:lastContributor";
    public static final String CREATOR_PROPERTY_NAME = "drools:creator";
    public static final String TYPE_PROPERTY_NAME = "drools:type";
    public static final String SOURCE_PROPERTY_NAME = "drools:source";
    public static final String SUBJECT_PROPERTY_NAME = "drools:subject";
    public static final String RELATION_PROPERTY_NAME = "drools:relation";
    public static final String RIGHTS_PROPERTY_NAME = "drools:rights";
    public static final String COVERAGE_PROPERTY_NAME = "drools:coverage";
    public static final String PUBLISHER_PROPERTY_NAME = "drools:publisher";
    public static final String STATE_PROPERTY_NAME = "drools:stateReference";
    public static final String CATEGORY_PROPERTY_NAME = "drools:categoryReference";
    public static final String DEFAULT_CONTENT_FORMAT = "txt";
    private Node contentNode = null;

    public VersionableItem(RulesRepository rulesRepository, Node node) {
        super(rulesRepository, node);
    }

    public String getUUID() {
        try {
            return this.getVersionContentNode().getUUID();
        }
        catch (RepositoryException e) {
            throw new RulesRepositoryException(e);
        }
    }

    public boolean isHistoricalVersion() throws RepositoryException {
        return this.node.getPrimaryNodeType().getName().equals("nt:version") || this.node.getPrimaryNodeType().getName().equals("nt:frozenNode");
    }

    protected Node getPrecedingVersionNode() throws RulesRepositoryException {
        try {
            Object versionNode = this.node.getPrimaryNodeType().getName().equals("nt:version") ? this.node : this.node.getBaseVersion();
            Property predecessorsProperty = versionNode.getProperty("jcr:predecessors");
            Value[] predecessorValues = predecessorsProperty.getValues();
            if (predecessorValues.length > 0) {
                Node predecessorNode = this.node.getSession().getNodeByUUID(predecessorValues[0].getString());
                if (predecessorNode.getName().equals("jcr:rootVersion")) {
                    return null;
                }
                return predecessorNode;
            }
        }
        catch (PathNotFoundException e) {
        }
        catch (Exception e) {
            log.error((Object)"Caught exception", (Throwable)e);
            throw new RulesRepositoryException(e);
        }
        return null;
    }

    protected Node getSucceedingVersionNode() throws RulesRepositoryException {
        try {
            Property successorsProperty = this.node.getProperty("jcr:successors");
            Value[] successorValues = successorsProperty.getValues();
            if (successorValues.length > 0) {
                Node successorNode = this.node.getSession().getNodeByUUID(successorValues[0].getString());
                return successorNode;
            }
        }
        catch (PathNotFoundException e) {
        }
        catch (Exception e) {
            log.error((Object)"Caught exception", (Throwable)e);
            throw new RulesRepositoryException(e);
        }
        return null;
    }

    ItemVersionIterator getSuccessorVersionsIterator() throws RulesRepositoryException {
        return new ItemVersionIterator(this, 1);
    }

    ItemVersionIterator getPredecessorVersionsIterator() throws RulesRepositoryException {
        return new ItemVersionIterator(this, 2);
    }

    public abstract VersionableItem getPrecedingVersion() throws RulesRepositoryException;

    public abstract VersionableItem getSucceedingVersion() throws RulesRepositoryException;

    public String getTitle() throws RulesRepositoryException {
        try {
            Node theNode = this.getVersionContentNode();
            Property data = theNode.getProperty(TITLE_PROPERTY_NAME);
            return data.getValue().getString();
        }
        catch (Exception e) {
            log.error((Object)"Caught Exception", (Throwable)e);
            throw new RulesRepositoryException(e);
        }
    }

    public void updateTitle(String title) throws RulesRepositoryException {
        this.updateStringProperty(title, TITLE_PROPERTY_NAME);
    }

    public void updateType(String type) {
        this.updateStringProperty(type, TYPE_PROPERTY_NAME);
    }

    public void updateExternalSource(String source) {
        this.updateStringProperty(source, SOURCE_PROPERTY_NAME);
    }

    public void updateSubject(String sub) {
        this.updateStringProperty(sub, SUBJECT_PROPERTY_NAME);
    }

    public void updateExternalRelation(String rel) {
        this.updateStringProperty(rel, RELATION_PROPERTY_NAME);
    }

    public void updateRights(String rights) {
        this.updateStringProperty(rights, RIGHTS_PROPERTY_NAME);
    }

    public void updateCoverage(String cov) {
        this.updateStringProperty(cov, COVERAGE_PROPERTY_NAME);
    }

    public void updatePublisher(String pub) {
        this.updateStringProperty(pub, PUBLISHER_PROPERTY_NAME);
    }

    public void updateStringProperty(String value, String prop) {
        try {
            this.checkIsUpdateable();
            if (value == null) {
                return;
            }
            this.node.checkout();
            this.node.setProperty(prop, value);
            Calendar lastModified = Calendar.getInstance();
            this.node.setProperty(LAST_MODIFIED_PROPERTY_NAME, lastModified);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RulesRepositoryException(e);
        }
    }

    public String getDescription() throws RulesRepositoryException {
        return this.getStringProperty(DESCRIPTION_PROPERTY_NAME);
    }

    public long getVersionNumber() {
        return this.getLongProperty(VERSION_NUMBER_PROPERTY_NAME);
    }

    public String getCheckinComment() throws RulesRepositoryException {
        return this.getStringProperty(CHECKIN_COMMENT);
    }

    public Calendar getLastModified() throws RulesRepositoryException {
        try {
            Node n = this.getVersionContentNode();
            if (n.hasProperty(LAST_MODIFIED_PROPERTY_NAME)) {
                Property lastModifiedProperty = this.getVersionContentNode().getProperty(LAST_MODIFIED_PROPERTY_NAME);
                return lastModifiedProperty.getDate();
            }
            return null;
        }
        catch (Exception e) {
            log.error((Object)"Caught Exception", (Throwable)e);
            throw new RulesRepositoryException(e);
        }
    }

    public void updateDescription(String newDescriptionContent) throws RulesRepositoryException {
        try {
            this.node.checkout();
            this.node.setProperty(DESCRIPTION_PROPERTY_NAME, newDescriptionContent);
            Calendar lastModified = Calendar.getInstance();
            this.node.setProperty(LAST_MODIFIED_PROPERTY_NAME, lastModified);
        }
        catch (Exception e) {
            log.error((Object)"Caught Exception", (Throwable)e);
            throw new RulesRepositoryException(e);
        }
    }

    public String getFormat() throws RulesRepositoryException {
        try {
            Node theNode = this.getVersionContentNode();
            Property data = theNode.getProperty(FORMAT_PROPERTY_NAME);
            return data.getValue().getString();
        }
        catch (Exception e) {
            log.error((Object)"Caught Exception", (Throwable)e);
            throw new RulesRepositoryException(e);
        }
    }

    public void updateFormat(String newFormat) {
        this.updateStringProperty(newFormat, FORMAT_PROPERTY_NAME);
    }

    public Node getVersionContentNode() throws RepositoryException, PathNotFoundException {
        if (this.contentNode == null) {
            this.contentNode = this.getRealContentFromVersion(this.node);
        }
        return this.contentNode;
    }

    protected Node getRealContentFromVersion(Node node) throws RepositoryException, PathNotFoundException {
        if (node.getPrimaryNodeType().getName().equals("nt:version")) {
            return node.getNode("jcr:frozenNode");
        }
        return node;
    }

    public String getName() {
        try {
            return this.getVersionContentNode().getName();
        }
        catch (RepositoryException e) {
            throw new RulesRepositoryException(e);
        }
    }

    public void checkout() {
        VersionableItem.checkout(this.node);
    }

    public static void checkout(Node targetNode) {
        try {
            targetNode.checkout();
        }
        catch (UnsupportedRepositoryOperationException e) {
            String message = "";
            try {
                message = "Error: Caught UnsupportedRepositoryOperationException when attempting to checkout rule: " + targetNode.getName() + ". Are you sure your JCR repository supports versioning? ";
                log.error((Object)message, (Throwable)e);
            }
            catch (RepositoryException e1) {
                log.error((Object)"Caught Exception", (Throwable)e);
                throw new RulesRepositoryException(e1);
            }
            throw new RulesRepositoryException(message, e);
        }
        catch (Exception e) {
            log.error((Object)"Caught Exception", (Throwable)e);
            throw new RulesRepositoryException(e);
        }
    }

    public void checkin(String comment) {
        this.checkIsUpdateable();
        try {
            this.node.setProperty(LAST_MODIFIED_PROPERTY_NAME, Calendar.getInstance());
            this.node.setProperty(CHECKIN_COMMENT, comment);
            this.node.setProperty(LAST_CONTRIBUTOR_PROPERTY_NAME, this.node.getSession().getUserID());
            long nextVersion = this.getVersionNumber() + 1L;
            this.node.setProperty(VERSION_NUMBER_PROPERTY_NAME, nextVersion);
            this.node.getSession().save();
            this.node.checkin();
            if (StorageEventManager.hasSaveEvent() && this instanceof AssetItem) {
                StorageEventManager.getSaveEvent().onAssetCheckin((AssetItem)this);
            }
        }
        catch (RepositoryException e) {
            throw new RulesRepositoryException("Unable to checkin.", e);
        }
    }

    protected void checkIsUpdateable() {
        try {
            if (this.node.getPrimaryNodeType().getName().equals("nt:version")) {
                String message = "Error. Tags can only be added to the head version of a rule node";
                log.error((Object)message);
                throw new RulesRepositoryException(message);
            }
        }
        catch (RepositoryException e) {
            throw new RulesRepositoryException(e);
        }
    }

    public void updateState(String stateName) throws RulesRepositoryException {
        try {
            this.checkout();
            StateItem stateItem = this.rulesRepository.getState(stateName);
            this.updateState(stateItem);
        }
        catch (Exception e) {
            log.error((Object)"Caught exception", (Throwable)e);
            throw new RulesRepositoryException(e);
        }
    }

    public void updateState(StateItem stateItem) throws RulesRepositoryException {
        this.checkIsUpdateable();
        try {
            this.checkout();
            this.node.setProperty(STATE_PROPERTY_NAME, stateItem.getNode());
        }
        catch (Exception e) {
            log.error((Object)"Caught exception", (Throwable)e);
            throw new RulesRepositoryException(e);
        }
    }

    public StateItem getState() throws RulesRepositoryException {
        try {
            Node content = this.getVersionContentNode();
            Property stateProperty = content.getProperty(STATE_PROPERTY_NAME);
            Node stateNode = this.rulesRepository.getSession().getNodeByUUID(stateProperty.getString());
            return new StateItem(this.rulesRepository, stateNode);
        }
        catch (PathNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            log.error((Object)"Caught exception", (Throwable)e);
            throw new RulesRepositoryException(e);
        }
    }

    public String getStateDescription() {
        StateItem state = this.getState();
        if (state == null) {
            return "";
        }
        return state.getName();
    }

    public boolean sameState(StateItem other) {
        StateItem thisState = this.getState();
        if (thisState == other) {
            return true;
        }
        if (thisState != null) {
            return thisState.equals(other);
        }
        return false;
    }

    public String getLastContributor() {
        return this.getStringProperty(LAST_CONTRIBUTOR_PROPERTY_NAME);
    }

    public String getCreator() {
        return this.getStringProperty(CREATOR_PROPERTY_NAME);
    }

    public String getType() {
        return this.getStringProperty(TYPE_PROPERTY_NAME);
    }

    public String getExternalSource() {
        return this.getStringProperty(SOURCE_PROPERTY_NAME);
    }

    public String getSubject() {
        return this.getStringProperty(SUBJECT_PROPERTY_NAME);
    }

    public String getExternalRelation() {
        return this.getStringProperty(RELATION_PROPERTY_NAME);
    }

    public String getRights() {
        return this.getStringProperty(RIGHTS_PROPERTY_NAME);
    }

    public String getCoverage() {
        return this.getStringProperty(COVERAGE_PROPERTY_NAME);
    }

    public String getPublisher() {
        return this.getStringProperty(PUBLISHER_PROPERTY_NAME);
    }

    public Calendar getCreatedDate() {
        try {
            Property prop = this.node.getProperty("jcr:created");
            return prop.getDate();
        }
        catch (RepositoryException e) {
            throw new RulesRepositoryException(e);
        }
    }

    public String getStringProperty(String property) {
        try {
            Node theNode = this.getVersionContentNode();
            if (theNode.hasProperty(property)) {
                Property data = theNode.getProperty(property);
                return data.getValue().getString();
            }
            return "";
        }
        catch (RepositoryException e) {
            throw new RulesRepositoryException(e);
        }
    }

    public String[] getStringPropertyArray(String property) {
        try {
            Node theNode = this.getVersionContentNode();
            if (theNode.hasProperty(property)) {
                Property data = theNode.getProperty(property);
                Value[] values = data.getValues();
                ArrayList<String> list = new ArrayList<String>();
                for (Value value : values) {
                    list.add(value.getString());
                }
                return list.toArray(new String[0]);
            }
            return new String[0];
        }
        catch (RepositoryException e) {
            throw new RulesRepositoryException(e);
        }
    }

    protected long getLongProperty(String property) {
        try {
            Node theNode = this.getVersionContentNode();
            if (theNode.hasProperty(property)) {
                Property data = theNode.getProperty(property);
                return data.getValue().getLong();
            }
            return 0L;
        }
        catch (RepositoryException e) {
            throw new RulesRepositoryException(e);
        }
    }

    public String getVersionSnapshotUUID() {
        try {
            if (this.isHistoricalVersion()) {
                return this.node.getUUID();
            }
            throw new RulesRepositoryException("This is the current version of the asset.");
        }
        catch (RepositoryException e) {
            throw new RulesRepositoryException(e);
        }
    }

    public VersionableItem archiveItem(boolean data) {
        this.checkout();
        try {
            this.node.setProperty(CONTENT_PROPERTY_ARCHIVE_FLAG, data);
            return this;
        }
        catch (RepositoryException e) {
            log.error((Object)"Unable to update this VersionableItem binary archive flag");
            throw new RulesRepositoryException(e);
        }
    }

    public boolean isArchived() {
        try {
            return this.node.getProperty(CONTENT_PROPERTY_ARCHIVE_FLAG).getBoolean();
        }
        catch (RepositoryException e) {
            log.error((Object)"Unable to check this asset");
            throw new RulesRepositoryException(e);
        }
    }
}

