/*
 * Decompiled with CFR 0.152.
 */
package org.drools.repository.security;

import java.security.Principal;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.core.ItemId;
import org.apache.jackrabbit.core.security.AMContext;
import org.apache.jackrabbit.core.security.AccessManager;
import org.apache.log4j.Logger;
import org.drools.repository.security.DroolsRepositoryACLManager;
import org.jboss.security.authorization.AuthorizationException;
import org.jboss.security.identity.Identity;
import org.jboss.security.identity.plugins.IdentityFactory;

public class DroolsRepositoryAccessManager
implements AccessManager {
    private static Logger log = Logger.getLogger(DroolsRepositoryAccessManager.class);
    public static ThreadLocal<Session> adminThreadlocal = new ThreadLocal();
    private String defaultpermission;
    protected Identity identity;
    protected DroolsRepositoryACLManager aclManager;
    private boolean initialized = false;

    public void init(AMContext context) throws AccessDeniedException, Exception {
        if (this.initialized) {
            throw new IllegalStateException("already initialized");
        }
        for (Principal principal : context.getSubject().getPrincipals()) {
            this.identity = IdentityFactory.createIdentity((String)principal.getName());
        }
        this.aclManager = new DroolsRepositoryACLManager(this.identity);
        this.initialized = true;
        log.debug((Object)"Repository Access Manager initialized");
    }

    public synchronized void close() throws Exception {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        Session session = adminThreadlocal.get();
        session.logout();
        this.initialized = false;
    }

    public void checkPermission(ItemId id, int permissions) throws AccessDeniedException, ItemNotFoundException, RepositoryException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        try {
            if (!this.aclManager.checkPermission(id, permissions)) {
                throw new AccessDeniedException("User doesn't have enough permission");
            }
        }
        catch (AuthorizationException authorizationException) {
            // empty catch block
        }
    }

    public boolean isGranted(ItemId id, int permissions) throws ItemNotFoundException, RepositoryException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        if (this.identity.getName() == "ADMINISTRATOR") {
            return true;
        }
        try {
            return this.aclManager.checkPermission(id, permissions);
        }
        catch (Exception e) {
            return true;
        }
    }

    public boolean canAccess(String workspaceName) throws NoSuchWorkspaceException, RepositoryException {
        System.out.println("canAccess: " + workspaceName);
        return true;
    }

    public String getDefaultpermission() {
        return this.defaultpermission;
    }

    public void setDefaultpermission(String defaultpermission) {
        this.defaultpermission = defaultpermission;
    }
}

