/*
 * Decompiled with CFR 0.152.
 */
package org.drools.repository;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.version.Version;
import javax.jcr.version.VersionIterator;
import junit.framework.TestCase;
import org.drools.repository.AssetHistoryIterator;
import org.drools.repository.AssetItem;
import org.drools.repository.CategoryItem;
import org.drools.repository.ItemVersionIterator;
import org.drools.repository.PackageItem;
import org.drools.repository.RepositorySessionUtil;
import org.drools.repository.RulesRepository;
import org.drools.repository.RulesRepositoryException;
import org.drools.repository.StateItem;

public class ShareableAssetItemTest
extends TestCase {
    private RulesRepository getRepo() {
        return RepositorySessionUtil.getRepository();
    }

    private PackageItem loadGlobalArea() {
        return this.getRepo().loadGlobalArea();
    }

    private PackageItem getDefaultPackage() {
        return this.getRepo().loadDefaultPackage();
    }

    public void testCreateShareableAsset() throws Exception {
        Calendar now = Calendar.getInstance();
        Thread.sleep(500L);
        AssetItem ruleItem = this.loadGlobalArea().addAsset("testCreateShareableAssetAsset", "desc");
        ruleItem.updateContent("la");
        ruleItem.checkin("initial");
        AssetItem linkedRuleItem = this.getDefaultPackage().addAssetImportedFromGlobalArea(ruleItem.getName());
        linkedRuleItem.updateContent("laa");
        linkedRuleItem.checkin("second");
        ShareableAssetItemTest.assertEquals((String)"testCreateShareableAssetAsset", (String)linkedRuleItem.getName());
        ShareableAssetItemTest.assertEquals((String)"testCreateShareableAssetAsset", (String)ruleItem.getName());
        ShareableAssetItemTest.assertNotNull((Object)ruleItem.getCreatedDate());
        ShareableAssetItemTest.assertNotNull((Object)linkedRuleItem.getCreatedDate());
        ShareableAssetItemTest.assertTrue((boolean)now.before(ruleItem.getCreatedDate()));
        ShareableAssetItemTest.assertTrue((boolean)now.before(linkedRuleItem.getCreatedDate()));
        ShareableAssetItemTest.assertEquals((String)"globalArea", (String)ruleItem.getPackageName());
        ShareableAssetItemTest.assertEquals((String)"globalArea", (String)linkedRuleItem.getPackageName());
        ShareableAssetItemTest.assertEquals((String)this.loadGlobalArea().getUUID(), (String)ruleItem.getPackage().getUUID());
        ShareableAssetItemTest.assertEquals((String)"laa", (String)linkedRuleItem.getContent());
        ShareableAssetItemTest.assertEquals((String)"laa", (String)ruleItem.getContent());
        ShareableAssetItemTest.assertNotNull((Object)ruleItem.getUUID());
        ShareableAssetItemTest.assertNotNull((Object)linkedRuleItem.getUUID());
        ShareableAssetItemTest.assertTrue((boolean)linkedRuleItem.getUUID().equals(linkedRuleItem.getUUID()));
    }

    public void testRemoveShareableAsset() throws Exception {
        AssetItem asset = this.loadGlobalArea().addAsset("testRemoveShareableAssetAsset", "desc");
        asset.updateContent("la");
        asset.checkin("initial");
        AssetItem linkedAsset = this.getDefaultPackage().addAssetImportedFromGlobalArea(asset.getName());
        linkedAsset.updateContent("laa");
        linkedAsset.checkin("second");
        linkedAsset.remove();
        try {
            AssetItem linkedAsset1 = this.getDefaultPackage().loadAsset("testRemoveShareableAssetAsset");
            ShareableAssetItemTest.fail((String)"Did not get expected exception");
        }
        catch (RulesRepositoryException e) {
            // empty catch block
        }
        AssetItem asset1 = this.loadGlobalArea().loadAsset("testRemoveShareableAssetAsset");
        ShareableAssetItemTest.assertTrue((boolean)asset.getUUID().equals(asset1.getUUID()));
    }

    public void testGetContentLengthForShareableAsset() throws Exception {
        AssetItem ruleItem = this.loadGlobalArea().addAsset("testGetContentLengthForShareableAsset", "desc");
        ruleItem.checkin("initial");
        AssetItem linkedRuleItem = this.getDefaultPackage().addAssetImportedFromGlobalArea(ruleItem.getName());
        ShareableAssetItemTest.assertEquals((long)0L, (long)ruleItem.getContentLength());
        ShareableAssetItemTest.assertEquals((long)0L, (long)linkedRuleItem.getContentLength());
        ruleItem.updateContent("boo");
        ruleItem.checkin("");
        ShareableAssetItemTest.assertEquals((long)"boo".getBytes().length, (long)ruleItem.getContentLength());
        ShareableAssetItemTest.assertEquals((long)"boo".getBytes().length, (long)linkedRuleItem.getContentLength());
        linkedRuleItem.updateContent("booo");
        linkedRuleItem.checkin("");
        ShareableAssetItemTest.assertEquals((long)"booo".getBytes().length, (long)ruleItem.getContentLength());
        ShareableAssetItemTest.assertEquals((long)"booo".getBytes().length, (long)linkedRuleItem.getContentLength());
        ruleItem = this.loadGlobalArea().addAsset("testGetContentLengthForShareableAsset2", "");
        ruleItem.checkin("initial");
        linkedRuleItem = this.getDefaultPackage().addAssetImportedFromGlobalArea(ruleItem.getName());
        ShareableAssetItemTest.assertEquals((long)0L, (long)ruleItem.getContentLength());
        ShareableAssetItemTest.assertEquals((long)0L, (long)linkedRuleItem.getContentLength());
        linkedRuleItem.updateBinaryContentAttachment((InputStream)new ByteArrayInputStream("foobar".getBytes()));
        linkedRuleItem.checkin("");
        ShareableAssetItemTest.assertEquals((long)"foobar".getBytes().length, (long)ruleItem.getContentLength());
        ShareableAssetItemTest.assertEquals((long)"foobar".getBytes().length, (long)linkedRuleItem.getContentLength());
        ruleItem.updateBinaryContentAttachment((InputStream)new ByteArrayInputStream("foobarr".getBytes()));
        ruleItem.checkin("");
        ShareableAssetItemTest.assertEquals((long)"foobarr".getBytes().length, (long)ruleItem.getContentLength());
        ShareableAssetItemTest.assertEquals((long)"foobarr".getBytes().length, (long)linkedRuleItem.getContentLength());
    }

    public void testUpdateStringPropertyForShareableAsset() throws Exception {
        AssetItem asset = this.loadGlobalArea().addAsset("testUpdateStringPropertyForShareableAsset", "desc");
        asset.checkin("initial");
        AssetItem linkedAsset = this.getDefaultPackage().addAssetImportedFromGlobalArea(asset.getName());
        linkedAsset.updateContent("new content");
        linkedAsset.checkin("");
        linkedAsset.updateStringProperty("Anything", "AField");
        ShareableAssetItemTest.assertEquals((String)"Anything", (String)linkedAsset.getStringProperty("AField"));
        ShareableAssetItemTest.assertEquals((String)"Anything", (String)asset.getStringProperty("AField"));
        asset.updateStringProperty("More", "AField", false);
        asset.updateContent("more content");
        asset.checkin("");
        asset = this.getRepo().loadAssetByUUID(asset.getUUID());
        ShareableAssetItemTest.assertEquals((String)"More", (String)asset.getStringProperty("AField"));
        ShareableAssetItemTest.assertEquals((String)"more content", (String)asset.getContent());
        linkedAsset = this.getRepo().loadAssetByUUID(linkedAsset.getUUID());
        ShareableAssetItemTest.assertEquals((String)"More", (String)linkedAsset.getStringProperty("AField"));
        ShareableAssetItemTest.assertEquals((String)"more content", (String)asset.getContent());
    }

    public void testGetPackageItemHistoricalForShareableAsset() throws Exception {
        AssetItem asset = this.loadGlobalArea().addAsset("testGetPackageItemHistoricalForShareableAsset", "test content");
        asset.checkin("initial");
        AssetItem linkedAsset = this.getDefaultPackage().addAssetImportedFromGlobalArea(asset.getName());
        this.getRepo().createPackageSnapshot(this.getDefaultPackage().getName(), "SNAP");
        PackageItem pkgSnap = this.getRepo().loadPackageSnapshot(this.getDefaultPackage().getName(), "SNAP");
        AssetItem assetSnap = pkgSnap.loadAsset("testGetPackageItemHistoricalForShareableAsset");
        PackageItem pkgSnap1 = assetSnap.getPackage();
        ShareableAssetItemTest.assertTrue((boolean)pkgSnap1.isSnapshot());
        ShareableAssetItemTest.assertTrue((boolean)pkgSnap.isSnapshot());
        ShareableAssetItemTest.assertFalse((boolean)this.getDefaultPackage().isSnapshot());
        ShareableAssetItemTest.assertEquals((String)this.getDefaultPackage().getName(), (String)pkgSnap1.getName());
        AssetItem linkedAsset1 = this.getDefaultPackage().loadAsset("testGetPackageItemHistoricalForShareableAsset");
        PackageItem linkedPkg = linkedAsset1.getPackage();
        ShareableAssetItemTest.assertFalse((boolean)linkedPkg.isSnapshot());
        ShareableAssetItemTest.assertFalse((boolean)this.getDefaultPackage().isSnapshot());
        ShareableAssetItemTest.assertEquals((String)this.getDefaultPackage().getName(), (String)linkedPkg.getName());
        linkedAsset.updateDescription("yeah !");
        linkedAsset.checkin("new");
        linkedAsset = this.getDefaultPackage().loadAsset("testGetPackageItemHistoricalForShareableAsset");
        ShareableAssetItemTest.assertNotNull((Object)linkedAsset.getPackage());
        AssetHistoryIterator linkedIt = linkedAsset.getHistory();
        ShareableAssetItemTest.assertEquals((int)4, (int)this.iteratorToList((Iterator)linkedIt).size());
        asset = this.getDefaultPackage().loadAsset("testGetPackageItemHistoricalForShareableAsset");
        AssetHistoryIterator it = asset.getHistory();
        ShareableAssetItemTest.assertEquals((int)4, (int)this.iteratorToList((Iterator)it).size());
    }

    List iteratorToList(Iterator it) {
        ArrayList list = new ArrayList();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    public void testGetContentForShareableAsset() {
        AssetItem asset = this.getRepo().loadGlobalArea().addAsset("testGetContentForShareableAsset", "test content");
        AssetItem linkedAsset = this.getRepo().loadDefaultPackage().addAssetImportedFromGlobalArea(asset.getName());
        linkedAsset.updateContent("test content");
        linkedAsset.updateFormat("drl");
        ShareableAssetItemTest.assertNotNull((Object)linkedAsset.getNode());
        ShareableAssetItemTest.assertEquals((String)"test content", (String)linkedAsset.getContent());
        ShareableAssetItemTest.assertEquals((String)"test content", (String)asset.getContent());
        ShareableAssetItemTest.assertFalse((boolean)linkedAsset.isBinary());
        ShareableAssetItemTest.assertFalse((boolean)asset.isBinary());
        ShareableAssetItemTest.assertNotNull((Object)linkedAsset.getBinaryContentAsBytes());
        ShareableAssetItemTest.assertNotNull((Object)linkedAsset.getBinaryContentAttachment());
        String content = new String(linkedAsset.getBinaryContentAsBytes());
        ShareableAssetItemTest.assertNotNull((Object)content);
        content = new String(asset.getBinaryContentAsBytes());
        ShareableAssetItemTest.assertNotNull((Object)content);
    }

    public void testUpdateContentForShareableAsset() throws Exception {
        AssetItem asset = this.getRepo().loadGlobalArea().addAsset("testUpdateContentForShareableAsset", "test content");
        AssetItem linkedAsset = this.getRepo().loadDefaultPackage().addAssetImportedFromGlobalArea(asset.getName());
        ShareableAssetItemTest.assertFalse((boolean)asset.getCreator().equals(""));
        ShareableAssetItemTest.assertFalse((boolean)linkedAsset.getCreator().equals(""));
        linkedAsset.updateContent("test content");
        linkedAsset.checkin("yeah");
        ShareableAssetItemTest.assertFalse((boolean)linkedAsset.getLastContributor().equals(""));
        ShareableAssetItemTest.assertFalse((boolean)asset.getLastContributor().equals(""));
        linkedAsset.updateContent("new rule content");
        ShareableAssetItemTest.assertEquals((String)"new rule content", (String)linkedAsset.getContent());
        ShareableAssetItemTest.assertTrue((boolean)linkedAsset.getNode().getSession().hasPendingChanges());
        ShareableAssetItemTest.assertTrue((boolean)asset.getNode().getSession().hasPendingChanges());
        asset.checkin("yeah !");
        ShareableAssetItemTest.assertFalse((boolean)asset.getNode().getSession().hasPendingChanges());
        ShareableAssetItemTest.assertEquals((String)"yeah !", (String)asset.getCheckinComment());
        try {
            linkedAsset.checkin("yeah linked !");
            ShareableAssetItemTest.fail((String)"Did not get expected exception: Unable to checkin");
        }
        catch (RulesRepositoryException e) {
            // empty catch block
        }
        AssetItem prev = (AssetItem)asset.getPrecedingVersion();
        ShareableAssetItemTest.assertEquals((String)"test content", (String)prev.getContent());
        ShareableAssetItemTest.assertFalse((boolean)"yeah !".equals(prev.getCheckinComment()));
        asset = this.getDefaultPackage().loadAsset("testUpdateContentForShareableAsset");
        VersionIterator it = asset.getNode().getVersionHistory().getAllVersions();
        ShareableAssetItemTest.assertTrue((boolean)it.hasNext());
        while (it.hasNext()) {
            Version n = it.nextVersion();
            AssetItem item = new AssetItem(asset.getRulesRepository(), (Node)n);
            ShareableAssetItemTest.assertNotNull((Object)item);
        }
    }

    public void testCategoriesForShareableAsset() {
        this.getRepo().loadCategory("/").addCategory("testCategoriesTag", "description");
        this.getRepo().loadCategory("/").addCategory("testCategoriesTag2", "description");
        AssetItem asset = this.getRepo().loadGlobalArea().addAsset("testCategoriesForShareableAsset", "desc");
        AssetItem linkedAsset = this.getDefaultPackage().addAssetImportedFromGlobalArea(asset.getName());
        linkedAsset.addCategory("testCategoriesTag");
        List tags = linkedAsset.getCategories();
        ShareableAssetItemTest.assertEquals((int)1, (int)tags.size());
        ShareableAssetItemTest.assertEquals((String)"testCategoriesTag", (String)((CategoryItem)tags.get(0)).getName());
        linkedAsset.addCategory("testCategoriesTag2");
        tags = linkedAsset.getCategories();
        ShareableAssetItemTest.assertEquals((int)2, (int)tags.size());
        linkedAsset.checkin("woot");
        List result = this.getRepo().findAssetsByCategory((String)"testCategoriesTag", (int)0, (int)-1).assets;
        ShareableAssetItemTest.assertEquals((int)1, (int)result.size());
        AssetItem retItem = (AssetItem)result.get(0);
        ShareableAssetItemTest.assertEquals((String)"testCategoriesForShareableAsset", (String)retItem.getName());
        asset.updateContent("foo");
        asset.checkin("latest");
        ShareableAssetItemTest.assertTrue((asset.getCategories().size() > 0 ? 1 : 0) != 0);
        ShareableAssetItemTest.assertNotNull((Object)asset.getCategorySummary());
        ShareableAssetItemTest.assertEquals((String)"testCategoriesTag testCategoriesTag2 ", (String)asset.getCategorySummary());
        result = this.getRepo().findAssetsByCategory((String)"testCategoriesTag2", (int)0, (int)-1).assets;
        ShareableAssetItemTest.assertEquals((int)1, (int)result.size());
        asset = (AssetItem)result.get(0);
        ShareableAssetItemTest.assertEquals((int)2, (int)asset.getCategories().size());
    }

    public void testUpdateCategoriesForShareableAsset() {
        this.getRepo().loadCategory("/").addCategory("testUpdateCategoriesForShareableAssetTag1", "la");
        this.getRepo().loadCategory("/").addCategory("testUpdateCategoriesForShareableAssetTag2", "la");
        AssetItem asset = this.getRepo().loadGlobalArea().addAsset("testUpdateCategoriesForShareableAsset", "desc");
        AssetItem linkedAsset = this.getDefaultPackage().addAssetImportedFromGlobalArea(asset.getName());
        String[] cats = new String[]{"testUpdateCategoriesForShareableAssetTag1", "testUpdateCategoriesForShareableAssetTag2"};
        linkedAsset.updateCategoryList(cats);
        linkedAsset.checkin("aaa");
        asset = this.getRepo().loadGlobalArea().loadAsset("testUpdateCategoriesForShareableAsset");
        ShareableAssetItemTest.assertEquals((int)2, (int)asset.getCategories().size());
        for (CategoryItem cat : asset.getCategories()) {
            ShareableAssetItemTest.assertTrue((boolean)cat.getName().startsWith("testUpdateCategoriesForShareableAssetTag"));
        }
    }

    public void testRemoveTagForShareableAsset() {
        this.getRepo().loadCategory("/").addCategory("testRemoveTagForShareableAssetTag1", "la");
        this.getRepo().loadCategory("/").addCategory("testRemoveTagForShareableAssetTag2", "description");
        this.getRepo().loadCategory("/").addCategory("testRemoveTagForShareableAssetTag3", "description");
        AssetItem asset = this.getRepo().loadGlobalArea().addAsset("testRemoveTagForShareableAsset", "desc");
        AssetItem linkedAsset = this.getDefaultPackage().addAssetImportedFromGlobalArea(asset.getName());
        linkedAsset.addCategory("testRemoveTagForShareableAssetTag1");
        List tags = linkedAsset.getCategories();
        ShareableAssetItemTest.assertEquals((int)1, (int)tags.size());
        linkedAsset.removeCategory("testRemoveTagForShareableAssetTag1");
        tags = linkedAsset.getCategories();
        ShareableAssetItemTest.assertEquals((int)0, (int)tags.size());
        linkedAsset.addCategory("testRemoveTagForShareableAssetTag2");
        linkedAsset.addCategory("testRemoveTagForShareableAssetTag3");
        linkedAsset.checkin("aaa");
        linkedAsset.removeCategory("testRemoveTagForShareableAssetTag3");
        linkedAsset.checkin("aaa");
        this.getRepo().save();
        tags = linkedAsset.getCategories();
        ShareableAssetItemTest.assertEquals((int)1, (int)tags.size());
        ShareableAssetItemTest.assertEquals((String)"testRemoveTagForShareableAssetTag2", (String)((CategoryItem)tags.get(0)).getName());
        try {
            this.getRepo().loadCategory("testRemoveTagForShareableAssetTag2").remove();
            ShareableAssetItemTest.fail((String)"should not be able to remove");
        }
        catch (RulesRepositoryException e) {
            ShareableAssetItemTest.assertNotNull((Object)e.getMessage());
        }
    }

    public void testStatusStufftestRemoveTagForShareableAsset() {
        this.getRepo().createState("testStatusStufftestRemoveTagForShareableAssetStatus");
        AssetItem asset = this.getRepo().loadGlobalArea().addAsset("testStatusStufftestRemoveTagForShareableAsset", "desc");
        AssetItem linkedAsset = this.getDefaultPackage().addAssetImportedFromGlobalArea(asset.getName());
        StateItem stateItem1 = linkedAsset.getState();
        ShareableAssetItemTest.assertEquals((String)"Draft", (String)stateItem1.getName());
        ShareableAssetItemTest.assertEquals((Object)this.getRepo().getState("Draft"), (Object)linkedAsset.getState());
        ShareableAssetItemTest.assertEquals((String)"Draft", (String)linkedAsset.getStateDescription());
        linkedAsset.updateState("testStatusStufftestRemoveTagForShareableAssetStatus");
        ShareableAssetItemTest.assertEquals((String)"testStatusStufftestRemoveTagForShareableAssetStatus", (String)linkedAsset.getState().getName());
    }

    public void testGetDateEffectiveForShareableAsset() {
        AssetItem asset = this.getRepo().loadGlobalArea().addAsset("testGetDateEffectiveForShareableAsset", "desc");
        AssetItem linkedAsset = this.getDefaultPackage().addAssetImportedFromGlobalArea(asset.getName());
        ShareableAssetItemTest.assertTrue((linkedAsset.getDateEffective() == null ? 1 : 0) != 0);
        Calendar cal = Calendar.getInstance();
        linkedAsset.updateDateEffective(cal);
        Calendar cal2 = linkedAsset.getDateEffective();
        ShareableAssetItemTest.assertEquals((Object)cal, (Object)cal2);
    }

    public void testGetDateExpiredForShareableAsset() {
        AssetItem asset = this.getRepo().loadGlobalArea().addAsset("testGetDateExpiredForShareableAsset", "desc");
        AssetItem linkedAsset = this.getDefaultPackage().addAssetImportedFromGlobalArea(asset.getName());
        ShareableAssetItemTest.assertTrue((linkedAsset.getDateExpired() == null ? 1 : 0) != 0);
        Calendar cal = Calendar.getInstance();
        linkedAsset.updateDateExpired(cal);
        Calendar cal2 = linkedAsset.getDateExpired();
        ShareableAssetItemTest.assertEquals((Object)cal, (Object)cal2);
    }

    public void testSaveAndCheckinDescriptionAndTitleForShareableAsset() throws Exception {
        AssetItem asset = this.getRepo().loadGlobalArea().addAsset("testSaveAndCheckinDescriptionAndTitleForShareableAsset", "desc");
        asset.checkin("version0");
        AssetItem linkedAsset = this.getDefaultPackage().addAssetImportedFromGlobalArea(asset.getName());
        ShareableAssetItemTest.assertEquals((String)"desc", (String)linkedAsset.getDescription());
        linkedAsset.updateDescription("test description");
        ShareableAssetItemTest.assertEquals((String)"test description", (String)linkedAsset.getDescription());
        ShareableAssetItemTest.assertTrue((boolean)this.getRepo().getSession().hasPendingChanges());
        linkedAsset.updateTitle("This is a title");
        ShareableAssetItemTest.assertTrue((boolean)this.getRepo().getSession().hasPendingChanges());
        linkedAsset.checkin("ya");
        this.getRepo().getSession().save();
        ShareableAssetItemTest.assertFalse((boolean)this.getRepo().getSession().hasPendingChanges());
        try {
            linkedAsset.getPrecedingVersion().updateTitle("baaad");
            ShareableAssetItemTest.fail((String)"should not be able to do this");
        }
        catch (RulesRepositoryException e) {
            ShareableAssetItemTest.assertNotNull((Object)e.getMessage());
        }
    }

    public void testGetPrecedingVersionAndRestoreForShareableAsset() throws Exception {
        this.getRepo().loadCategory("/").addCategory("testGetPrecedingVersionAndRestoreCat", "ka");
        AssetItem asset = this.getRepo().loadGlobalArea().addAsset("testGetPrecedingVersionAndRestoreForShareableAsset", "desc");
        asset.checkin("version0");
        AssetItem linkedAsset = this.getDefaultPackage().addAssetImportedFromGlobalArea(asset.getName());
        ShareableAssetItemTest.assertNotNull((Object)asset.getPrecedingVersion());
        ShareableAssetItemTest.assertNotNull((Object)linkedAsset.getPrecedingVersion());
        linkedAsset.addCategory("testGetPrecedingVersionAndRestoreCat");
        linkedAsset.updateContent("test content");
        linkedAsset.updateDescription("descr2");
        Thread.sleep(100L);
        linkedAsset.checkin("boo");
        AssetItem predecessorRuleItem = (AssetItem)linkedAsset.getPrecedingVersion();
        ShareableAssetItemTest.assertNotNull((Object)predecessorRuleItem);
        ShareableAssetItemTest.assertNotNull((Object)predecessorRuleItem.getVersionSnapshotUUID());
        ShareableAssetItemTest.assertFalse((boolean)predecessorRuleItem.getVersionSnapshotUUID().equals(asset.getUUID()));
        ShareableAssetItemTest.assertEquals((String)asset.getState().getName(), (String)predecessorRuleItem.getState().getName());
        AssetItem loadedHistorical = this.getRepo().loadAssetByUUID(predecessorRuleItem.getVersionSnapshotUUID());
        ShareableAssetItemTest.assertTrue((boolean)loadedHistorical.isHistoricalVersion());
        ShareableAssetItemTest.assertFalse((asset.getVersionNumber() == loadedHistorical.getVersionNumber() ? 1 : 0) != 0);
        linkedAsset.updateContent("new content");
        linkedAsset.checkin("two changes");
        predecessorRuleItem = (AssetItem)linkedAsset.getPrecedingVersion();
        ShareableAssetItemTest.assertNotNull((Object)predecessorRuleItem);
        ShareableAssetItemTest.assertEquals((int)1, (int)predecessorRuleItem.getCategories().size());
        CategoryItem cat = (CategoryItem)predecessorRuleItem.getCategories().get(0);
        ShareableAssetItemTest.assertEquals((String)"testGetPrecedingVersionAndRestoreCat", (String)cat.getName());
        ShareableAssetItemTest.assertEquals((String)"test content", (String)predecessorRuleItem.getContent());
        ShareableAssetItemTest.assertEquals((String)this.getRepo().loadGlobalArea().getName(), (String)predecessorRuleItem.getPackageName());
        linkedAsset.updateContent("newer lhs");
        linkedAsset.checkin("another");
        predecessorRuleItem = (AssetItem)linkedAsset.getPrecedingVersion();
        ShareableAssetItemTest.assertNotNull((Object)predecessorRuleItem);
        ShareableAssetItemTest.assertEquals((String)"new content", (String)predecessorRuleItem.getContent());
        predecessorRuleItem = (AssetItem)predecessorRuleItem.getPrecedingVersion();
        ShareableAssetItemTest.assertNotNull((Object)predecessorRuleItem);
        ShareableAssetItemTest.assertEquals((String)"test content", (String)predecessorRuleItem.getContent());
        long oldVersionNumber = asset.getVersionNumber();
        AssetItem toRestore = this.getRepo().loadAssetByUUID(predecessorRuleItem.getVersionSnapshotUUID());
        this.getRepo().restoreHistoricalAsset(toRestore, linkedAsset, "cause I want to");
        AssetItem restored = this.getRepo().loadDefaultPackage().loadAsset("testGetPrecedingVersionAndRestoreForShareableAsset");
        ShareableAssetItemTest.assertEquals((String)predecessorRuleItem.getDescription(), (String)restored.getDescription());
        ShareableAssetItemTest.assertEquals((String)"cause I want to", (String)restored.getCheckinComment());
        ShareableAssetItemTest.assertEquals((long)6L, (long)restored.getVersionNumber());
        ShareableAssetItemTest.assertFalse((oldVersionNumber == restored.getVersionNumber() ? 1 : 0) != 0);
    }

    public void testGetSucceedingVersionForShareableAsset() {
        AssetItem asset = this.getRepo().loadGlobalArea().addAsset("testGetSucceedingVersionForShareableAsset", "desc");
        asset.checkin("version0");
        AssetItem linkedAsset = this.getDefaultPackage().addAssetImportedFromGlobalArea(asset.getName());
        ShareableAssetItemTest.assertEquals((long)2L, (long)asset.getVersionNumber());
        linkedAsset.updateContent("new content1");
        linkedAsset.checkin("la");
        AssetItem succeedingRuleItem = (AssetItem)linkedAsset.getSucceedingVersion();
        ShareableAssetItemTest.assertTrue((succeedingRuleItem == null ? 1 : 0) != 0);
        linkedAsset.updateContent("new content2");
        linkedAsset.checkin("la");
        ShareableAssetItemTest.assertEquals((long)4L, (long)linkedAsset.getVersionNumber());
        AssetItem predecessorRuleItem = (AssetItem)linkedAsset.getPrecedingVersion();
        ShareableAssetItemTest.assertEquals((String)"new content1", (String)predecessorRuleItem.getContent());
        succeedingRuleItem = (AssetItem)predecessorRuleItem.getSucceedingVersion();
        ShareableAssetItemTest.assertNotNull((Object)succeedingRuleItem);
        ShareableAssetItemTest.assertEquals((String)linkedAsset.getContent(), (String)succeedingRuleItem.getContent());
    }

    public void testGetSuccessorVersionsIteratorForShareableAsset() {
        AssetItem asset = this.getRepo().loadGlobalArea().addAsset("testGetSuccessorVersionsIteratorForShareableAsset", "desc");
        asset.checkin("version0");
        AssetItem linkedAsset = this.getDefaultPackage().addAssetImportedFromGlobalArea(asset.getName());
        ItemVersionIterator iterator = linkedAsset.getSuccessorVersionsIterator();
        ShareableAssetItemTest.assertNotNull((Object)iterator);
        ShareableAssetItemTest.assertFalse((boolean)iterator.hasNext());
        linkedAsset.updateContent("new content").checkin("ya");
        iterator = linkedAsset.getSuccessorVersionsIterator();
        ShareableAssetItemTest.assertNotNull((Object)iterator);
        ShareableAssetItemTest.assertFalse((boolean)iterator.hasNext());
        AssetItem predecessorRuleItem = (AssetItem)linkedAsset.getPrecedingVersion();
        iterator = predecessorRuleItem.getSuccessorVersionsIterator();
        ShareableAssetItemTest.assertNotNull((Object)iterator);
        ShareableAssetItemTest.assertTrue((boolean)iterator.hasNext());
        AssetItem nextRuleItem = (AssetItem)iterator.next();
        ShareableAssetItemTest.assertEquals((String)"new content", (String)nextRuleItem.getContent());
        ShareableAssetItemTest.assertFalse((boolean)iterator.hasNext());
        linkedAsset.updateContent("newer content");
        linkedAsset.checkin("boo");
        iterator = predecessorRuleItem.getSuccessorVersionsIterator();
        ShareableAssetItemTest.assertNotNull((Object)iterator);
        ShareableAssetItemTest.assertTrue((boolean)iterator.hasNext());
        nextRuleItem = (AssetItem)iterator.next();
        ShareableAssetItemTest.assertEquals((String)"new content", (String)nextRuleItem.getContent());
        ShareableAssetItemTest.assertTrue((boolean)iterator.hasNext());
        nextRuleItem = (AssetItem)iterator.next();
        ShareableAssetItemTest.assertEquals((String)"newer content", (String)nextRuleItem.getContent());
        ShareableAssetItemTest.assertFalse((boolean)iterator.hasNext());
    }

    public void testGetPredecessorVersionsIteratorForShareableAsset() {
        AssetItem asset = this.getRepo().loadGlobalArea().addAsset("testGetPredecessorVersionsIteratorForShareableAsset", "desc");
        asset.checkin("version0");
        AssetItem linkedAsset = this.getDefaultPackage().addAssetImportedFromGlobalArea(asset.getName());
        linkedAsset.updateContent("test content");
        linkedAsset.checkin("lalalalala");
        ItemVersionIterator iterator = linkedAsset.getPredecessorVersionsIterator();
        ShareableAssetItemTest.assertNotNull((Object)iterator);
        ShareableAssetItemTest.assertTrue((boolean)iterator.hasNext());
        asset.updateContent("new content");
        asset.checkin("boo");
        iterator = linkedAsset.getPredecessorVersionsIterator();
        ShareableAssetItemTest.assertNotNull((Object)iterator);
        ShareableAssetItemTest.assertTrue((boolean)iterator.hasNext());
        AssetItem nextRuleItem = (AssetItem)iterator.next();
        ShareableAssetItemTest.assertEquals((String)"test content", (String)nextRuleItem.getContent());
        asset.updateContent("newer content");
        asset.checkin("wee");
        iterator = linkedAsset.getPredecessorVersionsIterator();
        ShareableAssetItemTest.assertNotNull((Object)iterator);
        ShareableAssetItemTest.assertTrue((boolean)iterator.hasNext());
        nextRuleItem = (AssetItem)iterator.next();
        ShareableAssetItemTest.assertTrue((boolean)iterator.hasNext());
        ShareableAssetItemTest.assertEquals((String)"new content", (String)nextRuleItem.getContent());
        nextRuleItem = (AssetItem)iterator.next();
        ShareableAssetItemTest.assertEquals((String)"test content", (String)nextRuleItem.getContent());
        ShareableAssetItemTest.assertEquals((String)"", (String)((AssetItem)iterator.next()).getContent());
    }

    public void testHistoryIteratorForShareableAsset() throws Exception {
        AssetItem asset = this.getRepo().loadGlobalArea().addAsset("testHistoryIteratorForShareableAsset", "desc");
        asset.checkin("version0");
        AssetItem linkedAsset = this.getDefaultPackage().addAssetImportedFromGlobalArea(asset.getName());
        linkedAsset = this.getRepo().loadAssetByUUID(linkedAsset.getUUID());
        linkedAsset.updateContent("wo");
        linkedAsset.checkin("version2");
        asset = this.getRepo().loadAssetByUUID(asset.getUUID());
        asset.updateContent("ya");
        asset.checkin("version3");
        AssetHistoryIterator it = asset.getHistory();
        for (int i = 0; i < 3; ++i) {
            ShareableAssetItemTest.assertTrue((boolean)it.hasNext());
            it.next();
        }
    }

    public void testGetTitleForShareableAsset() {
        AssetItem asset = this.getRepo().loadGlobalArea().addAsset("testGetTitleForShareableAsset", "desc");
        asset.checkin("version0");
        AssetItem linkedAsset = this.getDefaultPackage().addAssetImportedFromGlobalArea(asset.getName());
        ShareableAssetItemTest.assertEquals((String)"testGetTitleForShareableAsset", (String)linkedAsset.getName());
        ShareableAssetItemTest.assertEquals((String)"testGetTitleForShareableAsset", (String)asset.getName());
        ShareableAssetItemTest.assertEquals((String)"testGetTitleForShareableAsset", (String)linkedAsset.getTitle());
        ShareableAssetItemTest.assertEquals((String)"testGetTitleForShareableAsset", (String)asset.getTitle());
    }

    public void testDublinCorePropertiesForShareableAsset() {
        AssetItem asset = this.getRepo().loadGlobalArea().addAsset("testDublinCorePropertiesForShareableAsset", "desc");
        asset.checkin("version0");
        AssetItem linkedAsset = this.getDefaultPackage().addAssetImportedFromGlobalArea(asset.getName());
        linkedAsset.updateCoverage("b");
        ShareableAssetItemTest.assertEquals((String)"b", (String)linkedAsset.getCoverage());
        linkedAsset.checkin("woo");
        linkedAsset = this.getDefaultPackage().loadAsset("testDublinCorePropertiesForShareableAsset");
        ShareableAssetItemTest.assertEquals((String)"b", (String)linkedAsset.getCoverage());
        ShareableAssetItemTest.assertEquals((String)"", (String)linkedAsset.getExternalRelation());
        ShareableAssetItemTest.assertEquals((String)"", (String)linkedAsset.getExternalSource());
        linkedAsset = this.getRepo().loadGlobalArea().loadAsset("testDublinCorePropertiesForShareableAsset");
        ShareableAssetItemTest.assertEquals((String)"b", (String)linkedAsset.getCoverage());
        ShareableAssetItemTest.assertEquals((String)"", (String)linkedAsset.getExternalRelation());
        ShareableAssetItemTest.assertEquals((String)"", (String)linkedAsset.getExternalSource());
    }

    public void testGetFormatForShareableAsset() throws Exception {
        AssetItem asset = this.getRepo().loadGlobalArea().addAsset("testGetFormatForShareableAsset", "desc");
        asset.checkin("version0");
        AssetItem linkedAsset = this.getDefaultPackage().addAssetImportedFromGlobalArea(asset.getName());
        linkedAsset.updateContent("la");
        ShareableAssetItemTest.assertEquals((String)"txt", (String)linkedAsset.getFormat());
        ShareableAssetItemTest.assertTrue((boolean)linkedAsset.getNode().hasProperty("drools:content"));
        ShareableAssetItemTest.assertFalse((boolean)linkedAsset.getNode().hasProperty("drools:binaryContent"));
        linkedAsset.updateFormat("blah");
        ShareableAssetItemTest.assertEquals((String)"blah", (String)linkedAsset.getFormat());
    }

    public void testAnonymousPropertiesForShareableAsset() {
        AssetItem asset = this.getRepo().loadGlobalArea().addAsset("testAnonymousPropertiesForShareableAsset", "desc");
        asset.checkin("version0");
        AssetItem linkedAsset = this.getDefaultPackage().addAssetImportedFromGlobalArea(asset.getName());
        linkedAsset.updateUserProperty("fooBar", "value");
        ShareableAssetItemTest.assertEquals((String)"value", (String)linkedAsset.getUserProperty("fooBar"));
        linkedAsset.checkin("lalalala");
        try {
            linkedAsset.updateUserProperty("drools:content", "whee");
            ShareableAssetItemTest.fail((String)"should not be able to set built in properties this way.");
        }
        catch (IllegalArgumentException e) {
            ShareableAssetItemTest.assertNotNull((Object)e.getMessage());
        }
    }

    public void testBinaryAssetForShareableAsset() throws Exception {
        AssetItem asset = this.getRepo().loadGlobalArea().addAsset("testBinaryAssetForShareableAsset", "desc");
        asset.checkin("version0");
        AssetItem linkedAsset = this.getDefaultPackage().addAssetImportedFromGlobalArea(asset.getName());
        String data = "abc 123";
        ByteArrayInputStream in = new ByteArrayInputStream(data.getBytes());
        linkedAsset.updateBinaryContentAttachment((InputStream)in);
        linkedAsset.updateBinaryContentAttachmentFileName("x.x");
        in.close();
        ShareableAssetItemTest.assertEquals((String)data, (String)linkedAsset.getContent());
        ShareableAssetItemTest.assertFalse((boolean)linkedAsset.getNode().hasProperty("drools:content"));
        ShareableAssetItemTest.assertTrue((boolean)linkedAsset.getNode().hasProperty("drools:binaryContent"));
        linkedAsset.checkin("lalalala");
        ShareableAssetItemTest.assertTrue((boolean)linkedAsset.isBinary());
        asset = this.getRepo().loadGlobalArea().loadAsset("testBinaryAssetForShareableAsset");
        InputStream in2 = asset.getBinaryContentAttachment();
        ShareableAssetItemTest.assertNotNull((Object)in2);
        byte[] data2 = asset.getBinaryContentAsBytes();
        ShareableAssetItemTest.assertEquals((String)data, (String)new String(data2));
        ShareableAssetItemTest.assertEquals((String)"x.x", (String)asset.getBinaryContentAttachmentFileName());
        ShareableAssetItemTest.assertTrue((boolean)asset.isBinary());
        linkedAsset.updateContent("qed");
        linkedAsset.checkin("");
        linkedAsset = this.getRepo().loadAssetByUUID(linkedAsset.getUUID());
        ShareableAssetItemTest.assertEquals((String)"qed", (String)linkedAsset.getContent());
    }
}

