/*
 * Decompiled with CFR 0.152.
 */
package org.drools.repository;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Calendar;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.version.Version;
import javax.jcr.version.VersionIterator;
import junit.framework.TestCase;
import org.drools.repository.AssetHistoryIterator;
import org.drools.repository.AssetItem;
import org.drools.repository.AssetPageList;
import org.drools.repository.CategoryItem;
import org.drools.repository.ItemVersionIterator;
import org.drools.repository.PackageItem;
import org.drools.repository.RepositorySessionUtil;
import org.drools.repository.RulesRepository;
import org.drools.repository.RulesRepositoryException;
import org.drools.repository.StateItem;
import org.drools.repository.VersionableItem;

public class AssetItemTest
extends TestCase {
    private RulesRepository getRepo() {
        return RepositorySessionUtil.getRepository();
    }

    private PackageItem getDefaultPackage() {
        return this.getRepo().loadDefaultPackage();
    }

    public void testAssetItemCreation() throws Exception {
        Calendar now = Calendar.getInstance();
        Thread.sleep(500L);
        AssetItem ruleItem1 = this.getDefaultPackage().addAsset("testRuleItem", "test content");
        AssetItemTest.assertNotNull((Object)ruleItem1);
        AssetItemTest.assertNotNull((Object)ruleItem1.getNode());
        AssetItemTest.assertEquals((String)"testRuleItem", (String)ruleItem1.getName());
        AssetItemTest.assertNotNull((Object)ruleItem1.getCreatedDate());
        AssetItemTest.assertTrue((boolean)now.before(ruleItem1.getCreatedDate()));
        String packName = this.getDefaultPackage().getName();
        AssetItemTest.assertEquals((String)packName, (String)ruleItem1.getPackageName());
        AssetItemTest.assertNotNull((Object)ruleItem1.getUUID());
        try {
            PackageItem pitem = this.getRepo().loadDefaultPackage();
            new AssetItem(this.getRepo(), pitem.getNode());
            AssetItemTest.fail((String)"Exception not thrown for node of wrong type");
        }
        catch (RulesRepositoryException e) {
            AssetItemTest.assertNotNull((Object)e.getMessage());
        }
        catch (Exception e) {
            AssetItemTest.fail((String)("Caught unexpected exception: " + e));
        }
    }

    public void testGetContentLength() throws Exception {
        RulesRepository repo = this.getRepo();
        PackageItem pkg = repo.loadDefaultPackage();
        AssetItem asset = pkg.addAsset("testGetContentLength", "");
        AssetItemTest.assertEquals((long)0L, (long)asset.getContentLength());
        asset.updateContent("boo");
        asset.checkin("");
        AssetItemTest.assertEquals((long)"boo".getBytes().length, (long)asset.getContentLength());
        asset = pkg.addAsset("testGetContentLength2", "");
        AssetItemTest.assertEquals((long)0L, (long)asset.getContentLength());
        asset.updateBinaryContentAttachment((InputStream)new ByteArrayInputStream("foobar".getBytes()));
        asset.checkin("");
        AssetItemTest.assertEquals((long)"foobar".getBytes().length, (long)asset.getContentLength());
    }

    public void testGetPackageItem() throws Exception {
        RulesRepository repo = this.getRepo();
        PackageItem def = repo.loadDefaultPackage();
        AssetItem asset = repo.loadDefaultPackage().addAsset("testPackageItem", "test content");
        PackageItem pkg = asset.getPackage();
        AssetItemTest.assertEquals((String)def.getName(), (String)pkg.getName());
        AssetItemTest.assertEquals((String)def.getUUID(), (String)pkg.getUUID());
    }

    public void testUpdateStringProperty() throws Exception {
        RulesRepository repo = this.getRepo();
        PackageItem def = repo.loadDefaultPackage();
        AssetItem asset = repo.loadDefaultPackage().addAsset("testUpdateStringProperty", "test content");
        asset.updateContent("new content");
        asset.checkin("");
        Calendar lm = asset.getLastModified();
        Thread.sleep(100L);
        asset.updateStringProperty("Anything", "AField");
        AssetItemTest.assertEquals((String)"Anything", (String)asset.getStringProperty("AField"));
        Calendar lm_ = asset.getLastModified();
        AssetItemTest.assertTrue((lm_.getTimeInMillis() > lm.getTimeInMillis() ? 1 : 0) != 0);
        Thread.sleep(100L);
        asset.updateStringProperty("More", "AField", false);
        AssetItemTest.assertEquals((long)lm_.getTimeInMillis(), (long)asset.getLastModified().getTimeInMillis());
        asset.updateContent("more content");
        asset.checkin("");
        asset = repo.loadAssetByUUID(asset.getUUID());
        AssetItemTest.assertEquals((String)"More", (String)asset.getStringProperty("AField"));
    }

    public void testGetPackageItemHistorical() throws Exception {
        RulesRepository repo = this.getRepo();
        PackageItem pkg = repo.createPackage("testGetPackageItemHistorical", "");
        AssetItem asset = pkg.addAsset("whee", "");
        asset.checkin("");
        AssetItemTest.assertNotNull((Object)asset.getPackage());
        repo.createPackageSnapshot(pkg.getName(), "SNAP");
        PackageItem pkg_ = repo.loadPackageSnapshot(pkg.getName(), "SNAP");
        AssetItem asset_ = pkg_.loadAsset("whee");
        PackageItem pkg__ = asset_.getPackage();
        AssetItemTest.assertTrue((boolean)pkg__.isSnapshot());
        AssetItemTest.assertTrue((boolean)pkg_.isSnapshot());
        AssetItemTest.assertFalse((boolean)pkg.isSnapshot());
        AssetItemTest.assertEquals((String)pkg.getName(), (String)pkg__.getName());
        asset.updateDescription("yeah !");
        asset.checkin("new");
        asset = pkg.loadAsset("whee");
        AssetItemTest.assertNotNull((Object)asset.getPackage());
        AssetHistoryIterator it = asset.getHistory();
        while (it.hasNext()) {
            AssetItem as = it.next();
            if (as.getVersionNumber() <= 0L) continue;
            System.err.println(as.getVersionNumber());
            System.err.println(as.getPackageName());
            AssetItemTest.assertNotNull((Object)as.getPackage());
            AssetItemTest.assertEquals((String)pkg.getName(), (String)as.getPackage().getName());
        }
    }

    public void testGetAssetNameFromFileName() {
        String[] asset = AssetItem.getAssetNameFromFileName((String)"foo.bar");
        AssetItemTest.assertEquals((String)"foo", (String)asset[0]);
        AssetItemTest.assertEquals((String)"bar", (String)asset[1]);
        asset = AssetItem.getAssetNameFromFileName((String)"Rule 261.3 Something foo.drl");
        AssetItemTest.assertEquals((String)"Rule 261.3 Something foo", (String)asset[0]);
        AssetItemTest.assertEquals((String)"drl", (String)asset[1]);
        asset = AssetItem.getAssetNameFromFileName((String)"Rule_261.3_Something_foo.drl");
        AssetItemTest.assertEquals((String)"Rule_261.3_Something_foo", (String)asset[0]);
        AssetItemTest.assertEquals((String)"drl", (String)asset[1]);
        asset = AssetItem.getAssetNameFromFileName((String)"Rule 261.3 Something foo.model.drl");
        AssetItemTest.assertEquals((String)"Rule 261.3 Something foo", (String)asset[0]);
        AssetItemTest.assertEquals((String)"model.drl", (String)asset[1]);
        asset = AssetItem.getAssetNameFromFileName((String)"Rule_261.3_Something_foo.model.drl");
        AssetItemTest.assertEquals((String)"Rule_261.3_Something_foo", (String)asset[0]);
        AssetItemTest.assertEquals((String)"model.drl", (String)asset[1]);
        asset = AssetItem.getAssetNameFromFileName((String)"application-model-1.0.0.jar");
        AssetItemTest.assertEquals((String)"application-model-1.0.0", (String)asset[0]);
        AssetItemTest.assertEquals((String)"jar", (String)asset[1]);
        asset = AssetItem.getAssetNameFromFileName((String)"something-1.0.0.drl");
        AssetItemTest.assertEquals((String)"something-1.0.0", (String)asset[0]);
        AssetItemTest.assertEquals((String)"drl", (String)asset[1]);
        asset = AssetItem.getAssetNameFromFileName((String)"foo.bpel.jar");
        AssetItemTest.assertEquals((String)"foo", (String)asset[0]);
        AssetItemTest.assertEquals((String)"bpel.jar", (String)asset[1]);
        asset = AssetItem.getAssetNameFromFileName((String)"SubmitApplication.rf");
        AssetItemTest.assertEquals((String)"SubmitApplication", (String)asset[0]);
        AssetItemTest.assertEquals((String)"rf", (String)asset[1]);
        asset = AssetItem.getAssetNameFromFileName((String)"Submit.rf");
        AssetItemTest.assertEquals((String)"Submit", (String)asset[0]);
        AssetItemTest.assertEquals((String)"rf", (String)asset[1]);
    }

    public void testGetContent() {
        AssetItem ruleItem1 = this.getRepo().loadDefaultPackage().addAsset("testGetContent", "test content");
        ruleItem1.updateContent("test content");
        ruleItem1.updateFormat("drl");
        AssetItemTest.assertNotNull((Object)ruleItem1);
        AssetItemTest.assertNotNull((Object)ruleItem1.getNode());
        AssetItemTest.assertEquals((String)"test content", (String)ruleItem1.getContent());
        AssetItemTest.assertFalse((boolean)ruleItem1.isBinary());
        AssetItemTest.assertNotNull((Object)ruleItem1.getBinaryContentAsBytes());
        AssetItemTest.assertNotNull((Object)ruleItem1.getBinaryContentAttachment());
        String content = new String(ruleItem1.getBinaryContentAsBytes());
        AssetItemTest.assertNotNull((Object)content);
    }

    public void testUpdateContent() throws Exception {
        AssetItem ruleItem1 = this.getDefaultPackage().addAsset("testUpdateContent", "test description");
        AssetItemTest.assertFalse((boolean)ruleItem1.getCreator().equals(""));
        ruleItem1.updateContent("test content");
        ruleItem1.checkin("yeah");
        AssetItemTest.assertFalse((boolean)ruleItem1.getLastContributor().equals(""));
        ruleItem1.updateContent("new rule content");
        AssetItemTest.assertEquals((String)"new rule content", (String)ruleItem1.getContent());
        AssetItemTest.assertTrue((boolean)ruleItem1.getNode().getSession().hasPendingChanges());
        ruleItem1.checkin("yeah !");
        AssetItemTest.assertFalse((boolean)ruleItem1.getNode().getSession().hasPendingChanges());
        AssetItemTest.assertEquals((String)"yeah !", (String)ruleItem1.getCheckinComment());
        AssetItem prev = (AssetItem)ruleItem1.getPrecedingVersion();
        AssetItemTest.assertEquals((String)"test content", (String)prev.getContent());
        AssetItemTest.assertFalse((boolean)"yeah !".equals(prev.getCheckinComment()));
        AssetItemTest.assertEquals((Object)prev, (Object)ruleItem1.getPrecedingVersion());
        ruleItem1 = this.getDefaultPackage().loadAsset("testUpdateContent");
        VersionIterator it = VersionableItem.getVersionManager((Node)ruleItem1.getNode()).getVersionHistory(ruleItem1.getNode().getPath()).getAllVersions();
        AssetItemTest.assertTrue((boolean)it.hasNext());
        while (it.hasNext()) {
            Version n = it.nextVersion();
            AssetItem item = new AssetItem(ruleItem1.getRulesRepository(), (Node)n);
            AssetItemTest.assertNotNull((Object)item);
        }
    }

    public void testCategoriesPagination() {
        PackageItem pkg = this.getRepo().createPackage("testPagination", "");
        this.getRepo().loadCategory("/").addCategory("testPagedTag", "description");
        AssetItem a = pkg.addAsset("testPage1", "test content");
        a.addCategory("testPagedTag");
        a.checkin("");
        a = pkg.addAsset("testPage2", "test content");
        a.addCategory("testPagedTag");
        a.checkin("");
        a = pkg.addAsset("testPage3", "test content");
        a.addCategory("testPagedTag");
        a.checkin("");
        a = pkg.addAsset("testPage4", "test content");
        a.addCategory("testPagedTag");
        a.checkin("");
        a = pkg.addAsset("testPage5", "test content");
        a.addCategory("testPagedTag");
        a.checkin("");
        AssetPageList list = this.getRepo().findAssetsByCategory("testPagedTag", 0, -1);
        AssetItemTest.assertTrue((list.currentPosition > 0L ? 1 : 0) != 0);
        AssetItemTest.assertEquals((int)5, (int)list.assets.size());
        AssetItemTest.assertEquals((boolean)false, (boolean)list.hasNext);
        list = this.getRepo().findAssetsByCategory("testPagedTag", 0, 2);
        AssetItemTest.assertTrue((list.currentPosition > 0L ? 1 : 0) != 0);
        AssetItemTest.assertEquals((boolean)true, (boolean)list.hasNext);
        AssetItemTest.assertEquals((int)2, (int)list.assets.size());
        AssetItemTest.assertEquals((String)"testPage1", (String)((AssetItem)list.assets.get(0)).getName());
        AssetItemTest.assertEquals((String)"testPage2", (String)((AssetItem)list.assets.get(1)).getName());
        list = this.getRepo().findAssetsByCategory("testPagedTag", 2, 2);
        AssetItemTest.assertTrue((list.currentPosition > 0L ? 1 : 0) != 0);
        AssetItemTest.assertEquals((boolean)true, (boolean)list.hasNext);
        AssetItemTest.assertEquals((int)2, (int)list.assets.size());
        AssetItemTest.assertEquals((String)"testPage3", (String)((AssetItem)list.assets.get(0)).getName());
        AssetItemTest.assertEquals((String)"testPage4", (String)((AssetItem)list.assets.get(1)).getName());
        list = this.getRepo().findAssetsByCategory("testPagedTag", 2, 3);
        AssetItemTest.assertTrue((list.currentPosition > 0L ? 1 : 0) != 0);
        AssetItemTest.assertEquals((boolean)false, (boolean)list.hasNext);
        AssetItemTest.assertEquals((int)3, (int)list.assets.size());
        AssetItemTest.assertEquals((String)"testPage3", (String)((AssetItem)list.assets.get(0)).getName());
        AssetItemTest.assertEquals((String)"testPage4", (String)((AssetItem)list.assets.get(1)).getName());
        AssetItemTest.assertEquals((String)"testPage5", (String)((AssetItem)list.assets.get(2)).getName());
    }

    public void testCategories() {
        AssetItem ruleItem1 = this.getDefaultPackage().addAsset("testAddTag", "test content");
        this.getRepo().loadCategory("/").addCategory("testAddTagTestTag", "description");
        ruleItem1.addCategory("testAddTagTestTag");
        List tags = ruleItem1.getCategories();
        AssetItemTest.assertEquals((int)1, (int)tags.size());
        AssetItemTest.assertEquals((String)"testAddTagTestTag", (String)((CategoryItem)tags.get(0)).getName());
        this.getRepo().loadCategory("/").addCategory("testAddTagTestTag2", "description");
        ruleItem1.addCategory("testAddTagTestTag2");
        tags = ruleItem1.getCategories();
        AssetItemTest.assertEquals((int)2, (int)tags.size());
        ruleItem1.checkin("woot");
        List result = this.getRepo().findAssetsByCategory((String)"testAddTagTestTag", (int)0, (int)-1).assets;
        AssetItemTest.assertEquals((int)1, (int)result.size());
        AssetItem retItem = (AssetItem)result.get(0);
        AssetItemTest.assertEquals((String)"testAddTag", (String)retItem.getName());
        ruleItem1.updateContent("foo");
        ruleItem1.checkin("latest");
        AssetItemTest.assertTrue((ruleItem1.getCategories().size() > 0 ? 1 : 0) != 0);
        AssetItemTest.assertNotNull((Object)ruleItem1.getCategorySummary());
        AssetItemTest.assertEquals((String)"testAddTagTestTag testAddTagTestTag2 ", (String)ruleItem1.getCategorySummary());
        result = this.getRepo().findAssetsByCategory((String)"testAddTagTestTag", (int)0, (int)-1).assets;
        AssetItemTest.assertEquals((int)1, (int)result.size());
        ruleItem1 = (AssetItem)result.get(0);
        AssetItemTest.assertEquals((int)2, (int)ruleItem1.getCategories().size());
        AssetItemTest.assertEquals((String)"foo", (String)ruleItem1.getContent());
        AssetItem prev = (AssetItem)ruleItem1.getPrecedingVersion();
        AssetItemTest.assertNotNull((Object)prev);
    }

    public void testUpdateCategories() {
        this.getRepo().loadCategory("/").addCategory("testUpdateCategoriesOnAsset", "la");
        this.getRepo().loadCategory("/").addCategory("testUpdateCategoriesOnAsset2", "la");
        AssetItem item = this.getRepo().loadDefaultPackage().addAsset("testUpdateCategoriesOnAsset", "huhuhu");
        String[] cats = new String[]{"testUpdateCategoriesOnAsset", "testUpdateCategoriesOnAsset2"};
        item.updateCategoryList(cats);
        item.checkin("aaa");
        item = this.getRepo().loadDefaultPackage().loadAsset("testUpdateCategoriesOnAsset");
        AssetItemTest.assertEquals((int)2, (int)item.getCategories().size());
        for (CategoryItem cat : item.getCategories()) {
            AssetItemTest.assertTrue((boolean)cat.getName().startsWith("testUpdateCategoriesOnAsset"));
        }
    }

    public void testFindRulesByCategory() throws Exception {
        this.getRepo().loadCategory("/").addCategory("testFindRulesByCat", "yeah");
        AssetItem as1 = this.getDefaultPackage().addAsset("testFindRulesByCategory1", "ya", "testFindRulesByCat", "drl");
        this.getDefaultPackage().addAsset("testFindRulesByCategory2", "ya", "testFindRulesByCat", "txt").checkin("version0");
        as1.checkin("version0");
        AssetItemTest.assertEquals((String)"drl", (String)as1.getFormat());
        List rules = this.getRepo().findAssetsByCategory((String)"testFindRulesByCat", (int)0, (int)-1).assets;
        AssetItemTest.assertEquals((int)2, (int)rules.size());
        for (AssetItem element : rules) {
            AssetItemTest.assertTrue((boolean)element.getName().startsWith("testFindRulesByCategory"));
        }
        try {
            this.getRepo().loadCategory("testFindRulesByCat").remove();
            AssetItemTest.fail((String)"should not be able to remove");
        }
        catch (RulesRepositoryException e) {
            AssetItemTest.assertNotNull((Object)e.getMessage());
        }
    }

    public void testRemoveTag() {
        AssetItem ruleItem1 = this.getDefaultPackage().addAsset("testRemoveTag", "test content");
        this.getRepo().loadCategory("/").addCategory("TestRemoveCategory", "description");
        ruleItem1.addCategory("TestRemoveCategory");
        List tags = ruleItem1.getCategories();
        AssetItemTest.assertEquals((int)1, (int)tags.size());
        ruleItem1.removeCategory("TestRemoveCategory");
        tags = ruleItem1.getCategories();
        AssetItemTest.assertEquals((int)0, (int)tags.size());
        this.getRepo().loadCategory("/").addCategory("TestRemoveCategory2", "description");
        this.getRepo().loadCategory("/").addCategory("TestRemoveCategory3", "description");
        ruleItem1.addCategory("TestRemoveCategory2");
        ruleItem1.addCategory("TestRemoveCategory3");
        ruleItem1.removeCategory("TestRemoveCategory2");
        tags = ruleItem1.getCategories();
        AssetItemTest.assertEquals((int)1, (int)tags.size());
        AssetItemTest.assertEquals((String)"TestRemoveCategory3", (String)((CategoryItem)tags.get(0)).getName());
    }

    public void testGetTags() {
        AssetItem ruleItem1 = this.getDefaultPackage().addAsset("testGetTags", "test content");
        List tags = ruleItem1.getCategories();
        AssetItemTest.assertNotNull((Object)tags);
        AssetItemTest.assertEquals((int)0, (int)tags.size());
        this.getRepo().loadCategory("/").addCategory("testGetTagsTestTag", "description");
        ruleItem1.addCategory("testGetTagsTestTag");
        tags = ruleItem1.getCategories();
        AssetItemTest.assertEquals((int)1, (int)tags.size());
        AssetItemTest.assertEquals((String)"testGetTagsTestTag", (String)((CategoryItem)tags.get(0)).getName());
    }

    public void testSetStateString() {
        AssetItem ruleItem1 = this.getDefaultPackage().addAsset("testSetStateString", "test content");
        this.getRepo().createState("TestState1");
        ruleItem1.updateState("TestState1");
        AssetItemTest.assertNotNull((Object)ruleItem1.getState());
        AssetItemTest.assertEquals((String)"TestState1", (String)ruleItem1.getState().getName());
        this.getRepo().createState("TestState2");
        ruleItem1.updateState("TestState2");
        AssetItemTest.assertNotNull((Object)ruleItem1.getState());
        AssetItemTest.assertEquals((String)"TestState2", (String)ruleItem1.getState().getName());
        ruleItem1 = this.getDefaultPackage().addAsset("foobar", "test description");
        StateItem stateItem1 = this.getRepo().getState("TestState1");
        ruleItem1.updateState(stateItem1);
        AssetItemTest.assertNotNull((Object)ruleItem1.getState());
        AssetItemTest.assertEquals((String)ruleItem1.getState().getName(), (String)"TestState1");
        StateItem stateItem2 = this.getRepo().getState("TestState2");
        ruleItem1.updateState(stateItem2);
        AssetItemTest.assertNotNull((Object)ruleItem1.getState());
        AssetItemTest.assertEquals((String)"TestState2", (String)ruleItem1.getState().getName());
    }

    public void testStatusStuff() {
        AssetItem ruleItem1 = this.getDefaultPackage().addAsset("testGetState", "test content");
        StateItem stateItem1 = ruleItem1.getState();
        AssetItemTest.assertEquals((String)"Draft", (String)stateItem1.getName());
        ruleItem1.updateState("TestState1");
        AssetItemTest.assertNotNull((Object)ruleItem1.getState());
        AssetItemTest.assertEquals((String)"TestState1", (String)ruleItem1.getState().getName());
        ruleItem1 = this.getDefaultPackage().addAsset("testGetState2", "wa");
        AssetItemTest.assertEquals((String)"Draft", (String)ruleItem1.getStateDescription());
        AssetItemTest.assertEquals((Object)this.getRepo().getState("Draft"), (Object)ruleItem1.getState());
    }

    public void testToString() {
        AssetItem ruleItem1 = this.getDefaultPackage().addAsset("testToString", "test content");
        AssetItemTest.assertNotNull((Object)ruleItem1.toString());
    }

    public void testGetLastModifiedOnCheckin() throws Exception {
        AssetItem ruleItem1 = this.getDefaultPackage().addAsset("testGetLastModified", "test content");
        Calendar cal = Calendar.getInstance();
        long before = cal.getTimeInMillis();
        Thread.sleep(100L);
        ruleItem1.updateContent("new lhs");
        ruleItem1.checkin("woot");
        Calendar cal2 = ruleItem1.getLastModified();
        long lastMod = cal2.getTimeInMillis();
        cal = Calendar.getInstance();
        long after = cal.getTimeInMillis();
        AssetItemTest.assertTrue((before < lastMod ? 1 : 0) != 0);
        AssetItemTest.assertTrue((lastMod < after ? 1 : 0) != 0);
    }

    public void testGetDateEffective() {
        AssetItem ruleItem1 = this.getDefaultPackage().addAsset("testGetDateEffective", "test content");
        AssetItemTest.assertTrue((ruleItem1.getDateEffective() == null ? 1 : 0) != 0);
        Calendar cal = Calendar.getInstance();
        ruleItem1.updateDateEffective(cal);
        Calendar cal2 = ruleItem1.getDateEffective();
        AssetItemTest.assertEquals((Object)cal, (Object)cal2);
    }

    public void testGetDateExpired() {
        try {
            AssetItem ruleItem1 = this.getRepo().loadDefaultPackage().addAsset("testGetDateExpired", "test content");
            AssetItemTest.assertTrue((ruleItem1.getDateExpired() == null ? 1 : 0) != 0);
            Calendar cal = Calendar.getInstance();
            ruleItem1.updateDateExpired(cal);
            Calendar cal2 = ruleItem1.getDateExpired();
            AssetItemTest.assertEquals((Object)cal, (Object)cal2);
        }
        catch (Exception e) {
            AssetItemTest.fail((String)("Caught unexpected exception: " + e));
        }
    }

    public void testSaveAndCheckinDescriptionAndTitle() throws Exception {
        AssetItem ruleItem1 = this.getRepo().loadDefaultPackage().addAsset("testGetDescription", "");
        ruleItem1.checkin("version0");
        AssetItemTest.assertEquals((String)"", (String)ruleItem1.getDescription());
        ruleItem1.updateDescription("test description");
        AssetItemTest.assertEquals((String)"test description", (String)ruleItem1.getDescription());
        AssetItemTest.assertTrue((boolean)this.getRepo().getSession().hasPendingChanges());
        ruleItem1.updateTitle("This is a title");
        AssetItemTest.assertTrue((boolean)this.getRepo().getSession().hasPendingChanges());
        ruleItem1.checkin("ya");
        this.getRepo().getSession().save();
        AssetItemTest.assertFalse((boolean)this.getRepo().getSession().hasPendingChanges());
        try {
            ruleItem1.getPrecedingVersion().updateTitle("baaad");
            AssetItemTest.fail((String)"should not be able to do this");
        }
        catch (RulesRepositoryException e) {
            AssetItemTest.assertNotNull((Object)e.getMessage());
        }
    }

    public void testGetPrecedingVersionAndRestore() throws Exception {
        this.getRepo().loadCategory("/").addCategory("foo", "ka");
        AssetItem ruleItem1 = this.getRepo().loadDefaultPackage().addAsset("testGetPrecedingVersion", "descr");
        ruleItem1.checkin("version0");
        AssetItemTest.assertTrue((ruleItem1.getPrecedingVersion() == null ? 1 : 0) != 0);
        ruleItem1.addCategory("foo");
        ruleItem1.updateContent("test content");
        ruleItem1.updateDescription("descr2");
        Thread.sleep(100L);
        ruleItem1.checkin("boo");
        AssetItem predecessorRuleItem = (AssetItem)ruleItem1.getPrecedingVersion();
        AssetItemTest.assertNotNull((Object)predecessorRuleItem);
        AssetItemTest.assertNotNull((Object)predecessorRuleItem.getVersionSnapshotUUID());
        AssetItemTest.assertFalse((boolean)predecessorRuleItem.getVersionSnapshotUUID().equals(ruleItem1.getUUID()));
        AssetItemTest.assertEquals((String)ruleItem1.getState().getName(), (String)predecessorRuleItem.getState().getName());
        AssetItem loadedHistorical = this.getRepo().loadAssetByUUID(predecessorRuleItem.getVersionSnapshotUUID());
        AssetItemTest.assertTrue((boolean)loadedHistorical.isHistoricalVersion());
        AssetItemTest.assertFalse((ruleItem1.getVersionNumber() == loadedHistorical.getVersionNumber() ? 1 : 0) != 0);
        ruleItem1.updateContent("new content");
        ruleItem1.checkin("two changes");
        predecessorRuleItem = (AssetItem)ruleItem1.getPrecedingVersion();
        AssetItemTest.assertNotNull((Object)predecessorRuleItem);
        AssetItemTest.assertEquals((int)1, (int)predecessorRuleItem.getCategories().size());
        CategoryItem cat = (CategoryItem)predecessorRuleItem.getCategories().get(0);
        AssetItemTest.assertEquals((String)"foo", (String)cat.getName());
        AssetItemTest.assertEquals((String)"test content", (String)predecessorRuleItem.getContent());
        AssetItemTest.assertEquals((String)"defaultPackage", (String)predecessorRuleItem.getPackageName());
        ruleItem1.updateContent("newer lhs");
        ruleItem1.checkin("another");
        predecessorRuleItem = (AssetItem)ruleItem1.getPrecedingVersion();
        AssetItemTest.assertNotNull((Object)predecessorRuleItem);
        AssetItemTest.assertEquals((String)"new content", (String)predecessorRuleItem.getContent());
        predecessorRuleItem = (AssetItem)predecessorRuleItem.getPrecedingVersion();
        AssetItemTest.assertNotNull((Object)predecessorRuleItem);
        AssetItemTest.assertEquals((String)"test content", (String)predecessorRuleItem.getContent());
        long oldVersionNumber = ruleItem1.getVersionNumber();
        AssetItem toRestore = this.getRepo().loadAssetByUUID(predecessorRuleItem.getVersionSnapshotUUID());
        this.getRepo().restoreHistoricalAsset(toRestore, ruleItem1, "cause I want to");
        AssetItem restored = this.getRepo().loadDefaultPackage().loadAsset("testGetPrecedingVersion");
        AssetItemTest.assertEquals((String)predecessorRuleItem.getDescription(), (String)restored.getDescription());
        AssetItemTest.assertEquals((String)"cause I want to", (String)restored.getCheckinComment());
        AssetItemTest.assertEquals((long)5L, (long)restored.getVersionNumber());
        AssetItemTest.assertFalse((oldVersionNumber == restored.getVersionNumber() ? 1 : 0) != 0);
    }

    public void testGetSucceedingVersion() {
        AssetItem ruleItem1 = this.getRepo().loadDefaultPackage().addAsset("testGetSucceedingVersion", "test description");
        ruleItem1.checkin("version0");
        AssetItemTest.assertEquals((long)1L, (long)ruleItem1.getVersionNumber());
        AssetItem succeedingRuleItem = (AssetItem)ruleItem1.getSucceedingVersion();
        AssetItemTest.assertTrue((succeedingRuleItem == null ? 1 : 0) != 0);
        ruleItem1.updateContent("new content");
        ruleItem1.checkin("la");
        AssetItemTest.assertEquals((long)2L, (long)ruleItem1.getVersionNumber());
        AssetItem predecessorRuleItem = (AssetItem)ruleItem1.getPrecedingVersion();
        AssetItemTest.assertEquals((String)"", (String)predecessorRuleItem.getContent());
        succeedingRuleItem = (AssetItem)predecessorRuleItem.getSucceedingVersion();
        AssetItemTest.assertNotNull((Object)succeedingRuleItem);
        AssetItemTest.assertEquals((String)ruleItem1.getContent(), (String)succeedingRuleItem.getContent());
    }

    public void testGetSuccessorVersionsIterator() {
        try {
            AssetItem ruleItem1 = this.getRepo().loadDefaultPackage().addAsset("testGetSuccessorVersionsIterator", "test content");
            ruleItem1.checkin("version0");
            ItemVersionIterator iterator = ruleItem1.getSuccessorVersionsIterator();
            AssetItemTest.assertNotNull((Object)iterator);
            AssetItemTest.assertFalse((boolean)iterator.hasNext());
            ruleItem1.updateContent("new content").checkin("ya");
            iterator = ruleItem1.getSuccessorVersionsIterator();
            AssetItemTest.assertNotNull((Object)iterator);
            AssetItemTest.assertFalse((boolean)iterator.hasNext());
            AssetItem predecessorRuleItem = (AssetItem)ruleItem1.getPrecedingVersion();
            iterator = predecessorRuleItem.getSuccessorVersionsIterator();
            AssetItemTest.assertNotNull((Object)iterator);
            AssetItemTest.assertTrue((boolean)iterator.hasNext());
            AssetItem nextRuleItem = (AssetItem)iterator.next();
            AssetItemTest.assertEquals((String)"new content", (String)nextRuleItem.getContent());
            AssetItemTest.assertFalse((boolean)iterator.hasNext());
            ruleItem1.updateContent("newer content");
            ruleItem1.checkin("boo");
            iterator = predecessorRuleItem.getSuccessorVersionsIterator();
            AssetItemTest.assertNotNull((Object)iterator);
            AssetItemTest.assertTrue((boolean)iterator.hasNext());
            nextRuleItem = (AssetItem)iterator.next();
            AssetItemTest.assertEquals((String)"new content", (String)nextRuleItem.getContent());
            AssetItemTest.assertTrue((boolean)iterator.hasNext());
            nextRuleItem = (AssetItem)iterator.next();
            AssetItemTest.assertEquals((String)"newer content", (String)nextRuleItem.getContent());
            AssetItemTest.assertFalse((boolean)iterator.hasNext());
        }
        catch (Exception e) {
            AssetItemTest.fail((String)("Caught unexpected exception: " + e));
        }
    }

    public void testGetPredecessorVersionsIterator() {
        AssetItem ruleItem1 = this.getRepo().loadDefaultPackage().addAsset("testGetPredecessorVersionsIterator", "test description");
        ruleItem1.checkin("version0");
        ItemVersionIterator iterator = ruleItem1.getPredecessorVersionsIterator();
        AssetItemTest.assertNotNull((Object)iterator);
        AssetItemTest.assertFalse((boolean)iterator.hasNext());
        ruleItem1.updateContent("test content");
        ruleItem1.checkin("lalalalala");
        iterator = ruleItem1.getPredecessorVersionsIterator();
        AssetItemTest.assertNotNull((Object)iterator);
        AssetItemTest.assertTrue((boolean)iterator.hasNext());
        ruleItem1.updateContent("new content");
        ruleItem1.checkin("boo");
        iterator = ruleItem1.getPredecessorVersionsIterator();
        AssetItemTest.assertNotNull((Object)iterator);
        AssetItemTest.assertTrue((boolean)iterator.hasNext());
        AssetItem nextRuleItem = (AssetItem)iterator.next();
        AssetItemTest.assertEquals((String)"test content", (String)nextRuleItem.getContent());
        ruleItem1.updateContent("newer content");
        ruleItem1.checkin("wee");
        iterator = ruleItem1.getPredecessorVersionsIterator();
        AssetItemTest.assertNotNull((Object)iterator);
        AssetItemTest.assertTrue((boolean)iterator.hasNext());
        nextRuleItem = (AssetItem)iterator.next();
        AssetItemTest.assertTrue((boolean)iterator.hasNext());
        AssetItemTest.assertEquals((String)"new content", (String)nextRuleItem.getContent());
        nextRuleItem = (AssetItem)iterator.next();
        AssetItemTest.assertEquals((String)"test content", (String)nextRuleItem.getContent());
        AssetItemTest.assertEquals((String)"", (String)((AssetItem)iterator.next()).getContent());
    }

    public void testHistoryIterator() throws Exception {
        AssetItem ruleItem1 = this.getRepo().loadDefaultPackage().addAsset("testHistoryIterator", "test description");
        ruleItem1.checkin("version0");
        ruleItem1 = this.getRepo().loadAssetByUUID(ruleItem1.getUUID());
        ruleItem1.updateContent("wo");
        ruleItem1.checkin("version1");
        ruleItem1 = this.getRepo().loadAssetByUUID(ruleItem1.getUUID());
        ruleItem1.updateContent("ya");
        ruleItem1.checkin("version2");
        AssetHistoryIterator it = ruleItem1.getHistory();
        int i = 0;
        while (i < 2) {
            AssetItemTest.assertTrue((boolean)it.hasNext());
            it.next();
            ++i;
        }
    }

    public void testGetTitle() {
        AssetItem ruleItem1 = this.getRepo().loadDefaultPackage().addAsset("testGetTitle", "test content");
        AssetItemTest.assertEquals((String)"testGetTitle", (String)ruleItem1.getTitle());
    }

    public void testDublinCoreProperties() {
        PackageItem pkg = this.getRepo().createPackage("testDublinCore", "wa");
        AssetItem ruleItem = pkg.addAsset("testDublinCoreProperties", "yeah yeah yeah");
        ruleItem.updateCoverage("b");
        AssetItemTest.assertEquals((String)"b", (String)ruleItem.getCoverage());
        ruleItem.checkin("woo");
        pkg = this.getRepo().loadPackage("testDublinCore");
        ruleItem = (AssetItem)pkg.getAssets().next();
        AssetItemTest.assertEquals((String)"b", (String)ruleItem.getCoverage());
        AssetItemTest.assertEquals((String)"", (String)ruleItem.getExternalRelation());
        AssetItemTest.assertEquals((String)"", (String)ruleItem.getExternalSource());
    }

    public void testGetFormat() throws Exception {
        AssetItem ruleItem1 = this.getRepo().loadDefaultPackage().addAsset("testGetFormat", "test content");
        ruleItem1.updateContent("la");
        AssetItemTest.assertEquals((String)"txt", (String)ruleItem1.getFormat());
        AssetItemTest.assertTrue((boolean)ruleItem1.getNode().hasProperty("drools:content"));
        AssetItemTest.assertFalse((boolean)ruleItem1.getNode().hasProperty("drools:binaryContent"));
        ruleItem1.updateFormat("blah");
        AssetItemTest.assertEquals((String)"blah", (String)ruleItem1.getFormat());
    }

    public void testAnonymousProperties() {
        AssetItem item = this.getRepo().loadDefaultPackage().addAsset("anonymousproperty", "lalalalala");
        item.updateUserProperty("fooBar", "value");
        AssetItemTest.assertEquals((String)"value", (String)item.getUserProperty("fooBar"));
        item.checkin("lalalala");
        try {
            item.updateUserProperty("drools:content", "whee");
            AssetItemTest.fail((String)"should not be able to set built in properties this way.");
        }
        catch (IllegalArgumentException e) {
            AssetItemTest.assertNotNull((Object)e.getMessage());
        }
    }

    public void testBinaryAsset() throws Exception {
        AssetItem item = this.getRepo().loadDefaultPackage().addAsset("testBinaryAsset", "yeah");
        String data = "abc 123";
        ByteArrayInputStream in = new ByteArrayInputStream(data.getBytes());
        item.updateBinaryContentAttachment((InputStream)in);
        item.updateBinaryContentAttachmentFileName("x.x");
        in.close();
        AssetItemTest.assertEquals((String)data, (String)item.getContent());
        AssetItemTest.assertFalse((boolean)item.getNode().hasProperty("drools:content"));
        AssetItemTest.assertTrue((boolean)item.getNode().hasProperty("drools:binaryContent"));
        item.checkin("lalalala");
        AssetItemTest.assertTrue((boolean)item.isBinary());
        item = this.getRepo().loadDefaultPackage().loadAsset("testBinaryAsset");
        InputStream in2 = item.getBinaryContentAttachment();
        AssetItemTest.assertNotNull((Object)in2);
        byte[] data2 = item.getBinaryContentAsBytes();
        AssetItemTest.assertEquals((String)data, (String)new String(data2));
        AssetItemTest.assertEquals((String)"x.x", (String)item.getBinaryContentAttachmentFileName());
        AssetItemTest.assertTrue((boolean)item.isBinary());
        item.updateContent("qed");
        item.checkin("");
        item = this.getRepo().loadAssetByUUID(item.getUUID());
        AssetItemTest.assertEquals((String)"qed", (String)item.getContent());
    }
}

