/*
 * Decompiled with CFR 0.152.
 */
package org.drools.repository;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.Workspace;
import junit.framework.TestCase;
import org.drools.repository.AssetItem;
import org.drools.repository.AssetItemIterator;
import org.drools.repository.AssetPageList;
import org.drools.repository.CategoryItem;
import org.drools.repository.PackageItem;
import org.drools.repository.PackageIterator;
import org.drools.repository.RepositoryFilter;
import org.drools.repository.RepositorySessionUtil;
import org.drools.repository.RulesRepository;
import org.drools.repository.RulesRepositoryException;
import org.drools.repository.StateItem;
import org.drools.repository.migration.MigrateDroolsPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RulesRepositoryTest
extends TestCase {
    int running = 0;

    public void testDefaultPackage() throws Exception {
        RulesRepository repo = RepositorySessionUtil.getRepository();
        PackageIterator it = repo.listPackages();
        boolean foundDefault = false;
        while (it.hasNext()) {
            PackageItem item = (PackageItem)it.next();
            if (!item.getName().equals("defaultPackage")) continue;
            foundDefault = true;
        }
        RulesRepositoryTest.assertTrue((boolean)foundDefault);
        PackageItem def = repo.loadDefaultPackage();
        RulesRepositoryTest.assertNotNull((Object)def);
        RulesRepositoryTest.assertEquals((String)"defaultPackage", (String)def.getName());
        String userId = repo.getSession().getUserID();
        RulesRepositoryTest.assertNotNull((Object)userId);
        RulesRepositoryTest.assertFalse((boolean)userId.equals(""));
        MigrateDroolsPackage mig = new MigrateDroolsPackage();
        RulesRepositoryTest.assertFalse((boolean)mig.needsMigration(repo));
        RulesRepositoryTest.assertTrue((boolean)RulesRepository.initialized);
    }

    public void testCategoryRename() throws Exception {
        RulesRepository repo = RepositorySessionUtil.getRepository();
        CategoryItem root = repo.loadCategory("/");
        root.addCategory("testCatRename", "");
        repo.loadCategory("testCatRename").addCategory("testRename", "");
        repo.renameCategory("testCatRename/testRename", "testAnother");
        CategoryItem cat = repo.loadCategory("testCatRename/testAnother");
        RulesRepositoryTest.assertNotNull((Object)cat);
        try {
            repo.loadCategory("testCatRename/testRename");
            RulesRepositoryTest.fail((String)"should not exist.");
        }
        catch (RulesRepositoryException e) {
            RulesRepositoryTest.assertNotNull((Object)e.getMessage());
        }
        PackageItem pkg = repo.createPackage("testCategoryRename", "");
        AssetItem asset = pkg.addAsset("fooBar", "");
        asset.addCategory("testCatRename");
        asset.addCategory("testCatRename/testAnother");
        asset.checkin("");
        cat = repo.loadCategory("testCatRename/testAnother");
        AssetPageList as = repo.findAssetsByCategory("testCatRename/testAnother", 0, -1);
        RulesRepositoryTest.assertEquals((String)"fooBar", (String)((AssetItem)as.assets.get(0)).getName());
        repo.renameCategory("testCatRename/testAnother", "testYetAnother");
        as = repo.findAssetsByCategory("testCatRename/testYetAnother", 0, -1);
        RulesRepositoryTest.assertEquals((String)"fooBar", (String)((AssetItem)as.assets.get(0)).getName());
    }

    public void testAddVersionARule() throws Exception {
        RulesRepository repo = RepositorySessionUtil.getRepository();
        PackageItem pack = repo.createPackage("testAddVersionARule", "description");
        repo.save();
        AssetItem rule = pack.addAsset("my rule", "foobar");
        RulesRepositoryTest.assertEquals((String)"my rule", (String)rule.getName());
        rule.updateContent("foo foo");
        rule.checkin("version0");
        pack.addAsset("other rule", "description");
        rule.updateContent("foo bar");
        rule.checkin("version1");
        PackageItem pack2 = repo.loadPackage("testAddVersionARule");
        Iterator it = pack2.getAssets();
        it.next();
        it.next();
        RulesRepositoryTest.assertFalse((boolean)it.hasNext());
        AssetItem prev = (AssetItem)rule.getPrecedingVersion();
        RulesRepositoryTest.assertEquals((String)"foo bar", (String)rule.getContent());
        RulesRepositoryTest.assertEquals((String)"foo foo", (String)prev.getContent());
    }

    public void testFindByState() throws Exception {
        RulesRepository repo = RepositorySessionUtil.getRepository();
        PackageItem pkg = repo.createPackage("testFindByStatePackage", "heheheh");
        AssetItem asset1 = pkg.addAsset("asset1", "");
        AssetItem asset2 = pkg.addAsset("asset2", "");
        repo.createState("testFindByState");
        repo.save();
        asset1.updateState("testFindByState");
        asset2.updateState("testFindByState");
        asset1.checkin("");
        asset2.checkin("");
        AssetPageList list = repo.findAssetsByState("testFindByState", true, 0, -1);
        RulesRepositoryTest.assertEquals((int)2, (int)list.assets.size());
    }

    public void testFindRulesByName() throws Exception {
        RulesRepository repo = RepositorySessionUtil.getRepository();
        repo.loadDefaultPackage().addAsset("findRulesByNamex1", "X");
        repo.loadDefaultPackage().addAsset("findRulesByNamex2", "X");
        repo.save();
        List list = RulesRepositoryTest.iteratorToList(repo.findAssetsByName("findRulesByNamex1"));
        RulesRepositoryTest.assertEquals((int)1, (int)list.size());
        list = RulesRepositoryTest.iteratorToList(repo.findAssetsByName("findRulesByNamex2"));
        RulesRepositoryTest.assertEquals((int)1, (int)list.size());
        list = RulesRepositoryTest.iteratorToList(repo.findAssetsByName("findRulesByNamex%"));
        RulesRepositoryTest.assertEquals((int)2, (int)list.size());
        repo.createPackageSnapshot("defaultPackage", "testFindRulesByName");
        repo.save();
        list = RulesRepositoryTest.iteratorToList(repo.findAssetsByName("findRulesByNamex2"));
        AssetItem item = (AssetItem)list.get(0);
        RulesRepositoryTest.assertEquals((String)"findRulesByNamex2", (String)item.getName());
        RulesRepositoryTest.assertEquals((String)"X", (String)item.getDescription());
        RulesRepositoryTest.assertEquals((int)1, (int)list.size());
        list = RulesRepositoryTest.iteratorToList(repo.findAssetsByName("findRulesByNamex%"));
        RulesRepositoryTest.assertEquals((int)2, (int)list.size());
    }

    public void testQueryText() throws Exception {
        RulesRepository repo = RepositorySessionUtil.getRepository();
        PackageItem pkg = repo.createPackage("testQueryTest", "");
        AssetItem asset = pkg.addAsset("asset1", "testQueryText1");
        asset.updateSubject("testQueryText42");
        asset.checkin("firstCheckintestQueryTest");
        asset.updateFormat("drl");
        asset.checkin("firstCheckintestQueryTest2");
        pkg.addAsset("asset2", "testQueryText2");
        repo.save();
        List ls = RulesRepositoryTest.iteratorToList(repo.queryFullText("testQueryText*", false));
        RulesRepositoryTest.assertEquals((int)2, (int)ls.size());
        ls = RulesRepositoryTest.iteratorToList(repo.queryFullText("firstCheckintestQueryTest2", false));
        RulesRepositoryTest.assertEquals((int)1, (int)ls.size());
        ls = RulesRepositoryTest.iteratorToList(repo.queryFullText("firstCheckintestQueryTest", false));
        RulesRepositoryTest.assertEquals((int)0, (int)ls.size());
        ls = RulesRepositoryTest.iteratorToList(repo.queryFullText("testQueryText*", false));
        RulesRepositoryTest.assertEquals((int)2, (int)ls.size());
        asset.archiveItem(true);
        asset.checkin("");
        ls = RulesRepositoryTest.iteratorToList(repo.queryFullText("testQueryText*", false));
        RulesRepositoryTest.assertEquals((int)1, (int)ls.size());
        ls = RulesRepositoryTest.iteratorToList(repo.queryFullText("testQueryText*", true));
        RulesRepositoryTest.assertEquals((int)2, (int)ls.size());
    }

    public void testQuery() throws Exception {
        RulesRepository repo = RepositorySessionUtil.getRepository();
        AssetItem asset = repo.loadDefaultPackage().addAsset("testQuery", "wanklerotaryengine1cc");
        asset.updateContent("testingSearchWankle");
        asset.updateSubject("testQueryXXX42");
        asset.checkin("");
        HashMap<String, String[]> q = new HashMap<String, String[]>();
        q.put("drools:subject", new String[]{"testQueryXXX42"});
        AssetItemIterator asit = repo.query(q, false, null);
        List results = RulesRepositoryTest.iteratorToList(asit);
        RulesRepositoryTest.assertEquals((int)1, (int)results.size());
        AssetItem as = (AssetItem)results.get(0);
        RulesRepositoryTest.assertEquals((String)"testQuery", (String)as.getName());
        asset.updateExternalSource("database");
        asset.checkin("");
        q = new HashMap();
        q.put("drools:subject", new String[]{"testQueryXXX42"});
        q.put("drools:source", new String[]{"database"});
        results = RulesRepositoryTest.iteratorToList(repo.query(q, true, null));
        RulesRepositoryTest.assertEquals((int)1, (int)results.size());
        as = (AssetItem)results.get(0);
        RulesRepositoryTest.assertEquals((String)"testQuery", (String)as.getName());
        q = new HashMap();
        q.put("drools:subject", new String[]{"testQueryXXX42", "wankle"});
        q.put("drools:source", new String[]{"database", "wankle"});
        results = RulesRepositoryTest.iteratorToList(repo.query(q, false, null));
        RulesRepositoryTest.assertEquals((int)1, (int)results.size());
        as = (AssetItem)results.get(0);
        RulesRepositoryTest.assertEquals((String)"testQuery", (String)as.getName());
        q = new HashMap();
        q.put("drools:subject", null);
        q.put("cruddy", new String[0]);
        q.put("drools:source", new String[]{"database", "wankle"});
        results = RulesRepositoryTest.iteratorToList(repo.query(q, false, null));
        RulesRepositoryTest.assertEquals((int)1, (int)results.size());
        q = new HashMap();
        q.put("drools:subject", new String[]{"testQueryXXX42", "wankle"});
        q.put("drools:source", new String[]{"database", "wankle"});
        results = RulesRepositoryTest.iteratorToList(repo.query(q, false, new RulesRepository.DateQuery[]{new RulesRepository.DateQuery("jcr:created", "1974-07-10T00:00:00.000-05:00", "3074-07-10T00:00:00.000-05:00")}));
        RulesRepositoryTest.assertEquals((int)1, (int)results.size());
        as = (AssetItem)results.get(0);
        RulesRepositoryTest.assertEquals((String)"testQuery", (String)as.getName());
        q = new HashMap();
        q.put("drools:subject", new String[]{"testQueryXXX42", "wankle"});
        q.put("drools:source", new String[]{"database", "wankle"});
        results = RulesRepositoryTest.iteratorToList(repo.query(q, false, new RulesRepository.DateQuery[]{new RulesRepository.DateQuery("jcr:created", "1974-07-10T00:00:00.000-05:00", null)}));
        RulesRepositoryTest.assertEquals((int)1, (int)results.size());
        as = (AssetItem)results.get(0);
        RulesRepositoryTest.assertEquals((String)"testQuery", (String)as.getName());
        q = new HashMap();
        q.put("drools:subject", new String[]{"testQueryXXX42", "wankle"});
        q.put("drools:source", new String[]{"database", "wankle"});
        results = RulesRepositoryTest.iteratorToList(repo.query(q, false, new RulesRepository.DateQuery[]{new RulesRepository.DateQuery("jcr:created", null, "3074-07-10T00:00:00.000-05:00")}));
        RulesRepositoryTest.assertEquals((int)1, (int)results.size());
        as = (AssetItem)results.get(0);
        RulesRepositoryTest.assertEquals((String)"testQuery", (String)as.getName());
        q = new HashMap();
        q.put("drools:subject", new String[]{"testQueryXXX42", "wankle"});
        q.put("drools:source", new String[]{"database", "wankle"});
        results = RulesRepositoryTest.iteratorToList(repo.query(q, false, new RulesRepository.DateQuery[]{new RulesRepository.DateQuery("jcr:created", "3074-07-10T00:00:00.000-05:00", null)}));
        RulesRepositoryTest.assertEquals((int)0, (int)results.size());
        q = new HashMap();
        q.put("drools:subject", new String[]{"testQueryXXX42", "wankle"});
        q.put("drools:source", new String[]{"database", "wankle"});
        results = RulesRepositoryTest.iteratorToList(repo.query(q, false, new RulesRepository.DateQuery[]{new RulesRepository.DateQuery("jcr:created", null, "1974-07-10T00:00:00.000-05:00")}));
        RulesRepositoryTest.assertEquals((int)0, (int)results.size());
    }

    public void testLoadRuleByUUIDWithConcurrentSessions() throws Exception {
        RulesRepository repo = RepositorySessionUtil.getRepository();
        PackageItem rulePackageItem = repo.loadDefaultPackage();
        AssetItem rule = rulePackageItem.addAsset("testLoadRuleByUUID", "this is a description");
        repo.save();
        String uuid = rule.getNode().getIdentifier();
        AssetItem loaded = repo.loadAssetByUUID(uuid);
        RulesRepositoryTest.assertNotNull((Object)loaded);
        RulesRepositoryTest.assertEquals((String)"testLoadRuleByUUID", (String)loaded.getName());
        RulesRepositoryTest.assertEquals((String)"this is a description", (String)loaded.getDescription());
        long oldVersionNumber = loaded.getVersionNumber();
        loaded.updateContent("xxx");
        loaded.checkin("woo");
        AssetItem reload = repo.loadAssetByUUID(uuid);
        RulesRepositoryTest.assertEquals((String)"testLoadRuleByUUID", (String)reload.getName());
        RulesRepositoryTest.assertEquals((String)"xxx", (String)reload.getContent());
        System.out.println(reload.getVersionNumber());
        System.out.println(loaded.getVersionNumber());
        RulesRepositoryTest.assertFalse((reload.getVersionNumber() == oldVersionNumber ? 1 : 0) != 0);
        try {
            repo.loadAssetByUUID("01010101-0101-0101-0101-010101010101");
            RulesRepositoryTest.fail((String)"Exception not thrown loading rule package that was not created.");
        }
        catch (RulesRepositoryException e) {
            RulesRepositoryTest.assertNotNull((Object)e.getMessage());
        }
        AssetItem asset1 = repo.loadDefaultPackage().addAsset("testMultiSession", "description");
        asset1.updateContent("yeah");
        asset1.checkin("boo");
        uuid = asset1.getUUID();
        asset1.updateState("Draft");
        repo.save();
        Session s2 = repo.getSession().getRepository().login((Credentials)new SimpleCredentials("fdd", "password".toCharArray()));
        RulesRepository repo2 = new RulesRepository(s2);
        AssetItem asset2 = repo2.loadAssetByUUID(uuid);
        asset2.updateContent("yeah 42");
        asset2.checkin("yeah");
        asset1 = repo.loadAssetByUUID(uuid);
        RulesRepositoryTest.assertEquals((String)"yeah 42", (String)asset1.getContent());
        asset1.updateContent("yeah 43");
        asset1.checkin("la");
        asset2 = repo2.loadAssetByUUID(uuid);
        RulesRepositoryTest.assertEquals((String)"yeah 43", (String)asset2.getContent());
    }

    public void testAddRuleCalendarWithDates() {
        RulesRepository rulesRepository = RepositorySessionUtil.getRepository();
        Calendar effectiveDate = Calendar.getInstance();
        Calendar expiredDate = Calendar.getInstance();
        expiredDate.setTimeInMillis(effectiveDate.getTimeInMillis() + 86400000L);
        AssetItem ruleItem1 = rulesRepository.loadDefaultPackage().addAsset("testAddRuleCalendarCalendar", "desc");
        ruleItem1.updateDateEffective(effectiveDate);
        ruleItem1.updateDateExpired(expiredDate);
        RulesRepositoryTest.assertNotNull((Object)ruleItem1);
        RulesRepositoryTest.assertNotNull((Object)ruleItem1.getNode());
        RulesRepositoryTest.assertEquals((Object)effectiveDate, (Object)ruleItem1.getDateEffective());
        RulesRepositoryTest.assertEquals((Object)expiredDate, (Object)ruleItem1.getDateExpired());
        ruleItem1.checkin("ho ");
    }

    public void testGetState() {
        RulesRepository rulesRepository = RepositorySessionUtil.getRepository();
        StateItem state0 = rulesRepository.createState("testGetState");
        RulesRepositoryTest.assertNotNull((Object)state0);
        RulesRepositoryTest.assertEquals((String)"testGetState", (String)state0.getName());
        StateItem stateItem1 = rulesRepository.getState("testGetState");
        RulesRepositoryTest.assertNotNull((Object)stateItem1);
        RulesRepositoryTest.assertEquals((String)"testGetState", (String)stateItem1.getName());
        StateItem stateItem2 = rulesRepository.getState("testGetState");
        RulesRepositoryTest.assertNotNull((Object)stateItem2);
        RulesRepositoryTest.assertEquals((String)"testGetState", (String)stateItem2.getName());
        RulesRepositoryTest.assertEquals((Object)stateItem1, (Object)stateItem2);
    }

    public void testGetTag() {
        RulesRepository rulesRepository = RepositorySessionUtil.getRepository();
        CategoryItem root = rulesRepository.loadCategory("/");
        CategoryItem tagItem1 = root.addCategory("testGetTag", "ho");
        RulesRepositoryTest.assertNotNull((Object)tagItem1);
        RulesRepositoryTest.assertEquals((String)"testGetTag", (String)tagItem1.getName());
        RulesRepositoryTest.assertEquals((String)"testGetTag", (String)tagItem1.getFullPath());
        CategoryItem tagItem2 = rulesRepository.loadCategory("testGetTag");
        RulesRepositoryTest.assertNotNull((Object)tagItem2);
        RulesRepositoryTest.assertEquals((String)"testGetTag", (String)tagItem2.getName());
        RulesRepositoryTest.assertEquals((Object)tagItem1, (Object)tagItem2);
        CategoryItem tagItem3 = tagItem2.addCategory("TestChildTag1", "ka");
        RulesRepositoryTest.assertNotNull((Object)tagItem3);
        RulesRepositoryTest.assertEquals((String)"TestChildTag1", (String)tagItem3.getName());
        RulesRepositoryTest.assertEquals((String)"testGetTag/TestChildTag1", (String)tagItem3.getFullPath());
    }

    public void testListPackages() {
        RulesRepository rulesRepository = RepositorySessionUtil.getRepository();
        rulesRepository.createPackage("testListPackages", "desc");
        RulesRepositoryTest.assertTrue((boolean)rulesRepository.containsPackage("testListPackages"));
        RulesRepositoryTest.assertFalse((boolean)rulesRepository.containsPackage("XXXXXXX"));
        PackageIterator it = rulesRepository.listPackages();
        RulesRepositoryTest.assertTrue((boolean)it.hasNext());
        boolean found = false;
        boolean foundGlobalArea = false;
        while (it.hasNext()) {
            PackageItem element = (PackageItem)it.next();
            if (element.getName().equals("testListPackages")) {
                found = true;
            }
            if (!element.getName().equals("globalArea")) continue;
            foundGlobalArea = true;
        }
        RulesRepositoryTest.assertTrue((boolean)found);
        RulesRepositoryTest.assertFalse((boolean)foundGlobalArea);
    }

    public void testFindAssetsByState() throws Exception {
        RulesRepository repo = RepositorySessionUtil.getRepository();
        repo.loadCategory("/").addCategory("testFindAssetsByStateCat", "X");
        PackageItem pkg = repo.createPackage("testFindAssetsByStatePac", "");
        pkg.addAsset("testCat1", "x", "/testFindAssetsByStateCat", "drl");
        pkg.addAsset("testCat2", "x", "/testFindAssetsByStateCat", "drl");
        repo.save();
        AssetPageList apl = repo.findAssetsByState("Draft", false, 0, -1, new RepositoryFilter(){

            public boolean accept(Object artifact, String action) {
                if (!(artifact instanceof AssetItem)) {
                    return false;
                }
                return ((AssetItem)artifact).getName().equalsIgnoreCase("testCat1");
            }
        });
        RulesRepositoryTest.assertEquals((int)1, (int)apl.assets.size());
        RulesRepositoryTest.assertEquals((String)"testCat1", (String)((AssetItem)apl.assets.get(0)).getName());
    }

    public void testFindAssetsByCategory() throws Exception {
        RulesRepository repo = RepositorySessionUtil.getRepository();
        repo.loadCategory("/").addCategory("testFindAssetsByCategoryUsingFilterCat", "X");
        PackageItem pkg = repo.createPackage("testFindAssetsByCategoryUsingFilterPack", "");
        pkg.addAsset("testCat1", "x", "/testFindAssetsByCategoryUsingFilterCat", "drl");
        pkg.addAsset("testCat2", "x", "/testFindAssetsByCategoryUsingFilterCat", "drl");
        repo.save();
        List items = repo.findAssetsByCategory((String)"/testFindAssetsByCategoryUsingFilterCat", (int)0, (int)-1).assets;
        RulesRepositoryTest.assertEquals((int)2, (int)items.size());
        AssetPageList apl = repo.findAssetsByCategory("/testFindAssetsByCategoryUsingFilterCat", false, 0, -1, new RepositoryFilter(){

            public boolean accept(Object artifact, String action) {
                if (!(artifact instanceof AssetItem)) {
                    return false;
                }
                return ((AssetItem)artifact).getName().equalsIgnoreCase("testCat1");
            }
        });
        RulesRepositoryTest.assertEquals((int)1, (int)apl.assets.size());
        RulesRepositoryTest.assertEquals((String)"testCat1", (String)((AssetItem)apl.assets.get(0)).getName());
        pkg.addAsset("testCat3", "x", "/testFindAssetsByCategoryUsingFilterCat", "drl");
        pkg.addAsset("testCat4", "x", "/testFindAssetsByCategoryUsingFilterCat", "drl");
        pkg.addAsset("testCat5", "x", "/testFindAssetsByCategoryUsingFilterCat", "drl");
        pkg.addAsset("testCat6", "x", "/testFindAssetsByCategoryUsingFilterCat", "drl");
        pkg.addAsset("testCat7", "x", "/testFindAssetsByCategoryUsingFilterCat", "drl");
        pkg.addAsset("testCat8", "x", "/testFindAssetsByCategoryUsingFilterCat", "drl");
        pkg.loadAsset("testCat1").archiveItem(true).checkin("");
        pkg.loadAsset("testCat2").archiveItem(true).checkin("");
        pkg.loadAsset("testCat3").archiveItem(true).checkin("");
        pkg.loadAsset("testCat4").archiveItem(true).checkin("");
        repo.save();
        apl = repo.findAssetsByCategory("/testFindAssetsByCategoryUsingFilterCat", 0, -1);
        RulesRepositoryTest.assertEquals((int)4, (int)apl.assets.size());
        ArrayList<String> names = new ArrayList<String>();
        for (AssetItem as : apl.assets) {
            if (names.contains(as.getName())) {
                RulesRepositoryTest.fail((String)"dupe returned.");
            }
            names.add(as.getName());
        }
        names = new ArrayList();
        boolean hasNext = true;
        int skip = 0;
        while (hasNext) {
            apl = repo.findAssetsByCategory("/testFindAssetsByCategoryUsingFilterCat", skip, 2);
            for (AssetItem as : apl.assets) {
                if (names.contains(as.getName())) {
                    RulesRepositoryTest.fail((String)"dupe returned");
                }
                names.add(as.getName());
            }
            skip = (int)(apl.currentPosition + (long)apl.assets.size() - 2L);
            hasNext = apl.hasNext;
        }
        RulesRepositoryTest.assertEquals((int)4, (int)names.size());
        RulesRepositoryTest.assertTrue((boolean)names.contains("testCat5"));
        RulesRepositoryTest.assertTrue((boolean)names.contains("testCat6"));
        RulesRepositoryTest.assertTrue((boolean)names.contains("testCat7"));
        RulesRepositoryTest.assertTrue((boolean)names.contains("testCat8"));
    }

    public void testFunnyOrdering() throws Exception {
    }

    public void testCategoriesAndSnapshots() throws Exception {
        RulesRepository repo = RepositorySessionUtil.getRepository();
        repo.loadCategory("/").addCategory("testCategoriesAndSnapshots", "X");
        PackageItem pkg = repo.createPackage("testCategoriesAndSnapshots", "");
        pkg.addAsset("testCat1", "x", "/testCategoriesAndSnapshots", "drl");
        pkg.addAsset("testCat2", "x", "/testCategoriesAndSnapshots", "drl");
        repo.save();
        List items = repo.findAssetsByCategory((String)"/testCategoriesAndSnapshots", (int)0, (int)-1).assets;
        RulesRepositoryTest.assertEquals((int)2, (int)items.size());
        repo.createPackageSnapshot("testCategoriesAndSnapshots", "SNAP 1");
        items = repo.findAssetsByCategory((String)"testCategoriesAndSnapshots", (int)0, (int)-1).assets;
        RulesRepositoryTest.assertEquals((int)2, (int)items.size());
        RulesRepositoryTest.assertTrue((boolean)repo.containsSnapshot("testCategoriesAndSnapshots", "SNAP 1"));
        RulesRepositoryTest.assertFalse((boolean)repo.containsSnapshot("testCategoriesAndSnapshots", "SNAP XXXX"));
        RulesRepositoryTest.assertFalse((boolean)repo.containsSnapshot("gooberWhhewasssllllelelelelele", "SNAP"));
    }

    public void testMoveRulePackage() throws Exception {
        RulesRepository repo = RepositorySessionUtil.getRepository();
        PackageItem pkg = repo.createPackage("testMove", "description");
        AssetItem r = pkg.addAsset("testMove", "description");
        r.checkin("version0");
        String uuid = r.getUUID();
        RulesRepositoryTest.assertEquals((String)"testMove", (String)r.getPackageName());
        repo.save();
        RulesRepositoryTest.assertEquals((int)1, (int)RulesRepositoryTest.iteratorToList(pkg.getAssets()).size());
        repo.createPackage("testMove2", "description");
        repo.moveRuleItemPackage("testMove2", r.node.getIdentifier(), "explanation");
        pkg = repo.loadPackage("testMove");
        RulesRepositoryTest.assertEquals((int)0, (int)RulesRepositoryTest.iteratorToList(pkg.getAssets()).size());
        pkg = repo.loadPackage("testMove2");
        RulesRepositoryTest.assertEquals((int)1, (int)RulesRepositoryTest.iteratorToList(pkg.getAssets()).size());
        r = (AssetItem)pkg.getAssets().next();
        RulesRepositoryTest.assertEquals((String)"testMove", (String)r.getName());
        RulesRepositoryTest.assertEquals((String)"testMove2", (String)r.getPackageName());
        RulesRepositoryTest.assertEquals((String)"explanation", (String)r.getCheckinComment());
        AssetItem p = (AssetItem)r.getPrecedingVersion();
        RulesRepositoryTest.assertEquals((String)"testMove", (String)p.getPackageName());
        RulesRepositoryTest.assertEquals((String)"version0", (String)p.getCheckinComment());
        RulesRepositoryTest.assertEquals((String)uuid, (String)r.getUUID());
    }

    public void testCopyAsset() throws Exception {
        RulesRepository repo = RepositorySessionUtil.getRepository();
        repo.createPackage("testCopyAsset", "asset");
        AssetItem item = repo.loadDefaultPackage().addAsset("testCopyAssetSource", "desc");
        item.updateContent("la");
        item.checkin("");
        item.updateDescription("mmm");
        item.checkin("again");
        RulesRepositoryTest.assertEquals((long)2L, (long)item.getVersionNumber());
        String uuid = repo.copyAsset(item.getUUID(), "testCopyAsset", "testCopyAssetDestination");
        AssetItem dest = repo.loadAssetByUUID(uuid);
        RulesRepositoryTest.assertEquals((String)dest.getName(), (String)dest.getTitle());
        RulesRepositoryTest.assertEquals((String)"la", (String)dest.getContent());
        RulesRepositoryTest.assertEquals((String)"testCopyAsset", (String)dest.getPackageName());
        RulesRepositoryTest.assertFalse((boolean)uuid.equals(item.getUUID()));
        RulesRepositoryTest.assertEquals((long)1L, (long)dest.getVersionNumber());
    }

    public void testRenameAsset() throws Exception {
        RulesRepository repo = RepositorySessionUtil.getRepository();
        repo.createPackage("testRenameAsset", "asset");
        AssetItem item = repo.loadPackage("testRenameAsset").addAsset("testRenameAssetSource", "desc");
        item.updateContent("la");
        item.checkin("");
        String uuid = repo.renameAsset(item.getUUID(), "testRename2");
        item = repo.loadAssetByUUID(uuid);
        RulesRepositoryTest.assertEquals((String)"testRename2", (String)item.getName());
        RulesRepositoryTest.assertEquals((String)"testRename2", (String)item.getTitle());
        List assets = RulesRepositoryTest.iteratorToList(repo.loadPackage("testRenameAsset").getAssets());
        RulesRepositoryTest.assertEquals((int)1, (int)assets.size());
        item = (AssetItem)assets.get(0);
        RulesRepositoryTest.assertEquals((String)"testRename2", (String)item.getName());
        RulesRepositoryTest.assertEquals((String)"la", (String)item.getContent());
    }

    public void testRenamePackage() throws Exception {
        RulesRepository repo = RepositorySessionUtil.getRepository();
        PackageItem original = repo.createPackage("testRenamePackage", "asset");
        List packagesOriginal = RulesRepositoryTest.iteratorToList(repo.listPackages());
        AssetItem item = repo.loadPackage("testRenamePackage").addAsset("testRenameAssetSource", "desc");
        item.updateContent("la");
        item.checkin("");
        String uuid = repo.renamePackage(original.getUUID(), "testRenamePackage2");
        PackageItem pkg = repo.loadPackageByUUID(uuid);
        RulesRepositoryTest.assertEquals((String)"testRenamePackage2", (String)pkg.getName());
        List assets = RulesRepositoryTest.iteratorToList(repo.loadPackage("testRenamePackage2").getAssets());
        RulesRepositoryTest.assertEquals((int)1, (int)assets.size());
        item = (AssetItem)assets.get(0);
        RulesRepositoryTest.assertEquals((String)"testRenameAssetSource", (String)item.getName());
        RulesRepositoryTest.assertEquals((String)"la", (String)item.getContent());
        RulesRepositoryTest.assertEquals((String)"testRenamePackage2", (String)item.getPackageName());
        List packageFinal = RulesRepositoryTest.iteratorToList(repo.listPackages());
        RulesRepositoryTest.assertEquals((int)packagesOriginal.size(), (int)packageFinal.size());
    }

    public void testCopyPackage() throws Exception {
        RulesRepository repo = RepositorySessionUtil.getRepository();
        PackageItem source = repo.createPackage("testCopyPackage", "asset");
        AssetItem item = source.addAsset("testCopyPackage", "desc");
        item.updateContent("la");
        item.checkin("");
        repo.save();
        repo.copyPackage("testCopyPackage", "testCopyPackage2");
        PackageItem dest = repo.loadPackage("testCopyPackage2");
        RulesRepositoryTest.assertNotNull((Object)dest);
        RulesRepositoryTest.assertFalse((boolean)source.getUUID().equals(dest.getUUID()));
        RulesRepositoryTest.assertEquals((int)1, (int)RulesRepositoryTest.iteratorToList(dest.getAssets()).size());
        AssetItem item2 = (AssetItem)dest.getAssets().next();
        RulesRepositoryTest.assertEquals((String)"testCopyPackage", (String)item.getPackageName());
        RulesRepositoryTest.assertEquals((String)"testCopyPackage2", (String)item2.getPackageName());
        item2.updateContent("goober choo");
        item2.checkin("yeah");
        RulesRepositoryTest.assertEquals((String)"la", (String)item.getContent());
        try {
            repo.copyPackage("testCopyPackage", "testCopyPackage2");
            RulesRepositoryTest.fail((String)"should not be able to copy when existing.");
        }
        catch (RulesRepositoryException e) {
            RulesRepositoryTest.assertNotNull((Object)e.getMessage());
        }
    }

    public void testListStates() {
        RulesRepository repo = RepositorySessionUtil.getRepository();
        StateItem[] items = repo.listStates();
        RulesRepositoryTest.assertTrue((items.length > 0 ? 1 : 0) != 0);
        repo.createState("testListStates");
        StateItem[] items2 = repo.listStates();
        RulesRepositoryTest.assertEquals((int)(items.length + 1), (int)items2.length);
    }

    public void testRenameState() {
        RulesRepository repo = RepositorySessionUtil.getRepository();
        StateItem[] items = repo.listStates();
        RulesRepositoryTest.assertTrue((items.length > 0 ? 1 : 0) != 0);
        String oldName = "stateThatHasALongNameAndWillBeRenamed";
        repo.createState("stateThatHasALongNameAndWillBeRenamed");
        StateItem[] items2 = repo.listStates();
        RulesRepositoryTest.assertEquals((int)(items.length + 1), (int)items2.length);
        String newName = "stateThatHasALongNameAndWillBeRenamedNameAfterTheRenaming";
        repo.renameState("stateThatHasALongNameAndWillBeRenamed", "stateThatHasALongNameAndWillBeRenamedNameAfterTheRenaming");
        StateItem[] items3 = repo.listStates();
        RulesRepositoryTest.assertEquals((int)items2.length, (int)items3.length);
        try {
            repo.loadState("stateThatHasALongNameAndWillBeRenamed");
            RulesRepositoryTest.fail((String)"Should never be here. Old name is still used.");
        }
        catch (RulesRepositoryException rulesRepositoryException) {
            // empty catch block
        }
        RulesRepositoryTest.assertNotNull((Object)repo.loadState("stateThatHasALongNameAndWillBeRenamedNameAfterTheRenaming"));
    }

    public void testRemoveState() {
        RulesRepository repo = RepositorySessionUtil.getRepository();
        StateItem[] items = repo.listStates();
        RulesRepositoryTest.assertTrue((items.length > 0 ? 1 : 0) != 0);
        String name = "stateThatHasALongNameAndWillBeRenamed";
        repo.createState("stateThatHasALongNameAndWillBeRenamed");
        StateItem[] items2 = repo.listStates();
        RulesRepositoryTest.assertEquals((int)(items.length + 1), (int)items2.length);
        repo.loadState("stateThatHasALongNameAndWillBeRenamed").remove();
        repo.save();
        StateItem[] items3 = repo.listStates();
        RulesRepositoryTest.assertEquals((int)(items2.length - 1), (int)items3.length);
        try {
            repo.loadState("stateThatHasALongNameAndWillBeRenamed");
            RulesRepositoryTest.fail((String)"Should never be here. Removed state still exists.");
        }
        catch (RulesRepositoryException rulesRepositoryException) {
            // empty catch block
        }
    }

    public void xtestImportExport() {
        RulesRepository repo = RepositorySessionUtil.getRepository();
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        repo.exportRulesRepositoryToStream((OutputStream)bout);
        byte[] repository_backup = bout.toByteArray();
        RulesRepositoryTest.assertNotNull((Object)repository_backup);
        repo.createPackage("testImportExport", "nodescription");
        bout = new ByteArrayOutputStream();
        repo.exportRulesRepositoryToStream((OutputStream)bout);
        byte[] repository_unitest = bout.toByteArray();
        repo.importRulesRepositoryFromStream((InputStream)new ByteArrayInputStream(repository_backup));
        RulesRepositoryTest.assertFalse((boolean)repo.containsPackage("testImportExport"));
        repo.importRulesRepositoryFromStream((InputStream)new ByteArrayInputStream(repository_unitest));
        RulesRepositoryTest.assertTrue((boolean)repo.containsPackage("testImportExport"));
        repo.importRepository((InputStream)new ByteArrayInputStream(repository_unitest));
        RulesRepositoryTest.assertTrue((boolean)repo.containsPackage("testImportExport"));
    }

    public void testShareableNodes() throws Exception {
        RulesRepository repo = RepositorySessionUtil.getRepository();
        AssetItem item = repo.loadDefaultPackage().addAsset("testShareableNodeOriginal", "desc");
        item.updateContent("la");
        item.getNode().addMixin("mix:shareable");
        PackageItem source = repo.createPackage("testShareableNodesPackage", "desc");
        repo.save();
        source.checkout();
        Session session = repo.getSession();
        Workspace workspace = session.getWorkspace();
        String path = "/drools:repository/drools:package_area/testShareableNodesPackage/assets/testShareableNodeShared";
        workspace.clone(workspace.getName(), item.getNode().getPath(), path, false);
        repo.save();
        AssetItem originalItem = repo.loadDefaultPackage().loadAsset("testShareableNodeOriginal");
        AssetItem sharedItem = repo.loadPackage("testShareableNodesPackage").loadAsset("testShareableNodeShared");
        RulesRepositoryTest.assertTrue((boolean)originalItem.getContent().equals("la"));
        RulesRepositoryTest.assertTrue((boolean)sharedItem.getContent().equals("la"));
        originalItem.remove();
    }

    public void testShareableNodesWithQuery() throws Exception {
        RulesRepository repo = RepositorySessionUtil.getRepository();
        AssetItem item = repo.loadGlobalArea().addAsset("testShareableNodesWithQueryOriginal", "desc");
        item.updateFormat("xyz");
        item.getNode().addMixin("mix:shareable");
        PackageItem source = repo.createPackage("testShareableNodesWithQueryPackage", "desc");
        repo.save();
        AssetItemIterator it = repo.loadGlobalArea().queryAssets("drools:format='xyz'");
        List list = RulesRepositoryTest.iteratorToList(it);
        RulesRepositoryTest.assertEquals((int)1, (int)list.size());
        RulesRepositoryTest.assertTrue((boolean)(list.get(0) instanceof AssetItem));
        source.checkout();
        Session session = repo.getSession();
        Workspace workspace = session.getWorkspace();
        String path = "/drools:repository/drools:package_area/testShareableNodesWithQueryPackage/assets/testShareableNodesWithQueryShared";
        workspace.clone(workspace.getName(), item.getNode().getPath(), path, false);
        repo.save();
        AssetItem originalItem = repo.loadGlobalArea().loadAsset("testShareableNodesWithQueryOriginal");
        AssetItem sharedItem = repo.loadPackage("testShareableNodesWithQueryPackage").loadAsset("testShareableNodesWithQueryShared");
        RulesRepositoryTest.assertTrue((boolean)originalItem.getFormat().equals("xyz"));
        RulesRepositoryTest.assertTrue((boolean)sharedItem.getFormat().equals("xyz"));
        it = repo.loadGlobalArea().queryAssets("drools:format='xyz'");
        list = RulesRepositoryTest.iteratorToList(it);
        RulesRepositoryTest.assertEquals((int)1, (int)list.size());
        RulesRepositoryTest.assertTrue((boolean)(list.get(0) instanceof AssetItem));
    }

    public void xtestImportExportWithShareableNodes() throws Exception {
        RulesRepository repo = RepositorySessionUtil.getRepository();
        AssetItem item = repo.loadDefaultPackage().addAsset("testShareableNodeOriginal", "desc");
        item.updateContent("la");
        item.getNode().addMixin("mix:shareable");
        PackageItem source = repo.createPackage("testShareableNodesPackage", "desc");
        repo.save();
        source.checkout();
        Session session = repo.getSession();
        Workspace workspace = session.getWorkspace();
        String path = "/drools:repository/drools:package_area/testShareableNodesPackage/assets/testShareableNodeShared";
        workspace.clone(workspace.getName(), item.getNode().getPath(), path, false);
        repo.save();
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        repo.exportRulesRepositoryToStream((OutputStream)bout);
        byte[] repository_backup = bout.toByteArray();
        RulesRepositoryTest.assertNotNull((Object)repository_backup);
        repo.importRulesRepositoryFromStream((InputStream)new ByteArrayInputStream(repository_backup));
        RulesRepositoryTest.assertTrue((boolean)repo.containsPackage("testShareableNodesPackage"));
        RulesRepositoryTest.assertTrue((boolean)repo.loadPackage("testShareableNodesPackage").containsAsset("testShareableNodeOriginal"));
    }

    public void testConcurrentCopyPackage() throws Exception {
        RulesRepository repo = RepositorySessionUtil.getMultiThreadedRepository();
        PackageItem source = repo.createPackage("testConcurrentCopyPackage", "asset");
        AssetItem item = source.addAsset("testCopyPackage", "desc");
        item.updateContent("la");
        item.checkin("");
        repo.save();
        int NUM_ITERATIONS = 40;
        int NUM_SESSIONS = 2;
        int n = 0;
        while (n < NUM_ITERATIONS) {
            Node folderNode = repo.getAreaNode("drools:package_area");
            while (folderNode.hasNode("testConcurrentCopyPackage2")) {
                folderNode.getNode("testConcurrentCopyPackage2").remove();
                repo.save();
            }
            Thread[] threads = new Thread[NUM_SESSIONS];
            int i = 0;
            while (i < threads.length) {
                String id = "session#" + i;
                ConcurrentCopySession ts = new ConcurrentCopySession(id);
                Thread t = new Thread(ts);
                t.setName(id);
                t.start();
                threads[i] = t;
                ++i;
            }
            i = 0;
            while (i < threads.length) {
                threads[i].join();
                ++i;
            }
            NodeIterator results = folderNode.getNodes("testConcurrentCopyPackage2");
            RulesRepositoryTest.assertEquals((long)1L, (long)results.getSize());
            ++n;
        }
    }

    private static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            int i = 0;
            while (i < children.length) {
                boolean success = RulesRepositoryTest.deleteDir(new File(dir, children[i]));
                if (!success) {
                    return false;
                }
                ++i;
            }
        }
        return dir.delete();
    }

    public static <T> List<T> iteratorToList(Iterator<T> it) {
        ArrayList<T> list = new ArrayList<T>();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    class ConcurrentCopySession
    implements Runnable {
        String identity;
        Random r;
        RulesRepository localRepo;

        ConcurrentCopySession(String identity) {
            this.identity = identity;
            this.r = new Random();
            this.localRepo = RepositorySessionUtil.getMultiThreadedRepository();
        }

        private void randomSleep() {
            long l = this.r.nextInt(90) + 20;
            try {
                Thread.sleep(l);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void run() {
            try {
                this.localRepo.copyPackage("testConcurrentCopyPackage", "testConcurrentCopyPackage2");
                PackageItem dest = this.localRepo.loadPackage("testConcurrentCopyPackage2");
                RulesRepositoryTest.assertNotNull((Object)dest);
                this.randomSleep();
            }
            catch (RulesRepositoryException rulesRepositoryException) {
                // empty catch block
            }
        }
    }
}

