/*
 * Decompiled with CFR 0.152.
 */
package org.drools.repository;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.drools.repository.RepositorySessionUtil;
import org.drools.repository.RulesRepository;
import org.drools.repository.UserInfo;
import org.drools.repository.security.PermissionManager;

public class UserInfoTest
extends TestCase {
    public void testPersistence() throws Exception {
        RulesRepository repo = RepositorySessionUtil.getRepository();
        PermissionManager pm = new PermissionManager(repo);
        HashMap<String, List<String>> perms = new HashMap<String, List<String>>(){
            {
                this.put("package.admin", new ArrayList<String>(){
                    {
                        this.add("1234567890");
                    }
                });
                this.put("package.developer", new ArrayList<String>(){
                    {
                        this.add("1");
                        this.add("2");
                    }
                });
                this.put("analyst", new ArrayList<String>(){
                    {
                        this.add("HR");
                    }
                });
                this.put("admin", new ArrayList());
            }
        };
        pm.updateUserPermissions("wankle", (Map)perms);
        Map perms_ = pm.retrieveUserPermissions("wankle");
        UserInfo info = new UserInfo(repo);
        info.setProperty("inbox", "something", new UserInfo.Val("boo"));
        info.save();
        info.setProperty("inbox", "something", new UserInfo.Val("boo"));
        info.save();
        UserInfoTest.assertEquals((String)"boo", (String)info.getProperty((String)"inbox", (String)"something").value);
        info.setProperty("inbox", "something", new UserInfo.Val("boo2"));
        UserInfoTest.assertEquals((String)"boo2", (String)info.getProperty((String)"inbox", (String)"something").value);
        info.setProperty("inbox", "another", new UserInfo.Val("boo"));
        UserInfoTest.assertEquals((String)"boo", (String)info.getProperty((String)"inbox", (String)"another").value);
        info = new UserInfo(repo);
        info.init(repo, "wankle");
        info.setProperty("inbox", "something", new UserInfo.Val("boo"));
        UserInfoTest.assertEquals((String)"boo", (String)info.getProperty((String)"inbox", (String)"something").value);
        info.setProperty("inbox", "something", new UserInfo.Val("boo2"));
        UserInfoTest.assertEquals((String)"boo2", (String)info.getProperty((String)"inbox", (String)"something").value);
        info.setProperty("inbox", "another", new UserInfo.Val("boo"));
        UserInfoTest.assertEquals((String)"boo", (String)info.getProperty((String)"inbox", (String)"another").value);
        UserInfoTest.assertEquals((int)perms_.size(), (int)pm.retrieveUserPermissions("wankle").size());
        pm.updateUserPermissions("wankle", perms_);
        info = new UserInfo(repo);
        UserInfoTest.assertEquals((String)"boo", (String)info.getProperty((String)"inbox", (String)"another").value);
        pm.removeUserPermissions("wankle");
        info = new UserInfo(repo);
        UserInfoTest.assertEquals((String)"boo", (String)info.getProperty((String)"inbox", (String)"another").value);
        info = new UserInfo(repo);
        info.init(repo, "meee");
        info.setProperty("inbox", "whee", new UserInfo.Val("boo"));
        UserInfoTest.assertEquals((String)"boo", (String)info.getProperty((String)"inbox", (String)"whee").value);
        info = new UserInfo(repo);
        UserInfoTest.assertEquals((String)"boo", (String)info.getProperty((String)"inbox", (String)"another").value);
        info = new UserInfo();
        info.init(repo, "MrX");
        info.setProperty("inbox", "hi", new UserInfo.Val("42"));
        UserInfoTest.assertEquals((String)"42", (String)info.getProperty((String)"inbox", (String)"hi").value);
        info.init(repo, "MrsX");
        info.setProperty("inbox", "hi", new UserInfo.Val("43"));
        UserInfoTest.assertEquals((String)"43", (String)info.getProperty((String)"inbox", (String)"hi").value);
        info.init(repo, "MrX");
        info.setProperty("inbox", "hi", new UserInfo.Val("42"));
        UserInfoTest.assertEquals((String)"42", (String)info.getProperty((String)"inbox", (String)"hi").value);
        UserInfoTest.assertEquals((String)"", (String)info.getProperty((String)"inbox", (String)"qanno").value);
    }

    public void testIterateOverUsers() throws Exception {
        RulesRepository repo = RepositorySessionUtil.getRepository();
        final ArrayList names = new ArrayList();
        UserInfo uf = new UserInfo(repo);
        uf.init(repo, "michael");
        uf.setProperty("random", "property", new UserInfo.Val("hi"));
        UserInfo.eachUser((RulesRepository)repo, (UserInfo.Command)new UserInfo.Command(){

            public void process(String toUser) {
                names.add(toUser);
            }
        });
        UserInfoTest.assertTrue((names.size() > 0 ? 1 : 0) != 0);
        UserInfoTest.assertTrue((boolean)names.contains("michael"));
    }
}

