/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scm.svn;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import org.drools.scm.CompositeScmAction;
import org.drools.scm.ScmAction;
import org.drools.scm.ScmEntry;
import org.drools.scm.svn.SvnActionFactory;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNLogEntryPath;

public class SvnActionFactoryTest
extends TestCase {
    private static String svnUrl;

    public void setUp() throws IOException {
        URL url = ((Object)((Object)this)).getClass().getResource("/svn_repo_empty");
        SvnActionFactoryTest.assertNotNull((Object)url);
        File src = new File(url.getFile());
        File dst = new File(src.getParent(), "/copy_svn_repo_empty");
        SvnActionFactoryTest.delete(dst);
        SvnActionFactoryTest.copy(src, dst);
        svnUrl = "file:///" + dst.getAbsolutePath().replaceAll("\\\\", "/");
    }

    public void tearDown() throws Exception {
        URL url = ((Object)((Object)this)).getClass().getResource("/copy_svn_repo_empty");
        SvnActionFactoryTest.delete(new File(url.getFile()));
    }

    public void testCannotAddDirectoryWithNoParent() throws Exception {
        SvnActionFactory svn = new SvnActionFactory(svnUrl, "mrtrout", "drools");
        CompositeScmAction actions = new CompositeScmAction();
        try {
            SvnActionFactory.AddDirectory addDirectory = new SvnActionFactory.AddDirectory("folder1", "folder1_1");
            actions.addScmAction((ScmAction)addDirectory);
            svn.execute((ScmAction)actions, "test message");
            SvnActionFactoryTest.fail((String)"This should fail as 'folder1' has not yet been created");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testCannotAddDuplicateDirectories() throws Exception {
        SvnActionFactory svn = new SvnActionFactory(svnUrl, "mrtrout", "drools");
        CompositeScmAction actions = new CompositeScmAction();
        actions = new CompositeScmAction();
        SvnActionFactory.AddDirectory addDirectory = new SvnActionFactory.AddDirectory("", "folder1");
        actions.addScmAction((ScmAction)addDirectory);
        svn.execute((ScmAction)actions, "test message");
        try {
            actions = new CompositeScmAction();
            addDirectory = new SvnActionFactory.AddDirectory("", "folder1");
            actions.addScmAction((ScmAction)addDirectory);
            svn.execute((ScmAction)actions, "test message");
            SvnActionFactoryTest.fail((String)"This should fail as 'folder1' already exists");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testAddDirectories() throws Exception {
        SvnActionFactory svn = new SvnActionFactory(svnUrl, "mrtrout", "drools");
        CompositeScmAction actions = new CompositeScmAction();
        actions = new CompositeScmAction();
        SvnActionFactory.AddDirectory addDirectory = new SvnActionFactory.AddDirectory("", "folder1");
        actions.addScmAction((ScmAction)addDirectory);
        svn.execute((ScmAction)actions, "test message");
        actions = new CompositeScmAction();
        addDirectory = new SvnActionFactory.AddDirectory("folder1", "folder1_1");
        actions.addScmAction((ScmAction)addDirectory);
        addDirectory = new SvnActionFactory.AddDirectory("folder1/folder1_1", "folder1_1_1");
        actions.addScmAction((ScmAction)addDirectory);
        addDirectory = new SvnActionFactory.AddDirectory("folder1", "folder1_2");
        actions.addScmAction((ScmAction)addDirectory);
        addDirectory = new SvnActionFactory.AddDirectory("", "folder2/folder2_1");
        actions.addScmAction((ScmAction)addDirectory);
        addDirectory = new SvnActionFactory.AddDirectory("", "folder3/folder3_1/folder3_1_1/folder3_1_1_1");
        actions.addScmAction((ScmAction)addDirectory);
        svn.execute((ScmAction)actions, "test message");
        List list = SvnActionFactoryTest.convertToStringList(svn.listEntries(""));
        SvnActionFactoryTest.assertTrue((boolean)list.contains("folder1"));
        SvnActionFactoryTest.assertTrue((boolean)list.contains("folder1/folder1_1"));
        SvnActionFactoryTest.assertTrue((boolean)list.contains("folder1/folder1_2"));
        SvnActionFactoryTest.assertTrue((boolean)list.contains("folder2/folder2_1"));
        SvnActionFactoryTest.assertTrue((boolean)list.contains("folder3/folder3_1/folder3_1_1/folder3_1_1_1"));
    }

    public void testAddFiles() throws Exception {
        SvnActionFactory svn = new SvnActionFactory(svnUrl, "mrtrout", "drools");
        CompositeScmAction actions = new CompositeScmAction();
        SvnActionFactory.AddDirectory addDirectory = new SvnActionFactory.AddDirectory("", "folder1");
        actions.addScmAction((ScmAction)addDirectory);
        SvnActionFactory.AddFile addFile = new SvnActionFactory.AddFile("folder1", "file1.dat", new byte[]{1, 1, 1, 1});
        actions.addScmAction((ScmAction)addFile);
        addDirectory = new SvnActionFactory.AddDirectory("folder1", "folder1_1");
        actions.addScmAction((ScmAction)addDirectory);
        addFile = new SvnActionFactory.AddFile("folder1/folder1_1", "file1_1.dat", new byte[4]);
        actions.addScmAction((ScmAction)addFile);
        svn.execute((ScmAction)actions, "test message");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        svn.getContent("folder1", "file1.dat", -1L, (OutputStream)baos);
        SvnActionFactoryTest.assertTrue((boolean)Arrays.equals(new byte[]{1, 1, 1, 1}, baos.toByteArray()));
        baos = new ByteArrayOutputStream();
        svn.getContent("folder1/folder1_1", "file1_1.dat", -1L, (OutputStream)baos);
        SvnActionFactoryTest.assertTrue((boolean)Arrays.equals(new byte[4], baos.toByteArray()));
        List list = SvnActionFactoryTest.convertToStringList(svn.listEntries(""));
        SvnActionFactoryTest.assertTrue((boolean)list.contains("folder1"));
        SvnActionFactoryTest.assertTrue((boolean)list.contains("folder1/file1.dat"));
        SvnActionFactoryTest.assertTrue((boolean)list.contains("folder1/folder1_1"));
        SvnActionFactoryTest.assertTrue((boolean)list.contains("folder1/folder1_1/file1_1.dat"));
    }

    public void testUpdateFile() throws Exception {
        SvnActionFactory svn = new SvnActionFactory(svnUrl, "mrtrout", "drools");
        CompositeScmAction actions = new CompositeScmAction();
        SvnActionFactory.AddDirectory addDirectory = new SvnActionFactory.AddDirectory("", "folder1");
        actions.addScmAction((ScmAction)addDirectory);
        byte[] oldContent = new byte[]{1, 1, 1, 1};
        byte[] byArray = new byte[4];
        byArray[0] = 1;
        byArray[2] = 1;
        byte[] newContent = byArray;
        SvnActionFactory.AddFile addFile = new SvnActionFactory.AddFile("folder1", "file1.dat", oldContent);
        actions.addScmAction((ScmAction)addFile);
        svn.execute((ScmAction)actions, "test message");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        svn.getContent("folder1", "file1.dat", -1L, (OutputStream)baos);
        SvnActionFactoryTest.assertTrue((boolean)Arrays.equals(oldContent, baos.toByteArray()));
        actions = new CompositeScmAction();
        SvnActionFactory.UpdateFile updateFile = new SvnActionFactory.UpdateFile("folder1", "file1.dat", oldContent, newContent);
        actions.addScmAction((ScmAction)updateFile);
        svn.execute((ScmAction)actions, "test message");
        baos = new ByteArrayOutputStream();
        svn.getContent("folder1", "file1.dat", -1L, (OutputStream)baos);
        SvnActionFactoryTest.assertTrue((boolean)Arrays.equals(newContent, baos.toByteArray()));
        List list = SvnActionFactoryTest.convertToStringList(svn.listEntries(""));
        SvnActionFactoryTest.assertTrue((boolean)list.contains("folder1"));
        SvnActionFactoryTest.assertTrue((boolean)list.contains("folder1/file1.dat"));
    }

    public void testCopyFile() throws Exception {
        SvnActionFactory svn = new SvnActionFactory(svnUrl, "mrtrout", "drools");
        CompositeScmAction actions = new CompositeScmAction();
        SvnActionFactory.AddDirectory addDirectory = new SvnActionFactory.AddDirectory("", "folder1");
        actions.addScmAction((ScmAction)addDirectory);
        byte[] content = new byte[]{1, 1, 1, 1};
        SvnActionFactory.AddFile addFile = new SvnActionFactory.AddFile("folder1", "file1.dat", content);
        actions.addScmAction((ScmAction)addFile);
        svn.execute((ScmAction)actions, "test message");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        svn.getContent("folder1", "file1.dat", -1L, (OutputStream)baos);
        SvnActionFactoryTest.assertTrue((boolean)Arrays.equals(content, baos.toByteArray()));
        List list = SvnActionFactoryTest.convertToStringList(svn.listEntries(""));
        SvnActionFactoryTest.assertTrue((boolean)list.contains("folder1"));
        SvnActionFactoryTest.assertTrue((boolean)list.contains("folder1/file1.dat"));
        SvnActionFactoryTest.assertFalse((boolean)list.contains("folder2/file2.dat"));
        actions = new CompositeScmAction();
        addDirectory = new SvnActionFactory.AddDirectory("", "folder2");
        actions.addScmAction((ScmAction)addDirectory);
        SvnActionFactory.CopyFile copyFile = new SvnActionFactory.CopyFile("folder1", "file1.dat", "folder2", "file2.dat", svn.getLatestRevision());
        actions.addScmAction((ScmAction)copyFile);
        svn.execute((ScmAction)actions, "test message");
        baos = new ByteArrayOutputStream();
        svn.getContent("folder2", "file2.dat", -1L, (OutputStream)baos);
        SvnActionFactoryTest.assertTrue((boolean)Arrays.equals(content, baos.toByteArray()));
        list = SvnActionFactoryTest.convertToStringList(svn.listEntries(""));
        SvnActionFactoryTest.assertTrue((boolean)list.contains("folder1"));
        SvnActionFactoryTest.assertTrue((boolean)list.contains("folder1/file1.dat"));
        SvnActionFactoryTest.assertTrue((boolean)list.contains("folder2/file2.dat"));
    }

    public void testCopyDirectory() throws Exception {
        SvnActionFactory svn = new SvnActionFactory(svnUrl, "mrtrout", "drools");
        CompositeScmAction actions = new CompositeScmAction();
        SvnActionFactory.AddDirectory addDirectory = new SvnActionFactory.AddDirectory("", "folder1");
        actions.addScmAction((ScmAction)addDirectory);
        byte[] content1 = new byte[]{1, 1, 1, 1};
        SvnActionFactory.AddFile addFile = new SvnActionFactory.AddFile("folder1", "file1.dat", content1);
        actions.addScmAction((ScmAction)addFile);
        addDirectory = new SvnActionFactory.AddDirectory("folder1", "folder1_1");
        actions.addScmAction((ScmAction)addDirectory);
        byte[] byArray = new byte[4];
        byArray[0] = 1;
        byArray[3] = 1;
        byte[] content2 = byArray;
        addFile = new SvnActionFactory.AddFile("folder1/folder1_1", "file1.dat", content2);
        actions.addScmAction((ScmAction)addFile);
        svn.execute((ScmAction)actions, "test message");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        svn.getContent("folder1", "file1.dat", -1L, (OutputStream)baos);
        SvnActionFactoryTest.assertTrue((boolean)Arrays.equals(content1, baos.toByteArray()));
        baos = new ByteArrayOutputStream();
        svn.getContent("folder1/folder1_1", "file1.dat", -1L, (OutputStream)baos);
        SvnActionFactoryTest.assertTrue((boolean)Arrays.equals(content2, baos.toByteArray()));
        List list = SvnActionFactoryTest.convertToStringList(svn.listEntries(""));
        SvnActionFactoryTest.assertTrue((boolean)list.contains("folder1"));
        SvnActionFactoryTest.assertTrue((boolean)list.contains("folder1/folder1_1/file1.dat"));
        SvnActionFactoryTest.assertFalse((boolean)list.contains("folder2/folder1/file1.dat"));
        actions = new CompositeScmAction();
        addDirectory = new SvnActionFactory.AddDirectory("", "folder2");
        actions.addScmAction((ScmAction)addDirectory);
        SvnActionFactory.CopyDirectory copyDirectory = new SvnActionFactory.CopyDirectory("folder1", "folder2/folder1", svn.getLatestRevision());
        actions.addScmAction((ScmAction)copyDirectory);
        svn.execute((ScmAction)actions, "test message");
        baos = new ByteArrayOutputStream();
        svn.getContent("folder1", "file1.dat", -1L, (OutputStream)baos);
        SvnActionFactoryTest.assertTrue((boolean)Arrays.equals(content1, baos.toByteArray()));
        baos = new ByteArrayOutputStream();
        svn.getContent("folder1/folder1_1", "file1.dat", -1L, (OutputStream)baos);
        SvnActionFactoryTest.assertTrue((boolean)Arrays.equals(content2, baos.toByteArray()));
        baos = new ByteArrayOutputStream();
        svn.getContent("folder2/folder1", "file1.dat", -1L, (OutputStream)baos);
        SvnActionFactoryTest.assertTrue((boolean)Arrays.equals(content1, baos.toByteArray()));
        baos = new ByteArrayOutputStream();
        svn.getContent("folder2/folder1/folder1_1", "file1.dat", -1L, (OutputStream)baos);
        SvnActionFactoryTest.assertTrue((boolean)Arrays.equals(content2, baos.toByteArray()));
        list = SvnActionFactoryTest.convertToStringList(svn.listEntries(""));
        SvnActionFactoryTest.assertTrue((boolean)list.contains("folder1"));
        SvnActionFactoryTest.assertTrue((boolean)list.contains("folder1/folder1_1/file1.dat"));
        SvnActionFactoryTest.assertTrue((boolean)list.contains("folder2/folder1/file1.dat"));
    }

    public void testMoveFile() throws Exception {
        SvnActionFactory svn = new SvnActionFactory(svnUrl, "mrtrout", "drools");
        CompositeScmAction actions = new CompositeScmAction();
        SvnActionFactory.AddDirectory addDirectory = new SvnActionFactory.AddDirectory("", "folder1");
        actions.addScmAction((ScmAction)addDirectory);
        byte[] content = new byte[]{1, 1, 1, 1};
        SvnActionFactory.AddFile addFile = new SvnActionFactory.AddFile("folder1", "file1.dat", content);
        actions.addScmAction((ScmAction)addFile);
        svn.execute((ScmAction)actions, "test message");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        svn.getContent("folder1", "file1.dat", -1L, (OutputStream)baos);
        SvnActionFactoryTest.assertTrue((boolean)Arrays.equals(content, baos.toByteArray()));
        List list = SvnActionFactoryTest.convertToStringList(svn.listEntries(""));
        SvnActionFactoryTest.assertTrue((boolean)list.contains("folder1"));
        SvnActionFactoryTest.assertTrue((boolean)list.contains("folder1/file1.dat"));
        SvnActionFactoryTest.assertFalse((boolean)list.contains("folder2/file2.dat"));
        actions = new CompositeScmAction();
        addDirectory = new SvnActionFactory.AddDirectory("", "folder2");
        actions.addScmAction((ScmAction)addDirectory);
        SvnActionFactory.MoveFile moveFile = new SvnActionFactory.MoveFile("folder1", "file1.dat", "folder2", "file2.dat", svn.getLatestRevision());
        actions.addScmAction((ScmAction)moveFile);
        svn.execute((ScmAction)actions, "test message");
        baos = new ByteArrayOutputStream();
        svn.getContent("folder2", "file2.dat", -1L, (OutputStream)baos);
        SvnActionFactoryTest.assertTrue((boolean)Arrays.equals(content, baos.toByteArray()));
        list = SvnActionFactoryTest.convertToStringList(svn.listEntries(""));
        SvnActionFactoryTest.assertTrue((boolean)list.contains("folder1"));
        SvnActionFactoryTest.assertFalse((boolean)list.contains("folder1/file1.dat"));
        SvnActionFactoryTest.assertTrue((boolean)list.contains("folder2/file2.dat"));
    }

    public void testMoveDirectory() throws Exception {
        SvnActionFactory svn = new SvnActionFactory(svnUrl, "mrtrout", "drools");
        CompositeScmAction actions = new CompositeScmAction();
        SvnActionFactory.AddDirectory addDirectory = new SvnActionFactory.AddDirectory("", "folder1");
        actions.addScmAction((ScmAction)addDirectory);
        byte[] content = new byte[]{1, 1, 1, 1};
        SvnActionFactory.AddFile addFile = new SvnActionFactory.AddFile("folder1", "file1.dat", content);
        actions.addScmAction((ScmAction)addFile);
        svn.execute((ScmAction)actions, "test message");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        svn.getContent("folder1", "file1.dat", -1L, (OutputStream)baos);
        SvnActionFactoryTest.assertTrue((boolean)Arrays.equals(content, baos.toByteArray()));
        actions = new CompositeScmAction();
        SvnActionFactory.MoveDirectory moveDirectory = new SvnActionFactory.MoveDirectory("folder1", "folder2", svn.getLatestRevision());
        actions.addScmAction((ScmAction)moveDirectory);
        svn.execute((ScmAction)actions, "test message");
        baos = new ByteArrayOutputStream();
        svn.getContent("folder2", "file1.dat", -1L, (OutputStream)baos);
        SvnActionFactoryTest.assertTrue((boolean)Arrays.equals(content, baos.toByteArray()));
        List list = SvnActionFactoryTest.convertToStringList(svn.listEntries(""));
        SvnActionFactoryTest.assertFalse((boolean)list.contains("folder1"));
        SvnActionFactoryTest.assertFalse((boolean)list.contains("folder1/file1.dat"));
        SvnActionFactoryTest.assertTrue((boolean)list.contains("folder2/file1.dat"));
    }

    public void testDeleteFile() throws Exception {
        SvnActionFactory svn = new SvnActionFactory(svnUrl, "mrtrout", "drools");
        CompositeScmAction actions = new CompositeScmAction();
        SvnActionFactory.AddDirectory addDirectory = new SvnActionFactory.AddDirectory("", "folder1");
        actions.addScmAction((ScmAction)addDirectory);
        byte[] content = new byte[]{1, 1, 1, 1};
        SvnActionFactory.AddFile addFile = new SvnActionFactory.AddFile("folder1", "file1.dat", content);
        actions.addScmAction((ScmAction)addFile);
        svn.execute((ScmAction)actions, "test message");
        List list = SvnActionFactoryTest.convertToStringList(svn.listEntries(""));
        SvnActionFactoryTest.assertTrue((boolean)list.contains("folder1"));
        SvnActionFactoryTest.assertTrue((boolean)list.contains("folder1/file1.dat"));
        actions = new CompositeScmAction();
        SvnActionFactory.DeleteFile deleteFile = new SvnActionFactory.DeleteFile("folder1", "file1.dat");
        actions.addScmAction((ScmAction)deleteFile);
        svn.execute((ScmAction)actions, "test message");
        list = SvnActionFactoryTest.convertToStringList(svn.listEntries(""));
        SvnActionFactoryTest.assertTrue((boolean)list.contains("folder1"));
        SvnActionFactoryTest.assertFalse((boolean)list.contains("folder1/file1.dat"));
    }

    public void testDeleteDirectory() throws Exception {
        SvnActionFactory svn = new SvnActionFactory(svnUrl, "mrtrout", "drools");
        CompositeScmAction actions = new CompositeScmAction();
        SvnActionFactory.AddDirectory addDirectory = new SvnActionFactory.AddDirectory("", "folder1");
        actions.addScmAction((ScmAction)addDirectory);
        byte[] content = new byte[]{1, 1, 1, 1};
        SvnActionFactory.AddFile addFile = new SvnActionFactory.AddFile("folder1", "file1.dat", content);
        actions.addScmAction((ScmAction)addFile);
        addDirectory = new SvnActionFactory.AddDirectory("", "folder2");
        actions.addScmAction((ScmAction)addDirectory);
        svn.execute((ScmAction)actions, "test message");
        List list = SvnActionFactoryTest.convertToStringList(svn.listEntries(""));
        SvnActionFactoryTest.assertTrue((boolean)list.contains("folder1"));
        SvnActionFactoryTest.assertTrue((boolean)list.contains("folder1/file1.dat"));
        SvnActionFactoryTest.assertTrue((boolean)list.contains("folder2"));
        actions = new CompositeScmAction();
        SvnActionFactory.DeleteDirectory deleteDirectory = new SvnActionFactory.DeleteDirectory("folder1");
        actions.addScmAction((ScmAction)deleteDirectory);
        svn.execute((ScmAction)actions, "test message");
        list = SvnActionFactoryTest.convertToStringList(svn.listEntries(""));
        SvnActionFactoryTest.assertFalse((boolean)list.contains("folder1"));
        SvnActionFactoryTest.assertFalse((boolean)list.contains("folder1/file1.dat"));
        SvnActionFactoryTest.assertTrue((boolean)list.contains("folder2"));
    }

    public void XXXtestHistory() throws Exception {
        SvnActionFactory svn = new SvnActionFactory(svnUrl, "mrtrout", "drools");
        CompositeScmAction actions = new CompositeScmAction();
        SvnActionFactory.AddDirectory addDirectory = new SvnActionFactory.AddDirectory("", "folder1");
        actions.addScmAction((ScmAction)addDirectory);
        byte[] content = new byte[]{1, 1, 1, 1};
        SvnActionFactory.AddFile addFile = new SvnActionFactory.AddFile("folder1", "file1.dat", content);
        actions.addScmAction((ScmAction)addFile);
        svn.execute((ScmAction)actions, "test message");
        actions = new CompositeScmAction();
        SvnActionFactory.MoveDirectory moveDirectory = new SvnActionFactory.MoveDirectory("folder1", "folder2", svn.getLatestRevision());
        actions.addScmAction((ScmAction)moveDirectory);
        svn.execute((ScmAction)actions, "test message");
        List collection = svn.log(new String[]{""}, 0L, -1L);
        for (SVNLogEntry logEntry : collection) {
            Map map = logEntry.getChangedPaths();
            Set changePathSet = map.keySet();
            Iterator it2 = changePathSet.iterator();
            while (it2.hasNext()) {
                SVNLogEntryPath entryPath = (SVNLogEntryPath)map.get(it2.next());
                System.out.println(entryPath);
            }
        }
    }

    public static void copy(File src, File dest) throws IOException {
        if (src.isDirectory()) {
            dest.mkdirs();
            String[] list = src.list();
            int i = 0;
            while (i < list.length) {
                String dest1 = String.valueOf(dest.getPath()) + File.separator + list[i];
                String src1 = String.valueOf(src.getPath()) + File.separator + list[i];
                SvnActionFactoryTest.copy(new File(src1), new File(dest1));
                ++i;
            }
        } else {
            int c;
            FileInputStream fin = new FileInputStream(src);
            FileOutputStream fout = new FileOutputStream(dest);
            while ((c = fin.read()) >= 0) {
                fout.write(c);
            }
            fin.close();
            fout.close();
        }
    }

    public static void delete(File src) throws IOException {
        if (src.isDirectory()) {
            String[] list = src.list();
            int i = 0;
            while (i < list.length) {
                String src1 = String.valueOf(src.getPath()) + File.separator + list[i];
                SvnActionFactoryTest.delete(new File(src1));
                ++i;
            }
            src.delete();
        } else {
            src.delete();
        }
    }

    public static List convertToStringList(List list) {
        ArrayList<String> files = new ArrayList<String>(list.size());
        for (ScmEntry entry : list) {
            files.add(entry.getPath().equals("") ? entry.getName() : String.valueOf(entry.getPath()) + "/" + entry.getName());
        }
        return files;
    }

    public static Map convertToMap(List list) {
        HashMap<String, Object> map = new HashMap<String, Object>(list.size());
        for (ScmEntry entry : list) {
            if (entry.isDirectory()) {
                map.put(entry.getPath().equals("") ? entry.getName() : String.valueOf(entry.getPath()) + "/" + entry.getName(), entry);
                continue;
            }
            ArrayList<ScmEntry> files = (ArrayList<ScmEntry>)map.get(entry.getPath());
            if (files == null) {
                files = new ArrayList<ScmEntry>();
                map.put(entry.getPath(), files);
            }
            files.add(entry);
        }
        return map;
    }
}

