/*
 * Decompiled with CFR 0.152.
 */
package org.drools.repository;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import org.apache.log4j.Logger;
import org.drools.repository.CategorisableItem;
import org.drools.repository.Item;
import org.drools.repository.RulesRepository;
import org.drools.repository.RulesRepositoryException;

public class CategoryItem
extends Item {
    private Logger log = Logger.getLogger(CategoryItem.class);
    public static final String TAG_NODE_TYPE_NAME = "drools:categoryNodeType";

    public CategoryItem(RulesRepository rulesRepository, Node node) throws RulesRepositoryException {
        super(rulesRepository, node);
    }

    public String getFullPath() throws RulesRepositoryException {
        try {
            StringBuffer returnString = new StringBuffer();
            returnString.append(this.node.getName());
            Node parentNode = this.node.getParent();
            while (!parentNode.getName().equals("drools:tag_area")) {
                returnString.insert(0, String.valueOf(parentNode.getName()) + "/");
                parentNode = parentNode.getParent();
            }
            return returnString.toString();
        }
        catch (Exception e) {
            this.log.error((Object)("Caught Exception: " + e));
            throw new RulesRepositoryException(e);
        }
    }

    public List getChildTags() throws RulesRepositoryException {
        ArrayList<CategoryItem> children = new ArrayList<CategoryItem>();
        try {
            NodeIterator it = this.node.getNodes();
            while (it.hasNext()) {
                Node currentNode = it.nextNode();
                children.add(new CategoryItem(this.rulesRepository, currentNode));
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Caught Exception: " + e));
            throw new RulesRepositoryException(e);
        }
        return children;
    }

    public CategoryItem addCategory(String name, String description) {
        try {
            Node child = this.node.addNode(name, TAG_NODE_TYPE_NAME);
            this.rulesRepository.getSession().save();
            return new CategoryItem(this.rulesRepository, child);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RulesRepositoryException(e);
        }
    }

    public void remove() {
        try {
            PropertyIterator pi = this.node.getReferences();
            while (pi.hasNext()) {
                Property p = pi.nextProperty();
                Node parentNode = p.getParent();
                if (parentNode.getProperty("drools:archive").getBoolean()) {
                    CategorisableItem.removeCategory(parentNode, this.node.getName());
                    continue;
                }
                throw new RulesRepositoryException("The category still has some assets linked to it. You will need to remove the links so you can delete the cateogory.");
            }
            this.node.remove();
        }
        catch (RepositoryException e) {
            this.log.error((Object)e);
        }
    }
}

