/*
 * Decompiled with CFR 0.152.
 */
package org.drools.repository;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.jcr.Binary;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.nodetype.NodeType;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import org.drools.repository.AssetHistoryIterator;
import org.drools.repository.AssetItem;
import org.drools.repository.AssetItemIterator;
import org.drools.repository.PackageIterator;
import org.drools.repository.RulesRepository;
import org.drools.repository.RulesRepositoryException;
import org.drools.repository.StateItem;
import org.drools.repository.VersionableItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageItem
extends VersionableItem {
    private static final Logger log = LoggerFactory.getLogger(PackageItem.class);
    public static final String ASSET_FOLDER_NAME = "assets";
    public static final String PACKAGE_FORMAT = "package";
    public static final String RULE_PACKAGE_TYPE_NAME = "drools:packageNodeType";
    public static final String HEADER_PROPERTY_NAME = "drools:header";
    public static final String EXTERNAL_URI_PROPERTY_NAME = "drools:externalURI";
    public static final String CATEGORY_RULE_KEYS_PROPERTY_NAME = "categoryRuleKeys";
    public static final String CATEGORY_RULE_VALUES_PROPERTY_NAME = "categoryRuleValues";
    private static final String COMPILED_PACKAGE_PROPERTY_NAME = "drools:compiledPackage";

    public PackageItem(RulesRepository rulesRepository, Node node) throws RulesRepositoryException {
        super(rulesRepository, node);
        try {
            if (!this.node.getPrimaryNodeType().getName().equals(RULE_PACKAGE_TYPE_NAME) && !this.isHistoricalVersion()) {
                String message = String.valueOf(this.node.getName()) + " is not a node of type " + RULE_PACKAGE_TYPE_NAME + ". It is a node of type: " + this.node.getPrimaryNodeType().getName();
                log.error(message);
                throw new RulesRepositoryException(message);
            }
        }
        catch (Exception e) {
            log.error("Caught exception: " + e);
            throw new RulesRepositoryException(e);
        }
    }

    PackageItem() {
        super(null, null);
    }

    @Override
    public String getName() {
        try {
            if (this.isSnapshot()) {
                return this.node.getParent().getName();
            }
            return super.getName();
        }
        catch (RepositoryException e) {
            throw new RulesRepositoryException(e);
        }
    }

    public boolean isSnapshot() {
        try {
            return !this.rulesRepository.isNotSnapshot(this.node.getParent());
        }
        catch (RepositoryException e) {
            throw new IllegalStateException(e);
        }
    }

    public void updateBinaryUpToDate(boolean status) {
        try {
            this.checkIsUpdateable();
            this.checkout();
            this.node.setProperty("drools:binaryUpToDate", status);
        }
        catch (RepositoryException e) {
            log.error("fail to update drools:binaryUpToDate of " + this.getName(), (Throwable)e);
        }
    }

    public boolean isBinaryUpToDate() {
        try {
            if (this.node.hasProperty("drools:binaryUpToDate")) {
                return this.node.getProperty("drools:binaryUpToDate").getBoolean();
            }
            return false;
        }
        catch (RepositoryException e) {
            log.error("fail to get drools:binaryUpToDate of " + this.getName(), (Throwable)e);
            throw new RulesRepositoryException(e);
        }
    }

    public String getSnapshotName() {
        return super.getName();
    }

    public AssetItem addAsset(String assetName, String description) {
        return this.addAsset(assetName, description, null, null);
    }

    public AssetItem addAsset(String assetName, String description, String initialCategory, String format) {
        try {
            assetName = assetName.trim();
            Node rulesFolder = this.node.getNode(ASSET_FOLDER_NAME);
            Node ruleNode = rulesFolder.addNode(assetName, "drools:assetNodeType");
            ruleNode.setProperty("drools:title", assetName);
            ruleNode.setProperty("drools:description", description);
            if (format != null) {
                ruleNode.setProperty("drools:format", format);
            } else {
                ruleNode.setProperty("drools:format", "txt");
            }
            ruleNode.setProperty("drools:checkinComment", "Initial");
            Calendar lastModified = Calendar.getInstance();
            ruleNode.setProperty("drools:lastModified", lastModified);
            ruleNode.setProperty("drools:packageName", this.getName());
            ruleNode.setProperty("drools:creator", this.node.getSession().getUserID());
            this.rulesRepository.getSession().save();
            AssetItem rule = new AssetItem(this.rulesRepository, ruleNode);
            rule.updateState("Draft");
            if (initialCategory != null) {
                rule.addCategory(initialCategory);
            }
            return rule;
        }
        catch (RepositoryException e) {
            if (e instanceof ItemExistsException) {
                throw new RulesRepositoryException("A rule of that name already exists in that package.", e);
            }
            throw new RulesRepositoryException(e);
        }
    }

    public AssetItem addAssetImportedFromGlobalArea(String sharedAssetName) {
        try {
            Node rulesFolder = this.node.getNode(ASSET_FOLDER_NAME);
            Session session = this.rulesRepository.getSession();
            Workspace workspace = session.getWorkspace();
            PackageItem globalArea = this.rulesRepository.loadGlobalArea();
            AssetItem globalAssetItem = globalArea.loadAsset(sharedAssetName);
            if (!this.hasMixin(globalAssetItem.getNode())) {
                globalAssetItem.checkout();
                globalAssetItem.getNode().addMixin("mix:shareable");
                globalAssetItem.checkin("add mix:shareable");
            }
            String path = String.valueOf(rulesFolder.getPath()) + "/" + globalAssetItem.getName();
            workspace.clone(workspace.getName(), globalAssetItem.getNode().getPath(), path, false);
            Node ruleNode = rulesFolder.getNode(globalAssetItem.getName());
            AssetItem rule = new AssetItem(this.rulesRepository, ruleNode);
            return rule;
        }
        catch (RepositoryException e) {
            if (e instanceof ItemExistsException) {
                throw new RulesRepositoryException("A rule of that name already exists in that package.", e);
            }
            throw new RulesRepositoryException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasMixin(Node node) {
        try {
            NodeType[] nodeTypes;
            NodeType[] nodeTypeArray = nodeTypes = node.getMixinNodeTypes();
            int n = nodeTypes.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                NodeType nodeType = nodeTypeArray[n2];
                if (nodeType.isNodeType("mix:shareable")) {
                    return true;
                }
                ++n2;
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return false;
    }

    public void remove() {
        this.checkIsUpdateable();
        try {
            log.info("USER:" + this.getCurrentUserName() + " REMOVEING package [" + this.getName() + "]");
            this.node.remove();
        }
        catch (RepositoryException e) {
            throw new RulesRepositoryException("Was not able to delete package.", e);
        }
    }

    public Iterator<AssetItem> getAssets() {
        try {
            Node content = this.getVersionContentNode();
            return new AssetItemIterator(content.getNode(ASSET_FOLDER_NAME).getNodes(), this.rulesRepository);
        }
        catch (RepositoryException e) {
            throw new RulesRepositoryException(e);
        }
    }

    public AssetItemIterator queryAssets(String fieldPredicates, boolean seekArchived) {
        try {
            String sql = "SELECT * FROM drools:assetNodeType";
            sql = String.valueOf(sql) + " WHERE jcr:path LIKE '" + this.getVersionContentNode().getPath() + "/" + ASSET_FOLDER_NAME + "[%]/%'";
            if (fieldPredicates.length() > 0) {
                sql = String.valueOf(sql) + " and " + fieldPredicates;
            }
            if (!seekArchived) {
                sql = String.valueOf(sql) + " AND drools:archive = 'false'";
            }
            sql = String.valueOf(sql) + " ORDER BY drools:title";
            Query q = this.node.getSession().getWorkspace().getQueryManager().createQuery(sql, "sql");
            long time = System.currentTimeMillis();
            QueryResult res = q.execute();
            NodeIterator it = res.getNodes();
            long taken = System.currentTimeMillis() - time;
            if (taken > 2000L) {
                log.debug("QueryExec time is: " + (System.currentTimeMillis() - time));
                log.debug("SQL is " + sql);
                log.debug(it.getClass().getName());
            }
            return new AssetItemIterator(it, this.rulesRepository);
        }
        catch (RepositoryException e) {
            throw new RulesRepositoryException(e);
        }
    }

    public AssetItemIterator queryAssets(String fieldPredicates) {
        return this.queryAssets(fieldPredicates, false);
    }

    public AssetItemIterator listArchivedAssets() {
        return this.queryAssets("drools:archive = 'true'", true);
    }

    public AssetItemIterator listAssetsByFormat(String ... formats) {
        if (formats.length == 1) {
            return this.queryAssets("drools:format='" + formats[0] + "'");
        }
        String predicate = " ( ";
        int i = 0;
        while (i < formats.length) {
            predicate = String.valueOf(predicate) + "drools:format" + "='" + formats[i] + "'";
            if (i != formats.length - 1) {
                predicate = String.valueOf(predicate) + " OR ";
            }
            ++i;
        }
        predicate = String.valueOf(predicate) + " ) ";
        return this.queryAssets(predicate);
    }

    public AssetItemIterator listAssetsNotOfFormat(String[] formats) {
        if (formats.length == 1) {
            return this.queryAssets("not drools:format='" + formats[0] + "'");
        }
        String predicate = "not ( ";
        int i = 0;
        while (i < formats.length) {
            predicate = String.valueOf(predicate) + "drools:format='" + formats[i] + "'";
            if (i != formats.length - 1) {
                predicate = String.valueOf(predicate) + " OR ";
            }
            ++i;
        }
        predicate = String.valueOf(predicate) + " ) ";
        return this.queryAssets(predicate);
    }

    public AssetItem loadAsset(String name) {
        try {
            Node content = this.getVersionContentNode();
            return new AssetItem(this.rulesRepository, content.getNode(ASSET_FOLDER_NAME).getNode(name));
        }
        catch (RepositoryException e) {
            throw new RulesRepositoryException(e);
        }
    }

    public boolean containsAsset(String name) {
        try {
            Node content = this.getVersionContentNode();
            return content.getNode(ASSET_FOLDER_NAME).hasNode(name);
        }
        catch (RepositoryException e) {
            throw new RulesRepositoryException(e);
        }
    }

    public String toString() {
        try {
            StringBuffer returnString = new StringBuffer();
            returnString.append("Content of the rule package named " + this.node.getName() + ":");
            returnString.append("Description: " + this.getDescription() + "\n");
            returnString.append("Format: " + this.getFormat() + "\n");
            returnString.append("Last modified: " + this.getLastModified() + "\n");
            returnString.append("Title: " + this.getTitle() + "\n");
            returnString.append("----\n");
            return returnString.toString();
        }
        catch (Exception e) {
            log.error("Caught Exception", (Throwable)e);
            return "";
        }
    }

    @Override
    public PackageItem getPrecedingVersion() throws RulesRepositoryException {
        try {
            Node precedingVersionNode = this.getPrecedingVersionNode();
            if (precedingVersionNode != null) {
                return new PackageItem(this.rulesRepository, precedingVersionNode);
            }
            return null;
        }
        catch (Exception e) {
            log.error("Caught exception", (Throwable)e);
            throw new RulesRepositoryException(e);
        }
    }

    @Override
    public PackageItem getSucceedingVersion() throws RulesRepositoryException {
        try {
            Node succeedingVersionNode = this.getSucceedingVersionNode();
            if (succeedingVersionNode != null) {
                return new PackageItem(this.rulesRepository, succeedingVersionNode);
            }
            return null;
        }
        catch (Exception e) {
            log.error("Caught exception", (Throwable)e);
            throw new RulesRepositoryException(e);
        }
    }

    public Iterator<AssetItem> getAssetsWithStatus(StateItem state, StateItem ignoreState) {
        LinkedList<AssetItem> result = new LinkedList<AssetItem>();
        Iterator<AssetItem> rules = this.getAssets();
        block0: while (rules.hasNext()) {
            AssetItem head = rules.next();
            if (head.sameState(state)) {
                result.add(head);
                continue;
            }
            if (head.sameState(ignoreState)) continue;
            LinkedList<AssetItem> fullHistory = new LinkedList<AssetItem>();
            AssetHistoryIterator iter = head.getHistory();
            while (iter.hasNext()) {
                AssetItem element = (AssetItem)iter.next();
                if (element.getVersionNumber() == 0L) continue;
                fullHistory.add(element);
            }
            this.sortHistoryByVersionNumber(fullHistory);
            for (AssetItem prevRule : fullHistory) {
                if (!prevRule.sameState(state)) continue;
                result.add(prevRule);
                continue block0;
            }
        }
        return result.iterator();
    }

    void sortHistoryByVersionNumber(List<AssetItem> fullHistory) {
        Collections.sort(fullHistory, new Comparator<AssetItem>(){

            @Override
            public int compare(AssetItem a1, AssetItem a2) {
                long la2;
                long la1 = a1.getVersionNumber();
                return la1 == (la2 = a2.getVersionNumber()) ? 0 : (la1 < la2 ? 1 : -1);
            }
        });
    }

    public Iterator<AssetItem> getAssetsWithStatus(StateItem state) {
        return this.getAssetsWithStatus(state, null);
    }

    public String getExternalURI() {
        return this.getStringProperty(EXTERNAL_URI_PROPERTY_NAME);
    }

    public void updateExternalURI(String uri) {
        this.updateStringProperty(uri, EXTERNAL_URI_PROPERTY_NAME);
    }

    public void setCatRules(String map) {
        this.updateStringProperty(map, CATEGORY_RULE_KEYS_PROPERTY_NAME);
    }

    public void updateCategoryRules(String keys, String values) throws RulesRepositoryException {
        try {
            this.checkout();
            this.updateStringProperty(keys, CATEGORY_RULE_KEYS_PROPERTY_NAME);
            this.updateStringProperty(values, CATEGORY_RULE_VALUES_PROPERTY_NAME);
        }
        catch (Exception e) {
            log.error("Caught Exception", (Throwable)e);
            throw new RulesRepositoryException(e);
        }
    }

    private static HashMap<String, String> convertFromObjectGraphs(String[] keys, String[] values) {
        HashMap<String, String> hash = new HashMap<String, String>();
        int i = 0;
        while (i < keys.length) {
            hash.put(keys[i], values[i]);
            ++i;
        }
        return hash;
    }

    public String[] convertStringToArray(String tagName) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer tok = new StringTokenizer(tagName, ",");
        while (tok.hasMoreTokens()) {
            String currentTagName = tok.nextToken();
            list.add(currentTagName);
        }
        return list.toArray(new String[0]);
    }

    public HashMap<String, String> getCategoryRules() {
        return PackageItem.convertFromObjectGraphs(this.convertStringToArray(this.getCategoryRules(true)), this.convertStringToArray(this.getCategoryRules(false)));
    }

    public String getCategoryRules(boolean keys) {
        if (keys) {
            return this.getStringProperty(CATEGORY_RULE_KEYS_PROPERTY_NAME);
        }
        return this.getStringProperty(CATEGORY_RULE_VALUES_PROPERTY_NAME);
    }

    public void updateCheckinComment(String comment) {
        this.updateStringProperty(comment, "drools:checkinComment");
    }

    public void changeStatus(String newState) {
        StateItem stateItem = this.rulesRepository.getState(newState);
        this.updateState(stateItem);
        Iterator<AssetItem> iter = this.getAssets();
        while (iter.hasNext()) {
            iter.next().updateState(stateItem);
        }
    }

    public PackageItem updateCompiledPackage(InputStream data) {
        this.checkout();
        try {
            Binary binary = this.node.getSession().getValueFactory().createBinary(data);
            this.node.setProperty(COMPILED_PACKAGE_PROPERTY_NAME, binary);
            this.node.setProperty("drools:lastModified", Calendar.getInstance());
            return this;
        }
        catch (RepositoryException e) {
            log.error("Unable to update the assets binary content", (Throwable)e);
            throw new RulesRepositoryException(e);
        }
    }

    public byte[] getCompiledPackageBytes() {
        try {
            Node ruleNode = this.getVersionContentNode();
            if (ruleNode.hasProperty(COMPILED_PACKAGE_PROPERTY_NAME)) {
                Property data = ruleNode.getProperty(COMPILED_PACKAGE_PROPERTY_NAME);
                InputStream in = data.getBinary().getStream();
                byte[] bytes = new byte[(int)data.getLength()];
                int offset = 0;
                int numRead = 0;
                while (offset < bytes.length && (numRead = in.read(bytes, offset, bytes.length - offset)) >= 0) {
                    offset += numRead;
                }
                if (offset < bytes.length) {
                    throw new RulesRepositoryException("Could not completely read binary package for " + this.getName());
                }
                in.close();
                return bytes;
            }
            return null;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RulesRepositoryException(e);
        }
    }

    public PackageItem createSubPackage(String subPackageName) throws RepositoryException {
        Node subPkgsNode;
        this.checkout();
        log.info("USER: {} CREATEING subpackage [{}] under [{}]", new Object[]{this.getCurrentUserName(), subPackageName, this.getName()});
        try {
            subPkgsNode = this.node.getNode("drools:package_area");
        }
        catch (PathNotFoundException e) {
            subPkgsNode = this.node.addNode("drools:package_area", "nt:folder");
        }
        Node ruleSubPackageNode = subPkgsNode.addNode(subPackageName, RULE_PACKAGE_TYPE_NAME);
        ruleSubPackageNode.addNode(ASSET_FOLDER_NAME, "drools:versionableAssetFolder");
        ruleSubPackageNode.setProperty("drools:title", subPackageName);
        ruleSubPackageNode.setProperty("drools:description", "");
        ruleSubPackageNode.setProperty("drools:format", PACKAGE_FORMAT);
        ruleSubPackageNode.setProperty("drools:creator", this.rulesRepository.getSession().getUserID());
        Calendar lastModified = Calendar.getInstance();
        ruleSubPackageNode.setProperty("drools:lastModified", lastModified);
        ruleSubPackageNode.setProperty("drools:archive", false);
        return new PackageItem(this.rulesRepository, ruleSubPackageNode);
    }

    public PackageIterator listSubPackages() {
        try {
            return new PackageIterator(this.getRulesRepository(), this.node.getNode("drools:package_area").getNodes());
        }
        catch (PathNotFoundException e) {
            return new PackageIterator();
        }
        catch (RepositoryException e) {
            throw new RulesRepositoryException(e);
        }
    }

    private String getCurrentUserName() {
        return this.rulesRepository.getSession().getUserID();
    }
}

